/**
 * Copyright (C) 2011, the original authors
 *
 * ====================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ====================================================================
 */
package org.jclouds.karaf.services;

import java.util.Hashtable;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Constants;
import org.osgi.service.cm.ManagedServiceFactory;

/**
 * @author <a href="mailto:gnodet[at]gmail.com">Guillaume Nodet (gnodet)</a>
 */
public class Activator implements BundleActivator {

    public void start(BundleContext context) throws Exception {
        registerComputeServiceFactory(context);
        registerBlobstoreServiceFactory(context);
    }

    public void stop(BundleContext context) throws Exception {
    }

    /**
     * Registers a {@link ManagedServiceFactory} for the jclouds compute.
     * @param context
     */
    private void registerComputeServiceFactory(BundleContext context) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put(Constants.SERVICE_PID, "org.jclouds.compute");
        ComputeServiceFactory computeFactory = new ComputeServiceFactory(context);
        context.registerService(ManagedServiceFactory.class.getName(),
                computeFactory, properties);
    }

    /**
     * Registers a {@link ManagedServiceFactory} for the jclouds blobstore.
     * @param context
     */
    private void registerBlobstoreServiceFactory(BundleContext context) {
       Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put(Constants.SERVICE_PID, "org.jclouds.blobstore");
        BlobStoreServiceFactory blobStoreFactory = new BlobStoreServiceFactory(context);
        context.registerService(ManagedServiceFactory.class.getName(),
                blobStoreFactory, properties);
    }
}
