/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.services;

import com.google.common.collect.ImmutableSet;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.BlobStoreContextFactory;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreServiceFactory
implements ManagedServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobStoreServiceFactory.class);
    private final Map<String, ServiceRegistration> registrations = new ConcurrentHashMap<String, ServiceRegistration>();
    private final BundleContext bundleContext;

    public BlobStoreServiceFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getName() {
        return "BlobStore Service Factory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        ServiceRegistration oldRegistration;
        System.out.println("Updating configuration properties for BlobStoreServiceFactory " + pid);
        ServiceRegistration newRegistration = null;
        try {
            if (properties != null) {
                Properties props = new Properties();
                Enumeration e = properties.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object val = properties.get(key);
                    props.put(key, val);
                }
                String provider = (String)properties.get("provider");
                String identity = (String)properties.get("identity");
                String credential = (String)properties.get("credential");
                BlobStoreContext context = new BlobStoreContextFactory().createContext(provider, identity, credential, (Iterable)ImmutableSet.of((Object)new Log4JLoggingModule()), props);
                BlobStore blobStore = context.getBlobStore();
                newRegistration = this.bundleContext.registerService(BlobStore.class.getName(), (Object)blobStore, properties);
            }
            ServiceRegistration serviceRegistration = oldRegistration = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
        }
        catch (Exception ex) {
            ServiceRegistration oldRegistration2;
            try {
                LOGGER.error("Error creating blob store service.", (Throwable)ex);
                ServiceRegistration serviceRegistration = oldRegistration2 = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
            }
            catch (Throwable throwable) {
                ServiceRegistration oldRegistration3;
                ServiceRegistration serviceRegistration = oldRegistration3 = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                if (oldRegistration3 != null) {
                    System.out.println("Unregistering BlobStoreService " + pid);
                    oldRegistration3.unregister();
                }
                throw throwable;
            }
            if (oldRegistration2 != null) {
                System.out.println("Unregistering BlobStoreService " + pid);
                oldRegistration2.unregister();
            }
        }
        if (oldRegistration != null) {
            System.out.println("Unregistering BlobStoreService " + pid);
            oldRegistration.unregister();
        }
    }

    public void deleted(String pid) {
        System.out.println("BlobStoreServiceFactory deleted (" + pid + ")");
        ServiceRegistration oldRegistration = this.registrations.remove(pid);
        if (oldRegistration != null) {
            oldRegistration.unregister();
        }
    }
}

