/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.services;

import com.google.common.collect.ImmutableSet;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.karaf.services.modules.ConfigurationAdminCredentialStore;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeServiceFactory
implements ManagedServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComputeServiceFactory.class);
    public static final String PROVIDER = "provider";
    public static final String IDENTITY = "identity";
    public static final String CREDENTIAL = "credential";
    private final Map<String, ServiceRegistration> registrations = new ConcurrentHashMap<String, ServiceRegistration>();
    private final BundleContext bundleContext;
    private ConfigurationAdmin configurationAdmin;
    private ServiceReference configurationAdminReference;

    public ComputeServiceFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() {
        this.configurationAdminReference = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        this.configurationAdmin = (ConfigurationAdmin)this.bundleContext.getService(this.configurationAdminReference);
    }

    public void destroy() {
        this.bundleContext.ungetService(this.configurationAdminReference);
    }

    public String getName() {
        return "Compute Service Factory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        ServiceRegistration oldRegistration;
        System.out.println("Updating configuration properties for ComputeServiceFactory " + pid);
        ServiceRegistration newRegistration = null;
        try {
            if (properties != null) {
                Properties props = new Properties();
                Enumeration e = properties.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object val = properties.get(key);
                    props.put(key, val);
                }
                String provider = (String)properties.get(PROVIDER);
                String identity = (String)properties.get(IDENTITY);
                String credential = (String)properties.get(CREDENTIAL);
                ConfigurationAdminCredentialStore credentialStore = new ConfigurationAdminCredentialStore(this.configurationAdmin.getConfiguration("org.jclouds.credentials"));
                ComputeServiceContext context = new ComputeServiceContextFactory().createContext(provider, identity, credential, (Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new SshjSshClientModule(), (Object)((Object)credentialStore)), props);
                ComputeService client = context.getComputeService();
                newRegistration = this.bundleContext.registerService(ComputeService.class.getName(), (Object)client, properties);
            }
            ServiceRegistration serviceRegistration = oldRegistration = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
        }
        catch (Exception ex) {
            ServiceRegistration oldRegistration2;
            try {
                LOGGER.error("Error creating compute service.", (Throwable)ex);
                ServiceRegistration serviceRegistration = oldRegistration2 = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
            }
            catch (Throwable throwable) {
                ServiceRegistration oldRegistration3;
                ServiceRegistration serviceRegistration = oldRegistration3 = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                if (oldRegistration3 != null) {
                    System.out.println("Unregistering ComputeService " + pid);
                    oldRegistration3.unregister();
                }
                throw throwable;
            }
            if (oldRegistration2 != null) {
                System.out.println("Unregistering ComputeService " + pid);
                oldRegistration2.unregister();
            }
        }
        if (oldRegistration != null) {
            System.out.println("Unregistering ComputeService " + pid);
            oldRegistration.unregister();
        }
    }

    public void deleted(String pid) {
        System.out.println("ComputeServiceFactory deleted (" + pid + ")");
        ServiceRegistration oldRegistration = this.registrations.remove(pid);
        if (oldRegistration != null) {
            oldRegistration.unregister();
        }
    }
}

