/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.services;

import java.util.Hashtable;
import org.jclouds.karaf.core.BlobStoreProviderOrApiListener;
import org.jclouds.karaf.core.BlobStoreProviderOrApiRegistry;
import org.jclouds.karaf.core.ComputeProviderOrApiListener;
import org.jclouds.karaf.core.ComputeProviderOrApiRegistry;
import org.jclouds.karaf.services.BlobStoreServiceFactory;
import org.jclouds.karaf.services.ComputeServiceFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;

public class Activator
implements BundleActivator {
    ServiceRegistration computeFactoryRegistration;
    ServiceRegistration blobStoreFactoryRegistration;
    ComputeServiceFactory computeFactory;
    BlobStoreServiceFactory blobStoreFactory;

    public void start(BundleContext context) throws Exception {
        this.registerComputeServiceFactory(context);
        this.registerBlobstoreServiceFactory(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.computeFactoryRegistration != null) {
            this.computeFactoryRegistration.unregister();
        }
        if (this.blobStoreFactoryRegistration != null) {
            this.blobStoreFactoryRegistration.unregister();
        }
    }

    private void registerComputeServiceFactory(BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.pid", "org.jclouds.compute");
        this.computeFactory = new ComputeServiceFactory(context);
        this.computeFactoryRegistration = context.registerService(new String[]{ManagedServiceFactory.class.getName(), ComputeProviderOrApiListener.class.getName(), ComputeProviderOrApiRegistry.class.getName()}, (Object)this.computeFactory, properties);
    }

    private void registerBlobstoreServiceFactory(BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.pid", "org.jclouds.blobstore");
        this.blobStoreFactory = new BlobStoreServiceFactory(context);
        this.blobStoreFactoryRegistration = context.registerService(new String[]{ManagedServiceFactory.class.getName(), BlobStoreProviderOrApiListener.class.getName(), BlobStoreProviderOrApiRegistry.class.getName()}, (Object)this.blobStoreFactory, properties);
    }
}

