/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.services;

import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.karaf.core.BlobStoreProviderOrApiListener;
import org.jclouds.karaf.core.BlobStoreProviderOrApiRegistry;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.providers.ProviderMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreServiceFactory
implements ManagedServiceFactory,
BlobStoreProviderOrApiListener,
BlobStoreProviderOrApiRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobStoreServiceFactory.class);
    public static final String PROVIDER = "provider";
    public static final String IDENTITY = "identity";
    public static final String CREDENTIAL = "credential";
    private final Map<String, ServiceRegistration> registrations = new ConcurrentHashMap<String, ServiceRegistration>();
    private final Map<String, Dictionary> pendingPids = new HashMap<String, Dictionary>();
    private final Map<String, Dictionary> activePids = new HashMap<String, Dictionary>();
    private final Map<String, String> providerPids = new HashMap<String, String>();
    private final Map<String, String> apiPids = new HashMap<String, String>();
    private final Map<String, ProviderMetadata> installedProviders = new HashMap<String, ProviderMetadata>();
    private final Map<String, ApiMetadata> installedApis = new HashMap<String, ApiMetadata>();
    private final BundleContext bundleContext;
    private AbstractModule credentialStore;

    public BlobStoreServiceFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getName() {
        return "BlobStore Service Factory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        ServiceRegistration oldRegistration;
        ServiceRegistration newRegistration;
        block9: {
            ContextBuilder builder;
            BlobStoreContext context;
            String credential;
            String identity;
            Properties props;
            block11: {
                ServiceRegistration oldRegistration2;
                String providerOrApi;
                block10: {
                    ServiceRegistration oldRegistration3;
                    System.out.println("Updating configuration properties for BlobStore " + pid);
                    newRegistration = null;
                    if (properties == null) break block9;
                    props = new Properties();
                    Enumeration e = properties.keys();
                    while (e.hasMoreElements()) {
                        Object key = e.nextElement();
                        Object val = properties.get(key);
                        props.put(key, val);
                    }
                    providerOrApi = (String)properties.get(PROVIDER);
                    if (this.installedProviders.containsKey(providerOrApi) || this.installedApis.containsKey(providerOrApi)) break block10;
                    this.pendingPids.put(pid, properties);
                    LOGGER.debug("Provider {} is not currently installed. Service will resume once the the provider is installed.", (Object)providerOrApi);
                    ServiceRegistration serviceRegistration = oldRegistration3 = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                    if (oldRegistration3 == null) return;
                    System.out.println("Unregistering BlobStore " + pid);
                    oldRegistration3.unregister();
                    return;
                }
                identity = (String)properties.get(IDENTITY);
                credential = (String)properties.get(CREDENTIAL);
                ProviderMetadata providerMetadata = this.installedProviders.get(providerOrApi);
                ApiMetadata apiMetadata = this.installedApis.get(providerOrApi);
                context = null;
                builder = null;
                if (providerMetadata != null) {
                    builder = ContextBuilder.newBuilder((ProviderMetadata)providerMetadata);
                    break block11;
                }
                if (apiMetadata != null) {
                    builder = ContextBuilder.newBuilder((ApiMetadata)apiMetadata);
                    break block11;
                }
                ServiceRegistration serviceRegistration = oldRegistration2 = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                if (oldRegistration2 == null) return;
                System.out.println("Unregistering BlobStore " + pid);
                oldRegistration2.unregister();
                return;
            }
            try {
                context = (BlobStoreContext)builder.credentials(identity, credential).modules((Iterable)ImmutableSet.of((Object)new Log4JLoggingModule())).overrides(props).build(BlobStoreContext.class);
                BlobStore blobStore = context.getBlobStore();
                newRegistration = this.bundleContext.registerService(BlobStore.class.getName(), (Object)blobStore, properties);
                if (!this.pendingPids.containsKey(pid)) break block9;
                this.activePids.put(pid, this.pendingPids.remove(pid));
            }
            catch (Exception ex) {
                ServiceRegistration oldRegistration4;
                try {
                    LOGGER.error("Error creating blobstore service.", (Throwable)ex);
                    ServiceRegistration serviceRegistration = oldRegistration4 = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                }
                catch (Throwable throwable) {
                    ServiceRegistration oldRegistration5;
                    ServiceRegistration serviceRegistration = oldRegistration5 = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                    if (oldRegistration5 == null) throw throwable;
                    System.out.println("Unregistering BlobStore " + pid);
                    oldRegistration5.unregister();
                    throw throwable;
                }
                if (oldRegistration4 == null) return;
                System.out.println("Unregistering BlobStore " + pid);
                oldRegistration4.unregister();
                return;
            }
        }
        ServiceRegistration serviceRegistration = oldRegistration = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
        if (oldRegistration == null) return;
        System.out.println("Unregistering BlobStore " + pid);
        oldRegistration.unregister();
        return;
    }

    public void deleted(String pid) {
        System.out.println("BlobStore deleted (" + pid + ")");
        ServiceRegistration oldRegistration = this.registrations.remove(pid);
        if (oldRegistration != null) {
            oldRegistration.unregister();
        }
    }

    public void providerInstalled(ProviderMetadata provider) {
        this.installedProviders.put(provider.getId(), provider);
        String pid = this.providerPids.get(provider.getId());
        if (pid != null) {
            Dictionary properties = this.pendingPids.get(pid);
            try {
                this.updated(pid, properties);
            }
            catch (ConfigurationException e) {
                LOGGER.error("Error while installing service for pending provider " + provider + " with pid " + pid, (Throwable)e);
            }
        }
    }

    public void providerUninstalled(ProviderMetadata provider) {
        String pid = this.providerPids.get(provider.getId());
        if (pid != null) {
            if (this.activePids.containsKey(pid)) {
                this.pendingPids.put(pid, this.activePids.remove(pid));
            }
            this.deleted(pid);
        }
        this.installedProviders.remove(provider.getId());
    }

    public void apiInstalled(ApiMetadata api) {
        this.installedApis.put(api.getId(), api);
        String pid = this.apiPids.get(api.getId());
        if (pid != null) {
            Dictionary properties = this.activePids.get(pid);
            try {
                this.updated(pid, properties);
            }
            catch (ConfigurationException e) {
                LOGGER.error("Error while installing service for pending api " + api + " with pid " + pid, (Throwable)e);
            }
        }
    }

    public void apiUninstalled(ApiMetadata api) {
        String pid = this.apiPids.get(api.getId());
        if (pid != null) {
            if (this.activePids.containsKey(pid)) {
                this.pendingPids.put(pid, this.activePids.remove(pid));
            }
            this.deleted(pid);
        }
        this.installedApis.remove(api.getId());
    }

    public Map<String, ProviderMetadata> getInstalledProviders() {
        return this.installedProviders;
    }

    public Map<String, ApiMetadata> getInstalledApis() {
        return this.installedApis;
    }
}

