/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.services;

import com.google.common.collect.ImmutableSet;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.karaf.core.ComputeProviderOrApiListener;
import org.jclouds.karaf.core.ComputeProviderOrApiRegistry;
import org.jclouds.karaf.core.ComputeServiceEventProxy;
import org.jclouds.karaf.core.CredentialStore;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeServiceFactory
implements ManagedServiceFactory,
ComputeProviderOrApiListener,
ComputeProviderOrApiRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComputeServiceFactory.class);
    public static final String PROVIDER = "provider";
    public static final String IDENTITY = "identity";
    public static final String CREDENTIAL = "credential";
    public static final String NODE_EVENT_SUPPORT = "eventsupport";
    public static final String CREDENTIAL_STORE = "credential-store";
    public static final String DEFAULT_CREDENTIAL_STORE_TYPE = "cadmin";
    public static final String CREDENTIAL_STORE_FILTER = "(&(objectClass=org.jclouds.karaf.core.CredentialStore)(credential-store-type=%s))";
    private final Map<String, ServiceRegistration> registrations = new ConcurrentHashMap<String, ServiceRegistration>();
    private final Map<String, Dictionary> activePids = new HashMap<String, Dictionary>();
    private final Map<String, Dictionary> pendingPids = new HashMap<String, Dictionary>();
    private final Map<String, String> providerPids = new HashMap<String, String>();
    private final Map<String, String> apiPids = new HashMap<String, String>();
    private final Map<String, ProviderMetadata> installedProviders = new HashMap<String, ProviderMetadata>();
    private final Map<String, ApiMetadata> installedApis = new HashMap<String, ApiMetadata>();
    private ServiceTracker credentialStoreTracker;
    private final BundleContext bundleContext;

    public ComputeServiceFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private CredentialStore lookupStore(String type) {
        try {
            this.credentialStoreTracker = new ServiceTracker(this.bundleContext, this.bundleContext.createFilter(String.format(CREDENTIAL_STORE_FILTER, type)), null);
            this.credentialStoreTracker.open();
            return (CredentialStore)this.credentialStoreTracker.waitForService(10000L);
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error("Error looking up credential store.", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.error("Timed out waiting for store.", (Throwable)e);
        }
        return null;
    }

    public String getName() {
        return "Compute Service Factory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        ServiceRegistration oldRegistration;
        ServiceRegistration newRegistration;
        block14: {
            String provider;
            Properties props;
            block15: {
                ServiceRegistration oldRegistration2;
                newRegistration = null;
                if (properties == null) break block14;
                props = new Properties();
                Enumeration e = properties.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object val = properties.get(key);
                    props.put(key, val);
                }
                provider = (String)properties.get(PROVIDER);
                if (this.installedProviders.containsKey(provider) || this.installedApis.containsKey(provider)) break block15;
                this.pendingPids.put(pid, properties);
                this.providerPids.put(provider, pid);
                LOGGER.debug("Provider {} is not currently installed. Service will resume once the the provider is installed.", (Object)provider);
                ServiceRegistration serviceRegistration = oldRegistration2 = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                if (oldRegistration2 == null) return;
                oldRegistration2.unregister();
                return;
            }
            try {
                void var16_21;
                String identity = (String)properties.get(IDENTITY);
                String credential = (String)properties.get(CREDENTIAL);
                String storeType = (String)properties.get(CREDENTIAL_STORE);
                String eventSupport = (String)properties.get(NODE_EVENT_SUPPORT);
                Boolean enableEventSupport = false;
                if (storeType == null || storeType.isEmpty()) {
                    storeType = DEFAULT_CREDENTIAL_STORE_TYPE;
                }
                if (eventSupport != null && !eventSupport.isEmpty()) {
                    enableEventSupport = Boolean.parseBoolean(eventSupport);
                }
                CredentialStore credentialStore = this.lookupStore(storeType);
                ProviderMetadata providerMetadata = this.installedProviders.get(provider);
                ApiMetadata apiMetadata = this.installedApis.get(provider);
                ContextBuilder builder = null;
                if (providerMetadata != null) {
                    builder = ContextBuilder.newBuilder((ProviderMetadata)providerMetadata);
                } else if (apiMetadata != null) {
                    builder = ContextBuilder.newBuilder((ApiMetadata)apiMetadata);
                }
                builder.modules((Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new SshjSshClientModule()));
                if (credentialStore != null) {
                    builder.modules((Iterable)ImmutableSet.of((Object)credentialStore));
                }
                builder.credentials(identity, credential).overrides(props);
                ComputeServiceContext context = (ComputeServiceContext)builder.build(ComputeServiceContext.class);
                Object var16_18 = null;
                if (enableEventSupport.booleanValue()) {
                    ComputeServiceEventProxy computeServiceEventProxy = new ComputeServiceEventProxy(this.bundleContext, context.getComputeService());
                } else {
                    ComputeService computeService = context.getComputeService();
                }
                newRegistration = this.bundleContext.registerService(ComputeService.class.getName(), (Object)var16_21, properties);
                if (!this.pendingPids.containsKey(pid)) break block14;
                this.activePids.put(pid, this.pendingPids.remove(pid));
            }
            catch (Exception ex) {
                ServiceRegistration oldRegistration3;
                try {
                    LOGGER.error("Error creating compute service.", (Throwable)ex);
                    ServiceRegistration serviceRegistration = oldRegistration3 = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                }
                catch (Throwable throwable) {
                    ServiceRegistration oldRegistration4;
                    ServiceRegistration serviceRegistration = oldRegistration4 = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                    if (oldRegistration4 == null) throw throwable;
                    oldRegistration4.unregister();
                    throw throwable;
                }
                if (oldRegistration3 == null) return;
                oldRegistration3.unregister();
                return;
            }
        }
        ServiceRegistration serviceRegistration = oldRegistration = newRegistration == null ? this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
        if (oldRegistration == null) return;
        oldRegistration.unregister();
        return;
    }

    public void deleted(String pid) {
        ServiceRegistration oldRegistration = this.registrations.remove(pid);
        if (oldRegistration != null) {
            oldRegistration.unregister();
        }
    }

    public void providerInstalled(ProviderMetadata provider) {
        this.installedProviders.put(provider.getId(), provider);
        String pid = this.providerPids.get(provider.getId());
        if (pid != null) {
            Dictionary properties = this.pendingPids.get(pid);
            try {
                this.updated(pid, properties);
            }
            catch (ConfigurationException e) {
                LOGGER.error("Error while installing service for pending provider " + provider + " with pid " + pid, (Throwable)e);
            }
        }
    }

    public void providerUninstalled(ProviderMetadata provider) {
        String pid = this.providerPids.get(provider.getId());
        if (pid != null) {
            if (this.activePids.containsKey(pid)) {
                this.pendingPids.put(pid, this.activePids.remove(pid));
            }
            this.deleted(pid);
        }
        this.installedProviders.remove(provider.getId());
    }

    public void apiInstalled(ApiMetadata api) {
        this.installedApis.put(api.getId(), api);
        String pid = this.apiPids.get(api.getId());
        if (pid != null) {
            Dictionary properties = this.pendingPids.get(pid);
            try {
                this.updated(pid, properties);
            }
            catch (ConfigurationException e) {
                LOGGER.error("Error while installing service for pending api " + api + " with pid " + pid, (Throwable)e);
            }
        }
    }

    public void apiUninstalled(ApiMetadata api) {
        String pid = this.apiPids.get(api.getId());
        if (pid != null) {
            if (this.activePids.containsKey(pid)) {
                this.pendingPids.put(pid, this.activePids.remove(pid));
            }
            this.deleted(pid);
        }
        this.installedApis.remove(api.getId());
    }

    public Map<String, ProviderMetadata> getInstalledProviders() {
        return this.installedProviders;
    }

    public Map<String, ApiMetadata> getInstalledApis() {
        return this.installedApis;
    }
}

