/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.services;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.karaf.core.ComputeProviderOrApiListener;
import org.jclouds.karaf.core.ComputeProviderOrApiRegistry;
import org.jclouds.karaf.core.ComputeServiceEventProxy;
import org.jclouds.karaf.core.CredentialStore;
import org.jclouds.karaf.services.ServiceFactorySupport;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeServiceFactory
extends ServiceFactorySupport
implements ComputeProviderOrApiListener,
ComputeProviderOrApiRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComputeServiceFactory.class);
    public static final String NODE_EVENT_SUPPORT = "eventsupport";
    public static final String CREDENTIAL_STORE = "credential-store";
    public static final String DEFAULT_CREDENTIAL_STORE_TYPE = "cadmin";
    public static final String CREDENTIAL_STORE_FILTER = "(&(objectClass=org.jclouds.karaf.core.CredentialStore)(credential-store-type=%s))";
    private ServiceTracker credentialStoreTracker;
    private final BundleContext bundleContext;

    public ComputeServiceFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private CredentialStore lookupStore(String type) {
        try {
            this.credentialStoreTracker = new ServiceTracker(this.bundleContext, this.bundleContext.createFilter(String.format(CREDENTIAL_STORE_FILTER, type)), null);
            this.credentialStoreTracker.open();
            return (CredentialStore)this.credentialStoreTracker.waitForService(10000L);
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error("Error looking up credential store.", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.error("Timed out waiting for store.", (Throwable)e);
        }
        return null;
    }

    public String getName() {
        return "Compute Service Factory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        ServiceRegistration oldRegistration;
        ServiceRegistration newRegistration;
        block23: {
            ApiMetadata apiMetadata;
            ProviderMetadata providerMetadata;
            Properties props;
            block24: {
                ServiceRegistration oldRegistration2;
                newRegistration = null;
                this.lock.tryLock();
                if (properties == null) break block23;
                props = new Properties();
                Enumeration e = properties.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object val = properties.get(key);
                    props.put(key, val);
                }
                String provider = (String)properties.get("provider");
                String api = (String)properties.get("api");
                providerMetadata = null;
                apiMetadata = null;
                if (!Strings.isNullOrEmpty((String)provider) && this.installedProviders.containsKey(provider)) {
                    providerMetadata = (ProviderMetadata)this.installedProviders.get(provider);
                    break block24;
                }
                if (!Strings.isNullOrEmpty((String)api) && this.installedApis.containsKey(api)) {
                    apiMetadata = (ApiMetadata)this.installedApis.get(api);
                    break block24;
                }
                if (!Strings.isNullOrEmpty((String)provider)) {
                    this.providerPids.put(provider, pid);
                }
                if (!Strings.isNullOrEmpty((String)api)) {
                    this.apiPids.put(api, pid);
                }
                this.pendingPids.put(pid, properties);
                LOGGER.warn("Provider {} or Api {} is not currently installed. Service will resume once the the provider is installed.", (Object)provider, (Object)api);
                ServiceRegistration serviceRegistration = oldRegistration2 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                if (oldRegistration2 != null) {
                    oldRegistration2.unregister();
                }
                if (!this.lock.isHeldByCurrentThread()) return;
                this.lock.unlock();
                return;
            }
            try {
                void var18_24;
                String identity = (String)properties.remove("identity");
                String credential = (String)properties.remove("credential");
                String endpoint = (String)properties.get("endpoint");
                String storeType = (String)properties.get(CREDENTIAL_STORE);
                String eventSupport = (String)properties.get(NODE_EVENT_SUPPORT);
                Boolean enableEventSupport = false;
                if (storeType == null || storeType.isEmpty()) {
                    storeType = DEFAULT_CREDENTIAL_STORE_TYPE;
                }
                if (eventSupport != null && !eventSupport.isEmpty()) {
                    enableEventSupport = Boolean.parseBoolean(eventSupport);
                }
                CredentialStore credentialStore = this.lookupStore(storeType);
                ContextBuilder builder = null;
                if (providerMetadata != null) {
                    builder = ContextBuilder.newBuilder((ProviderMetadata)providerMetadata);
                } else if (apiMetadata != null) {
                    builder = ContextBuilder.newBuilder((ApiMetadata)apiMetadata);
                }
                if (!Strings.isNullOrEmpty((String)endpoint)) {
                    builder = builder.endpoint(endpoint);
                }
                builder = builder.modules((Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new SshjSshClientModule()));
                if (credentialStore != null) {
                    builder = builder.modules((Iterable)ImmutableSet.of((Object)credentialStore));
                }
                builder = builder.credentials(identity, credential).overrides(props);
                ComputeServiceContext context = (ComputeServiceContext)builder.build(ComputeServiceContext.class);
                Object var18_21 = null;
                if (enableEventSupport.booleanValue()) {
                    ComputeServiceEventProxy computeServiceEventProxy = new ComputeServiceEventProxy(this.bundleContext, context.getComputeService());
                } else {
                    ComputeService computeService = context.getComputeService();
                }
                newRegistration = this.bundleContext.registerService(ComputeService.class.getName(), (Object)var18_24, properties);
                if (!this.pendingPids.containsKey(pid)) break block23;
                this.activePids.put(pid, this.pendingPids.remove(pid));
            }
            catch (Exception ex) {
                ServiceRegistration oldRegistration3;
                try {
                    LOGGER.error("Error creating compute service.", (Throwable)ex);
                    ServiceRegistration serviceRegistration = oldRegistration3 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                }
                catch (Throwable throwable) {
                    ServiceRegistration oldRegistration4;
                    ServiceRegistration serviceRegistration = oldRegistration4 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                    if (oldRegistration4 != null) {
                        oldRegistration4.unregister();
                    }
                    if (!this.lock.isHeldByCurrentThread()) throw throwable;
                    this.lock.unlock();
                    throw throwable;
                }
                if (oldRegistration3 != null) {
                    oldRegistration3.unregister();
                }
                if (!this.lock.isHeldByCurrentThread()) return;
                this.lock.unlock();
                return;
            }
        }
        ServiceRegistration serviceRegistration = oldRegistration = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
        if (oldRegistration != null) {
            oldRegistration.unregister();
        }
        if (!this.lock.isHeldByCurrentThread()) return;
        this.lock.unlock();
        return;
    }
}

