/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.services.internal;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.ApiPredicates;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.karaf.core.ComputeServiceEventProxy;
import org.jclouds.karaf.core.CredentialStore;
import org.jclouds.karaf.services.InvalidConfigurationException;
import org.jclouds.karaf.services.ServiceFactorySupport;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.ProviderPredicates;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeServiceFactory
extends ServiceFactorySupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComputeServiceFactory.class);
    public static final String NODE_EVENT_SUPPORT = "eventsupport";
    public static final String CREDENTIAL_STORE = "credential-store";
    public static final String DEFAULT_CREDENTIAL_STORE_TYPE = "cadmin";
    public static final String CREDENTIAL_STORE_FILTER = "(&(objectClass=org.jclouds.karaf.core.CredentialStore)(credential-store-type=%s))";
    private final BundleContext bundleContext;

    public ComputeServiceFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CredentialStore lookupStore(String type) {
        ServiceTracker credentialStoreTracker = null;
        try {
            credentialStoreTracker = new ServiceTracker(this.bundleContext, this.bundleContext.createFilter(String.format(CREDENTIAL_STORE_FILTER, type)), null);
            credentialStoreTracker.open();
            CredentialStore credentialStore = (CredentialStore)credentialStoreTracker.waitForService(10000L);
            return credentialStore;
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error("Error looking up credential store.", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.error("Timed out waiting for store.", (Throwable)e);
        }
        finally {
            if (credentialStoreTracker != null) {
                credentialStoreTracker.close();
            }
        }
        return null;
    }

    public String getName() {
        return "Compute Service Factory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void updated(String pid, Dictionary properties) throws ConfigurationException {
        ServiceRegistration oldRegistration;
        ServiceRegistration newRegistration;
        block23: {
            Boolean enableEventSupport;
            String eventSupport;
            String storeType;
            String endpoint;
            String credential;
            String identity;
            String id;
            ApiMetadata apiMetadata;
            ProviderMetadata providerMetadata;
            Properties props;
            block26: {
                ServiceRegistration oldRegistration2;
                block25: {
                    ServiceRegistration oldRegistration3;
                    block24: {
                        ServiceRegistration oldRegistration4;
                        newRegistration = null;
                        if (properties == null) break block23;
                        props = new Properties();
                        Enumeration e = properties.keys();
                        while (e.hasMoreElements()) {
                            Object key = e.nextElement();
                            Object val = properties.get(key);
                            props.put(key, val);
                        }
                        String provider = (String)properties.get("provider");
                        String api = (String)properties.get("api");
                        providerMetadata = null;
                        apiMetadata = null;
                        if (!Strings.isNullOrEmpty((String)provider) && this.installedProviders.containsKey(provider)) {
                            providerMetadata = (ProviderMetadata)this.installedProviders.get(provider);
                            ComputeServiceFactory.validate(providerMetadata, properties);
                            break block24;
                        }
                        if (!Strings.isNullOrEmpty((String)api) && this.installedApis.containsKey(api)) {
                            apiMetadata = (ApiMetadata)this.installedApis.get(api);
                            ComputeServiceFactory.validate(apiMetadata, properties);
                            break block24;
                        }
                        if (!Strings.isNullOrEmpty((String)provider)) {
                            this.providerPids.put(provider, pid);
                        }
                        if (!Strings.isNullOrEmpty((String)api)) {
                            this.apiPids.put(api, pid);
                        }
                        this.pendingPids.put(pid, properties);
                        LOGGER.warn("Provider {} or Api {} is not currently installed. Service will resume once the the provider is installed.", (Object)provider, (Object)api);
                        ServiceRegistration serviceRegistration = oldRegistration4 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                        if (oldRegistration4 == null) return;
                        oldRegistration4.unregister();
                        return;
                    }
                    id = (String)properties.get("name");
                    identity = (String)properties.remove("identity");
                    credential = (String)properties.remove("credential");
                    endpoint = (String)properties.get("endpoint");
                    storeType = (String)properties.get(CREDENTIAL_STORE);
                    eventSupport = (String)properties.get(NODE_EVENT_SUPPORT);
                    enableEventSupport = false;
                    if (!Strings.isNullOrEmpty((String)credential) || providerMetadata == null || providerMetadata.getApiMetadata().getDefaultCredential().isPresent()) break block25;
                    LOGGER.warn("No credential specified and provider {}.", (Object)providerMetadata.getId());
                    ServiceRegistration serviceRegistration = oldRegistration3 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                    if (oldRegistration3 == null) return;
                    oldRegistration3.unregister();
                    return;
                }
                if (!Strings.isNullOrEmpty((String)credential) || apiMetadata == null || apiMetadata.getDefaultCredential().isPresent()) break block26;
                LOGGER.warn("No credential specified and api {}.", (Object)apiMetadata.getId());
                ServiceRegistration serviceRegistration = oldRegistration2 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                if (oldRegistration2 == null) return;
                oldRegistration2.unregister();
                return;
            }
            try {
                void var19_29;
                if (storeType == null || storeType.isEmpty()) {
                    storeType = DEFAULT_CREDENTIAL_STORE_TYPE;
                }
                if (eventSupport != null && !eventSupport.isEmpty()) {
                    enableEventSupport = Boolean.parseBoolean(eventSupport);
                }
                CredentialStore credentialStore = this.lookupStore(storeType);
                ContextBuilder builder = null;
                if (providerMetadata != null) {
                    builder = ContextBuilder.newBuilder((ProviderMetadata)providerMetadata);
                } else if (apiMetadata != null) {
                    builder = ContextBuilder.newBuilder((ApiMetadata)apiMetadata);
                }
                if (!Strings.isNullOrEmpty((String)endpoint)) {
                    builder = builder.endpoint(endpoint);
                }
                builder = builder.name(id).modules((Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new SshjSshClientModule()));
                if (credentialStore != null) {
                    builder = builder.modules((Iterable)ImmutableSet.of((Object)credentialStore));
                }
                builder = builder.name(id).credentials(identity, credential).overrides(props);
                ComputeServiceContext context = (ComputeServiceContext)builder.build(ComputeServiceContext.class);
                Object var19_26 = null;
                if (enableEventSupport.booleanValue()) {
                    ComputeServiceEventProxy computeServiceEventProxy = new ComputeServiceEventProxy(this.bundleContext, context.getComputeService());
                } else {
                    ComputeService computeService = context.getComputeService();
                }
                newRegistration = this.bundleContext.registerService(ComputeService.class.getName(), (Object)var19_29, properties);
                if (!this.pendingPids.containsKey(pid)) break block23;
                this.activePids.put(pid, this.pendingPids.remove(pid));
            }
            catch (InvalidConfigurationException ex) {
                ServiceRegistration oldRegistration5;
                LOGGER.warn("Invalid configuration: {}", (Object)ex.getMessage());
                ServiceRegistration serviceRegistration = oldRegistration5 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                if (oldRegistration5 == null) return;
                oldRegistration5.unregister();
                return;
            }
            catch (Exception ex2) {
                ServiceRegistration oldRegistration6;
                LOGGER.error("Error creating compute service.", (Throwable)ex2);
                ServiceRegistration serviceRegistration = oldRegistration6 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                {
                    catch (Throwable throwable) {
                        ServiceRegistration oldRegistration7;
                        ServiceRegistration serviceRegistration2 = oldRegistration7 = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
                        if (oldRegistration7 == null) throw throwable;
                        oldRegistration7.unregister();
                        throw throwable;
                    }
                }
                if (oldRegistration6 == null) return;
                oldRegistration6.unregister();
                return;
            }
        }
        ServiceRegistration serviceRegistration = oldRegistration = newRegistration == null ? (ServiceRegistration)this.registrations.remove(pid) : (ServiceRegistration)this.registrations.put(pid, newRegistration);
        if (oldRegistration == null) return;
        oldRegistration.unregister();
        return;
    }

    @Override
    public boolean apply(ProviderMetadata provider) {
        return ProviderPredicates.viewableAs((TypeToken)TypeToken.of(ComputeServiceContext.class)).apply((Object)provider);
    }

    @Override
    public boolean apply(ApiMetadata api) {
        return ApiPredicates.viewableAs((TypeToken)TypeToken.of(ComputeServiceContext.class)).apply((Object)api);
    }
}

