/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.utils.blobstore;

import com.google.inject.Module;
import java.util.List;
import java.util.Properties;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.BlobStoreContextFactory;

public class BlobStoreHelper {
    public static BlobStore getBlobStore(String provider, List<BlobStore> services) {
        if (provider != null) {
            BlobStore service = null;
            for (BlobStore svc : services) {
                if (!provider.equals(svc.getContext().getProviderSpecificContext().getId())) continue;
                service = svc;
                break;
            }
            if (service == null) {
                throw new IllegalArgumentException("Provider " + provider + " not found");
            }
            return service;
        }
        if (services.size() == 0) {
            throw new IllegalArgumentException("No providers are present. Note: It takes a couple of seconds for the provider to initialize.");
        }
        if (services.size() != 1) {
            StringBuilder sb = new StringBuilder();
            for (BlobStore svc : services) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(svc.getContext().getProviderSpecificContext().getId());
            }
            throw new IllegalArgumentException("Multiple providers are present, please select one using the --provider argument in the following values: " + sb.toString());
        }
        return services.get(0);
    }

    public static BlobStore createBlobStore(String provider, String identity, String credential, Iterable<? extends Module> modules, Properties props) {
        BlobStoreContext context = new BlobStoreContextFactory().createContext(provider, identity, credential, modules, props);
        BlobStore blobStore = context.getBlobStore();
        return blobStore;
    }

    private BlobStoreHelper() {
    }
}

