/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.utils.compute;

import com.google.common.base.Strings;
import java.util.LinkedList;
import java.util.List;
import org.jclouds.compute.ComputeService;

public class ComputeHelper {
    public static List<String> findCacheKeysForService(ComputeService computeService) {
        LinkedList<String> keys = new LinkedList<String>();
        String contextName = computeService.getContext().unwrap().getName();
        String providerOrApi = computeService.getContext().unwrap().getId();
        if (contextName != null) {
            keys.add(contextName);
        }
        if (providerOrApi != null) {
            keys.add(providerOrApi);
        }
        return keys;
    }

    public static ComputeService getComputeService(String id, String providerOrApi, List<ComputeService> services) {
        if (!Strings.isNullOrEmpty((String)id)) {
            ComputeService service = null;
            for (ComputeService svc : services) {
                if (!id.equals(svc.getContext().unwrap().getName())) continue;
                service = svc;
                break;
            }
            if (service == null) {
                throw new IllegalArgumentException("No compute service with id" + id + " found.");
            }
            return service;
        }
        if (!Strings.isNullOrEmpty((String)providerOrApi)) {
            ComputeService service = null;
            for (ComputeService svc : services) {
                if (!providerOrApi.equals(svc.getContext().unwrap().getId())) continue;
                service = svc;
                break;
            }
            if (service == null) {
                throw new IllegalArgumentException("No Provider or Api named " + providerOrApi + " found.");
            }
            return service;
        }
        if (services.size() == 0) {
            throw new IllegalArgumentException("No providers are present.  Note: It takes a couple of seconds for the provider to initialize.");
        }
        if (services.size() != 1) {
            StringBuilder sb = new StringBuilder();
            for (ComputeService svc : services) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(svc.getContext().unwrap().getId());
            }
            throw new IllegalArgumentException("Multiple providers/apis are present, please select one using the --provider/--api argument in the following values: " + sb.toString());
        }
        return services.get(0);
    }

    private ComputeHelper() {
    }
}

