/*
 * JCublas - Java bindings for CUBLAS, the NVIDIA CUDA BLAS library,
 * to be used with JCuda
 *
 * Copyright (c) 2010-2016 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

 /* DO NOT EDIT THIS FILE - it is machine generated */
#include <jni.h>
 /* Header for class jcuda_jcublas_JCublas2 */

#ifndef _Included_jcuda_jcublas_JCublas2
#define _Included_jcuda_jcublas_JCublas2
#ifdef __cplusplus
extern "C" {
#endif
	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    setLogLevelNative
	* Signature: (I)V
	*/
	JNIEXPORT void JNICALL Java_jcuda_jcublas_JCublas2_setLogLevelNative
		(JNIEnv *, jclass, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSetVectorNative
	* Signature: (IILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSetVectorNative
		(JNIEnv *, jclass, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasGetVectorNative
	* Signature: (IILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasGetVectorNative
		(JNIEnv *, jclass, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSetMatrixNative
	* Signature: (IIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSetMatrixNative
		(JNIEnv *, jclass, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasGetMatrixNative
	* Signature: (IIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasGetMatrixNative
		(JNIEnv *, jclass, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSetVectorAsyncNative
	* Signature: (IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/runtime/cudaStream_t;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSetVectorAsyncNative
		(JNIEnv *, jclass, jint, jint, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasGetVectorAsyncNative
	* Signature: (IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/runtime/cudaStream_t;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasGetVectorAsyncNative
		(JNIEnv *, jclass, jint, jint, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSetMatrixAsyncNative
	* Signature: (IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/runtime/cudaStream_t;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSetMatrixAsyncNative
		(JNIEnv *, jclass, jint, jint, jint, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasGetMatrixAsyncNative
	* Signature: (IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/runtime/cudaStream_t;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasGetMatrixAsyncNative
		(JNIEnv *, jclass, jint, jint, jint, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCreateNative
	* Signature: (Ljcuda/jcublas/cublasHandle;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCreateNative
		(JNIEnv *, jclass, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDestroyNative
	* Signature: (Ljcuda/jcublas/cublasHandle;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDestroyNative
		(JNIEnv *, jclass, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasGetVersionNative
	* Signature: (Ljcuda/jcublas/cublasHandle;[I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasGetVersionNative
		(JNIEnv *, jclass, jobject, jintArray);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasGetPropertyNative
	* Signature: (I[I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasGetPropertyNative
		(JNIEnv *, jclass, jint, jintArray);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSetStreamNative
	* Signature: (Ljcuda/jcublas/cublasHandle;Ljcuda/runtime/cudaStream_t;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSetStreamNative
		(JNIEnv *, jclass, jobject, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasGetStreamNative
	* Signature: (Ljcuda/jcublas/cublasHandle;Ljcuda/runtime/cudaStream_t;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasGetStreamNative
		(JNIEnv *, jclass, jobject, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasGetPointerModeNative
	* Signature: (Ljcuda/jcublas/cublasHandle;[I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasGetPointerModeNative
		(JNIEnv *, jclass, jobject, jintArray);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSetPointerModeNative
	* Signature: (Ljcuda/jcublas/cublasHandle;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSetPointerModeNative
		(JNIEnv *, jclass, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasGetAtomicsModeNative
	* Signature: (Ljcuda/jcublas/cublasHandle;[I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasGetAtomicsModeNative
		(JNIEnv *, jclass, jobject, jintArray);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSetAtomicsModeNative
	* Signature: (Ljcuda/jcublas/cublasHandle;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSetAtomicsModeNative
		(JNIEnv *, jclass, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasGetMathModeNative
	* Signature: (Ljcuda/jcublas/cublasHandle;[I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasGetMathModeNative
		(JNIEnv *, jclass, jobject, jintArray);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSetMathModeNative
	* Signature: (Ljcuda/jcublas/cublasHandle;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSetMathModeNative
		(JNIEnv *, jclass, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasNrm2ExNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;IILjcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasNrm2ExNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jint, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSnrm2Native
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSnrm2Native
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDnrm2Native
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDnrm2Native
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasScnrm2Native
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasScnrm2Native
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDznrm2Native
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDznrm2Native
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDotExNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;IILjcuda/Pointer;IILjcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDotExNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jint, jobject, jint, jint, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDotcExNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;IILjcuda/Pointer;IILjcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDotcExNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jint, jobject, jint, jint, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSdotNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSdotNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDdotNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDdotNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCdotuNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCdotuNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCdotcNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCdotcNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZdotuNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZdotuNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZdotcNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZdotcNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasScalExNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;III)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasScalExNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSscalNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSscalNative
		(JNIEnv *, jclass, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDscalNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDscalNative
		(JNIEnv *, jclass, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCscalNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCscalNative
		(JNIEnv *, jclass, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCsscalNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCsscalNative
		(JNIEnv *, jclass, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZscalNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZscalNative
		(JNIEnv *, jclass, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZdscalNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZdscalNative
		(JNIEnv *, jclass, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasAxpyExNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;IILjcuda/Pointer;III)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasAxpyExNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jint, jobject, jint, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSaxpyNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSaxpyNative
		(JNIEnv *, jclass, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDaxpyNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDaxpyNative
		(JNIEnv *, jclass, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCaxpyNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCaxpyNative
		(JNIEnv *, jclass, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZaxpyNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZaxpyNative
		(JNIEnv *, jclass, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasScopyNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasScopyNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDcopyNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDcopyNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCcopyNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCcopyNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZcopyNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZcopyNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSswapNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSswapNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDswapNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDswapNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCswapNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCswapNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZswapNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZswapNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasIsamaxNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasIsamaxNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasIdamaxNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasIdamaxNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasIcamaxNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasIcamaxNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasIzamaxNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasIzamaxNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasIsaminNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasIsaminNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasIdaminNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasIdaminNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasIcaminNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasIcaminNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasIzaminNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasIzaminNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSasumNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSasumNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDasumNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDasumNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasScasumNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasScasumNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDzasumNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDzasumNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSrotNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSrotNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDrotNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDrotNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCrotNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCrotNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCsrotNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCsrotNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZrotNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZrotNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZdrotNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZdrotNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSrotgNative
	* Signature: (Ljcuda/jcublas/cublasHandle;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSrotgNative
		(JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDrotgNative
	* Signature: (Ljcuda/jcublas/cublasHandle;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDrotgNative
		(JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCrotgNative
	* Signature: (Ljcuda/jcublas/cublasHandle;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCrotgNative
		(JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZrotgNative
	* Signature: (Ljcuda/jcublas/cublasHandle;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZrotgNative
		(JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSrotmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSrotmNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDrotmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDrotmNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSrotmgNative
	* Signature: (Ljcuda/jcublas/cublasHandle;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSrotmgNative
		(JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDrotmgNative
	* Signature: (Ljcuda/jcublas/cublasHandle;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDrotmgNative
		(JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSgemvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSgemvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDgemvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDgemvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgemvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgemvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZgemvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZgemvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSgbmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSgbmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDgbmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDgbmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgbmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgbmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZgbmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZgbmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasStrmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasStrmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDtrmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDtrmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCtrmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCtrmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZtrmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZtrmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasStbmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasStbmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDtbmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDtbmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCtbmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCtbmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZtbmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZtbmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasStpmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasStpmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDtpmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDtpmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCtpmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCtpmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZtpmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZtpmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasStrsvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasStrsvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDtrsvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDtrsvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCtrsvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCtrsvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZtrsvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZtrsvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasStpsvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasStpsvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDtpsvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDtpsvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCtpsvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCtpsvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZtpsvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZtpsvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasStbsvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasStbsvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDtbsvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDtbsvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCtbsvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCtbsvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZtbsvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZtbsvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSsymvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSsymvNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDsymvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDsymvNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCsymvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCsymvNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZsymvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZsymvNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasChemvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasChemvNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZhemvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZhemvNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSsbmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSsbmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDsbmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDsbmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasChbmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasChbmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZhbmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZhbmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSspmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSspmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDspmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDspmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasChpmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasChpmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZhpmvNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZhpmvNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSgerNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSgerNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDgerNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDgerNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgeruNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgeruNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgercNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgercNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZgeruNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZgeruNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZgercNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZgercNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSsyrNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSsyrNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDsyrNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDsyrNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCsyrNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCsyrNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZsyrNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZsyrNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCherNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCherNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZherNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZherNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSsprNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSsprNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDsprNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDsprNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasChprNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasChprNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZhprNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZhprNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSsyr2Native
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSsyr2Native
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDsyr2Native
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDsyr2Native
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCsyr2Native
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCsyr2Native
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZsyr2Native
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZsyr2Native
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCher2Native
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCher2Native
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZher2Native
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZher2Native
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSspr2Native
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSspr2Native
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDspr2Native
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDspr2Native
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasChpr2Native
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasChpr2Native
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZhpr2Native
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZhpr2Native
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSgemmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSgemmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDgemmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDgemmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgemmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgemmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgemm3mNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgemm3mNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgemm3mExNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgemm3mExNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jint, jobject, jint, jint, jobject, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZgemmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZgemmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZgemm3mNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZgemm3mNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSgemmExNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSgemmExNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jint, jobject, jint, jint, jobject, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasGemmExNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;IIII)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasGemmExNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jint, jobject, jint, jint, jobject, jobject, jint, jint, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgemmExNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgemmExNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jint, jobject, jint, jint, jobject, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSsyrkNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSsyrkNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDsyrkNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDsyrkNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCsyrkNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCsyrkNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZsyrkNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZsyrkNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCsyrkExNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCsyrkExNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jint, jobject, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCsyrk3mExNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCsyrk3mExNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jint, jobject, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCherkNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCherkNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZherkNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZherkNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCherkExNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCherkExNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jint, jobject, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCherk3mExNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCherk3mExNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jint, jobject, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSsyr2kNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSsyr2kNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDsyr2kNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDsyr2kNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCsyr2kNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCsyr2kNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZsyr2kNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZsyr2kNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCher2kNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCher2kNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZher2kNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZher2kNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSsyrkxNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSsyrkxNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDsyrkxNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDsyrkxNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCsyrkxNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCsyrkxNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZsyrkxNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZsyrkxNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCherkxNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCherkxNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZherkxNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZherkxNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSsymmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSsymmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDsymmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDsymmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCsymmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCsymmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZsymmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZsymmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasChemmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasChemmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZhemmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZhemmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasStrsmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasStrsmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDtrsmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDtrsmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCtrsmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCtrsmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZtrsmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZtrsmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasStrmmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasStrmmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDtrmmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDtrmmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCtrmmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCtrmmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZtrmmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZtrmmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSgemmBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSgemmBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDgemmBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDgemmBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgemmBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgemmBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgemm3mBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgemm3mBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZgemmBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZgemmBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jobject, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasGemmBatchedExNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;IIIII)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasGemmBatchedExNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jint, jobject, jint, jint, jobject, jobject, jint, jint, jint, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasGemmStridedBatchedExNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;IIJLjcuda/Pointer;IIJLjcuda/Pointer;Ljcuda/Pointer;IIJIII)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasGemmStridedBatchedExNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jint, jlong, jobject, jint, jint, jlong, jobject, jobject, jint, jint, jlong, jint, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSgemmStridedBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;IJLjcuda/Pointer;IJLjcuda/Pointer;Ljcuda/Pointer;IJI)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSgemmStridedBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jlong, jobject, jint, jlong, jobject, jobject, jint, jlong, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDgemmStridedBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;IJLjcuda/Pointer;IJLjcuda/Pointer;Ljcuda/Pointer;IJI)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDgemmStridedBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jlong, jobject, jint, jlong, jobject, jobject, jint, jlong, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgemmStridedBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;IJLjcuda/Pointer;IJLjcuda/Pointer;Ljcuda/Pointer;IJI)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgemmStridedBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jlong, jobject, jint, jlong, jobject, jobject, jint, jlong, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgemm3mStridedBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;IJLjcuda/Pointer;IJLjcuda/Pointer;Ljcuda/Pointer;IJI)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgemm3mStridedBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jlong, jobject, jint, jlong, jobject, jobject, jint, jlong, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZgemmStridedBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIILjcuda/Pointer;Ljcuda/Pointer;IJLjcuda/Pointer;IJLjcuda/Pointer;Ljcuda/Pointer;IJI)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZgemmStridedBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jint, jlong, jobject, jint, jlong, jobject, jobject, jint, jlong, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSgeamNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSgeamNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDgeamNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDgeamNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgeamNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgeamNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZgeamNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZgeamNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSgetrfBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSgetrfBatchedNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDgetrfBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDgetrfBatchedNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgetrfBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgetrfBatchedNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZgetrfBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZgetrfBatchedNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSgetriBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSgetriBatchedNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDgetriBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDgetriBatchedNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgetriBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgetriBatchedNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZgetriBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZgetriBatchedNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSgetrsBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSgetrsBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDgetrsBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDgetrsBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgetrsBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgetrsBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZgetrsBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZgetrsBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasStrsmBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasStrsmBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDtrsmBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDtrsmBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCtrsmBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCtrsmBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZtrsmBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;II)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZtrsmBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jint, jobject, jint, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSmatinvBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSmatinvBatchedNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDmatinvBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDmatinvBatchedNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCmatinvBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCmatinvBatchedNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZmatinvBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZmatinvBatchedNative
		(JNIEnv *, jclass, jobject, jint, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSgeqrfBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSgeqrfBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDgeqrfBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDgeqrfBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgeqrfBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgeqrfBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZgeqrfBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZgeqrfBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSgelsBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSgelsBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDgelsBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDgelsBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCgelsBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCgelsBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZgelsBatchedNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZgelsBatchedNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasSdgmmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasSdgmmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDdgmmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDdgmmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCdgmmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCdgmmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZdgmmNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZdgmmNative
		(JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasStpttrNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasStpttrNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDtpttrNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDtpttrNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCtpttrNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCtpttrNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZtpttrNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;Ljcuda/Pointer;I)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZtpttrNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasStrttpNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasStrttpNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasDtrttpNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasDtrttpNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasCtrttpNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasCtrttpNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jint, jobject);

	/*
	* Class:     jcuda_jcublas_JCublas2
	* Method:    cublasZtrttpNative
	* Signature: (Ljcuda/jcublas/cublasHandle;IILjcuda/Pointer;ILjcuda/Pointer;)I
	*/
	JNIEXPORT jint JNICALL Java_jcuda_jcublas_JCublas2_cublasZtrttpNative
		(JNIEnv *, jclass, jobject, jint, jint, jobject, jint, jobject);

#ifdef __cplusplus
}
#endif
#endif
