/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcublas;

import jcuda.CudaException;
import jcuda.JCudaVersion;
import jcuda.LibUtils;
import jcuda.LibUtilsCuda;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.jcublas.cublasHandle;
import jcuda.jcublas.cublasLogCallback;
import jcuda.jcublas.cublasStatus;
import jcuda.runtime.cudaStream_t;

public class JCublas2 {
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    private JCublas2() {
    }

    public static void initialize() {
        if (!initialized) {
            String libraryBaseName = "JCublas2-" + JCudaVersion.get();
            String libraryName = LibUtils.createPlatformLibraryName((String)libraryBaseName);
            LibUtilsCuda.loadLibrary((String)libraryName, (String[])new String[0]);
            initialized = true;
        }
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCublas2.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(cublasStatus.stringFor(result));
        }
        return result;
    }

    public static int cublasSetVector(int n, int elemSize, Pointer x, int incx, Pointer devicePtr, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSetVectorNative(n, elemSize, x, incx, devicePtr, incy));
    }

    private static native int cublasSetVectorNative(int var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasGetVector(int n, int elemSize, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasGetVectorNative(n, elemSize, x, incx, y, incy));
    }

    private static native int cublasGetVectorNative(int var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasSetMatrix(int rows, int cols, int elemSize, Pointer A, int lda, Pointer B, int ldb) {
        return JCublas2.checkResult(JCublas2.cublasSetMatrixNative(rows, cols, elemSize, A, lda, B, ldb));
    }

    private static native int cublasSetMatrixNative(int var0, int var1, int var2, Pointer var3, int var4, Pointer var5, int var6);

    public static int cublasGetMatrix(int rows, int cols, int elemSize, Pointer A, int lda, Pointer B, int ldb) {
        return JCublas2.checkResult(JCublas2.cublasGetMatrixNative(rows, cols, elemSize, A, lda, B, ldb));
    }

    private static native int cublasGetMatrixNative(int var0, int var1, int var2, Pointer var3, int var4, Pointer var5, int var6);

    public static int cublasSetVectorAsync(int n, int elemSize, Pointer hostPtr, int incx, Pointer devicePtr, int incy, cudaStream_t stream) {
        return JCublas2.checkResult(JCublas2.cublasSetVectorAsyncNative(n, elemSize, hostPtr, incx, devicePtr, incy, stream));
    }

    private static native int cublasSetVectorAsyncNative(int var0, int var1, Pointer var2, int var3, Pointer var4, int var5, cudaStream_t var6);

    public static int cublasGetVectorAsync(int n, int elemSize, Pointer devicePtr, int incx, Pointer hostPtr, int incy, cudaStream_t stream) {
        return JCublas2.checkResult(JCublas2.cublasGetVectorAsyncNative(n, elemSize, devicePtr, incx, hostPtr, incy, stream));
    }

    private static native int cublasGetVectorAsyncNative(int var0, int var1, Pointer var2, int var3, Pointer var4, int var5, cudaStream_t var6);

    public static int cublasSetMatrixAsync(int rows, int cols, int elemSize, Pointer A, int lda, Pointer B, int ldb, cudaStream_t stream) {
        return JCublas2.checkResult(JCublas2.cublasSetMatrixAsyncNative(rows, cols, elemSize, A, lda, B, ldb, stream));
    }

    private static native int cublasSetMatrixAsyncNative(int var0, int var1, int var2, Pointer var3, int var4, Pointer var5, int var6, cudaStream_t var7);

    public static int cublasGetMatrixAsync(int rows, int cols, int elemSize, Pointer A, int lda, Pointer B, int ldb, cudaStream_t stream) {
        return JCublas2.checkResult(JCublas2.cublasGetMatrixAsyncNative(rows, cols, elemSize, A, lda, B, ldb, stream));
    }

    private static native int cublasGetMatrixAsyncNative(int var0, int var1, int var2, Pointer var3, int var4, Pointer var5, int var6, cudaStream_t var7);

    public static int cublasSetVector_64(long n, long elemSize, Pointer x, long incx, Pointer devicePtr, long incy) {
        return JCublas2.checkResult(JCublas2.cublasSetVector_64Native(n, elemSize, x, incx, devicePtr, incy));
    }

    private static native int cublasSetVector_64Native(long var0, long var2, Pointer var4, long var5, Pointer var7, long var8);

    public static int cublasGetVector_64(long n, long elemSize, Pointer x, long incx, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasGetVector_64Native(n, elemSize, x, incx, y, incy));
    }

    private static native int cublasGetVector_64Native(long var0, long var2, Pointer var4, long var5, Pointer var7, long var8);

    public static int cublasSetMatrix_64(long rows, long cols, long elemSize, Pointer A, long lda, Pointer B, long ldb) {
        return JCublas2.checkResult(JCublas2.cublasSetMatrix_64Native(rows, cols, elemSize, A, lda, B, ldb));
    }

    private static native int cublasSetMatrix_64Native(long var0, long var2, long var4, Pointer var6, long var7, Pointer var9, long var10);

    public static int cublasGetMatrix_64(long rows, long cols, long elemSize, Pointer A, long lda, Pointer B, long ldb) {
        return JCublas2.checkResult(JCublas2.cublasGetMatrix_64Native(rows, cols, elemSize, A, lda, B, ldb));
    }

    private static native int cublasGetMatrix_64Native(long var0, long var2, long var4, Pointer var6, long var7, Pointer var9, long var10);

    public static int cublasSetVectorAsync_64(long n, long elemSize, Pointer hostPtr, long incx, Pointer devicePtr, long incy, cudaStream_t stream) {
        return JCublas2.checkResult(JCublas2.cublasSetVectorAsync_64Native(n, elemSize, hostPtr, incx, devicePtr, incy, stream));
    }

    private static native int cublasSetVectorAsync_64Native(long var0, long var2, Pointer var4, long var5, Pointer var7, long var8, cudaStream_t var10);

    public static int cublasGetVectorAsync_64(int n, int elemSize, Pointer devicePtr, int incx, Pointer hostPtr, int incy, cudaStream_t stream) {
        return JCublas2.checkResult(JCublas2.cublasGetVectorAsync_64Native(n, elemSize, devicePtr, incx, hostPtr, incy, stream));
    }

    private static native int cublasGetVectorAsync_64Native(long var0, long var2, Pointer var4, long var5, Pointer var7, long var8, cudaStream_t var10);

    public static int cublasSetMatrixAsync_64(long rows, long cols, long elemSize, Pointer A, long lda, Pointer B, long ldb, cudaStream_t stream) {
        return JCublas2.checkResult(JCublas2.cublasSetMatrixAsync_64Native(rows, cols, elemSize, A, lda, B, ldb, stream));
    }

    private static native int cublasSetMatrixAsync_64Native(long var0, long var2, long var4, Pointer var6, long var7, Pointer var9, long var10, cudaStream_t var12);

    public static int cublasGetMatrixAsync_64(long rows, long cols, long elemSize, Pointer A, long lda, Pointer B, long ldb, cudaStream_t stream) {
        return JCublas2.checkResult(JCublas2.cublasGetMatrixAsync_64Native(rows, cols, elemSize, A, lda, B, ldb, stream));
    }

    private static native int cublasGetMatrixAsync_64Native(long var0, long var2, long var4, Pointer var6, long var7, Pointer var9, long var10, cudaStream_t var12);

    private static int cublasMigrateComputeType(cublasHandle handle, int dataType, int[] computeType) {
        int[] mathMode = new int[]{0};
        int status = 0;
        status = JCublas2.cublasGetMathMode(handle, mathMode);
        if (status != 0) {
            return status;
        }
        boolean isPedantic = (mathMode[0] & 0xF) == 2;
        switch (dataType) {
            case 0: 
            case 4: {
                computeType[0] = isPedantic ? 69 : 68;
                return 0;
            }
            case 1: 
            case 5: {
                computeType[0] = isPedantic ? 71 : 70;
                return 0;
            }
            case 2: {
                computeType[0] = isPedantic ? 65 : 64;
                return 0;
            }
            case 10: {
                computeType[0] = isPedantic ? 73 : 72;
                return 0;
            }
        }
        return 15;
    }

    public static int cublasGemmEx(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int Atype, int lda, Pointer B, int Btype, int ldb, Pointer beta, Pointer C, int Ctype, int ldc, int computeType, int algo) {
        int[] cublasComputeType2 = new int[]{0};
        int status = JCublas2.cublasMigrateComputeType(handle, computeType, cublasComputeType2);
        if (status != 0) {
            return status;
        }
        return JCublas2.cublasGemmEx_new(handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype, ldc, cublasComputeType2[0], algo);
    }

    public static int cublasGemmBatchedEx(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer Aarray, int Atype, int lda, Pointer Barray, int Btype, int ldb, Pointer beta, Pointer Carray, int Ctype, int ldc, int batchCount, int computeType, int algo) {
        int[] cublasComputeType2 = new int[]{0};
        int status = JCublas2.cublasMigrateComputeType(handle, computeType, cublasComputeType2);
        if (status != 0) {
            return status;
        }
        return JCublas2.cublasGemmBatchedEx_new(handle, transa, transb, m, n, k, alpha, Aarray, Atype, lda, Barray, Btype, ldb, beta, Carray, Ctype, ldc, batchCount, cublasComputeType2[0], algo);
    }

    public static int cublasGemmStridedBatchedEx(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int Atype, int lda, long strideA, Pointer B, int Btype, int ldb, long strideB, Pointer beta, Pointer C, int Ctype, int ldc, long strideC, int batchCount, int computeType, int algo) {
        int[] cublasComputeType2 = new int[]{0};
        int status = JCublas2.cublasMigrateComputeType(handle, computeType, cublasComputeType2);
        if (status != 0) {
            return status;
        }
        return JCublas2.cublasGemmStridedBatchedEx_new(handle, transa, transb, m, n, k, alpha, A, Atype, lda, strideA, B, Btype, ldb, strideB, beta, C, Ctype, ldc, strideC, batchCount, cublasComputeType2[0], algo);
    }

    public static int cublasCreate(cublasHandle handle) {
        return JCublas2.checkResult(JCublas2.cublasCreateNative(handle));
    }

    private static native int cublasCreateNative(cublasHandle var0);

    public static int cublasDestroy(cublasHandle handle) {
        return JCublas2.checkResult(JCublas2.cublasDestroyNative(handle));
    }

    private static native int cublasDestroyNative(cublasHandle var0);

    public static int cublasGetVersion(cublasHandle handle, int[] version) {
        return JCublas2.checkResult(JCublas2.cublasGetVersionNative(handle, version));
    }

    private static native int cublasGetVersionNative(cublasHandle var0, int[] var1);

    public static int cublasGetProperty(int type, int[] value) {
        return JCublas2.checkResult(JCublas2.cublasGetPropertyNative(type, value));
    }

    private static native int cublasGetPropertyNative(int var0, int[] var1);

    public static long cublasGetCudartVersion() {
        return JCublas2.cublasGetCudartVersionNative();
    }

    private static native long cublasGetCudartVersionNative();

    public static int cublasSetWorkspace(cublasHandle handle, Pointer workspace, long workspaceSizeInBytes) {
        return JCublas2.checkResult(JCublas2.cublasSetWorkspaceNative(handle, workspace, workspaceSizeInBytes));
    }

    private static native int cublasSetWorkspaceNative(cublasHandle var0, Pointer var1, long var2);

    public static int cublasSetStream(cublasHandle handle, cudaStream_t streamId) {
        return JCublas2.checkResult(JCublas2.cublasSetStreamNative(handle, streamId));
    }

    private static native int cublasSetStreamNative(cublasHandle var0, cudaStream_t var1);

    public static int cublasGetStream(cublasHandle handle, cudaStream_t streamId) {
        return JCublas2.checkResult(JCublas2.cublasGetStreamNative(handle, streamId));
    }

    private static native int cublasGetStreamNative(cublasHandle var0, cudaStream_t var1);

    public static int cublasGetPointerMode(cublasHandle handle, int[] mode) {
        return JCublas2.checkResult(JCublas2.cublasGetPointerModeNative(handle, mode));
    }

    private static native int cublasGetPointerModeNative(cublasHandle var0, int[] var1);

    public static int cublasSetPointerMode(cublasHandle handle, int mode) {
        return JCublas2.checkResult(JCublas2.cublasSetPointerModeNative(handle, mode));
    }

    private static native int cublasSetPointerModeNative(cublasHandle var0, int var1);

    public static int cublasGetAtomicsMode(cublasHandle handle, int[] mode) {
        return JCublas2.checkResult(JCublas2.cublasGetAtomicsModeNative(handle, mode));
    }

    private static native int cublasGetAtomicsModeNative(cublasHandle var0, int[] var1);

    public static int cublasSetAtomicsMode(cublasHandle handle, int mode) {
        return JCublas2.checkResult(JCublas2.cublasSetAtomicsModeNative(handle, mode));
    }

    private static native int cublasSetAtomicsModeNative(cublasHandle var0, int var1);

    public static int cublasGetMathMode(cublasHandle handle, int[] mode) {
        return JCublas2.checkResult(JCublas2.cublasGetMathModeNative(handle, mode));
    }

    private static native int cublasGetMathModeNative(cublasHandle var0, int[] var1);

    public static int cublasSetMathMode(cublasHandle handle, int mode) {
        return JCublas2.checkResult(JCublas2.cublasSetMathModeNative(handle, mode));
    }

    private static native int cublasSetMathModeNative(cublasHandle var0, int var1);

    public static int cublasGetSmCountTarget(cublasHandle handle, Pointer smCountTarget) {
        return JCublas2.checkResult(JCublas2.cublasGetSmCountTargetNative(handle, smCountTarget));
    }

    private static native int cublasGetSmCountTargetNative(cublasHandle var0, Pointer var1);

    public static int cublasSetSmCountTarget(cublasHandle handle, int smCountTarget) {
        return JCublas2.checkResult(JCublas2.cublasSetSmCountTargetNative(handle, smCountTarget));
    }

    private static native int cublasSetSmCountTargetNative(cublasHandle var0, int var1);

    public static String cublasGetStatusName(int status) {
        return JCublas2.cublasGetStatusNameNative(status);
    }

    private static native String cublasGetStatusNameNative(int var0);

    public static String cublasGetStatusString(int status) {
        return JCublas2.cublasGetStatusStringNative(status);
    }

    private static native String cublasGetStatusStringNative(int var0);

    public static int cublasLoggerConfigure(int logIsOn, int logToStdOut, int logToStdErr, String logFileName) {
        return JCublas2.checkResult(JCublas2.cublasLoggerConfigureNative(logIsOn, logToStdOut, logToStdErr, logFileName));
    }

    private static native int cublasLoggerConfigureNative(int var0, int var1, int var2, String var3);

    public static int cublasSetLoggerCallback(cublasLogCallback userCallback) {
        return JCublas2.checkResult(JCublas2.cublasSetLoggerCallbackNative(userCallback));
    }

    private static native int cublasSetLoggerCallbackNative(cublasLogCallback var0);

    public static int cublasGetLoggerCallback(cublasLogCallback[] userCallback) {
        return JCublas2.checkResult(JCublas2.cublasGetLoggerCallbackNative(userCallback));
    }

    private static native int cublasGetLoggerCallbackNative(cublasLogCallback[] var0);

    public static int cublasNrm2Ex(cublasHandle handle, int n, Pointer x, int xType, int incx, Pointer result, int resultType, int executionType) {
        return JCublas2.checkResult(JCublas2.cublasNrm2ExNative(handle, n, x, xType, incx, result, resultType, executionType));
    }

    private static native int cublasNrm2ExNative(cublasHandle var0, int var1, Pointer var2, int var3, int var4, Pointer var5, int var6, int var7);

    public static int cublasNrm2Ex_64(cublasHandle handle, long n, Pointer x, int xType, long incx, Pointer result, int resultType, int executionType) {
        return JCublas2.checkResult(JCublas2.cublasNrm2Ex_64Native(handle, n, x, xType, incx, result, resultType, executionType));
    }

    private static native int cublasNrm2Ex_64Native(cublasHandle var0, long var1, Pointer var3, int var4, long var5, Pointer var7, int var8, int var9);

    public static int cublasSnrm2(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasSnrm2Native(handle, n, x, incx, result));
    }

    private static native int cublasSnrm2Native(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasSnrm2_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasSnrm2_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasSnrm2_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6);

    public static int cublasDnrm2(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasDnrm2Native(handle, n, x, incx, result));
    }

    private static native int cublasDnrm2Native(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasDnrm2_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasDnrm2_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasDnrm2_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6);

    public static int cublasScnrm2(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasScnrm2Native(handle, n, x, incx, result));
    }

    private static native int cublasScnrm2Native(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasScnrm2_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasScnrm2_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasScnrm2_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6);

    public static int cublasDznrm2(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasDznrm2Native(handle, n, x, incx, result));
    }

    private static native int cublasDznrm2Native(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasDznrm2_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasDznrm2_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasDznrm2_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6);

    public static int cublasDotEx(cublasHandle handle, int n, Pointer x, int xType, int incx, Pointer y, int yType, int incy, Pointer result, int resultType, int executionType) {
        return JCublas2.checkResult(JCublas2.cublasDotExNative(handle, n, x, xType, incx, y, yType, incy, result, resultType, executionType));
    }

    private static native int cublasDotExNative(cublasHandle var0, int var1, Pointer var2, int var3, int var4, Pointer var5, int var6, int var7, Pointer var8, int var9, int var10);

    public static int cublasDotEx_64(cublasHandle handle, long n, Pointer x, int xType, long incx, Pointer y, int yType, long incy, Pointer result, int resultType, int executionType) {
        return JCublas2.checkResult(JCublas2.cublasDotEx_64Native(handle, n, x, xType, incx, y, yType, incy, result, resultType, executionType));
    }

    private static native int cublasDotEx_64Native(cublasHandle var0, long var1, Pointer var3, int var4, long var5, Pointer var7, int var8, long var9, Pointer var11, int var12, int var13);

    public static int cublasDotcEx(cublasHandle handle, int n, Pointer x, int xType, int incx, Pointer y, int yType, int incy, Pointer result, int resultType, int executionType) {
        return JCublas2.checkResult(JCublas2.cublasDotcExNative(handle, n, x, xType, incx, y, yType, incy, result, resultType, executionType));
    }

    private static native int cublasDotcExNative(cublasHandle var0, int var1, Pointer var2, int var3, int var4, Pointer var5, int var6, int var7, Pointer var8, int var9, int var10);

    public static int cublasDotcEx_64(cublasHandle handle, long n, Pointer x, int xType, long incx, Pointer y, int yType, long incy, Pointer result, int resultType, int executionType) {
        return JCublas2.checkResult(JCublas2.cublasDotcEx_64Native(handle, n, x, xType, incx, y, yType, incy, result, resultType, executionType));
    }

    private static native int cublasDotcEx_64Native(cublasHandle var0, long var1, Pointer var3, int var4, long var5, Pointer var7, int var8, long var9, Pointer var11, int var12, int var13);

    public static int cublasSdot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasSdotNative(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasSdotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasSdot_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasSdot_v2_64Native(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasSdot_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7, Pointer var9);

    public static int cublasDdot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasDdotNative(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasDdotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasDdot_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasDdot_v2_64Native(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasDdot_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7, Pointer var9);

    public static int cublasCdotu(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasCdotuNative(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasCdotuNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasCdotu_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasCdotu_v2_64Native(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasCdotu_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7, Pointer var9);

    public static int cublasCdotc(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasCdotcNative(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasCdotcNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasCdotc_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasCdotc_v2_64Native(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasCdotc_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7, Pointer var9);

    public static int cublasZdotu(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasZdotuNative(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasZdotuNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasZdotu_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasZdotu_v2_64Native(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasZdotu_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7, Pointer var9);

    public static int cublasZdotc(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasZdotcNative(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasZdotcNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasZdotc_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasZdotc_v2_64Native(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasZdotc_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7, Pointer var9);

    public static int cublasScalEx(cublasHandle handle, int n, Pointer alpha, int alphaType, Pointer x, int xType, int incx, int executionType) {
        return JCublas2.checkResult(JCublas2.cublasScalExNative(handle, n, alpha, alphaType, x, xType, incx, executionType));
    }

    private static native int cublasScalExNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, int var6, int var7);

    public static int cublasScalEx_64(cublasHandle handle, long n, Pointer alpha, int alphaType, Pointer x, int xType, long incx, int executionType) {
        return JCublas2.checkResult(JCublas2.cublasScalEx_64Native(handle, n, alpha, alphaType, x, xType, incx, executionType));
    }

    private static native int cublasScalEx_64Native(cublasHandle var0, long var1, Pointer var3, int var4, Pointer var5, int var6, long var7, int var9);

    public static int cublasSscal(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasSscalNative(handle, n, alpha, x, incx));
    }

    private static native int cublasSscalNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4);

    public static int cublasSscal_v2_64(cublasHandle handle, long n, Pointer alpha, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasSscal_v2_64Native(handle, n, alpha, x, incx));
    }

    private static native int cublasSscal_v2_64Native(cublasHandle var0, long var1, Pointer var3, Pointer var4, long var5);

    public static int cublasDscal(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasDscalNative(handle, n, alpha, x, incx));
    }

    private static native int cublasDscalNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4);

    public static int cublasDscal_v2_64(cublasHandle handle, long n, Pointer alpha, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasDscal_v2_64Native(handle, n, alpha, x, incx));
    }

    private static native int cublasDscal_v2_64Native(cublasHandle var0, long var1, Pointer var3, Pointer var4, long var5);

    public static int cublasCscal(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCscalNative(handle, n, alpha, x, incx));
    }

    private static native int cublasCscalNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4);

    public static int cublasCscal_v2_64(cublasHandle handle, long n, Pointer alpha, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasCscal_v2_64Native(handle, n, alpha, x, incx));
    }

    private static native int cublasCscal_v2_64Native(cublasHandle var0, long var1, Pointer var3, Pointer var4, long var5);

    public static int cublasCsscal(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCsscalNative(handle, n, alpha, x, incx));
    }

    private static native int cublasCsscalNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4);

    public static int cublasCsscal_v2_64(cublasHandle handle, long n, Pointer alpha, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasCsscal_v2_64Native(handle, n, alpha, x, incx));
    }

    private static native int cublasCsscal_v2_64Native(cublasHandle var0, long var1, Pointer var3, Pointer var4, long var5);

    public static int cublasZscal(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZscalNative(handle, n, alpha, x, incx));
    }

    private static native int cublasZscalNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4);

    public static int cublasZscal_v2_64(cublasHandle handle, long n, Pointer alpha, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasZscal_v2_64Native(handle, n, alpha, x, incx));
    }

    private static native int cublasZscal_v2_64Native(cublasHandle var0, long var1, Pointer var3, Pointer var4, long var5);

    public static int cublasZdscal(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZdscalNative(handle, n, alpha, x, incx));
    }

    private static native int cublasZdscalNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4);

    public static int cublasZdscal_v2_64(cublasHandle handle, long n, Pointer alpha, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasZdscal_v2_64Native(handle, n, alpha, x, incx));
    }

    private static native int cublasZdscal_v2_64Native(cublasHandle var0, long var1, Pointer var3, Pointer var4, long var5);

    public static int cublasAxpyEx(cublasHandle handle, int n, Pointer alpha, int alphaType, Pointer x, int xType, int incx, Pointer y, int yType, int incy, int executiontype) {
        return JCublas2.checkResult(JCublas2.cublasAxpyExNative(handle, n, alpha, alphaType, x, xType, incx, y, yType, incy, executiontype));
    }

    private static native int cublasAxpyExNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, int var6, Pointer var7, int var8, int var9, int var10);

    public static int cublasAxpyEx_64(cublasHandle handle, long n, Pointer alpha, int alphaType, Pointer x, int xType, long incx, Pointer y, int yType, long incy, int executiontype) {
        return JCublas2.checkResult(JCublas2.cublasAxpyEx_64Native(handle, n, alpha, alphaType, x, xType, incx, y, yType, incy, executiontype));
    }

    private static native int cublasAxpyEx_64Native(cublasHandle var0, long var1, Pointer var3, int var4, Pointer var5, int var6, long var7, Pointer var9, int var10, long var11, int var13);

    public static int cublasSaxpy(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSaxpyNative(handle, n, alpha, x, incx, y, incy));
    }

    private static native int cublasSaxpyNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4, Pointer var5, int var6);

    public static int cublasSaxpy_v2_64(cublasHandle handle, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasSaxpy_v2_64Native(handle, n, alpha, x, incx, y, incy));
    }

    private static native int cublasSaxpy_v2_64Native(cublasHandle var0, long var1, Pointer var3, Pointer var4, long var5, Pointer var7, long var8);

    public static int cublasDaxpy(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDaxpyNative(handle, n, alpha, x, incx, y, incy));
    }

    private static native int cublasDaxpyNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4, Pointer var5, int var6);

    public static int cublasDaxpy_v2_64(cublasHandle handle, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasDaxpy_v2_64Native(handle, n, alpha, x, incx, y, incy));
    }

    private static native int cublasDaxpy_v2_64Native(cublasHandle var0, long var1, Pointer var3, Pointer var4, long var5, Pointer var7, long var8);

    public static int cublasCaxpy(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasCaxpyNative(handle, n, alpha, x, incx, y, incy));
    }

    private static native int cublasCaxpyNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4, Pointer var5, int var6);

    public static int cublasCaxpy_v2_64(cublasHandle handle, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasCaxpy_v2_64Native(handle, n, alpha, x, incx, y, incy));
    }

    private static native int cublasCaxpy_v2_64Native(cublasHandle var0, long var1, Pointer var3, Pointer var4, long var5, Pointer var7, long var8);

    public static int cublasZaxpy(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZaxpyNative(handle, n, alpha, x, incx, y, incy));
    }

    private static native int cublasZaxpyNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4, Pointer var5, int var6);

    public static int cublasZaxpy_v2_64(cublasHandle handle, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasZaxpy_v2_64Native(handle, n, alpha, x, incx, y, incy));
    }

    private static native int cublasZaxpy_v2_64Native(cublasHandle var0, long var1, Pointer var3, Pointer var4, long var5, Pointer var7, long var8);

    public static int cublasCopyEx(cublasHandle handle, int n, Pointer x, int xType, int incx, Pointer y, int yType, int incy) {
        return JCublas2.checkResult(JCublas2.cublasCopyExNative(handle, n, x, xType, incx, y, yType, incy));
    }

    private static native int cublasCopyExNative(cublasHandle var0, int var1, Pointer var2, int var3, int var4, Pointer var5, int var6, int var7);

    public static int cublasCopyEx_64(cublasHandle handle, long n, Pointer x, int xType, long incx, Pointer y, int yType, long incy) {
        return JCublas2.checkResult(JCublas2.cublasCopyEx_64Native(handle, n, x, xType, incx, y, yType, incy));
    }

    private static native int cublasCopyEx_64Native(cublasHandle var0, long var1, Pointer var3, int var4, long var5, Pointer var7, int var8, long var9);

    public static int cublasScopy(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasScopyNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasScopyNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasScopy_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasScopy_v2_64Native(handle, n, x, incx, y, incy));
    }

    private static native int cublasScopy_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7);

    public static int cublasDcopy(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDcopyNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasDcopyNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasDcopy_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasDcopy_v2_64Native(handle, n, x, incx, y, incy));
    }

    private static native int cublasDcopy_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7);

    public static int cublasCcopy(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasCcopyNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasCcopyNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasCcopy_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasCcopy_v2_64Native(handle, n, x, incx, y, incy));
    }

    private static native int cublasCcopy_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7);

    public static int cublasZcopy(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZcopyNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasZcopyNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasZcopy_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasZcopy_v2_64Native(handle, n, x, incx, y, incy));
    }

    private static native int cublasZcopy_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7);

    public static int cublasSswap(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSswapNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasSswapNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasSswap_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasSswap_v2_64Native(handle, n, x, incx, y, incy));
    }

    private static native int cublasSswap_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7);

    public static int cublasDswap(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDswapNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasDswapNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasDswap_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasDswap_v2_64Native(handle, n, x, incx, y, incy));
    }

    private static native int cublasDswap_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7);

    public static int cublasCswap(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasCswapNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasCswapNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasCswap_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasCswap_v2_64Native(handle, n, x, incx, y, incy));
    }

    private static native int cublasCswap_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7);

    public static int cublasZswap(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZswapNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasZswapNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasZswap_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasZswap_v2_64Native(handle, n, x, incx, y, incy));
    }

    private static native int cublasZswap_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7);

    public static int cublasSwapEx(cublasHandle handle, int n, Pointer x, int xType, int incx, Pointer y, int yType, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSwapExNative(handle, n, x, xType, incx, y, yType, incy));
    }

    private static native int cublasSwapExNative(cublasHandle var0, int var1, Pointer var2, int var3, int var4, Pointer var5, int var6, int var7);

    public static int cublasSwapEx_64(cublasHandle handle, long n, Pointer x, int xType, long incx, Pointer y, int yType, long incy) {
        return JCublas2.checkResult(JCublas2.cublasSwapEx_64Native(handle, n, x, xType, incx, y, yType, incy));
    }

    private static native int cublasSwapEx_64Native(cublasHandle var0, long var1, Pointer var3, int var4, long var5, Pointer var7, int var8, long var9);

    public static int cublasIsamax(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIsamaxNative(handle, n, x, incx, result));
    }

    private static native int cublasIsamaxNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasIsamax_v2_64(cublasHandle handle, long n, Pointer x, long incx, long[] result) {
        return JCublas2.checkResult(JCublas2.cublasIsamax_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasIsamax_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, long[] var6);

    public static int cublasIdamax(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIdamaxNative(handle, n, x, incx, result));
    }

    private static native int cublasIdamaxNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasIdamax_v2_64(cublasHandle handle, long n, Pointer x, long incx, long[] result) {
        return JCublas2.checkResult(JCublas2.cublasIdamax_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasIdamax_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, long[] var6);

    public static int cublasIcamax(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIcamaxNative(handle, n, x, incx, result));
    }

    private static native int cublasIcamaxNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasIcamax_v2_64(cublasHandle handle, long n, Pointer x, long incx, long[] result) {
        return JCublas2.checkResult(JCublas2.cublasIcamax_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasIcamax_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, long[] var6);

    public static int cublasIzamax(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIzamaxNative(handle, n, x, incx, result));
    }

    private static native int cublasIzamaxNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasIzamax_v2_64(cublasHandle handle, long n, Pointer x, long incx, long[] result) {
        return JCublas2.checkResult(JCublas2.cublasIzamax_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasIzamax_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, long[] var6);

    public static int cublasIamaxEx(cublasHandle handle, int n, Pointer x, int xType, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIamaxExNative(handle, n, x, xType, incx, result));
    }

    private static native int cublasIamaxExNative(cublasHandle var0, int var1, Pointer var2, int var3, int var4, Pointer var5);

    public static int cublasIamaxEx_64(cublasHandle handle, long n, Pointer x, int xType, long incx, long[] result) {
        return JCublas2.checkResult(JCublas2.cublasIamaxEx_64Native(handle, n, x, xType, incx, result));
    }

    private static native int cublasIamaxEx_64Native(cublasHandle var0, long var1, Pointer var3, int var4, long var5, long[] var7);

    public static int cublasIsamin(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIsaminNative(handle, n, x, incx, result));
    }

    private static native int cublasIsaminNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasIsamin_v2_64(cublasHandle handle, long n, Pointer x, long incx, long[] result) {
        return JCublas2.checkResult(JCublas2.cublasIsamin_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasIsamin_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, long[] var6);

    public static int cublasIdamin(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIdaminNative(handle, n, x, incx, result));
    }

    private static native int cublasIdaminNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasIdamin_v2_64(cublasHandle handle, long n, Pointer x, long incx, long[] result) {
        return JCublas2.checkResult(JCublas2.cublasIdamin_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasIdamin_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, long[] var6);

    public static int cublasIcamin(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIcaminNative(handle, n, x, incx, result));
    }

    private static native int cublasIcaminNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasIcamin_v2_64(cublasHandle handle, long n, Pointer x, long incx, long[] result) {
        return JCublas2.checkResult(JCublas2.cublasIcamin_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasIcamin_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, long[] var6);

    public static int cublasIzamin(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIzaminNative(handle, n, x, incx, result));
    }

    private static native int cublasIzaminNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasIzamin_v2_64(cublasHandle handle, long n, Pointer x, long incx, long[] result) {
        return JCublas2.checkResult(JCublas2.cublasIzamin_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasIzamin_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, long[] var6);

    public static int cublasIaminEx(cublasHandle handle, int n, Pointer x, int xType, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIaminExNative(handle, n, x, xType, incx, result));
    }

    private static native int cublasIaminExNative(cublasHandle var0, int var1, Pointer var2, int var3, int var4, Pointer var5);

    public static int cublasIaminEx_64(cublasHandle handle, long n, Pointer x, int xType, long incx, long[] result) {
        return JCublas2.checkResult(JCublas2.cublasIaminEx_64Native(handle, n, x, xType, incx, result));
    }

    private static native int cublasIaminEx_64Native(cublasHandle var0, long var1, Pointer var3, int var4, long var5, long[] var7);

    public static int cublasAsumEx(cublasHandle handle, int n, Pointer x, int xType, int incx, Pointer result, int resultType, int executiontype) {
        return JCublas2.checkResult(JCublas2.cublasAsumExNative(handle, n, x, xType, incx, result, resultType, executiontype));
    }

    private static native int cublasAsumExNative(cublasHandle var0, int var1, Pointer var2, int var3, int var4, Pointer var5, int var6, int var7);

    public static int cublasAsumEx_64(cublasHandle handle, long n, Pointer x, int xType, long incx, Pointer result, int resultType, int executiontype) {
        return JCublas2.checkResult(JCublas2.cublasAsumEx_64Native(handle, n, x, xType, incx, result, resultType, executiontype));
    }

    private static native int cublasAsumEx_64Native(cublasHandle var0, long var1, Pointer var3, int var4, long var5, Pointer var7, int var8, int var9);

    public static int cublasSasum(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasSasumNative(handle, n, x, incx, result));
    }

    private static native int cublasSasumNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasSasum_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasSasum_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasSasum_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6);

    public static int cublasDasum(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasDasumNative(handle, n, x, incx, result));
    }

    private static native int cublasDasumNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasDasum_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasDasum_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasDasum_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6);

    public static int cublasScasum(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasScasumNative(handle, n, x, incx, result));
    }

    private static native int cublasScasumNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasScasum_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasScasum_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasScasum_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6);

    public static int cublasDzasum(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasDzasumNative(handle, n, x, incx, result));
    }

    private static native int cublasDzasumNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasDzasum_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasDzasum_v2_64Native(handle, n, x, incx, result));
    }

    private static native int cublasDzasum_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6);

    public static int cublasSrot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasSrotNative(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasSrotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7);

    public static int cublasSrot_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasSrot_v2_64Native(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasSrot_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7, Pointer var9, Pointer var10);

    public static int cublasDrot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasDrotNative(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasDrotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7);

    public static int cublasDrot_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasDrot_v2_64Native(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasDrot_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7, Pointer var9, Pointer var10);

    public static int cublasCrot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasCrotNative(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasCrotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7);

    public static int cublasCrot_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasCrot_v2_64Native(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasCrot_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7, Pointer var9, Pointer var10);

    public static int cublasCsrot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasCsrotNative(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasCsrotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7);

    public static int cublasCsrot_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasCsrot_v2_64Native(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasCsrot_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7, Pointer var9, Pointer var10);

    public static int cublasZrot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasZrotNative(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasZrotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7);

    public static int cublasZrot_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasZrot_v2_64Native(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasZrot_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7, Pointer var9, Pointer var10);

    public static int cublasZdrot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasZdrotNative(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasZdrotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7);

    public static int cublasZdrot_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasZdrot_v2_64Native(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasZdrot_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7, Pointer var9, Pointer var10);

    public static int cublasRotEx(cublasHandle handle, int n, Pointer x, int xType, int incx, Pointer y, int yType, int incy, Pointer c, Pointer s, int csType, int executiontype) {
        return JCublas2.checkResult(JCublas2.cublasRotExNative(handle, n, x, xType, incx, y, yType, incy, c, s, csType, executiontype));
    }

    private static native int cublasRotExNative(cublasHandle var0, int var1, Pointer var2, int var3, int var4, Pointer var5, int var6, int var7, Pointer var8, Pointer var9, int var10, int var11);

    public static int cublasRotEx_64(cublasHandle handle, long n, Pointer x, int xType, long incx, Pointer y, int yType, long incy, Pointer c, Pointer s, int csType, int executiontype) {
        return JCublas2.checkResult(JCublas2.cublasRotEx_64Native(handle, n, x, xType, incx, y, yType, incy, c, s, csType, executiontype));
    }

    private static native int cublasRotEx_64Native(cublasHandle var0, long var1, Pointer var3, int var4, long var5, Pointer var7, int var8, long var9, Pointer var11, Pointer var12, int var13, int var14);

    public static int cublasSrotg(cublasHandle handle, Pointer a, Pointer b, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasSrotgNative(handle, a, b, c, s));
    }

    private static native int cublasSrotgNative(cublasHandle var0, Pointer var1, Pointer var2, Pointer var3, Pointer var4);

    public static int cublasDrotg(cublasHandle handle, Pointer a, Pointer b, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasDrotgNative(handle, a, b, c, s));
    }

    private static native int cublasDrotgNative(cublasHandle var0, Pointer var1, Pointer var2, Pointer var3, Pointer var4);

    public static int cublasCrotg(cublasHandle handle, Pointer a, Pointer b, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasCrotgNative(handle, a, b, c, s));
    }

    private static native int cublasCrotgNative(cublasHandle var0, Pointer var1, Pointer var2, Pointer var3, Pointer var4);

    public static int cublasZrotg(cublasHandle handle, Pointer a, Pointer b, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasZrotgNative(handle, a, b, c, s));
    }

    private static native int cublasZrotgNative(cublasHandle var0, Pointer var1, Pointer var2, Pointer var3, Pointer var4);

    public static int cublasRotgEx(cublasHandle handle, Pointer a, Pointer b, int abType, Pointer c, Pointer s, int csType, int executiontype) {
        return JCublas2.checkResult(JCublas2.cublasRotgExNative(handle, a, b, abType, c, s, csType, executiontype));
    }

    private static native int cublasRotgExNative(cublasHandle var0, Pointer var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6, int var7);

    public static int cublasSrotm(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer param) {
        return JCublas2.checkResult(JCublas2.cublasSrotmNative(handle, n, x, incx, y, incy, param));
    }

    private static native int cublasSrotmNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasSrotm_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy, Pointer param) {
        return JCublas2.checkResult(JCublas2.cublasSrotm_v2_64Native(handle, n, x, incx, y, incy, param));
    }

    private static native int cublasSrotm_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7, Pointer var9);

    public static int cublasDrotm(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer param) {
        return JCublas2.checkResult(JCublas2.cublasDrotmNative(handle, n, x, incx, y, incy, param));
    }

    private static native int cublasDrotmNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasDrotm_v2_64(cublasHandle handle, long n, Pointer x, long incx, Pointer y, long incy, Pointer param) {
        return JCublas2.checkResult(JCublas2.cublasDrotm_v2_64Native(handle, n, x, incx, y, incy, param));
    }

    private static native int cublasDrotm_v2_64Native(cublasHandle var0, long var1, Pointer var3, long var4, Pointer var6, long var7, Pointer var9);

    public static int cublasRotmEx(cublasHandle handle, int n, Pointer x, int xType, int incx, Pointer y, int yType, int incy, Pointer param, int paramType, int executiontype) {
        return JCublas2.checkResult(JCublas2.cublasRotmExNative(handle, n, x, xType, incx, y, yType, incy, param, paramType, executiontype));
    }

    private static native int cublasRotmExNative(cublasHandle var0, int var1, Pointer var2, int var3, int var4, Pointer var5, int var6, int var7, Pointer var8, int var9, int var10);

    public static int cublasRotmEx_64(cublasHandle handle, long n, Pointer x, int xType, long incx, Pointer y, int yType, long incy, Pointer param, int paramType, int executiontype) {
        return JCublas2.checkResult(JCublas2.cublasRotmEx_64Native(handle, n, x, xType, incx, y, yType, incy, param, paramType, executiontype));
    }

    private static native int cublasRotmEx_64Native(cublasHandle var0, long var1, Pointer var3, int var4, long var5, Pointer var7, int var8, long var9, Pointer var11, int var12, int var13);

    public static int cublasSrotmg(cublasHandle handle, Pointer d1, Pointer d2, Pointer x1, Pointer y1, Pointer param) {
        return JCublas2.checkResult(JCublas2.cublasSrotmgNative(handle, d1, d2, x1, y1, param));
    }

    private static native int cublasSrotmgNative(cublasHandle var0, Pointer var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cublasDrotmg(cublasHandle handle, Pointer d1, Pointer d2, Pointer x1, Pointer y1, Pointer param) {
        return JCublas2.checkResult(JCublas2.cublasDrotmgNative(handle, d1, d2, x1, y1, param));
    }

    private static native int cublasDrotmgNative(cublasHandle var0, Pointer var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cublasRotmgEx(cublasHandle handle, Pointer d1, int d1Type, Pointer d2, int d2Type, Pointer x1, int x1Type, Pointer y1, int y1Type, Pointer param, int paramType, int executiontype) {
        return JCublas2.checkResult(JCublas2.cublasRotmgExNative(handle, d1, d1Type, d2, d2Type, x1, x1Type, y1, y1Type, param, paramType, executiontype));
    }

    private static native int cublasRotmgExNative(cublasHandle var0, Pointer var1, int var2, Pointer var3, int var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, int var10, int var11);

    public static int cublasSgemv(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSgemvNative(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasSgemvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasSgemv_v2_64(cublasHandle handle, int trans, long m, long n, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasSgemv_v2_64Native(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasSgemv_v2_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, Pointer var10, long var11, Pointer var13, Pointer var14, long var15);

    public static int cublasDgemv(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDgemvNative(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasDgemvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasDgemv_v2_64(cublasHandle handle, int trans, long m, long n, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasDgemv_v2_64Native(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasDgemv_v2_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, Pointer var10, long var11, Pointer var13, Pointer var14, long var15);

    public static int cublasCgemv(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasCgemvNative(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasCgemvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasCgemv_v2_64(cublasHandle handle, int trans, long m, long n, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasCgemv_v2_64Native(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasCgemv_v2_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, Pointer var10, long var11, Pointer var13, Pointer var14, long var15);

    public static int cublasZgemv(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZgemvNative(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasZgemvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasZgemv_v2_64(cublasHandle handle, int trans, long m, long n, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasZgemv_v2_64Native(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasZgemv_v2_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, Pointer var10, long var11, Pointer var13, Pointer var14, long var15);

    public static int cublasSgbmv(cublasHandle handle, int trans, int m, int n, int kl, int ku, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSgbmvNative(handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasSgbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasSgbmv_v2_64(cublasHandle handle, int trans, long m, long n, long kl, long ku, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasSgbmv_v2_64Native(handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasSgbmv_v2_64Native(cublasHandle var0, int var1, long var2, long var4, long var6, long var8, Pointer var10, Pointer var11, long var12, Pointer var14, long var15, Pointer var17, Pointer var18, long var19);

    public static int cublasDgbmv(cublasHandle handle, int trans, int m, int n, int kl, int ku, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDgbmvNative(handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasDgbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasDgbmv_v2_64(cublasHandle handle, int trans, long m, long n, long kl, long ku, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasDgbmv_v2_64Native(handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasDgbmv_v2_64Native(cublasHandle var0, int var1, long var2, long var4, long var6, long var8, Pointer var10, Pointer var11, long var12, Pointer var14, long var15, Pointer var17, Pointer var18, long var19);

    public static int cublasCgbmv(cublasHandle handle, int trans, int m, int n, int kl, int ku, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasCgbmvNative(handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasCgbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasCgbmv_v2_64(cublasHandle handle, int trans, long m, long n, long kl, long ku, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasCgbmv_v2_64Native(handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasCgbmv_v2_64Native(cublasHandle var0, int var1, long var2, long var4, long var6, long var8, Pointer var10, Pointer var11, long var12, Pointer var14, long var15, Pointer var17, Pointer var18, long var19);

    public static int cublasZgbmv(cublasHandle handle, int trans, int m, int n, int kl, int ku, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZgbmvNative(handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasZgbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasZgbmv_v2_64(cublasHandle handle, int trans, long m, long n, long kl, long ku, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasZgbmv_v2_64Native(handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasZgbmv_v2_64Native(cublasHandle var0, int var1, long var2, long var4, long var6, long var8, Pointer var10, Pointer var11, long var12, Pointer var14, long var15, Pointer var17, Pointer var18, long var19);

    public static int cublasStrmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasStrmvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasStrmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasStrmv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasStrmv_v2_64Native(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasStrmv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, long var7, Pointer var9, long var10);

    public static int cublasDtrmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasDtrmvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasDtrmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasDtrmv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasDtrmv_v2_64Native(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasDtrmv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, long var7, Pointer var9, long var10);

    public static int cublasCtrmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCtrmvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasCtrmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasCtrmv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasCtrmv_v2_64Native(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasCtrmv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, long var7, Pointer var9, long var10);

    public static int cublasZtrmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZtrmvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasZtrmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasZtrmv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasZtrmv_v2_64Native(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasZtrmv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, long var7, Pointer var9, long var10);

    public static int cublasStbmv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasStbmvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasStbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasStbmv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, long k, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasStbmv_v2_64Native(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasStbmv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, long var6, Pointer var8, long var9, Pointer var11, long var12);

    public static int cublasDtbmv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasDtbmvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasDtbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasDtbmv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, long k, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasDtbmv_v2_64Native(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasDtbmv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, long var6, Pointer var8, long var9, Pointer var11, long var12);

    public static int cublasCtbmv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCtbmvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasCtbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasCtbmv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, long k, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasCtbmv_v2_64Native(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasCtbmv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, long var6, Pointer var8, long var9, Pointer var11, long var12);

    public static int cublasZtbmv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZtbmvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasZtbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasZtbmv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, long k, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasZtbmv_v2_64Native(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasZtbmv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, long var6, Pointer var8, long var9, Pointer var11, long var12);

    public static int cublasStpmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasStpmvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasStpmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasStpmv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer AP, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasStpmv_v2_64Native(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasStpmv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, Pointer var7, long var8);

    public static int cublasDtpmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasDtpmvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasDtpmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasDtpmv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer AP, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasDtpmv_v2_64Native(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasDtpmv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, Pointer var7, long var8);

    public static int cublasCtpmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCtpmvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasCtpmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasCtpmv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer AP, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasCtpmv_v2_64Native(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasCtpmv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, Pointer var7, long var8);

    public static int cublasZtpmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZtpmvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasZtpmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasZtpmv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer AP, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasZtpmv_v2_64Native(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasZtpmv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, Pointer var7, long var8);

    public static int cublasStrsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasStrsvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasStrsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasStrsv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasStrsv_v2_64Native(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasStrsv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, long var7, Pointer var9, long var10);

    public static int cublasDtrsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasDtrsvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasDtrsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasDtrsv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasDtrsv_v2_64Native(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasDtrsv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, long var7, Pointer var9, long var10);

    public static int cublasCtrsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCtrsvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasCtrsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasCtrsv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasCtrsv_v2_64Native(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasCtrsv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, long var7, Pointer var9, long var10);

    public static int cublasZtrsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZtrsvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasZtrsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasZtrsv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasZtrsv_v2_64Native(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasZtrsv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, long var7, Pointer var9, long var10);

    public static int cublasStpsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasStpsvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasStpsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasStpsv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer AP, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasStpsv_v2_64Native(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasStpsv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, Pointer var7, long var8);

    public static int cublasDtpsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasDtpsvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasDtpsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasDtpsv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer AP, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasDtpsv_v2_64Native(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasDtpsv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, Pointer var7, long var8);

    public static int cublasCtpsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCtpsvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasCtpsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasCtpsv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer AP, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasCtpsv_v2_64Native(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasCtpsv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, Pointer var7, long var8);

    public static int cublasZtpsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZtpsvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasZtpsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasZtpsv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, Pointer AP, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasZtpsv_v2_64Native(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasZtpsv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, Pointer var6, Pointer var7, long var8);

    public static int cublasStbsv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasStbsvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasStbsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasStbsv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, long k, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasStbsv_v2_64Native(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasStbsv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, long var6, Pointer var8, long var9, Pointer var11, long var12);

    public static int cublasDtbsv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasDtbsvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasDtbsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasDtbsv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, long k, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasDtbsv_v2_64Native(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasDtbsv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, long var6, Pointer var8, long var9, Pointer var11, long var12);

    public static int cublasCtbsv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCtbsvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasCtbsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasCtbsv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, long k, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasCtbsv_v2_64Native(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasCtbsv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, long var6, Pointer var8, long var9, Pointer var11, long var12);

    public static int cublasZtbsv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZtbsvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasZtbsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasZtbsv_v2_64(cublasHandle handle, int uplo, int trans, int diag, long n, long k, Pointer A, long lda, Pointer x, long incx) {
        return JCublas2.checkResult(JCublas2.cublasZtbsv_v2_64Native(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasZtbsv_v2_64Native(cublasHandle var0, int var1, int var2, int var3, long var4, long var6, Pointer var8, long var9, Pointer var11, long var12);

    public static int cublasSsymv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSsymvNative(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasSsymvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasSsymv_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasSsymv_v2_64Native(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasSsymv_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11, Pointer var12, long var13);

    public static int cublasDsymv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDsymvNative(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasDsymvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasDsymv_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasDsymv_v2_64Native(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasDsymv_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11, Pointer var12, long var13);

    public static int cublasCsymv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasCsymvNative(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasCsymvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasCsymv_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasCsymv_v2_64Native(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasCsymv_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11, Pointer var12, long var13);

    public static int cublasZsymv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZsymvNative(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasZsymvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasZsymv_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasZsymv_v2_64Native(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasZsymv_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11, Pointer var12, long var13);

    public static int cublasChemv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasChemvNative(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasChemvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasChemv_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasChemv_v2_64Native(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasChemv_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11, Pointer var12, long var13);

    public static int cublasZhemv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZhemvNative(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasZhemvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasZhemv_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasZhemv_v2_64Native(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasZhemv_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11, Pointer var12, long var13);

    public static int cublasSsbmv(cublasHandle handle, int uplo, int n, int k, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSsbmvNative(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasSsbmvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasSsbmv_v2_64(cublasHandle handle, int uplo, long n, long k, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasSsbmv_v2_64Native(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasSsbmv_v2_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, Pointer var10, long var11, Pointer var13, Pointer var14, long var15);

    public static int cublasDsbmv(cublasHandle handle, int uplo, int n, int k, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDsbmvNative(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasDsbmvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasDsbmv_v2_64(cublasHandle handle, int uplo, long n, long k, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasDsbmv_v2_64Native(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasDsbmv_v2_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, Pointer var10, long var11, Pointer var13, Pointer var14, long var15);

    public static int cublasChbmv(cublasHandle handle, int uplo, int n, int k, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasChbmvNative(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasChbmvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasChbmv_v2_64(cublasHandle handle, int uplo, long n, long k, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasChbmv_v2_64Native(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasChbmv_v2_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, Pointer var10, long var11, Pointer var13, Pointer var14, long var15);

    public static int cublasZhbmv(cublasHandle handle, int uplo, int n, int k, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZhbmvNative(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasZhbmvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasZhbmv_v2_64(cublasHandle handle, int uplo, long n, long k, Pointer alpha, Pointer A, long lda, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasZhbmv_v2_64Native(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasZhbmv_v2_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, Pointer var10, long var11, Pointer var13, Pointer var14, long var15);

    public static int cublasSspmv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer AP, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSspmvNative(handle, uplo, n, alpha, AP, x, incx, beta, y, incy));
    }

    private static native int cublasSspmvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, int var6, Pointer var7, Pointer var8, int var9);

    public static int cublasSspmv_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer AP, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasSspmv_v2_64Native(handle, uplo, n, alpha, AP, x, incx, beta, y, incy));
    }

    private static native int cublasSspmv_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, Pointer var6, long var7, Pointer var9, Pointer var10, long var11);

    public static int cublasDspmv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer AP, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDspmvNative(handle, uplo, n, alpha, AP, x, incx, beta, y, incy));
    }

    private static native int cublasDspmvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, int var6, Pointer var7, Pointer var8, int var9);

    public static int cublasDspmv_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer AP, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasDspmv_v2_64Native(handle, uplo, n, alpha, AP, x, incx, beta, y, incy));
    }

    private static native int cublasDspmv_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, Pointer var6, long var7, Pointer var9, Pointer var10, long var11);

    public static int cublasChpmv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer AP, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasChpmvNative(handle, uplo, n, alpha, AP, x, incx, beta, y, incy));
    }

    private static native int cublasChpmvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, int var6, Pointer var7, Pointer var8, int var9);

    public static int cublasChpmv_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer AP, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasChpmv_v2_64Native(handle, uplo, n, alpha, AP, x, incx, beta, y, incy));
    }

    private static native int cublasChpmv_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, Pointer var6, long var7, Pointer var9, Pointer var10, long var11);

    public static int cublasZhpmv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer AP, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZhpmvNative(handle, uplo, n, alpha, AP, x, incx, beta, y, incy));
    }

    private static native int cublasZhpmvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, int var6, Pointer var7, Pointer var8, int var9);

    public static int cublasZhpmv_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer AP, Pointer x, long incx, Pointer beta, Pointer y, long incy) {
        return JCublas2.checkResult(JCublas2.cublasZhpmv_v2_64Native(handle, uplo, n, alpha, AP, x, incx, beta, y, incy));
    }

    private static native int cublasZhpmv_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, Pointer var6, long var7, Pointer var9, Pointer var10, long var11);

    public static int cublasSger(cublasHandle handle, int m, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasSgerNative(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasSgerNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasSger_v2_64(cublasHandle handle, long m, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasSger_v2_64Native(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasSger_v2_64Native(cublasHandle var0, long var1, long var3, Pointer var5, Pointer var6, long var7, Pointer var9, long var10, Pointer var12, long var13);

    public static int cublasDger(cublasHandle handle, int m, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasDgerNative(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasDgerNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasDger_v2_64(cublasHandle handle, long m, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasDger_v2_64Native(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasDger_v2_64Native(cublasHandle var0, long var1, long var3, Pointer var5, Pointer var6, long var7, Pointer var9, long var10, Pointer var12, long var13);

    public static int cublasCgeru(cublasHandle handle, int m, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasCgeruNative(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasCgeruNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasCgeru_v2_64(cublasHandle handle, long m, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasCgeru_v2_64Native(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasCgeru_v2_64Native(cublasHandle var0, long var1, long var3, Pointer var5, Pointer var6, long var7, Pointer var9, long var10, Pointer var12, long var13);

    public static int cublasCgerc(cublasHandle handle, int m, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasCgercNative(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasCgercNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasCgerc_v2_64(cublasHandle handle, long m, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasCgerc_v2_64Native(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasCgerc_v2_64Native(cublasHandle var0, long var1, long var3, Pointer var5, Pointer var6, long var7, Pointer var9, long var10, Pointer var12, long var13);

    public static int cublasZgeru(cublasHandle handle, int m, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasZgeruNative(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasZgeruNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasZgeru_v2_64(cublasHandle handle, long m, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasZgeru_v2_64Native(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasZgeru_v2_64Native(cublasHandle var0, long var1, long var3, Pointer var5, Pointer var6, long var7, Pointer var9, long var10, Pointer var12, long var13);

    public static int cublasZgerc(cublasHandle handle, int m, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasZgercNative(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasZgercNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasZgerc_v2_64(cublasHandle handle, long m, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasZgerc_v2_64Native(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasZgerc_v2_64Native(cublasHandle var0, long var1, long var3, Pointer var5, Pointer var6, long var7, Pointer var9, long var10, Pointer var12, long var13);

    public static int cublasSsyr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasSsyrNative(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasSsyrNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasSsyr_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasSsyr_v2_64Native(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasSsyr_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9);

    public static int cublasDsyr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasDsyrNative(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasDsyrNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasDsyr_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasDsyr_v2_64Native(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasDsyr_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9);

    public static int cublasCsyr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasCsyrNative(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasCsyrNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasCsyr_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasCsyr_v2_64Native(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasCsyr_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9);

    public static int cublasZsyr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasZsyrNative(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasZsyrNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasZsyr_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasZsyr_v2_64Native(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasZsyr_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9);

    public static int cublasCher(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasCherNative(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasCherNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasCher_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasCher_v2_64Native(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasCher_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9);

    public static int cublasZher(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasZherNative(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasZherNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasZher_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasZher_v2_64Native(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasZher_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9);

    public static int cublasSspr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasSsprNative(handle, uplo, n, alpha, x, incx, AP));
    }

    private static native int cublasSsprNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6);

    public static int cublasSspr_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasSspr_v2_64Native(handle, uplo, n, alpha, x, incx, AP));
    }

    private static native int cublasSspr_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8);

    public static int cublasDspr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasDsprNative(handle, uplo, n, alpha, x, incx, AP));
    }

    private static native int cublasDsprNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6);

    public static int cublasDspr_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasDspr_v2_64Native(handle, uplo, n, alpha, x, incx, AP));
    }

    private static native int cublasDspr_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8);

    public static int cublasChpr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasChprNative(handle, uplo, n, alpha, x, incx, AP));
    }

    private static native int cublasChprNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6);

    public static int cublasChpr_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasChpr_v2_64Native(handle, uplo, n, alpha, x, incx, AP));
    }

    private static native int cublasChpr_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8);

    public static int cublasZhpr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasZhprNative(handle, uplo, n, alpha, x, incx, AP));
    }

    private static native int cublasZhprNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6);

    public static int cublasZhpr_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasZhpr_v2_64Native(handle, uplo, n, alpha, x, incx, AP));
    }

    private static native int cublasZhpr_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8);

    public static int cublasSsyr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasSsyr2Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasSsyr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasSsyr2_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasSsyr2_v2_64Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasSsyr2_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11, long var12);

    public static int cublasDsyr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasDsyr2Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasDsyr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasDsyr2_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasDsyr2_v2_64Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasDsyr2_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11, long var12);

    public static int cublasCsyr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasCsyr2Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasCsyr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasCsyr2_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasCsyr2_v2_64Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasCsyr2_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11, long var12);

    public static int cublasZsyr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasZsyr2Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasZsyr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasZsyr2_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasZsyr2_v2_64Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasZsyr2_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11, long var12);

    public static int cublasCher2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasCher2Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasCher2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasCher2_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasCher2_v2_64Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasCher2_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11, long var12);

    public static int cublasZher2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasZher2Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasZher2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasZher2_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer A, long lda) {
        return JCublas2.checkResult(JCublas2.cublasZher2_v2_64Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasZher2_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11, long var12);

    public static int cublasSspr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasSspr2Native(handle, uplo, n, alpha, x, incx, y, incy, AP));
    }

    private static native int cublasSspr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8);

    public static int cublasSspr2_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasSspr2_v2_64Native(handle, uplo, n, alpha, x, incx, y, incy, AP));
    }

    private static native int cublasSspr2_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11);

    public static int cublasDspr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasDspr2Native(handle, uplo, n, alpha, x, incx, y, incy, AP));
    }

    private static native int cublasDspr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8);

    public static int cublasDspr2_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasDspr2_v2_64Native(handle, uplo, n, alpha, x, incx, y, incy, AP));
    }

    private static native int cublasDspr2_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11);

    public static int cublasChpr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasChpr2Native(handle, uplo, n, alpha, x, incx, y, incy, AP));
    }

    private static native int cublasChpr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8);

    public static int cublasChpr2_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasChpr2_v2_64Native(handle, uplo, n, alpha, x, incx, y, incy, AP));
    }

    private static native int cublasChpr2_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11);

    public static int cublasZhpr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasZhpr2Native(handle, uplo, n, alpha, x, incx, y, incy, AP));
    }

    private static native int cublasZhpr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8);

    public static int cublasZhpr2_v2_64(cublasHandle handle, int uplo, long n, Pointer alpha, Pointer x, long incx, Pointer y, long incy, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasZhpr2_v2_64Native(handle, uplo, n, alpha, x, incx, y, incy, AP));
    }

    private static native int cublasZhpr2_v2_64Native(cublasHandle var0, int var1, long var2, Pointer var4, Pointer var5, long var6, Pointer var8, long var9, Pointer var11);

    public static int cublasSgemvBatched(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer Aarray, int lda, Pointer xarray, int incx, Pointer beta, Pointer yarray, int incy, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasSgemvBatchedNative(handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount));
    }

    private static native int cublasSgemvBatchedNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11, int var12);

    public static int cublasSgemvBatched_64(cublasHandle handle, int trans, long m, long n, Pointer alpha, Pointer Aarray, long lda, Pointer xarray, long incx, Pointer beta, Pointer yarray, long incy, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasSgemvBatched_64Native(handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount));
    }

    private static native int cublasSgemvBatched_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, Pointer var10, long var11, Pointer var13, Pointer var14, long var15, long var17);

    public static int cublasDgemvBatched(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer Aarray, int lda, Pointer xarray, int incx, Pointer beta, Pointer yarray, int incy, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasDgemvBatchedNative(handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount));
    }

    private static native int cublasDgemvBatchedNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11, int var12);

    public static int cublasDgemvBatched_64(cublasHandle handle, int trans, long m, long n, Pointer alpha, Pointer Aarray, long lda, Pointer xarray, long incx, Pointer beta, Pointer yarray, long incy, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasDgemvBatched_64Native(handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount));
    }

    private static native int cublasDgemvBatched_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, Pointer var10, long var11, Pointer var13, Pointer var14, long var15, long var17);

    public static int cublasCgemvBatched(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer Aarray, int lda, Pointer xarray, int incx, Pointer beta, Pointer yarray, int incy, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCgemvBatchedNative(handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount));
    }

    private static native int cublasCgemvBatchedNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11, int var12);

    public static int cublasCgemvBatched_64(cublasHandle handle, int trans, long m, long n, Pointer alpha, Pointer Aarray, long lda, Pointer xarray, long incx, Pointer beta, Pointer yarray, long incy, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCgemvBatched_64Native(handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount));
    }

    private static native int cublasCgemvBatched_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, Pointer var10, long var11, Pointer var13, Pointer var14, long var15, long var17);

    public static int cublasZgemvBatched(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer Aarray, int lda, Pointer xarray, int incx, Pointer beta, Pointer yarray, int incy, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasZgemvBatchedNative(handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount));
    }

    private static native int cublasZgemvBatchedNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11, int var12);

    public static int cublasZgemvBatched_64(cublasHandle handle, int trans, long m, long n, Pointer alpha, Pointer Aarray, long lda, Pointer xarray, long incx, Pointer beta, Pointer yarray, long incy, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasZgemvBatched_64Native(handle, trans, m, n, alpha, Aarray, lda, xarray, incx, beta, yarray, incy, batchCount));
    }

    private static native int cublasZgemvBatched_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, Pointer var10, long var11, Pointer var13, Pointer var14, long var15, long var17);

    public static int cublasSgemvStridedBatched(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer A, int lda, long strideA, Pointer x, int incx, long stridex, Pointer beta, Pointer y, int incy, long stridey, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasSgemvStridedBatchedNative(handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey, batchCount));
    }

    private static native int cublasSgemvStridedBatchedNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, long var7, Pointer var9, int var10, long var11, Pointer var13, Pointer var14, int var15, long var16, int var18);

    public static int cublasSgemvStridedBatched_64(cublasHandle handle, int trans, long m, long n, Pointer alpha, Pointer A, long lda, long strideA, Pointer x, long incx, long stridex, Pointer beta, Pointer y, long incy, long stridey, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasSgemvStridedBatched_64Native(handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey, batchCount));
    }

    private static native int cublasSgemvStridedBatched_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, long var10, Pointer var12, long var13, long var15, Pointer var17, Pointer var18, long var19, long var21, long var23);

    public static int cublasDgemvStridedBatched(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer A, int lda, long strideA, Pointer x, int incx, long stridex, Pointer beta, Pointer y, int incy, long stridey, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasDgemvStridedBatchedNative(handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey, batchCount));
    }

    private static native int cublasDgemvStridedBatchedNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, long var7, Pointer var9, int var10, long var11, Pointer var13, Pointer var14, int var15, long var16, int var18);

    public static int cublasDgemvStridedBatched_64(cublasHandle handle, int trans, long m, long n, Pointer alpha, Pointer A, long lda, long strideA, Pointer x, long incx, long stridex, Pointer beta, Pointer y, long incy, long stridey, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasDgemvStridedBatched_64Native(handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey, batchCount));
    }

    private static native int cublasDgemvStridedBatched_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, long var10, Pointer var12, long var13, long var15, Pointer var17, Pointer var18, long var19, long var21, long var23);

    public static int cublasCgemvStridedBatched(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer A, int lda, long strideA, Pointer x, int incx, long stridex, Pointer beta, Pointer y, int incy, long stridey, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCgemvStridedBatchedNative(handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey, batchCount));
    }

    private static native int cublasCgemvStridedBatchedNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, long var7, Pointer var9, int var10, long var11, Pointer var13, Pointer var14, int var15, long var16, int var18);

    public static int cublasCgemvStridedBatched_64(cublasHandle handle, int trans, long m, long n, Pointer alpha, Pointer A, long lda, long strideA, Pointer x, long incx, long stridex, Pointer beta, Pointer y, long incy, long stridey, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCgemvStridedBatched_64Native(handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey, batchCount));
    }

    private static native int cublasCgemvStridedBatched_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, long var10, Pointer var12, long var13, long var15, Pointer var17, Pointer var18, long var19, long var21, long var23);

    public static int cublasZgemvStridedBatched(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer A, int lda, long strideA, Pointer x, int incx, long stridex, Pointer beta, Pointer y, int incy, long stridey, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasZgemvStridedBatchedNative(handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey, batchCount));
    }

    private static native int cublasZgemvStridedBatchedNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, long var7, Pointer var9, int var10, long var11, Pointer var13, Pointer var14, int var15, long var16, int var18);

    public static int cublasZgemvStridedBatched_64(cublasHandle handle, int trans, long m, long n, Pointer alpha, Pointer A, long lda, long strideA, Pointer x, long incx, long stridex, Pointer beta, Pointer y, long incy, long stridey, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasZgemvStridedBatched_64Native(handle, trans, m, n, alpha, A, lda, strideA, x, incx, stridex, beta, y, incy, stridey, batchCount));
    }

    private static native int cublasZgemvStridedBatched_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, Pointer var7, long var8, long var10, Pointer var12, long var13, long var15, Pointer var17, Pointer var18, long var19, long var21, long var23);

    public static int cublasSgemm(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasSgemmNative(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasSgemmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasSgemm_v2_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasSgemm_v2_64Native(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasSgemm_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, Pointer var16, Pointer var17, long var18);

    public static int cublasDgemm(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDgemmNative(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasDgemmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasDgemm_v2_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasDgemm_v2_64Native(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasDgemm_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, Pointer var16, Pointer var17, long var18);

    public static int cublasCgemm(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCgemmNative(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCgemmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasCgemm_v2_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCgemm_v2_64Native(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCgemm_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, Pointer var16, Pointer var17, long var18);

    public static int cublasCgemm3m(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCgemm3mNative(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCgemm3mNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasCgemm3m_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCgemm3m_64Native(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCgemm3m_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, Pointer var16, Pointer var17, long var18);

    public static int cublasCgemm3mEx(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int Atype, int lda, Pointer B, int Btype, int ldb, Pointer beta, Pointer C, int Ctype, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCgemm3mExNative(handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype, ldc));
    }

    private static native int cublasCgemm3mExNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, int var9, Pointer var10, int var11, int var12, Pointer var13, Pointer var14, int var15, int var16);

    public static int cublasCgemm3mEx_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, int Atype, long lda, Pointer B, int Btype, long ldb, Pointer beta, Pointer C, int Ctype, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCgemm3mEx_64Native(handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype, ldc));
    }

    private static native int cublasCgemm3mEx_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, int var11, long var12, Pointer var14, int var15, long var16, Pointer var18, Pointer var19, int var20, long var21);

    public static int cublasZgemm(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZgemmNative(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZgemmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasZgemm_v2_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasZgemm_v2_64Native(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZgemm_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, Pointer var16, Pointer var17, long var18);

    public static int cublasZgemm3m(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZgemm3mNative(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZgemm3mNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasZgemm3m_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasZgemm3m_64Native(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZgemm3m_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, Pointer var16, Pointer var17, long var18);

    public static int cublasSgemmEx(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int Atype, int lda, Pointer B, int Btype, int ldb, Pointer beta, Pointer C, int Ctype, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasSgemmExNative(handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype, ldc));
    }

    private static native int cublasSgemmExNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, int var9, Pointer var10, int var11, int var12, Pointer var13, Pointer var14, int var15, int var16);

    public static int cublasSgemmEx_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, int Atype, long lda, Pointer B, int Btype, long ldb, Pointer beta, Pointer C, int Ctype, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasSgemmEx_64Native(handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype, ldc));
    }

    private static native int cublasSgemmEx_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, int var11, long var12, Pointer var14, int var15, long var16, Pointer var18, Pointer var19, int var20, long var21);

    public static int cublasGemmEx_new(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int Atype, int lda, Pointer B, int Btype, int ldb, Pointer beta, Pointer C, int Ctype, int ldc, int computeType, int algo) {
        return JCublas2.checkResult(JCublas2.cublasGemmEx_newNative(handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype, ldc, computeType, algo));
    }

    private static native int cublasGemmEx_newNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, int var9, Pointer var10, int var11, int var12, Pointer var13, Pointer var14, int var15, int var16, int var17, int var18);

    public static int cublasGemmEx_64_new(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, int Atype, long lda, Pointer B, int Btype, long ldb, Pointer beta, Pointer C, int Ctype, long ldc, int computeType, int algo) {
        return JCublas2.checkResult(JCublas2.cublasGemmEx_64_newNative(handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype, ldc, computeType, algo));
    }

    private static native int cublasGemmEx_64_newNative(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, int var11, long var12, Pointer var14, int var15, long var16, Pointer var18, Pointer var19, int var20, long var21, int var23, int var24);

    public static int cublasCgemmEx(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int Atype, int lda, Pointer B, int Btype, int ldb, Pointer beta, Pointer C, int Ctype, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCgemmExNative(handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype, ldc));
    }

    private static native int cublasCgemmExNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, int var9, Pointer var10, int var11, int var12, Pointer var13, Pointer var14, int var15, int var16);

    public static int cublasCgemmEx_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, int Atype, long lda, Pointer B, int Btype, long ldb, Pointer beta, Pointer C, int Ctype, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCgemmEx_64Native(handle, transa, transb, m, n, k, alpha, A, Atype, lda, B, Btype, ldb, beta, C, Ctype, ldc));
    }

    private static native int cublasCgemmEx_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, int var11, long var12, Pointer var14, int var15, long var16, Pointer var18, Pointer var19, int var20, long var21);

    public static int cublasSsyrk(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasSsyrkNative(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasSsyrkNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasSsyrk_v2_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasSsyrk_v2_64Native(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasSsyrk_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, Pointer var12, long var13);

    public static int cublasDsyrk(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDsyrkNative(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasDsyrkNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasDsyrk_v2_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasDsyrk_v2_64Native(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasDsyrk_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, Pointer var12, long var13);

    public static int cublasCsyrk(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsyrkNative(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasCsyrkNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasCsyrk_v2_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsyrk_v2_64Native(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasCsyrk_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, Pointer var12, long var13);

    public static int cublasZsyrk(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZsyrkNative(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasZsyrkNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasZsyrk_v2_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasZsyrk_v2_64Native(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasZsyrk_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, Pointer var12, long var13);

    public static int cublasCsyrkEx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int Atype, int lda, Pointer beta, Pointer C, int Ctype, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsyrkExNative(handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc));
    }

    private static native int cublasCsyrkExNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, int var8, Pointer var9, Pointer var10, int var11, int var12);

    public static int cublasCsyrkEx_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, int Atype, long lda, Pointer beta, Pointer C, int Ctype, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsyrkEx_64Native(handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc));
    }

    private static native int cublasCsyrkEx_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, int var9, long var10, Pointer var12, Pointer var13, int var14, long var15);

    public static int cublasCsyrk3mEx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int Atype, int lda, Pointer beta, Pointer C, int Ctype, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsyrk3mExNative(handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc));
    }

    private static native int cublasCsyrk3mExNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, int var8, Pointer var9, Pointer var10, int var11, int var12);

    public static int cublasCsyrk3mEx_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, int Atype, long lda, Pointer beta, Pointer C, int Ctype, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsyrk3mEx_64Native(handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc));
    }

    private static native int cublasCsyrk3mEx_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, int var9, long var10, Pointer var12, Pointer var13, int var14, long var15);

    public static int cublasCherk(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCherkNative(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasCherkNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasCherk_v2_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCherk_v2_64Native(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasCherk_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, Pointer var12, long var13);

    public static int cublasZherk(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZherkNative(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasZherkNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasZherk_v2_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasZherk_v2_64Native(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasZherk_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, Pointer var12, long var13);

    public static int cublasCherkEx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int Atype, int lda, Pointer beta, Pointer C, int Ctype, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCherkExNative(handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc));
    }

    private static native int cublasCherkExNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, int var8, Pointer var9, Pointer var10, int var11, int var12);

    public static int cublasCherkEx_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, int Atype, long lda, Pointer beta, Pointer C, int Ctype, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCherkEx_64Native(handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc));
    }

    private static native int cublasCherkEx_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, int var9, long var10, Pointer var12, Pointer var13, int var14, long var15);

    public static int cublasCherk3mEx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int Atype, int lda, Pointer beta, Pointer C, int Ctype, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCherk3mExNative(handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc));
    }

    private static native int cublasCherk3mExNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, int var8, Pointer var9, Pointer var10, int var11, int var12);

    public static int cublasCherk3mEx_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, int Atype, long lda, Pointer beta, Pointer C, int Ctype, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCherk3mEx_64Native(handle, uplo, trans, n, k, alpha, A, Atype, lda, beta, C, Ctype, ldc));
    }

    private static native int cublasCherk3mEx_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, int var9, long var10, Pointer var12, Pointer var13, int var14, long var15);

    public static int cublasSsyr2k(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasSsyr2kNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasSsyr2kNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasSsyr2k_v2_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasSsyr2k_v2_64Native(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasSsyr2k_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasDsyr2k(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDsyr2kNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasDsyr2kNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasDsyr2k_v2_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasDsyr2k_v2_64Native(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasDsyr2k_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasCsyr2k(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsyr2kNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCsyr2kNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasCsyr2k_v2_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsyr2k_v2_64Native(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCsyr2k_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasZsyr2k(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZsyr2kNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZsyr2kNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasZsyr2k_v2_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasZsyr2k_v2_64Native(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZsyr2k_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasCher2k(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCher2kNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCher2kNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasCher2k_v2_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCher2k_v2_64Native(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCher2k_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasZher2k(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZher2kNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZher2kNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasZher2k_v2_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasZher2k_v2_64Native(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZher2k_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasSsyrkx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasSsyrkxNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasSsyrkxNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasSsyrkx_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasSsyrkx_64Native(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasSsyrkx_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasDsyrkx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDsyrkxNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasDsyrkxNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasDsyrkx_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasDsyrkx_64Native(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasDsyrkx_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasCsyrkx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsyrkxNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCsyrkxNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasCsyrkx_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsyrkx_64Native(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCsyrkx_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasZsyrkx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZsyrkxNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZsyrkxNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasZsyrkx_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasZsyrkx_64Native(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZsyrkx_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasCherkx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCherkxNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCherkxNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasCherkx_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCherkx_64Native(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCherkx_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasZherkx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZherkxNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZherkxNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasZherkx_64(cublasHandle handle, int uplo, int trans, long n, long k, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasZherkx_64Native(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZherkx_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasSsymm(cublasHandle handle, int side, int uplo, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasSsymmNative(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasSsymmNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasSsymm_v2_64(cublasHandle handle, int side, int uplo, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasSsymm_v2_64Native(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasSsymm_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasDsymm(cublasHandle handle, int side, int uplo, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDsymmNative(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasDsymmNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasDsymm_v2_64(cublasHandle handle, int side, int uplo, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasDsymm_v2_64Native(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasDsymm_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasCsymm(cublasHandle handle, int side, int uplo, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsymmNative(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCsymmNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasCsymm_v2_64(cublasHandle handle, int side, int uplo, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsymm_v2_64Native(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCsymm_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasZsymm(cublasHandle handle, int side, int uplo, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZsymmNative(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZsymmNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasZsymm_v2_64(cublasHandle handle, int side, int uplo, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasZsymm_v2_64Native(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZsymm_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasChemm(cublasHandle handle, int side, int uplo, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasChemmNative(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasChemmNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasChemm_v2_64(cublasHandle handle, int side, int uplo, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasChemm_v2_64Native(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasChemm_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasZhemm(cublasHandle handle, int side, int uplo, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZhemmNative(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZhemmNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasZhemm_v2_64(cublasHandle handle, int side, int uplo, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer beta, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasZhemm_v2_64Native(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZhemm_v2_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, long var12, Pointer var14, Pointer var15, long var16);

    public static int cublasStrsm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb) {
        return JCublas2.checkResult(JCublas2.cublasStrsmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb));
    }

    private static native int cublasStrsmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11);

    public static int cublasStrsm_v2_64(cublasHandle handle, int side, int uplo, int trans, int diag, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb) {
        return JCublas2.checkResult(JCublas2.cublasStrsm_v2_64Native(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb));
    }

    private static native int cublasStrsm_v2_64Native(cublasHandle var0, int var1, int var2, int var3, int var4, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14);

    public static int cublasDtrsm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb) {
        return JCublas2.checkResult(JCublas2.cublasDtrsmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb));
    }

    private static native int cublasDtrsmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11);

    public static int cublasDtrsm_v2_64(cublasHandle handle, int side, int uplo, int trans, int diag, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb) {
        return JCublas2.checkResult(JCublas2.cublasDtrsm_v2_64Native(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb));
    }

    private static native int cublasDtrsm_v2_64Native(cublasHandle var0, int var1, int var2, int var3, int var4, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14);

    public static int cublasCtrsm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb) {
        return JCublas2.checkResult(JCublas2.cublasCtrsmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb));
    }

    private static native int cublasCtrsmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11);

    public static int cublasCtrsm_v2_64(cublasHandle handle, int side, int uplo, int trans, int diag, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb) {
        return JCublas2.checkResult(JCublas2.cublasCtrsm_v2_64Native(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb));
    }

    private static native int cublasCtrsm_v2_64Native(cublasHandle var0, int var1, int var2, int var3, int var4, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14);

    public static int cublasZtrsm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb) {
        return JCublas2.checkResult(JCublas2.cublasZtrsmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb));
    }

    private static native int cublasZtrsmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11);

    public static int cublasZtrsm_v2_64(cublasHandle handle, int side, int uplo, int trans, int diag, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb) {
        return JCublas2.checkResult(JCublas2.cublasZtrsm_v2_64Native(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb));
    }

    private static native int cublasZtrsm_v2_64Native(cublasHandle var0, int var1, int var2, int var3, int var4, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14);

    public static int cublasStrmm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasStrmmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc));
    }

    private static native int cublasStrmmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cublasStrmm_v2_64(cublasHandle handle, int side, int uplo, int trans, int diag, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasStrmm_v2_64Native(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc));
    }

    private static native int cublasStrmm_v2_64Native(cublasHandle var0, int var1, int var2, int var3, int var4, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, Pointer var16, long var17);

    public static int cublasDtrmm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDtrmmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc));
    }

    private static native int cublasDtrmmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cublasDtrmm_v2_64(cublasHandle handle, int side, int uplo, int trans, int diag, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasDtrmm_v2_64Native(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc));
    }

    private static native int cublasDtrmm_v2_64Native(cublasHandle var0, int var1, int var2, int var3, int var4, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, Pointer var16, long var17);

    public static int cublasCtrmm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCtrmmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc));
    }

    private static native int cublasCtrmmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cublasCtrmm_v2_64(cublasHandle handle, int side, int uplo, int trans, int diag, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCtrmm_v2_64Native(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc));
    }

    private static native int cublasCtrmm_v2_64Native(cublasHandle var0, int var1, int var2, int var3, int var4, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, Pointer var16, long var17);

    public static int cublasZtrmm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZtrmmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc));
    }

    private static native int cublasZtrmmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cublasZtrmm_v2_64(cublasHandle handle, int side, int uplo, int trans, int diag, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasZtrmm_v2_64Native(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc));
    }

    private static native int cublasZtrmm_v2_64Native(cublasHandle var0, int var1, int var2, int var3, int var4, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, Pointer var16, long var17);

    public static int cublasSgemmBatched(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer Aarray, int lda, Pointer Barray, int ldb, Pointer beta, Pointer Carray, int ldc, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasSgemmBatchedNative(handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc, batchCount));
    }

    private static native int cublasSgemmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13, int var14);

    public static int cublasSgemmBatched_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer Aarray, long lda, Pointer Barray, long ldb, Pointer beta, Pointer Carray, long ldc, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasSgemmBatched_64Native(handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc, batchCount));
    }

    private static native int cublasSgemmBatched_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, Pointer var16, Pointer var17, long var18, long var20);

    public static int cublasDgemmBatched(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer Aarray, int lda, Pointer Barray, int ldb, Pointer beta, Pointer Carray, int ldc, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasDgemmBatchedNative(handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc, batchCount));
    }

    private static native int cublasDgemmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13, int var14);

    public static int cublasDgemmBatched_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer Aarray, long lda, Pointer Barray, long ldb, Pointer beta, Pointer Carray, long ldc, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasDgemmBatched_64Native(handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc, batchCount));
    }

    private static native int cublasDgemmBatched_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, Pointer var16, Pointer var17, long var18, long var20);

    public static int cublasCgemmBatched(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer Aarray, int lda, Pointer Barray, int ldb, Pointer beta, Pointer Carray, int ldc, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCgemmBatchedNative(handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc, batchCount));
    }

    private static native int cublasCgemmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13, int var14);

    public static int cublasCgemmBatched_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer Aarray, long lda, Pointer Barray, long ldb, Pointer beta, Pointer Carray, long ldc, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCgemmBatched_64Native(handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc, batchCount));
    }

    private static native int cublasCgemmBatched_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, Pointer var16, Pointer var17, long var18, long var20);

    public static int cublasCgemm3mBatched(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer Aarray, int lda, Pointer Barray, int ldb, Pointer beta, Pointer Carray, int ldc, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCgemm3mBatchedNative(handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc, batchCount));
    }

    private static native int cublasCgemm3mBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13, int var14);

    public static int cublasCgemm3mBatched_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer Aarray, long lda, Pointer Barray, long ldb, Pointer beta, Pointer Carray, long ldc, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCgemm3mBatched_64Native(handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc, batchCount));
    }

    private static native int cublasCgemm3mBatched_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, Pointer var16, Pointer var17, long var18, long var20);

    public static int cublasZgemmBatched(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer Aarray, int lda, Pointer Barray, int ldb, Pointer beta, Pointer Carray, int ldc, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasZgemmBatchedNative(handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc, batchCount));
    }

    private static native int cublasZgemmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13, int var14);

    public static int cublasZgemmBatched_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer Aarray, long lda, Pointer Barray, long ldb, Pointer beta, Pointer Carray, long ldc, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasZgemmBatched_64Native(handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc, batchCount));
    }

    private static native int cublasZgemmBatched_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, Pointer var16, Pointer var17, long var18, long var20);

    public static int cublasSgemmStridedBatched(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, long strideA, Pointer B, int ldb, long strideB, Pointer beta, Pointer C, int ldc, long strideC, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasSgemmStridedBatchedNative(handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc, strideC, batchCount));
    }

    private static native int cublasSgemmStridedBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, long var9, Pointer var11, int var12, long var13, Pointer var15, Pointer var16, int var17, long var18, int var20);

    public static int cublasSgemmStridedBatched_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, long lda, long strideA, Pointer B, long ldb, long strideB, Pointer beta, Pointer C, long ldc, long strideC, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasSgemmStridedBatched_64Native(handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc, strideC, batchCount));
    }

    private static native int cublasSgemmStridedBatched_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, long var13, Pointer var15, long var16, long var18, Pointer var20, Pointer var21, long var22, long var24, long var26);

    public static int cublasDgemmStridedBatched(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, long strideA, Pointer B, int ldb, long strideB, Pointer beta, Pointer C, int ldc, long strideC, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasDgemmStridedBatchedNative(handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc, strideC, batchCount));
    }

    private static native int cublasDgemmStridedBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, long var9, Pointer var11, int var12, long var13, Pointer var15, Pointer var16, int var17, long var18, int var20);

    public static int cublasDgemmStridedBatched_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, long lda, long strideA, Pointer B, long ldb, long strideB, Pointer beta, Pointer C, long ldc, long strideC, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasDgemmStridedBatched_64Native(handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc, strideC, batchCount));
    }

    private static native int cublasDgemmStridedBatched_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, long var13, Pointer var15, long var16, long var18, Pointer var20, Pointer var21, long var22, long var24, long var26);

    public static int cublasCgemmStridedBatched(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, long strideA, Pointer B, int ldb, long strideB, Pointer beta, Pointer C, int ldc, long strideC, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCgemmStridedBatchedNative(handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc, strideC, batchCount));
    }

    private static native int cublasCgemmStridedBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, long var9, Pointer var11, int var12, long var13, Pointer var15, Pointer var16, int var17, long var18, int var20);

    public static int cublasCgemmStridedBatched_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, long lda, long strideA, Pointer B, long ldb, long strideB, Pointer beta, Pointer C, long ldc, long strideC, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCgemmStridedBatched_64Native(handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc, strideC, batchCount));
    }

    private static native int cublasCgemmStridedBatched_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, long var13, Pointer var15, long var16, long var18, Pointer var20, Pointer var21, long var22, long var24, long var26);

    public static int cublasCgemm3mStridedBatched(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, long strideA, Pointer B, int ldb, long strideB, Pointer beta, Pointer C, int ldc, long strideC, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCgemm3mStridedBatchedNative(handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc, strideC, batchCount));
    }

    private static native int cublasCgemm3mStridedBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, long var9, Pointer var11, int var12, long var13, Pointer var15, Pointer var16, int var17, long var18, int var20);

    public static int cublasCgemm3mStridedBatched_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, long lda, long strideA, Pointer B, long ldb, long strideB, Pointer beta, Pointer C, long ldc, long strideC, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCgemm3mStridedBatched_64Native(handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc, strideC, batchCount));
    }

    private static native int cublasCgemm3mStridedBatched_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, long var13, Pointer var15, long var16, long var18, Pointer var20, Pointer var21, long var22, long var24, long var26);

    public static int cublasZgemmStridedBatched(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, long strideA, Pointer B, int ldb, long strideB, Pointer beta, Pointer C, int ldc, long strideC, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasZgemmStridedBatchedNative(handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc, strideC, batchCount));
    }

    private static native int cublasZgemmStridedBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, long var9, Pointer var11, int var12, long var13, Pointer var15, Pointer var16, int var17, long var18, int var20);

    public static int cublasZgemmStridedBatched_64(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, long lda, long strideA, Pointer B, long ldb, long strideB, Pointer beta, Pointer C, long ldc, long strideC, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasZgemmStridedBatched_64Native(handle, transa, transb, m, n, k, alpha, A, lda, strideA, B, ldb, strideB, beta, C, ldc, strideC, batchCount));
    }

    private static native int cublasZgemmStridedBatched_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, long var11, long var13, Pointer var15, long var16, long var18, Pointer var20, Pointer var21, long var22, long var24, long var26);

    public static int cublasGemmBatchedEx_new(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer Aarray, int Atype, int lda, Pointer Barray, int Btype, int ldb, Pointer beta, Pointer Carray, int Ctype, int ldc, int batchCount, int computeType, int algo) {
        return JCublas2.checkResult(JCublas2.cublasGemmBatchedEx_newNative(handle, transa, transb, m, n, k, alpha, Aarray, Atype, lda, Barray, Btype, ldb, beta, Carray, Ctype, ldc, batchCount, computeType, algo));
    }

    private static native int cublasGemmBatchedEx_newNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, int var9, Pointer var10, int var11, int var12, Pointer var13, Pointer var14, int var15, int var16, int var17, int var18, int var19);

    public static int cublasGemmBatchedEx_64_new(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer Aarray, int Atype, long lda, Pointer Barray, int Btype, long ldb, Pointer beta, Pointer Carray, int Ctype, long ldc, long batchCount, int computeType, int algo) {
        return JCublas2.checkResult(JCublas2.cublasGemmBatchedEx_64_newNative(handle, transa, transb, m, n, k, alpha, Aarray, Atype, lda, Barray, Btype, ldb, beta, Carray, Ctype, ldc, batchCount, computeType, algo));
    }

    private static native int cublasGemmBatchedEx_64_newNative(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, int var11, long var12, Pointer var14, int var15, long var16, Pointer var18, Pointer var19, int var20, long var21, long var23, int var25, int var26);

    public static int cublasGemmStridedBatchedEx_new(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int Atype, int lda, long strideA, Pointer B, int Btype, int ldb, long strideB, Pointer beta, Pointer C, int Ctype, int ldc, long strideC, int batchCount, int computeType, int algo) {
        return JCublas2.checkResult(JCublas2.cublasGemmStridedBatchedEx_newNative(handle, transa, transb, m, n, k, alpha, A, Atype, lda, strideA, B, Btype, ldb, strideB, beta, C, Ctype, ldc, strideC, batchCount, computeType, algo));
    }

    private static native int cublasGemmStridedBatchedEx_newNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, int var9, long var10, Pointer var12, int var13, int var14, long var15, Pointer var17, Pointer var18, int var19, int var20, long var21, int var23, int var24, int var25);

    public static int cublasGemmStridedBatchedEx_64_new(cublasHandle handle, int transa, int transb, long m, long n, long k, Pointer alpha, Pointer A, int Atype, long lda, long strideA, Pointer B, int Btype, long ldb, long strideB, Pointer beta, Pointer C, int Ctype, long ldc, long strideC, long batchCount, int computeType, int algo) {
        return JCublas2.checkResult(JCublas2.cublasGemmStridedBatchedEx_64_newNative(handle, transa, transb, m, n, k, alpha, A, Atype, lda, strideA, B, Btype, ldb, strideB, beta, C, Ctype, ldc, strideC, batchCount, computeType, algo));
    }

    private static native int cublasGemmStridedBatchedEx_64_newNative(cublasHandle var0, int var1, int var2, long var3, long var5, long var7, Pointer var9, Pointer var10, int var11, long var12, long var14, Pointer var16, int var17, long var18, long var20, Pointer var22, Pointer var23, int var24, long var25, long var27, long var29, int var31, int var32);

    public static int cublasSgeam(cublasHandle handle, int transa, int transb, int m, int n, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasSgeamNative(handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc));
    }

    private static native int cublasSgeamNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10, Pointer var11, int var12);

    public static int cublasSgeam_64(cublasHandle handle, int transa, int transb, long m, long n, Pointer alpha, Pointer A, long lda, Pointer beta, Pointer B, long ldb, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasSgeam_64Native(handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc));
    }

    private static native int cublasSgeam_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, Pointer var12, long var13, Pointer var15, long var16);

    public static int cublasDgeam(cublasHandle handle, int transa, int transb, int m, int n, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDgeamNative(handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc));
    }

    private static native int cublasDgeamNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10, Pointer var11, int var12);

    public static int cublasDgeam_64(cublasHandle handle, int transa, int transb, long m, long n, Pointer alpha, Pointer A, long lda, Pointer beta, Pointer B, long ldb, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasDgeam_64Native(handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc));
    }

    private static native int cublasDgeam_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, Pointer var12, long var13, Pointer var15, long var16);

    public static int cublasCgeam(cublasHandle handle, int transa, int transb, int m, int n, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCgeamNative(handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc));
    }

    private static native int cublasCgeamNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10, Pointer var11, int var12);

    public static int cublasCgeam_64(cublasHandle handle, int transa, int transb, long m, long n, Pointer alpha, Pointer A, long lda, Pointer beta, Pointer B, long ldb, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCgeam_64Native(handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc));
    }

    private static native int cublasCgeam_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, Pointer var12, long var13, Pointer var15, long var16);

    public static int cublasZgeam(cublasHandle handle, int transa, int transb, int m, int n, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZgeamNative(handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc));
    }

    private static native int cublasZgeamNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10, Pointer var11, int var12);

    public static int cublasZgeam_64(cublasHandle handle, int transa, int transb, long m, long n, Pointer alpha, Pointer A, long lda, Pointer beta, Pointer B, long ldb, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasZgeam_64Native(handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc));
    }

    private static native int cublasZgeam_64Native(cublasHandle var0, int var1, int var2, long var3, long var5, Pointer var7, Pointer var8, long var9, Pointer var11, Pointer var12, long var13, Pointer var15, long var16);

    public static int cublasStrsmBatched(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasStrsmBatchedNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount));
    }

    private static native int cublasStrsmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, int var12);

    public static int cublasStrsmBatched_64(cublasHandle handle, int side, int uplo, int trans, int diag, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasStrsmBatched_64Native(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount));
    }

    private static native int cublasStrsmBatched_64Native(cublasHandle var0, int var1, int var2, int var3, int var4, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, long var16);

    public static int cublasDtrsmBatched(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasDtrsmBatchedNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount));
    }

    private static native int cublasDtrsmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, int var12);

    public static int cublasDtrsmBatched_64(cublasHandle handle, int side, int uplo, int trans, int diag, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasDtrsmBatched_64Native(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount));
    }

    private static native int cublasDtrsmBatched_64Native(cublasHandle var0, int var1, int var2, int var3, int var4, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, long var16);

    public static int cublasCtrsmBatched(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCtrsmBatchedNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount));
    }

    private static native int cublasCtrsmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, int var12);

    public static int cublasCtrsmBatched_64(cublasHandle handle, int side, int uplo, int trans, int diag, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCtrsmBatched_64Native(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount));
    }

    private static native int cublasCtrsmBatched_64Native(cublasHandle var0, int var1, int var2, int var3, int var4, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, long var16);

    public static int cublasZtrsmBatched(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasZtrsmBatchedNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount));
    }

    private static native int cublasZtrsmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, int var12);

    public static int cublasZtrsmBatched_64(cublasHandle handle, int side, int uplo, int trans, int diag, long m, long n, Pointer alpha, Pointer A, long lda, Pointer B, long ldb, long batchCount) {
        return JCublas2.checkResult(JCublas2.cublasZtrsmBatched_64Native(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount));
    }

    private static native int cublasZtrsmBatched_64Native(cublasHandle var0, int var1, int var2, int var3, int var4, long var5, long var7, Pointer var9, Pointer var10, long var11, Pointer var13, long var14, long var16);

    public static int cublasSdgmm(cublasHandle handle, int mode, int m, int n, Pointer A, int lda, Pointer x, int incx, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasSdgmmNative(handle, mode, m, n, A, lda, x, incx, C, ldc));
    }

    private static native int cublasSdgmmNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasSdgmm_64(cublasHandle handle, int mode, long m, long n, Pointer A, long lda, Pointer x, long incx, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasSdgmm_64Native(handle, mode, m, n, A, lda, x, incx, C, ldc));
    }

    private static native int cublasSdgmm_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, long var7, Pointer var9, long var10, Pointer var12, long var13);

    public static int cublasDdgmm(cublasHandle handle, int mode, int m, int n, Pointer A, int lda, Pointer x, int incx, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDdgmmNative(handle, mode, m, n, A, lda, x, incx, C, ldc));
    }

    private static native int cublasDdgmmNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasDdgmm_64(cublasHandle handle, int mode, long m, long n, Pointer A, long lda, Pointer x, long incx, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasDdgmm_64Native(handle, mode, m, n, A, lda, x, incx, C, ldc));
    }

    private static native int cublasDdgmm_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, long var7, Pointer var9, long var10, Pointer var12, long var13);

    public static int cublasCdgmm(cublasHandle handle, int mode, int m, int n, Pointer A, int lda, Pointer x, int incx, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCdgmmNative(handle, mode, m, n, A, lda, x, incx, C, ldc));
    }

    private static native int cublasCdgmmNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasCdgmm_64(cublasHandle handle, int mode, long m, long n, Pointer A, long lda, Pointer x, long incx, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasCdgmm_64Native(handle, mode, m, n, A, lda, x, incx, C, ldc));
    }

    private static native int cublasCdgmm_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, long var7, Pointer var9, long var10, Pointer var12, long var13);

    public static int cublasZdgmm(cublasHandle handle, int mode, int m, int n, Pointer A, int lda, Pointer x, int incx, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZdgmmNative(handle, mode, m, n, A, lda, x, incx, C, ldc));
    }

    private static native int cublasZdgmmNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasZdgmm_64(cublasHandle handle, int mode, long m, long n, Pointer A, long lda, Pointer x, long incx, Pointer C, long ldc) {
        return JCublas2.checkResult(JCublas2.cublasZdgmm_64Native(handle, mode, m, n, A, lda, x, incx, C, ldc));
    }

    private static native int cublasZdgmm_64Native(cublasHandle var0, int var1, long var2, long var4, Pointer var6, long var7, Pointer var9, long var10, Pointer var12, long var13);

    public static int cublasSmatinvBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer Ainv, int lda_inv, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasSmatinvBatchedNative(handle, n, A, lda, Ainv, lda_inv, info, batchSize));
    }

    private static native int cublasSmatinvBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasDmatinvBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer Ainv, int lda_inv, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasDmatinvBatchedNative(handle, n, A, lda, Ainv, lda_inv, info, batchSize));
    }

    private static native int cublasDmatinvBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasCmatinvBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer Ainv, int lda_inv, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasCmatinvBatchedNative(handle, n, A, lda, Ainv, lda_inv, info, batchSize));
    }

    private static native int cublasCmatinvBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasZmatinvBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer Ainv, int lda_inv, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasZmatinvBatchedNative(handle, n, A, lda, Ainv, lda_inv, info, batchSize));
    }

    private static native int cublasZmatinvBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasSgeqrfBatched(cublasHandle handle, int m, int n, Pointer Aarray, int lda, Pointer TauArray, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasSgeqrfBatchedNative(handle, m, n, Aarray, lda, TauArray, info, batchSize));
    }

    private static native int cublasSgeqrfBatchedNative(cublasHandle var0, int var1, int var2, Pointer var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasDgeqrfBatched(cublasHandle handle, int m, int n, Pointer Aarray, int lda, Pointer TauArray, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasDgeqrfBatchedNative(handle, m, n, Aarray, lda, TauArray, info, batchSize));
    }

    private static native int cublasDgeqrfBatchedNative(cublasHandle var0, int var1, int var2, Pointer var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasCgeqrfBatched(cublasHandle handle, int m, int n, Pointer Aarray, int lda, Pointer TauArray, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasCgeqrfBatchedNative(handle, m, n, Aarray, lda, TauArray, info, batchSize));
    }

    private static native int cublasCgeqrfBatchedNative(cublasHandle var0, int var1, int var2, Pointer var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasZgeqrfBatched(cublasHandle handle, int m, int n, Pointer Aarray, int lda, Pointer TauArray, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasZgeqrfBatchedNative(handle, m, n, Aarray, lda, TauArray, info, batchSize));
    }

    private static native int cublasZgeqrfBatchedNative(cublasHandle var0, int var1, int var2, Pointer var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasSgelsBatched(cublasHandle handle, int trans, int m, int n, int nrhs, Pointer Aarray, int lda, Pointer Carray, int ldc, Pointer info, Pointer devInfoArray, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasSgelsBatchedNative(handle, trans, m, n, nrhs, Aarray, lda, Carray, ldc, info, devInfoArray, batchSize));
    }

    private static native int cublasSgelsBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasDgelsBatched(cublasHandle handle, int trans, int m, int n, int nrhs, Pointer Aarray, int lda, Pointer Carray, int ldc, Pointer info, Pointer devInfoArray, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasDgelsBatchedNative(handle, trans, m, n, nrhs, Aarray, lda, Carray, ldc, info, devInfoArray, batchSize));
    }

    private static native int cublasDgelsBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasCgelsBatched(cublasHandle handle, int trans, int m, int n, int nrhs, Pointer Aarray, int lda, Pointer Carray, int ldc, Pointer info, Pointer devInfoArray, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasCgelsBatchedNative(handle, trans, m, n, nrhs, Aarray, lda, Carray, ldc, info, devInfoArray, batchSize));
    }

    private static native int cublasCgelsBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasZgelsBatched(cublasHandle handle, int trans, int m, int n, int nrhs, Pointer Aarray, int lda, Pointer Carray, int ldc, Pointer info, Pointer devInfoArray, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasZgelsBatchedNative(handle, trans, m, n, nrhs, Aarray, lda, Carray, ldc, info, devInfoArray, batchSize));
    }

    private static native int cublasZgelsBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasStpttr(cublasHandle handle, int uplo, int n, Pointer AP, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasStpttrNative(handle, uplo, n, AP, A, lda));
    }

    private static native int cublasStpttrNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5);

    public static int cublasDtpttr(cublasHandle handle, int uplo, int n, Pointer AP, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasDtpttrNative(handle, uplo, n, AP, A, lda));
    }

    private static native int cublasDtpttrNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5);

    public static int cublasCtpttr(cublasHandle handle, int uplo, int n, Pointer AP, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasCtpttrNative(handle, uplo, n, AP, A, lda));
    }

    private static native int cublasCtpttrNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5);

    public static int cublasZtpttr(cublasHandle handle, int uplo, int n, Pointer AP, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasZtpttrNative(handle, uplo, n, AP, A, lda));
    }

    private static native int cublasZtpttrNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5);

    public static int cublasStrttp(cublasHandle handle, int uplo, int n, Pointer A, int lda, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasStrttpNative(handle, uplo, n, A, lda, AP));
    }

    private static native int cublasStrttpNative(cublasHandle var0, int var1, int var2, Pointer var3, int var4, Pointer var5);

    public static int cublasDtrttp(cublasHandle handle, int uplo, int n, Pointer A, int lda, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasDtrttpNative(handle, uplo, n, A, lda, AP));
    }

    private static native int cublasDtrttpNative(cublasHandle var0, int var1, int var2, Pointer var3, int var4, Pointer var5);

    public static int cublasCtrttp(cublasHandle handle, int uplo, int n, Pointer A, int lda, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasCtrttpNative(handle, uplo, n, A, lda, AP));
    }

    private static native int cublasCtrttpNative(cublasHandle var0, int var1, int var2, Pointer var3, int var4, Pointer var5);

    public static int cublasZtrttp(cublasHandle handle, int uplo, int n, Pointer A, int lda, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasZtrttpNative(handle, uplo, n, A, lda, AP));
    }

    private static native int cublasZtrttpNative(cublasHandle var0, int var1, int var2, Pointer var3, int var4, Pointer var5);

    public static int cublasSgetrfBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasSgetrfBatchedNative(handle, n, A, lda, P, info, batchSize));
    }

    private static native int cublasSgetrfBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6);

    public static int cublasDgetrfBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasDgetrfBatchedNative(handle, n, A, lda, P, info, batchSize));
    }

    private static native int cublasDgetrfBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6);

    public static int cublasCgetrfBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasCgetrfBatchedNative(handle, n, A, lda, P, info, batchSize));
    }

    private static native int cublasCgetrfBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6);

    public static int cublasZgetrfBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasZgetrfBatchedNative(handle, n, A, lda, P, info, batchSize));
    }

    private static native int cublasZgetrfBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6);

    public static int cublasSgetriBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer C, int ldc, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasSgetriBatchedNative(handle, n, A, lda, P, C, ldc, info, batchSize));
    }

    private static native int cublasSgetriBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasDgetriBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer C, int ldc, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasDgetriBatchedNative(handle, n, A, lda, P, C, ldc, info, batchSize));
    }

    private static native int cublasDgetriBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasCgetriBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer C, int ldc, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasCgetriBatchedNative(handle, n, A, lda, P, C, ldc, info, batchSize));
    }

    private static native int cublasCgetriBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasZgetriBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer C, int ldc, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasZgetriBatchedNative(handle, n, A, lda, P, C, ldc, info, batchSize));
    }

    private static native int cublasZgetriBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasSgetrsBatched(cublasHandle handle, int trans, int n, int nrhs, Pointer Aarray, int lda, Pointer devIpiv, Pointer Barray, int ldb, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasSgetrsBatchedNative(handle, trans, n, nrhs, Aarray, lda, devIpiv, Barray, ldb, info, batchSize));
    }

    private static native int cublasSgetrsBatchedNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10);

    public static int cublasDgetrsBatched(cublasHandle handle, int trans, int n, int nrhs, Pointer Aarray, int lda, Pointer devIpiv, Pointer Barray, int ldb, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasDgetrsBatchedNative(handle, trans, n, nrhs, Aarray, lda, devIpiv, Barray, ldb, info, batchSize));
    }

    private static native int cublasDgetrsBatchedNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10);

    public static int cublasCgetrsBatched(cublasHandle handle, int trans, int n, int nrhs, Pointer Aarray, int lda, Pointer devIpiv, Pointer Barray, int ldb, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasCgetrsBatchedNative(handle, trans, n, nrhs, Aarray, lda, devIpiv, Barray, ldb, info, batchSize));
    }

    private static native int cublasCgetrsBatchedNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10);

    public static int cublasZgetrsBatched(cublasHandle handle, int trans, int n, int nrhs, Pointer Aarray, int lda, Pointer devIpiv, Pointer Barray, int ldb, Pointer info, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasZgetrsBatchedNative(handle, trans, n, nrhs, Aarray, lda, devIpiv, Barray, ldb, info, batchSize));
    }

    private static native int cublasZgetrsBatchedNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10);

    public static int cublasMigrateComputeType_new(cublasHandle handle, int dataType, int[] computeType) {
        return JCublas2.checkResult(JCublas2.cublasMigrateComputeType_newNative(handle, dataType, computeType));
    }

    private static native int cublasMigrateComputeType_newNative(cublasHandle var0, int var1, int[] var2);

    static {
        JCublas2.initialize();
    }
}

