/*
 * JCuda - Java bindings for NVIDIA CUDA driver and runtime API
 *
 * Copyright (c) 2009-2016 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

 /* DO NOT EDIT THIS FILE - it is machine generated */
#include <jni.h>
 /* Header for class jcuda_runtime_JCuda */

#ifndef _Included_jcuda_runtime_JCuda
#define _Included_jcuda_runtime_JCuda
#ifdef __cplusplus
extern "C" {
#endif
#undef jcuda_runtime_JCuda_CUDART_VERSION
#define jcuda_runtime_JCuda_CUDART_VERSION 10010L
#undef jcuda_runtime_JCuda_cudaHostAllocDefault
#define jcuda_runtime_JCuda_cudaHostAllocDefault 0L
#undef jcuda_runtime_JCuda_cudaHostAllocPortable
#define jcuda_runtime_JCuda_cudaHostAllocPortable 1L
#undef jcuda_runtime_JCuda_cudaHostAllocMapped
#define jcuda_runtime_JCuda_cudaHostAllocMapped 2L
#undef jcuda_runtime_JCuda_cudaHostAllocWriteCombined
#define jcuda_runtime_JCuda_cudaHostAllocWriteCombined 4L
#undef jcuda_runtime_JCuda_cudaHostRegisterDefault
#define jcuda_runtime_JCuda_cudaHostRegisterDefault 0L
#undef jcuda_runtime_JCuda_cudaHostRegisterPortable
#define jcuda_runtime_JCuda_cudaHostRegisterPortable 1L
#undef jcuda_runtime_JCuda_cudaHostRegisterMapped
#define jcuda_runtime_JCuda_cudaHostRegisterMapped 2L
#undef jcuda_runtime_JCuda_cudaHostRegisterIoMemory
#define jcuda_runtime_JCuda_cudaHostRegisterIoMemory 4L
#undef jcuda_runtime_JCuda_cudaPeerAccessDefault
#define jcuda_runtime_JCuda_cudaPeerAccessDefault 0L
#undef jcuda_runtime_JCuda_cudaStreamDefault
#define jcuda_runtime_JCuda_cudaStreamDefault 0L
#undef jcuda_runtime_JCuda_cudaStreamNonBlocking
#define jcuda_runtime_JCuda_cudaStreamNonBlocking 1L
#undef jcuda_runtime_JCuda_cudaEventDefault
#define jcuda_runtime_JCuda_cudaEventDefault 0L
#undef jcuda_runtime_JCuda_cudaEventBlockingSync
#define jcuda_runtime_JCuda_cudaEventBlockingSync 1L
#undef jcuda_runtime_JCuda_cudaEventDisableTiming
#define jcuda_runtime_JCuda_cudaEventDisableTiming 2L
#undef jcuda_runtime_JCuda_cudaEventInterprocess
#define jcuda_runtime_JCuda_cudaEventInterprocess 4L
#undef jcuda_runtime_JCuda_cudaDeviceScheduleAuto
#define jcuda_runtime_JCuda_cudaDeviceScheduleAuto 0L
#undef jcuda_runtime_JCuda_cudaDeviceScheduleSpin
#define jcuda_runtime_JCuda_cudaDeviceScheduleSpin 1L
#undef jcuda_runtime_JCuda_cudaDeviceScheduleYield
#define jcuda_runtime_JCuda_cudaDeviceScheduleYield 2L
#undef jcuda_runtime_JCuda_cudaDeviceScheduleBlockingSync
#define jcuda_runtime_JCuda_cudaDeviceScheduleBlockingSync 4L
#undef jcuda_runtime_JCuda_cudaDeviceBlockingSync
#define jcuda_runtime_JCuda_cudaDeviceBlockingSync 4L
#undef jcuda_runtime_JCuda_cudaDeviceScheduleMask
#define jcuda_runtime_JCuda_cudaDeviceScheduleMask 7L
#undef jcuda_runtime_JCuda_cudaDeviceMapHost
#define jcuda_runtime_JCuda_cudaDeviceMapHost 8L
#undef jcuda_runtime_JCuda_cudaDeviceLmemResizeToMax
#define jcuda_runtime_JCuda_cudaDeviceLmemResizeToMax 16L
#undef jcuda_runtime_JCuda_cudaDeviceMask
#define jcuda_runtime_JCuda_cudaDeviceMask 31L
#undef jcuda_runtime_JCuda_cudaArrayDefault
#define jcuda_runtime_JCuda_cudaArrayDefault 0L
#undef jcuda_runtime_JCuda_cudaArrayLayered
#define jcuda_runtime_JCuda_cudaArrayLayered 1L
#undef jcuda_runtime_JCuda_cudaArraySurfaceLoadStore
#define jcuda_runtime_JCuda_cudaArraySurfaceLoadStore 2L
#undef jcuda_runtime_JCuda_cudaArrayCubemap
#define jcuda_runtime_JCuda_cudaArrayCubemap 4L
#undef jcuda_runtime_JCuda_cudaArrayTextureGather
#define jcuda_runtime_JCuda_cudaArrayTextureGather 8L
#undef jcuda_runtime_JCuda_cudaArrayColorAttachment
#define jcuda_runtime_JCuda_cudaArrayColorAttachment 32L
#undef jcuda_runtime_JCuda_cudaIpcMemLazyEnablePeerAccess
#define jcuda_runtime_JCuda_cudaIpcMemLazyEnablePeerAccess 1L
#undef jcuda_runtime_JCuda_cudaStreamCallbackNonblocking
#define jcuda_runtime_JCuda_cudaStreamCallbackNonblocking 0L
#undef jcuda_runtime_JCuda_cudaStreamCallbackBlocking
#define jcuda_runtime_JCuda_cudaStreamCallbackBlocking 1L
#undef jcuda_runtime_JCuda_cudaSurfaceType1D
#define jcuda_runtime_JCuda_cudaSurfaceType1D 1L
#undef jcuda_runtime_JCuda_cudaSurfaceType2D
#define jcuda_runtime_JCuda_cudaSurfaceType2D 2L
#undef jcuda_runtime_JCuda_cudaSurfaceType3D
#define jcuda_runtime_JCuda_cudaSurfaceType3D 3L
#undef jcuda_runtime_JCuda_cudaSurfaceTypeCubemap
#define jcuda_runtime_JCuda_cudaSurfaceTypeCubemap 12L
#undef jcuda_runtime_JCuda_cudaSurfaceType1DLayered
#define jcuda_runtime_JCuda_cudaSurfaceType1DLayered 241L
#undef jcuda_runtime_JCuda_cudaSurfaceType2DLayered
#define jcuda_runtime_JCuda_cudaSurfaceType2DLayered 242L
#undef jcuda_runtime_JCuda_cudaSurfaceTypeCubemapLayered
#define jcuda_runtime_JCuda_cudaSurfaceTypeCubemapLayered 252L
#undef jcuda_runtime_JCuda_cudaTextureType1D
#define jcuda_runtime_JCuda_cudaTextureType1D 1L
#undef jcuda_runtime_JCuda_cudaTextureType2D
#define jcuda_runtime_JCuda_cudaTextureType2D 2L
#undef jcuda_runtime_JCuda_cudaTextureType3D
#define jcuda_runtime_JCuda_cudaTextureType3D 3L
#undef jcuda_runtime_JCuda_cudaTextureTypeCubemap
#define jcuda_runtime_JCuda_cudaTextureTypeCubemap 12L
#undef jcuda_runtime_JCuda_cudaTextureType1DLayered
#define jcuda_runtime_JCuda_cudaTextureType1DLayered 241L
#undef jcuda_runtime_JCuda_cudaTextureType2DLayered
#define jcuda_runtime_JCuda_cudaTextureType2DLayered 242L
#undef jcuda_runtime_JCuda_cudaTextureTypeCubemapLayered
#define jcuda_runtime_JCuda_cudaTextureTypeCubemapLayered 252L
#undef jcuda_runtime_JCuda_cudaMemAttachGlobal
#define jcuda_runtime_JCuda_cudaMemAttachGlobal 1L
#undef jcuda_runtime_JCuda_cudaMemAttachHost
#define jcuda_runtime_JCuda_cudaMemAttachHost 2L
#undef jcuda_runtime_JCuda_cudaMemAttachSingle
#define jcuda_runtime_JCuda_cudaMemAttachSingle 4L
#undef jcuda_runtime_JCuda_cudaOccupancyDefault
#define jcuda_runtime_JCuda_cudaOccupancyDefault 0L
#undef jcuda_runtime_JCuda_cudaOccupancyDisableCachingOverride
#define jcuda_runtime_JCuda_cudaOccupancyDisableCachingOverride 1L
#undef jcuda_runtime_JCuda_cudaCpuDeviceId
#define jcuda_runtime_JCuda_cudaCpuDeviceId -1L
#undef jcuda_runtime_JCuda_cudaInvalidDeviceId
#define jcuda_runtime_JCuda_cudaInvalidDeviceId -2L
#undef jcuda_runtime_JCuda_cudaCooperativeLaunchMultiDeviceNoPreSync
#define jcuda_runtime_JCuda_cudaCooperativeLaunchMultiDeviceNoPreSync 1L
#undef jcuda_runtime_JCuda_cudaCooperativeLaunchMultiDeviceNoPostSync
#define jcuda_runtime_JCuda_cudaCooperativeLaunchMultiDeviceNoPostSync 2L
    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    setLogLevel
    * Signature: (I)V
    */
    JNIEXPORT void JNICALL Java_jcuda_runtime_JCuda_setLogLevel
        (JNIEnv *, jclass, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGetDeviceCountNative
    * Signature: ([I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGetDeviceCountNative
        (JNIEnv *, jclass, jintArray);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaSetDeviceNative
    * Signature: (I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaSetDeviceNative
        (JNIEnv *, jclass, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaSetDeviceFlagsNative
    * Signature: (I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaSetDeviceFlagsNative
        (JNIEnv *, jclass, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGetDeviceFlagsNative
    * Signature: ([I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGetDeviceFlagsNative
        (JNIEnv *, jclass, jintArray);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaSetValidDevicesNative
    * Signature: ([II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaSetValidDevicesNative
        (JNIEnv *, jclass, jintArray, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGetDeviceNative
    * Signature: ([I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGetDeviceNative
        (JNIEnv *, jclass, jintArray);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGetDevicePropertiesNative
    * Signature: (Ljcuda/runtime/cudaDeviceProp;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGetDevicePropertiesNative
        (JNIEnv *, jclass, jobject, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceGetAttributeNative
    * Signature: ([III)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceGetAttributeNative
        (JNIEnv *, jclass, jintArray, jint, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceGetP2PAttributeNative
    * Signature: ([IIII)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceGetP2PAttributeNative
        (JNIEnv *, jclass, jintArray, jint, jint, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaChooseDeviceNative
    * Signature: ([ILjcuda/runtime/cudaDeviceProp;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaChooseDeviceNative
        (JNIEnv *, jclass, jintArray, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMalloc3DNative
    * Signature: (Ljcuda/runtime/cudaPitchedPtr;Ljcuda/runtime/cudaExtent;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMalloc3DNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMalloc3DArrayNative
    * Signature: (Ljcuda/runtime/cudaArray;Ljcuda/runtime/cudaChannelFormatDesc;Ljcuda/runtime/cudaExtent;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMalloc3DArrayNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMallocMipmappedArrayNative
    * Signature: (Ljcuda/runtime/cudaMipmappedArray;Ljcuda/runtime/cudaChannelFormatDesc;Ljcuda/runtime/cudaExtent;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMallocMipmappedArrayNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGetMipmappedArrayLevelNative
    * Signature: (Ljcuda/runtime/cudaArray;Ljcuda/runtime/cudaMipmappedArray;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGetMipmappedArrayLevelNative
        (JNIEnv *, jclass, jobject, jobject, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemset3DNative
    * Signature: (Ljcuda/runtime/cudaPitchedPtr;ILjcuda/runtime/cudaExtent;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemset3DNative
        (JNIEnv *, jclass, jobject, jint, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemsetAsyncNative
    * Signature: (Ljcuda/Pointer;IJLjcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemsetAsyncNative
        (JNIEnv *, jclass, jobject, jint, jlong, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemset2DAsyncNative
    * Signature: (Ljcuda/Pointer;JIJJLjcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemset2DAsyncNative
        (JNIEnv *, jclass, jobject, jlong, jint, jlong, jlong, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemset3DAsyncNative
    * Signature: (Ljcuda/runtime/cudaPitchedPtr;ILjcuda/runtime/cudaExtent;Ljcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemset3DAsyncNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpy3DNative
    * Signature: (Ljcuda/runtime/cudaMemcpy3DParms;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpy3DNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpy3DPeerNative
    * Signature: (Ljcuda/runtime/cudaMemcpy3DPeerParms;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpy3DPeerNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpy3DAsyncNative
    * Signature: (Ljcuda/runtime/cudaMemcpy3DParms;Ljcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpy3DAsyncNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpy3DPeerAsyncNative
    * Signature: (Ljcuda/runtime/cudaMemcpy3DPeerParms;Ljcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpy3DPeerAsyncNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemGetInfoNative
    * Signature: ([J[J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemGetInfoNative
        (JNIEnv *, jclass, jlongArray, jlongArray);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaArrayGetInfoNative
    * Signature: (Ljcuda/runtime/cudaChannelFormatDesc;Ljcuda/runtime/cudaExtent;[ILjcuda/runtime/cudaArray;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaArrayGetInfoNative
        (JNIEnv *, jclass, jobject, jobject, jintArray, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaHostAllocNative
    * Signature: (Ljcuda/Pointer;JI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaHostAllocNative
        (JNIEnv *, jclass, jobject, jlong, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaHostRegisterNative
    * Signature: (Ljcuda/Pointer;JI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaHostRegisterNative
        (JNIEnv *, jclass, jobject, jlong, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaHostUnregisterNative
    * Signature: (Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaHostUnregisterNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaHostGetDevicePointerNative
    * Signature: (Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaHostGetDevicePointerNative
        (JNIEnv *, jclass, jobject, jobject, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMallocManagedNative
    * Signature: (Ljcuda/Pointer;JI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMallocManagedNative
        (JNIEnv *, jclass, jobject, jlong, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMallocNative
    * Signature: (Ljcuda/Pointer;J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMallocNative
        (JNIEnv *, jclass, jobject, jlong);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMallocHostNative
    * Signature: (Ljcuda/Pointer;J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMallocHostNative
        (JNIEnv *, jclass, jobject, jlong);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMallocPitchNative
    * Signature: (Ljcuda/Pointer;[JJJ)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMallocPitchNative
        (JNIEnv *, jclass, jobject, jlongArray, jlong, jlong);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMallocArrayNative
    * Signature: (Ljcuda/runtime/cudaArray;Ljcuda/runtime/cudaChannelFormatDesc;JJI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMallocArrayNative
        (JNIEnv *, jclass, jobject, jobject, jlong, jlong, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaFreeNative
    * Signature: (Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaFreeNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaFreeHostNative
    * Signature: (Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaFreeHostNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaFreeArrayNative
    * Signature: (Ljcuda/runtime/cudaArray;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaFreeArrayNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaFreeMipmappedArrayNative
    * Signature: (Ljcuda/runtime/cudaMipmappedArray;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaFreeMipmappedArrayNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpyNative
    * Signature: (Ljcuda/Pointer;Ljcuda/Pointer;JI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpyNative
        (JNIEnv *, jclass, jobject, jobject, jlong, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpyPeerNative
    * Signature: (Ljcuda/Pointer;ILjcuda/Pointer;IJ)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpyPeerNative
        (JNIEnv *, jclass, jobject, jint, jobject, jint, jlong);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpyToArrayNative
    * Signature: (Ljcuda/runtime/cudaArray;JJLjcuda/Pointer;JI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpyToArrayNative
        (JNIEnv *, jclass, jobject, jlong, jlong, jobject, jlong, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpyFromArrayNative
    * Signature: (Ljcuda/Pointer;Ljcuda/runtime/cudaArray;JJJI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpyFromArrayNative
        (JNIEnv *, jclass, jobject, jobject, jlong, jlong, jlong, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpyArrayToArrayNative
    * Signature: (Ljcuda/runtime/cudaArray;JJLjcuda/runtime/cudaArray;JJJI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpyArrayToArrayNative
        (JNIEnv *, jclass, jobject, jlong, jlong, jobject, jlong, jlong, jlong, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpy2DNative
    * Signature: (Ljcuda/Pointer;JLjcuda/Pointer;JJJI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpy2DNative
        (JNIEnv *, jclass, jobject, jlong, jobject, jlong, jlong, jlong, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpy2DToArrayNative
    * Signature: (Ljcuda/runtime/cudaArray;JJLjcuda/Pointer;JJJI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpy2DToArrayNative
        (JNIEnv *, jclass, jobject, jlong, jlong, jobject, jlong, jlong, jlong, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpy2DFromArrayNative
    * Signature: (Ljcuda/Pointer;JLjcuda/runtime/cudaArray;JJJJI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpy2DFromArrayNative
        (JNIEnv *, jclass, jobject, jlong, jobject, jlong, jlong, jlong, jlong, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpy2DArrayToArrayNative
    * Signature: (Ljcuda/runtime/cudaArray;JJLjcuda/runtime/cudaArray;JJJJI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpy2DArrayToArrayNative
        (JNIEnv *, jclass, jobject, jlong, jlong, jobject, jlong, jlong, jlong, jlong, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpyAsyncNative
    * Signature: (Ljcuda/Pointer;Ljcuda/Pointer;JILjcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpyAsyncNative
        (JNIEnv *, jclass, jobject, jobject, jlong, jint, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpyPeerAsyncNative
    * Signature: (Ljcuda/Pointer;ILjcuda/Pointer;IJLjcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpyPeerAsyncNative
        (JNIEnv *, jclass, jobject, jint, jobject, jint, jlong, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpyToArrayAsyncNative
    * Signature: (Ljcuda/runtime/cudaArray;JJLjcuda/Pointer;JILjcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpyToArrayAsyncNative
        (JNIEnv *, jclass, jobject, jlong, jlong, jobject, jlong, jint, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpyFromArrayAsyncNative
    * Signature: (Ljcuda/Pointer;Ljcuda/runtime/cudaArray;JJJILjcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpyFromArrayAsyncNative
        (JNIEnv *, jclass, jobject, jobject, jlong, jlong, jlong, jint, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpy2DAsyncNative
    * Signature: (Ljcuda/Pointer;JLjcuda/Pointer;JJJILjcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpy2DAsyncNative
        (JNIEnv *, jclass, jobject, jlong, jobject, jlong, jlong, jlong, jint, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpy2DToArrayAsyncNative
    * Signature: (Ljcuda/runtime/cudaArray;JJLjcuda/Pointer;JJJILjcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpy2DToArrayAsyncNative
        (JNIEnv *, jclass, jobject, jlong, jlong, jobject, jlong, jlong, jlong, jint, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemcpy2DFromArrayAsyncNative
    * Signature: (Ljcuda/Pointer;JLjcuda/runtime/cudaArray;JJJJILjcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemcpy2DFromArrayAsyncNative
        (JNIEnv *, jclass, jobject, jlong, jobject, jlong, jlong, jlong, jlong, jint, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemsetNative
    * Signature: (Ljcuda/Pointer;IJ)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemsetNative
        (JNIEnv *, jclass, jobject, jint, jlong);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemset2DNative
    * Signature: (Ljcuda/Pointer;JIJJ)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemset2DNative
        (JNIEnv *, jclass, jobject, jlong, jint, jlong, jlong);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGetChannelDescNative
    * Signature: (Ljcuda/runtime/cudaChannelFormatDesc;Ljcuda/runtime/cudaArray;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGetChannelDescNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaCreateChannelDescNative
    * Signature: (IIIII)Ljcuda/runtime/cudaChannelFormatDesc;
    */
    JNIEXPORT jobject JNICALL Java_jcuda_runtime_JCuda_cudaCreateChannelDescNative
        (JNIEnv *, jclass, jint, jint, jint, jint, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGetLastErrorNative
    * Signature: ()I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGetLastErrorNative
        (JNIEnv *, jclass);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaPeekAtLastErrorNative
    * Signature: ()I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaPeekAtLastErrorNative
        (JNIEnv *, jclass);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGetErrorNameNative
    * Signature: (I)Ljava/lang/String;
    */
    JNIEXPORT jstring JNICALL Java_jcuda_runtime_JCuda_cudaGetErrorNameNative
        (JNIEnv *, jclass, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGetErrorStringNative
    * Signature: (I)Ljava/lang/String;
    */
    JNIEXPORT jstring JNICALL Java_jcuda_runtime_JCuda_cudaGetErrorStringNative
        (JNIEnv *, jclass, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaStreamCreateNative
    * Signature: (Ljcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaStreamCreateNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaStreamCreateWithFlagsNative
    * Signature: (Ljcuda/runtime/cudaStream_t;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaStreamCreateWithFlagsNative
        (JNIEnv *, jclass, jobject, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaStreamCreateWithPriorityNative
    * Signature: (Ljcuda/runtime/cudaStream_t;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaStreamCreateWithPriorityNative
        (JNIEnv *, jclass, jobject, jint, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaStreamGetPriorityNative
    * Signature: (Ljcuda/runtime/cudaStream_t;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaStreamGetPriorityNative
        (JNIEnv *, jclass, jobject, jintArray);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaStreamGetFlagsNative
    * Signature: (Ljcuda/runtime/cudaStream_t;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaStreamGetFlagsNative
        (JNIEnv *, jclass, jobject, jintArray);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaStreamDestroyNative
    * Signature: (Ljcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaStreamDestroyNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaStreamWaitEventNative
    * Signature: (Ljcuda/runtime/cudaStream_t;Ljcuda/runtime/cudaEvent_t;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaStreamWaitEventNative
        (JNIEnv *, jclass, jobject, jobject, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaStreamAddCallbackNative
    * Signature: (Ljcuda/runtime/cudaStream_t;Ljcuda/runtime/cudaStreamCallback;Ljava/lang/Object;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaStreamAddCallbackNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaStreamSynchronizeNative
    * Signature: (Ljcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaStreamSynchronizeNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaStreamQueryNative
    * Signature: (Ljcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaStreamQueryNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaStreamAttachMemAsyncNative
    * Signature: (Ljcuda/runtime/cudaStream_t;Ljcuda/Pointer;JI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaStreamAttachMemAsyncNative
        (JNIEnv *, jclass, jobject, jobject, jlong, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaEventCreateNative
    * Signature: (Ljcuda/runtime/cudaEvent_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaEventCreateNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaEventCreateWithFlagsNative
    * Signature: (Ljcuda/runtime/cudaEvent_t;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaEventCreateWithFlagsNative
        (JNIEnv *, jclass, jobject, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaEventRecordNative
    * Signature: (Ljcuda/runtime/cudaEvent_t;Ljcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaEventRecordNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaEventQueryNative
    * Signature: (Ljcuda/runtime/cudaEvent_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaEventQueryNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaEventSynchronizeNative
    * Signature: (Ljcuda/runtime/cudaEvent_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaEventSynchronizeNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaEventDestroyNative
    * Signature: (Ljcuda/runtime/cudaEvent_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaEventDestroyNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaEventElapsedTimeNative
    * Signature: ([FLjcuda/runtime/cudaEvent_t;Ljcuda/runtime/cudaEvent_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaEventElapsedTimeNative
        (JNIEnv *, jclass, jfloatArray, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceResetNative
    * Signature: ()I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceResetNative
        (JNIEnv *, jclass);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceSynchronizeNative
    * Signature: ()I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceSynchronizeNative
        (JNIEnv *, jclass);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceSetLimitNative
    * Signature: (IJ)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceSetLimitNative
        (JNIEnv *, jclass, jint, jlong);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceGetLimitNative
    * Signature: ([JI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceGetLimitNative
        (JNIEnv *, jclass, jlongArray, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceGetCacheConfigNative
    * Signature: ([I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceGetCacheConfigNative
        (JNIEnv *, jclass, jintArray);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceGetStreamPriorityRangeNative
    * Signature: ([I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceGetStreamPriorityRangeNative
        (JNIEnv *, jclass, jintArray, jintArray);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceGetSharedMemConfigNative
    * Signature: ([I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceGetSharedMemConfigNative
        (JNIEnv *, jclass, jintArray);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceSetSharedMemConfigNative
    * Signature: (I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceSetSharedMemConfigNative
        (JNIEnv *, jclass, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceSetCacheConfigNative
    * Signature: (I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceSetCacheConfigNative
        (JNIEnv *, jclass, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceGetByPCIBusIdNative
    * Signature: ([ILjava/lang/String;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceGetByPCIBusIdNative
        (JNIEnv *, jclass, jintArray, jstring);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceGetPCIBusIdNative
    * Signature: ([Ljava/lang/String;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceGetPCIBusIdNative
        (JNIEnv *, jclass, jobjectArray, jint, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaIpcGetEventHandleNative
    * Signature: (Ljcuda/runtime/cudaIpcEventHandle;Ljcuda/runtime/cudaEvent_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaIpcGetEventHandleNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaIpcOpenEventHandleNative
    * Signature: (Ljcuda/runtime/cudaEvent_t;Ljcuda/runtime/cudaIpcEventHandle;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaIpcOpenEventHandleNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaIpcGetMemHandleNative
    * Signature: (Ljcuda/runtime/cudaIpcMemHandle;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaIpcGetMemHandleNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaIpcOpenMemHandleNative
    * Signature: (Ljcuda/Pointer;Ljcuda/runtime/cudaIpcMemHandle;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaIpcOpenMemHandleNative
        (JNIEnv *, jclass, jobject, jobject, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaIpcCloseMemHandleNative
    * Signature: (Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaIpcCloseMemHandleNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaThreadExitNative
    * Signature: ()I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaThreadExitNative
        (JNIEnv *, jclass);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaThreadSynchronizeNative
    * Signature: ()I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaThreadSynchronizeNative
        (JNIEnv *, jclass);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaThreadSetLimitNative
    * Signature: (IJ)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaThreadSetLimitNative
        (JNIEnv *, jclass, jint, jlong);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaThreadGetCacheConfigNative
    * Signature: ([I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaThreadGetCacheConfigNative
        (JNIEnv *, jclass, jintArray);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaThreadSetCacheConfigNative
    * Signature: (I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaThreadSetCacheConfigNative
        (JNIEnv *, jclass, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaThreadGetLimitNative
    * Signature: ([JI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaThreadGetLimitNative
        (JNIEnv *, jclass, jlongArray, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemPrefetchAsyncNative
    * Signature: (Ljcuda/Pointer;JILjcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemPrefetchAsyncNative
        (JNIEnv *, jclass, jobject, jlong, jint, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemAdviseNative
    * Signature: (Ljcuda/Pointer;JII)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemAdviseNative
        (JNIEnv *, jclass, jobject, jlong, jint, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemRangeGetAttributeNative
    * Signature: (Ljcuda/Pointer;JILjcuda/Pointer;J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemRangeGetAttributeNative
        (JNIEnv *, jclass, jobject, jlong, jint, jobject, jlong);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaMemRangeGetAttributesNative
    * Signature: ([Ljcuda/Pointer;[J[IJLjcuda/Pointer;J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaMemRangeGetAttributesNative
        (JNIEnv *, jclass, jobjectArray, jlongArray, jintArray, jlong, jobject, jlong);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaBindTextureNative
    * Signature: ([JLjcuda/runtime/textureReference;Ljcuda/Pointer;Ljcuda/runtime/cudaChannelFormatDesc;J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaBindTextureNative
        (JNIEnv *, jclass, jlongArray, jobject, jobject, jobject, jlong);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaBindTexture2DNative
    * Signature: ([JLjcuda/runtime/textureReference;Ljcuda/Pointer;Ljcuda/runtime/cudaChannelFormatDesc;JJJ)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaBindTexture2DNative
        (JNIEnv *, jclass, jlongArray, jobject, jobject, jobject, jlong, jlong, jlong);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaBindTextureToArrayNative
    * Signature: (Ljcuda/runtime/textureReference;Ljcuda/runtime/cudaArray;Ljcuda/runtime/cudaChannelFormatDesc;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaBindTextureToArrayNative
        (JNIEnv *, jclass, jobject, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaBindTextureToMipmappedArrayNative
    * Signature: (Ljcuda/runtime/textureReference;Ljcuda/runtime/cudaMipmappedArray;Ljcuda/runtime/cudaChannelFormatDesc;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaBindTextureToMipmappedArrayNative
        (JNIEnv *, jclass, jobject, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaUnbindTextureNative
    * Signature: (Ljcuda/runtime/textureReference;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaUnbindTextureNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGetTextureAlignmentOffsetNative
    * Signature: ([JLjcuda/runtime/textureReference;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGetTextureAlignmentOffsetNative
        (JNIEnv *, jclass, jlongArray, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaBindSurfaceToArrayNative
    * Signature: (Ljcuda/runtime/surfaceReference;Ljcuda/runtime/cudaArray;Ljcuda/runtime/cudaChannelFormatDesc;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaBindSurfaceToArrayNative
        (JNIEnv *, jclass, jobject, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaCreateTextureObjectNative
    * Signature: (Ljcuda/runtime/cudaTextureObject;Ljcuda/runtime/cudaResourceDesc;Ljcuda/runtime/cudaTextureDesc;Ljcuda/runtime/cudaResourceViewDesc;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaCreateTextureObjectNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDestroyTextureObjectNative
    * Signature: (Ljcuda/runtime/cudaTextureObject;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDestroyTextureObjectNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGetTextureObjectResourceDescNative
    * Signature: (Ljcuda/runtime/cudaResourceDesc;Ljcuda/runtime/cudaTextureObject;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGetTextureObjectResourceDescNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGetTextureObjectTextureDescNative
    * Signature: (Ljcuda/runtime/cudaTextureDesc;Ljcuda/runtime/cudaTextureObject;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGetTextureObjectTextureDescNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGetTextureObjectResourceViewDescNative
    * Signature: (Ljcuda/runtime/cudaResourceViewDesc;Ljcuda/runtime/cudaTextureObject;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGetTextureObjectResourceViewDescNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaCreateSurfaceObjectNative
    * Signature: (Ljcuda/runtime/cudaSurfaceObject;Ljcuda/runtime/cudaResourceDesc;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaCreateSurfaceObjectNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDestroySurfaceObjectNative
    * Signature: (Ljcuda/runtime/cudaSurfaceObject;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDestroySurfaceObjectNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGetSurfaceObjectResourceDescNative
    * Signature: (Ljcuda/runtime/cudaResourceDesc;Ljcuda/runtime/cudaSurfaceObject;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGetSurfaceObjectResourceDescNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaLaunchHostFuncNative
    * Signature: (Ljcuda/runtime/cudaStream_t;Ljcuda/runtime/cudaHostFn;Ljava/lang/Object;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaLaunchHostFuncNative
        (JNIEnv *, jclass, jobject, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGLSetGLDeviceNative
    * Signature: (I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGLSetGLDeviceNative
        (JNIEnv *, jclass, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGLGetDevicesNative
    * Signature: ([I[III)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGLGetDevicesNative
        (JNIEnv *, jclass, jintArray, jintArray, jint, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGraphicsGLRegisterImageNative
    * Signature: (Ljcuda/runtime/cudaGraphicsResource;III)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGraphicsGLRegisterImageNative
        (JNIEnv *, jclass, jobject, jint, jint, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGraphicsGLRegisterBufferNative
    * Signature: (Ljcuda/runtime/cudaGraphicsResource;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGraphicsGLRegisterBufferNative
        (JNIEnv *, jclass, jobject, jint, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGLMapBufferObjectNative
    * Signature: (Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGLMapBufferObjectNative
        (JNIEnv *, jclass, jobject, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGLUnmapBufferObjectNative
    * Signature: (I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGLUnmapBufferObjectNative
        (JNIEnv *, jclass, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGLUnregisterBufferObjectNative
    * Signature: (I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGLUnregisterBufferObjectNative
        (JNIEnv *, jclass, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGLSetBufferObjectMapFlagsNative
    * Signature: (II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGLSetBufferObjectMapFlagsNative
        (JNIEnv *, jclass, jint, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGLMapBufferObjectAsyncNative
    * Signature: (Ljcuda/Pointer;ILjcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGLMapBufferObjectAsyncNative
        (JNIEnv *, jclass, jobject, jint, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGLUnmapBufferObjectAsyncNative
    * Signature: (ILjcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGLUnmapBufferObjectAsyncNative
        (JNIEnv *, jclass, jint, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDriverGetVersionNative
    * Signature: ([I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDriverGetVersionNative
        (JNIEnv *, jclass, jintArray);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaRuntimeGetVersionNative
    * Signature: ([I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaRuntimeGetVersionNative
        (JNIEnv *, jclass, jintArray);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaPointerGetAttributesNative
    * Signature: (Ljcuda/runtime/cudaPointerAttributes;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaPointerGetAttributesNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceCanAccessPeerNative
    * Signature: ([III)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceCanAccessPeerNative
        (JNIEnv *, jclass, jintArray, jint, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceEnablePeerAccessNative
    * Signature: (II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceEnablePeerAccessNative
        (JNIEnv *, jclass, jint, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaDeviceDisablePeerAccessNative
    * Signature: (I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaDeviceDisablePeerAccessNative
        (JNIEnv *, jclass, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGraphicsUnregisterResourceNative
    * Signature: (Ljcuda/runtime/cudaGraphicsResource;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGraphicsUnregisterResourceNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGraphicsResourceSetMapFlagsNative
    * Signature: (Ljcuda/runtime/cudaGraphicsResource;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGraphicsResourceSetMapFlagsNative
        (JNIEnv *, jclass, jobject, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGraphicsMapResourcesNative
    * Signature: (I[Ljcuda/runtime/cudaGraphicsResource;Ljcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGraphicsMapResourcesNative
        (JNIEnv *, jclass, jint, jobjectArray, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGraphicsUnmapResourcesNative
    * Signature: (I[Ljcuda/runtime/cudaGraphicsResource;Ljcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGraphicsUnmapResourcesNative
        (JNIEnv *, jclass, jint, jobjectArray, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGraphicsResourceGetMappedPointerNative
    * Signature: (Ljcuda/Pointer;[JLjcuda/runtime/cudaGraphicsResource;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGraphicsResourceGetMappedPointerNative
        (JNIEnv *, jclass, jobject, jlongArray, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGraphicsSubResourceGetMappedArrayNative
    * Signature: (Ljcuda/runtime/cudaArray;Ljcuda/runtime/cudaGraphicsResource;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGraphicsSubResourceGetMappedArrayNative
        (JNIEnv *, jclass, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaGraphicsResourceGetMappedMipmappedArrayNative
    * Signature: (Ljcuda/runtime/cudaMipmappedArray;Ljcuda/runtime/cudaGraphicsResource;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaGraphicsResourceGetMappedMipmappedArrayNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaProfilerInitializeNative
    * Signature: (Ljava/lang/String;Ljava/lang/String;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaProfilerInitializeNative
        (JNIEnv *, jclass, jstring, jstring, jint);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaProfilerStartNative
    * Signature: ()I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaProfilerStartNative
        (JNIEnv *, jclass);

    /*
    * Class:     jcuda_runtime_JCuda
    * Method:    cudaProfilerStopNative
    * Signature: ()I
    */
    JNIEXPORT jint JNICALL Java_jcuda_runtime_JCuda_cudaProfilerStopNative
        (JNIEnv *, jclass);

#ifdef __cplusplus
}
#endif
#endif
