/*
 * JCuda - Java bindings for NVIDIA CUDA driver and runtime API
 *
 * Copyright (c) 2009-2015 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

 /* DO NOT EDIT THIS FILE - it is machine generated */
#include <jni.h>
/* Header for class jcuda_driver_JCudaDriver */

#ifndef _Included_jcuda_driver_JCudaDriver
#define _Included_jcuda_driver_JCudaDriver
#ifdef __cplusplus
extern "C" {
#endif
#undef jcuda_driver_JCudaDriver_CUDA_VERSION
#define jcuda_driver_JCudaDriver_CUDA_VERSION 11000L
#undef jcuda_driver_JCudaDriver_CU_MEMHOSTALLOC_PORTABLE
#define jcuda_driver_JCudaDriver_CU_MEMHOSTALLOC_PORTABLE 1L
#undef jcuda_driver_JCudaDriver_CU_MEMHOSTALLOC_DEVICEMAP
#define jcuda_driver_JCudaDriver_CU_MEMHOSTALLOC_DEVICEMAP 2L
#undef jcuda_driver_JCudaDriver_CU_MEMHOSTALLOC_WRITECOMBINED
#define jcuda_driver_JCudaDriver_CU_MEMHOSTALLOC_WRITECOMBINED 4L
#undef jcuda_driver_JCudaDriver_CU_MEMHOSTREGISTER_PORTABLE
#define jcuda_driver_JCudaDriver_CU_MEMHOSTREGISTER_PORTABLE 1L
#undef jcuda_driver_JCudaDriver_CU_MEMHOSTREGISTER_DEVICEMAP
#define jcuda_driver_JCudaDriver_CU_MEMHOSTREGISTER_DEVICEMAP 2L
#undef jcuda_driver_JCudaDriver_CU_MEMPEERREGISTER_DEVICEMAP
#define jcuda_driver_JCudaDriver_CU_MEMPEERREGISTER_DEVICEMAP 2L
#undef jcuda_driver_JCudaDriver_CU_MEMHOSTREGISTER_IOMEMORY
#define jcuda_driver_JCudaDriver_CU_MEMHOSTREGISTER_IOMEMORY 4L
#undef jcuda_driver_JCudaDriver_CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_PRE_LAUNCH_SYNC
#define jcuda_driver_JCudaDriver_CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_PRE_LAUNCH_SYNC 1L
#undef jcuda_driver_JCudaDriver_CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_POST_LAUNCH_SYNC
#define jcuda_driver_JCudaDriver_CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_POST_LAUNCH_SYNC 2L
#undef jcuda_driver_JCudaDriver_CUDA_ARRAY3D_LAYERED
#define jcuda_driver_JCudaDriver_CUDA_ARRAY3D_LAYERED 1L
#undef jcuda_driver_JCudaDriver_CUDA_ARRAY3D_2DARRAY
#define jcuda_driver_JCudaDriver_CUDA_ARRAY3D_2DARRAY 1L
#undef jcuda_driver_JCudaDriver_CUDA_ARRAY3D_SURFACE_LDST
#define jcuda_driver_JCudaDriver_CUDA_ARRAY3D_SURFACE_LDST 2L
#undef jcuda_driver_JCudaDriver_CUDA_ARRAY3D_CUBEMAP
#define jcuda_driver_JCudaDriver_CUDA_ARRAY3D_CUBEMAP 4L
#undef jcuda_driver_JCudaDriver_CUDA_ARRAY3D_TEXTURE_GATHER
#define jcuda_driver_JCudaDriver_CUDA_ARRAY3D_TEXTURE_GATHER 8L
#undef jcuda_driver_JCudaDriver_CUDA_ARRAY3D_DEPTH_TEXTURE
#define jcuda_driver_JCudaDriver_CUDA_ARRAY3D_DEPTH_TEXTURE 16L
#undef jcuda_driver_JCudaDriver_CUDA_ARRAY3D_COLOR_ATTACHMENT
#define jcuda_driver_JCudaDriver_CUDA_ARRAY3D_COLOR_ATTACHMENT 32L
#undef jcuda_driver_JCudaDriver_CU_PARAM_TR_DEFAULT
#define jcuda_driver_JCudaDriver_CU_PARAM_TR_DEFAULT -1L
#undef jcuda_driver_JCudaDriver_CU_TRSA_OVERRIDE_FORMAT
#define jcuda_driver_JCudaDriver_CU_TRSA_OVERRIDE_FORMAT 1L
#undef jcuda_driver_JCudaDriver_CU_TRSF_READ_AS_INTEGER
#define jcuda_driver_JCudaDriver_CU_TRSF_READ_AS_INTEGER 1L
#undef jcuda_driver_JCudaDriver_CU_TRSF_NORMALIZED_COORDINATES
#define jcuda_driver_JCudaDriver_CU_TRSF_NORMALIZED_COORDINATES 2L
#undef jcuda_driver_JCudaDriver_CU_TRSF_SRGB
#define jcuda_driver_JCudaDriver_CU_TRSF_SRGB 16L
#undef jcuda_driver_JCudaDriver_CU_STREAM_CALLBACK_NONBLOCKING
#define jcuda_driver_JCudaDriver_CU_STREAM_CALLBACK_NONBLOCKING 0L
#undef jcuda_driver_JCudaDriver_CU_STREAM_CALLBACK_BLOCKING
#define jcuda_driver_JCudaDriver_CU_STREAM_CALLBACK_BLOCKING 1L
#undef jcuda_driver_JCudaDriver_CU_TRSF_DISABLE_TRILINEAR_OPTIMIZATION
#define jcuda_driver_JCudaDriver_CU_TRSF_DISABLE_TRILINEAR_OPTIMIZATION 32L
    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    setLogLevel
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_jcuda_driver_JCudaDriver_setLogLevel
    (JNIEnv*, jclass, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuModuleLoadDataJITNative
     * Signature: (Ljcuda/driver/CUmodule;Ljcuda/Pointer;Ljcuda/driver/JITOptions;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuModuleLoadDataJITNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGetErrorStringNative
     * Signature: (I[Ljava/lang/String;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGetErrorStringNative
    (JNIEnv*, jclass, jint, jobjectArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGetErrorNameNative
     * Signature: (I[Ljava/lang/String;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGetErrorNameNative
    (JNIEnv*, jclass, jint, jobjectArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuInitNative
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuInitNative
    (JNIEnv*, jclass, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDeviceGetNative
     * Signature: (Ljcuda/driver/CUdevice;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDeviceGetNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDeviceGetCountNative
     * Signature: ([I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDeviceGetCountNative
    (JNIEnv*, jclass, jintArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDeviceGetNameNative
     * Signature: ([BILjcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDeviceGetNameNative
    (JNIEnv*, jclass, jbyteArray, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDeviceGetUuidNative
     * Signature: (Ljcuda/driver/CUuuid;Ljcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDeviceGetUuidNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDeviceGetLuidNative
     * Signature: ([B[ILjcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDeviceGetLuidNative
    (JNIEnv*, jclass, jbyteArray, jintArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDeviceComputeCapabilityNative
     * Signature: ([I[ILjcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDeviceComputeCapabilityNative
    (JNIEnv*, jclass, jintArray, jintArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDevicePrimaryCtxRetainNative
     * Signature: (Ljcuda/driver/CUcontext;Ljcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDevicePrimaryCtxRetainNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDevicePrimaryCtxReleaseNative
     * Signature: (Ljcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDevicePrimaryCtxReleaseNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDevicePrimaryCtxSetFlagsNative
     * Signature: (Ljcuda/driver/CUdevice;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDevicePrimaryCtxSetFlagsNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDeviceTotalMemNative
     * Signature: ([JLjcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDeviceTotalMemNative
    (JNIEnv*, jclass, jlongArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDeviceGetPropertiesNative
     * Signature: (Ljcuda/driver/CUdevprop;Ljcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDeviceGetPropertiesNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDeviceGetAttributeNative
     * Signature: ([IILjcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDeviceGetAttributeNative
    (JNIEnv*, jclass, jintArray, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDriverGetVersionNative
     * Signature: ([I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDriverGetVersionNative
    (JNIEnv*, jclass, jintArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxCreateNative
     * Signature: (Ljcuda/driver/CUcontext;ILjcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxCreateNative
    (JNIEnv*, jclass, jobject, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxDestroyNative
     * Signature: (Ljcuda/driver/CUcontext;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxDestroyNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxAttachNative
     * Signature: (Ljcuda/driver/CUcontext;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxAttachNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxDetachNative
     * Signature: (Ljcuda/driver/CUcontext;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxDetachNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxPushCurrentNative
     * Signature: (Ljcuda/driver/CUcontext;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxPushCurrentNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxPopCurrentNative
     * Signature: (Ljcuda/driver/CUcontext;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxPopCurrentNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxSetCurrentNative
     * Signature: (Ljcuda/driver/CUcontext;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxSetCurrentNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxGetCurrentNative
     * Signature: (Ljcuda/driver/CUcontext;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxGetCurrentNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxGetDeviceNative
     * Signature: (Ljcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxGetDeviceNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxGetFlagsNative
     * Signature: ([I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxGetFlagsNative
    (JNIEnv*, jclass, jintArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxSynchronizeNative
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxSynchronizeNative
    (JNIEnv*, jclass);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuModuleLoadNative
     * Signature: (Ljcuda/driver/CUmodule;Ljava/lang/String;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuModuleLoadNative
    (JNIEnv*, jclass, jobject, jstring);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuModuleLoadDataNative
     * Signature: (Ljcuda/driver/CUmodule;[B)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuModuleLoadDataNative
    (JNIEnv*, jclass, jobject, jbyteArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuModuleLoadDataExNative
     * Signature: (Ljcuda/driver/CUmodule;Ljcuda/Pointer;I[ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuModuleLoadDataExNative
    (JNIEnv*, jclass, jobject, jobject, jint, jintArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuModuleLoadFatBinaryNative
     * Signature: (Ljcuda/driver/CUmodule;[B)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuModuleLoadFatBinaryNative
    (JNIEnv*, jclass, jobject, jbyteArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuModuleUnloadNative
     * Signature: (Ljcuda/driver/CUmodule;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuModuleUnloadNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuModuleGetFunctionNative
     * Signature: (Ljcuda/driver/CUfunction;Ljcuda/driver/CUmodule;Ljava/lang/String;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuModuleGetFunctionNative
    (JNIEnv*, jclass, jobject, jobject, jstring);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuModuleGetGlobalNative
     * Signature: (Ljcuda/driver/CUdeviceptr;[JLjcuda/driver/CUmodule;Ljava/lang/String;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuModuleGetGlobalNative
    (JNIEnv*, jclass, jobject, jlongArray, jobject, jstring);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuModuleGetTexRefNative
     * Signature: (Ljcuda/driver/CUtexref;Ljcuda/driver/CUmodule;Ljava/lang/String;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuModuleGetTexRefNative
    (JNIEnv*, jclass, jobject, jobject, jstring);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuModuleGetSurfRefNative
     * Signature: (Ljcuda/driver/CUsurfref;Ljcuda/driver/CUmodule;Ljava/lang/String;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuModuleGetSurfRefNative
    (JNIEnv*, jclass, jobject, jobject, jstring);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuLinkCreateNative
     * Signature: (Ljcuda/driver/JITOptions;Ljcuda/driver/CUlinkState;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuLinkCreateNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuLinkAddDataNative
     * Signature: (Ljcuda/driver/CUlinkState;ILjcuda/Pointer;JLjava/lang/String;Ljcuda/driver/JITOptions;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuLinkAddDataNative
    (JNIEnv*, jclass, jobject, jint, jobject, jlong, jstring, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuLinkAddFileNative
     * Signature: (Ljcuda/driver/CUlinkState;ILjava/lang/String;Ljcuda/driver/JITOptions;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuLinkAddFileNative
    (JNIEnv*, jclass, jobject, jint, jstring, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuLinkCompleteNative
     * Signature: (Ljcuda/driver/CUlinkState;Ljcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuLinkCompleteNative
    (JNIEnv*, jclass, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuLinkDestroyNative
     * Signature: (Ljcuda/driver/CUlinkState;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuLinkDestroyNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemGetInfoNative
     * Signature: ([J[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemGetInfoNative
    (JNIEnv*, jclass, jlongArray, jlongArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemHostAllocNative
     * Signature: (Ljcuda/Pointer;JI)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemHostAllocNative
    (JNIEnv*, jclass, jobject, jlong, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemHostGetDevicePointerNative
     * Signature: (Ljcuda/driver/CUdeviceptr;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemHostGetDevicePointerNative
    (JNIEnv*, jclass, jobject, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemHostGetFlagsNative
     * Signature: ([ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemHostGetFlagsNative
    (JNIEnv*, jclass, jintArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDeviceGetByPCIBusIdNative
     * Signature: (Ljcuda/driver/CUdevice;Ljava/lang/String;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDeviceGetByPCIBusIdNative
    (JNIEnv*, jclass, jobject, jstring);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemAllocManagedNative
     * Signature: (Ljcuda/driver/CUdeviceptr;JI)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemAllocManagedNative
    (JNIEnv*, jclass, jobject, jlong, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDeviceGetPCIBusIdNative
     * Signature: ([Ljava/lang/String;ILjcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDeviceGetPCIBusIdNative
    (JNIEnv*, jclass, jobjectArray, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuIpcGetEventHandleNative
     * Signature: (Ljcuda/driver/CUipcEventHandle;Ljcuda/driver/CUevent;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuIpcGetEventHandleNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuIpcOpenEventHandleNative
     * Signature: (Ljcuda/driver/CUevent;Ljcuda/driver/CUipcEventHandle;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuIpcOpenEventHandleNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuIpcGetMemHandleNative
     * Signature: (Ljcuda/driver/CUipcMemHandle;Ljcuda/driver/CUdeviceptr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuIpcGetMemHandleNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuIpcOpenMemHandleNative
     * Signature: (Ljcuda/driver/CUdeviceptr;Ljcuda/driver/CUipcMemHandle;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuIpcOpenMemHandleNative
    (JNIEnv*, jclass, jobject, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuIpcCloseMemHandleNative
     * Signature: (Ljcuda/driver/CUdeviceptr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuIpcCloseMemHandleNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemHostRegisterNative
     * Signature: (Ljcuda/Pointer;JI)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemHostRegisterNative
    (JNIEnv*, jclass, jobject, jlong, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemHostUnregisterNative
     * Signature: (Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemHostUnregisterNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyNative
     * Signature: (Ljcuda/driver/CUdeviceptr;Ljcuda/driver/CUdeviceptr;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyNative
    (JNIEnv*, jclass, jobject, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyPeerNative
     * Signature: (Ljcuda/driver/CUdeviceptr;Ljcuda/driver/CUcontext;Ljcuda/driver/CUdeviceptr;Ljcuda/driver/CUcontext;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyPeerNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemAllocNative
     * Signature: (Ljcuda/driver/CUdeviceptr;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemAllocNative
    (JNIEnv*, jclass, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemAllocPitchNative
     * Signature: (Ljcuda/driver/CUdeviceptr;[JJJI)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemAllocPitchNative
    (JNIEnv*, jclass, jobject, jlongArray, jlong, jlong, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemFreeNative
     * Signature: (Ljcuda/driver/CUdeviceptr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemFreeNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemGetAddressRangeNative
     * Signature: (Ljcuda/driver/CUdeviceptr;[JLjcuda/driver/CUdeviceptr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemGetAddressRangeNative
    (JNIEnv*, jclass, jobject, jlongArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemAllocHostNative
     * Signature: (Ljcuda/Pointer;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemAllocHostNative
    (JNIEnv*, jclass, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemFreeHostNative
     * Signature: (Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemFreeHostNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyHtoDNative
     * Signature: (Ljcuda/driver/CUdeviceptr;Ljcuda/Pointer;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyHtoDNative
    (JNIEnv*, jclass, jobject, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyDtoHNative
     * Signature: (Ljcuda/Pointer;Ljcuda/driver/CUdeviceptr;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyDtoHNative
    (JNIEnv*, jclass, jobject, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyDtoDNative
     * Signature: (Ljcuda/driver/CUdeviceptr;Ljcuda/driver/CUdeviceptr;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyDtoDNative
    (JNIEnv*, jclass, jobject, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyDtoANative
     * Signature: (Ljcuda/driver/CUarray;JLjcuda/driver/CUdeviceptr;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyDtoANative
    (JNIEnv*, jclass, jobject, jlong, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyAtoDNative
     * Signature: (Ljcuda/driver/CUdeviceptr;Ljcuda/driver/CUarray;JJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyAtoDNative
    (JNIEnv*, jclass, jobject, jobject, jlong, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyHtoANative
     * Signature: (Ljcuda/driver/CUarray;JLjcuda/Pointer;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyHtoANative
    (JNIEnv*, jclass, jobject, jlong, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyAtoHNative
     * Signature: (Ljcuda/Pointer;Ljcuda/driver/CUarray;JJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyAtoHNative
    (JNIEnv*, jclass, jobject, jobject, jlong, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyAtoANative
     * Signature: (Ljcuda/driver/CUarray;JLjcuda/driver/CUarray;JJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyAtoANative
    (JNIEnv*, jclass, jobject, jlong, jobject, jlong, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpy2DNative
     * Signature: (Ljcuda/driver/CUDA_MEMCPY2D;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpy2DNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpy2DUnalignedNative
     * Signature: (Ljcuda/driver/CUDA_MEMCPY2D;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpy2DUnalignedNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpy3DNative
     * Signature: (Ljcuda/driver/CUDA_MEMCPY3D;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpy3DNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpy3DPeerNative
     * Signature: (Ljcuda/driver/CUDA_MEMCPY3D_PEER;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpy3DPeerNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyAsyncNative
     * Signature: (Ljcuda/driver/CUdeviceptr;Ljcuda/driver/CUdeviceptr;JLjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyAsyncNative
    (JNIEnv*, jclass, jobject, jobject, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyPeerAsyncNative
     * Signature: (Ljcuda/driver/CUdeviceptr;Ljcuda/driver/CUcontext;Ljcuda/driver/CUdeviceptr;Ljcuda/driver/CUcontext;JLjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyPeerAsyncNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jobject, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyHtoDAsyncNative
     * Signature: (Ljcuda/driver/CUdeviceptr;Ljcuda/Pointer;JLjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyHtoDAsyncNative
    (JNIEnv*, jclass, jobject, jobject, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyDtoHAsyncNative
     * Signature: (Ljcuda/Pointer;Ljcuda/driver/CUdeviceptr;JLjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyDtoHAsyncNative
    (JNIEnv*, jclass, jobject, jobject, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyDtoDAsyncNative
     * Signature: (Ljcuda/driver/CUdeviceptr;Ljcuda/driver/CUdeviceptr;JLjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyDtoDAsyncNative
    (JNIEnv*, jclass, jobject, jobject, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyHtoAAsyncNative
     * Signature: (Ljcuda/driver/CUarray;JLjcuda/Pointer;JLjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyHtoAAsyncNative
    (JNIEnv*, jclass, jobject, jlong, jobject, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpyAtoHAsyncNative
     * Signature: (Ljcuda/Pointer;Ljcuda/driver/CUarray;JJLjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpyAtoHAsyncNative
    (JNIEnv*, jclass, jobject, jobject, jlong, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpy2DAsyncNative
     * Signature: (Ljcuda/driver/CUDA_MEMCPY2D;Ljcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpy2DAsyncNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpy3DAsyncNative
     * Signature: (Ljcuda/driver/CUDA_MEMCPY3D;Ljcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpy3DAsyncNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemcpy3DPeerAsyncNative
     * Signature: (Ljcuda/driver/CUDA_MEMCPY3D_PEER;Ljcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemcpy3DPeerAsyncNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemsetD8Native
     * Signature: (Ljcuda/driver/CUdeviceptr;BJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemsetD8Native
    (JNIEnv*, jclass, jobject, jbyte, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemsetD16Native
     * Signature: (Ljcuda/driver/CUdeviceptr;SJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemsetD16Native
    (JNIEnv*, jclass, jobject, jshort, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemsetD32Native
     * Signature: (Ljcuda/driver/CUdeviceptr;IJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemsetD32Native
    (JNIEnv*, jclass, jobject, jint, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemsetD2D8Native
     * Signature: (Ljcuda/driver/CUdeviceptr;JBJJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemsetD2D8Native
    (JNIEnv*, jclass, jobject, jlong, jbyte, jlong, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemsetD2D16Native
     * Signature: (Ljcuda/driver/CUdeviceptr;JSJJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemsetD2D16Native
    (JNIEnv*, jclass, jobject, jlong, jshort, jlong, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemsetD2D32Native
     * Signature: (Ljcuda/driver/CUdeviceptr;JIJJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemsetD2D32Native
    (JNIEnv*, jclass, jobject, jlong, jint, jlong, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemsetD8AsyncNative
     * Signature: (Ljcuda/driver/CUdeviceptr;BJLjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemsetD8AsyncNative
    (JNIEnv*, jclass, jobject, jbyte, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemsetD16AsyncNative
     * Signature: (Ljcuda/driver/CUdeviceptr;SJLjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemsetD16AsyncNative
    (JNIEnv*, jclass, jobject, jshort, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemsetD32AsyncNative
     * Signature: (Ljcuda/driver/CUdeviceptr;IJLjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemsetD32AsyncNative
    (JNIEnv*, jclass, jobject, jint, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemsetD2D8AsyncNative
     * Signature: (Ljcuda/driver/CUdeviceptr;JBJJLjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemsetD2D8AsyncNative
    (JNIEnv*, jclass, jobject, jlong, jbyte, jlong, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemsetD2D16AsyncNative
     * Signature: (Ljcuda/driver/CUdeviceptr;JSJJLjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemsetD2D16AsyncNative
    (JNIEnv*, jclass, jobject, jlong, jshort, jlong, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemsetD2D32AsyncNative
     * Signature: (Ljcuda/driver/CUdeviceptr;JIJJLjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemsetD2D32AsyncNative
    (JNIEnv*, jclass, jobject, jlong, jint, jlong, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuFuncGetAttributeNative
     * Signature: ([IILjcuda/driver/CUfunction;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuFuncGetAttributeNative
    (JNIEnv*, jclass, jintArray, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuFuncSetAttributeNative
     * Signature: (Ljcuda/driver/CUfunction;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuFuncSetAttributeNative
    (JNIEnv*, jclass, jobject, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuFuncSetBlockShapeNative
     * Signature: (Ljcuda/driver/CUfunction;III)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuFuncSetBlockShapeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuFuncSetSharedSizeNative
     * Signature: (Ljcuda/driver/CUfunction;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuFuncSetSharedSizeNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuFuncSetCacheConfigNative
     * Signature: (Ljcuda/driver/CUfunction;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuFuncSetCacheConfigNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuFuncSetSharedMemConfigNative
     * Signature: (Ljcuda/driver/CUfunction;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuFuncSetSharedMemConfigNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuArrayCreateNative
     * Signature: (Ljcuda/driver/CUarray;Ljcuda/driver/CUDA_ARRAY_DESCRIPTOR;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuArrayCreateNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuArrayGetDescriptorNative
     * Signature: (Ljcuda/driver/CUDA_ARRAY_DESCRIPTOR;Ljcuda/driver/CUarray;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuArrayGetDescriptorNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuArrayDestroyNative
     * Signature: (Ljcuda/driver/CUarray;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuArrayDestroyNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuArray3DCreateNative
     * Signature: (Ljcuda/driver/CUarray;Ljcuda/driver/CUDA_ARRAY3D_DESCRIPTOR;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuArray3DCreateNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuArray3DGetDescriptorNative
     * Signature: (Ljcuda/driver/CUDA_ARRAY3D_DESCRIPTOR;Ljcuda/driver/CUarray;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuArray3DGetDescriptorNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMipmappedArrayCreateNative
     * Signature: (Ljcuda/driver/CUmipmappedArray;Ljcuda/driver/CUDA_ARRAY3D_DESCRIPTOR;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMipmappedArrayCreateNative
    (JNIEnv*, jclass, jobject, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMipmappedArrayGetLevelNative
     * Signature: (Ljcuda/driver/CUarray;Ljcuda/driver/CUmipmappedArray;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMipmappedArrayGetLevelNative
    (JNIEnv*, jclass, jobject, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMipmappedArrayDestroyNative
     * Signature: (Ljcuda/driver/CUmipmappedArray;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMipmappedArrayDestroyNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemAddressReserveNative
     * Signature: (Ljcuda/driver/CUdeviceptr;JJLjcuda/driver/CUdeviceptr;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemAddressReserveNative
    (JNIEnv*, jclass, jobject, jlong, jlong, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemAddressFreeNative
     * Signature: (Ljcuda/driver/CUdeviceptr;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemAddressFreeNative
    (JNIEnv*, jclass, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemCreateNative
     * Signature: (Ljcuda/driver/CUmemGenericAllocationHandle;JLjcuda/driver/CUmemAllocationProp;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemCreateNative
    (JNIEnv*, jclass, jobject, jlong, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemReleaseNative
     * Signature: (Ljcuda/driver/CUmemGenericAllocationHandle;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemReleaseNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemMapNative
     * Signature: (Ljcuda/driver/CUdeviceptr;JJLjcuda/driver/CUmemGenericAllocationHandle;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemMapNative
    (JNIEnv*, jclass, jobject, jlong, jlong, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemUnmapNative
     * Signature: (Ljcuda/driver/CUdeviceptr;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemUnmapNative
    (JNIEnv*, jclass, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemSetAccessNative
     * Signature: (Ljcuda/driver/CUdeviceptr;J[Ljcuda/driver/CUmemAccessDesc;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemSetAccessNative
    (JNIEnv*, jclass, jobject, jlong, jobjectArray, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemGetAccessNative
     * Signature: ([JLjcuda/driver/CUmemLocation;Ljcuda/driver/CUdeviceptr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemGetAccessNative
    (JNIEnv*, jclass, jlongArray, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemExportToShareableHandleNative
     * Signature: (Ljcuda/Pointer;Ljcuda/driver/CUmemGenericAllocationHandle;IJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemExportToShareableHandleNative
    (JNIEnv*, jclass, jobject, jobject, jint, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemImportFromShareableHandleNative
     * Signature: (Ljcuda/driver/CUmemGenericAllocationHandle;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemImportFromShareableHandleNative
    (JNIEnv*, jclass, jobject, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemGetAllocationGranularityNative
     * Signature: ([JLjcuda/driver/CUmemAllocationProp;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemGetAllocationGranularityNative
    (JNIEnv*, jclass, jlongArray, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemGetAllocationPropertiesFromHandleNative
     * Signature: (Ljcuda/driver/CUmemAllocationProp;Ljcuda/driver/CUmemGenericAllocationHandle;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemGetAllocationPropertiesFromHandleNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemRetainAllocationHandleNative
     * Signature: (Ljcuda/driver/CUmemGenericAllocationHandle;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemRetainAllocationHandleNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefCreateNative
     * Signature: (Ljcuda/driver/CUtexref;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefCreateNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefDestroyNative
     * Signature: (Ljcuda/driver/CUtexref;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefDestroyNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefSetArrayNative
     * Signature: (Ljcuda/driver/CUtexref;Ljcuda/driver/CUarray;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefSetArrayNative
    (JNIEnv*, jclass, jobject, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefSetMipmappedArrayNative
     * Signature: (Ljcuda/driver/CUtexref;Ljcuda/driver/CUmipmappedArray;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefSetMipmappedArrayNative
    (JNIEnv*, jclass, jobject, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefSetAddressNative
     * Signature: ([JLjcuda/driver/CUtexref;Ljcuda/driver/CUdeviceptr;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefSetAddressNative
    (JNIEnv*, jclass, jlongArray, jobject, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefSetFormatNative
     * Signature: (Ljcuda/driver/CUtexref;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefSetFormatNative
    (JNIEnv*, jclass, jobject, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefSetAddress2DNative
     * Signature: (Ljcuda/driver/CUtexref;Ljcuda/driver/CUDA_ARRAY_DESCRIPTOR;Ljcuda/driver/CUdeviceptr;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefSetAddress2DNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefSetAddressModeNative
     * Signature: (Ljcuda/driver/CUtexref;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefSetAddressModeNative
    (JNIEnv*, jclass, jobject, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefSetFilterModeNative
     * Signature: (Ljcuda/driver/CUtexref;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefSetFilterModeNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefSetMipmapFilterModeNative
     * Signature: (Ljcuda/driver/CUtexref;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefSetMipmapFilterModeNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefSetMipmapLevelBiasNative
     * Signature: (Ljcuda/driver/CUtexref;F)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefSetMipmapLevelBiasNative
    (JNIEnv*, jclass, jobject, jfloat);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefSetMipmapLevelClampNative
     * Signature: (Ljcuda/driver/CUtexref;FF)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefSetMipmapLevelClampNative
    (JNIEnv*, jclass, jobject, jfloat, jfloat);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefSetMaxAnisotropyNative
     * Signature: (Ljcuda/driver/CUtexref;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefSetMaxAnisotropyNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefSetBorderColorNative
     * Signature: (Ljcuda/driver/CUtexref;[F)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefSetBorderColorNative
    (JNIEnv*, jclass, jobject, jfloatArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefSetFlagsNative
     * Signature: (Ljcuda/driver/CUtexref;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefSetFlagsNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefGetAddressNative
     * Signature: (Ljcuda/driver/CUdeviceptr;Ljcuda/driver/CUtexref;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefGetAddressNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefGetArrayNative
     * Signature: (Ljcuda/driver/CUarray;Ljcuda/driver/CUtexref;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefGetArrayNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefGetMipmappedArrayNative
     * Signature: (Ljcuda/driver/CUmipmappedArray;Ljcuda/driver/CUtexref;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefGetMipmappedArrayNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefGetAddressModeNative
     * Signature: ([ILjcuda/driver/CUtexref;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefGetAddressModeNative
    (JNIEnv*, jclass, jintArray, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefGetFilterModeNative
     * Signature: ([ILjcuda/driver/CUtexref;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefGetFilterModeNative
    (JNIEnv*, jclass, jintArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefGetFormatNative
     * Signature: ([I[ILjcuda/driver/CUtexref;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefGetFormatNative
    (JNIEnv*, jclass, jintArray, jintArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefGetMipmapFilterModeNative
     * Signature: ([ILjcuda/driver/CUtexref;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefGetMipmapFilterModeNative
    (JNIEnv*, jclass, jintArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefGetMipmapLevelBiasNative
     * Signature: ([FLjcuda/driver/CUtexref;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefGetMipmapLevelBiasNative
    (JNIEnv*, jclass, jfloatArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefGetMipmapLevelClampNative
     * Signature: ([F[FLjcuda/driver/CUtexref;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefGetMipmapLevelClampNative
    (JNIEnv*, jclass, jfloatArray, jfloatArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefGetMaxAnisotropyNative
     * Signature: ([ILjcuda/driver/CUtexref;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefGetMaxAnisotropyNative
    (JNIEnv*, jclass, jintArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefGetBorderColorNative
     * Signature: ([FLjcuda/driver/CUtexref;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefGetBorderColorNative
    (JNIEnv*, jclass, jfloatArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexRefGetFlagsNative
     * Signature: ([ILjcuda/driver/CUtexref;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexRefGetFlagsNative
    (JNIEnv*, jclass, jintArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuSurfRefSetArrayNative
     * Signature: (Ljcuda/driver/CUsurfref;Ljcuda/driver/CUarray;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuSurfRefSetArrayNative
    (JNIEnv*, jclass, jobject, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuSurfRefGetArrayNative
     * Signature: (Ljcuda/driver/CUarray;Ljcuda/driver/CUsurfref;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuSurfRefGetArrayNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexObjectCreateNative
     * Signature: (Ljcuda/driver/CUtexObject;Ljcuda/driver/CUDA_RESOURCE_DESC;Ljcuda/driver/CUDA_TEXTURE_DESC;Ljcuda/driver/CUDA_RESOURCE_VIEW_DESC;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexObjectCreateNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexObjectDestroyNative
     * Signature: (Ljcuda/driver/CUtexObject;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexObjectDestroyNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexObjectGetResourceDescNative
     * Signature: (Ljcuda/driver/CUDA_RESOURCE_DESC;Ljcuda/driver/CUtexObject;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexObjectGetResourceDescNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexObjectGetTextureDescNative
     * Signature: (Ljcuda/driver/CUDA_TEXTURE_DESC;Ljcuda/driver/CUtexObject;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexObjectGetTextureDescNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuTexObjectGetResourceViewDescNative
     * Signature: (Ljcuda/driver/CUDA_RESOURCE_VIEW_DESC;Ljcuda/driver/CUtexObject;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuTexObjectGetResourceViewDescNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuSurfObjectCreateNative
     * Signature: (Ljcuda/driver/CUsurfObject;Ljcuda/driver/CUDA_RESOURCE_DESC;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuSurfObjectCreateNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuSurfObjectDestroyNative
     * Signature: (Ljcuda/driver/CUsurfObject;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuSurfObjectDestroyNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuSurfObjectGetResourceDescNative
     * Signature: (Ljcuda/driver/CUDA_RESOURCE_DESC;Ljcuda/driver/CUsurfObject;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuSurfObjectGetResourceDescNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDeviceCanAccessPeerNative
     * Signature: ([ILjcuda/driver/CUdevice;Ljcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDeviceCanAccessPeerNative
    (JNIEnv*, jclass, jintArray, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuDeviceGetP2PAttributeNative
     * Signature: ([IILjcuda/driver/CUdevice;Ljcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuDeviceGetP2PAttributeNative
    (JNIEnv*, jclass, jintArray, jint, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxEnablePeerAccessNative
     * Signature: (Ljcuda/driver/CUcontext;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxEnablePeerAccessNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxDisablePeerAccessNative
     * Signature: (Ljcuda/driver/CUcontext;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxDisablePeerAccessNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuParamSetSizeNative
     * Signature: (Ljcuda/driver/CUfunction;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuParamSetSizeNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuParamSetiNative
     * Signature: (Ljcuda/driver/CUfunction;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuParamSetiNative
    (JNIEnv*, jclass, jobject, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuParamSetfNative
     * Signature: (Ljcuda/driver/CUfunction;IF)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuParamSetfNative
    (JNIEnv*, jclass, jobject, jint, jfloat);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuParamSetvNative
     * Signature: (Ljcuda/driver/CUfunction;ILjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuParamSetvNative
    (JNIEnv*, jclass, jobject, jint, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuParamSetTexRefNative
     * Signature: (Ljcuda/driver/CUfunction;ILjcuda/driver/CUtexref;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuParamSetTexRefNative
    (JNIEnv*, jclass, jobject, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphCreateNative
     * Signature: (Ljcuda/driver/CUgraph;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphCreateNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphAddKernelNodeNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUgraph;[Ljcuda/driver/CUgraphNode;JLjcuda/driver/CUDA_KERNEL_NODE_PARAMS;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphAddKernelNodeNative
    (JNIEnv*, jclass, jobject, jobject, jobjectArray, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphKernelNodeGetParamsNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUDA_KERNEL_NODE_PARAMS;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphKernelNodeGetParamsNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphKernelNodeSetParamsNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUDA_KERNEL_NODE_PARAMS;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphKernelNodeSetParamsNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphAddMemcpyNodeNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUgraph;[Ljcuda/driver/CUgraphNode;JLjcuda/driver/CUDA_MEMCPY3D;Ljcuda/driver/CUcontext;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphAddMemcpyNodeNative
    (JNIEnv*, jclass, jobject, jobject, jobjectArray, jlong, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphMemcpyNodeGetParamsNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUDA_MEMCPY3D;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphMemcpyNodeGetParamsNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphMemcpyNodeSetParamsNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUDA_MEMCPY3D;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphMemcpyNodeSetParamsNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphAddMemsetNodeNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUgraph;[Ljcuda/driver/CUgraphNode;JLjcuda/driver/CUDA_MEMSET_NODE_PARAMS;Ljcuda/driver/CUcontext;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphAddMemsetNodeNative
    (JNIEnv*, jclass, jobject, jobject, jobjectArray, jlong, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphMemsetNodeGetParamsNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUDA_MEMSET_NODE_PARAMS;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphMemsetNodeGetParamsNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphMemsetNodeSetParamsNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUDA_MEMSET_NODE_PARAMS;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphMemsetNodeSetParamsNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphAddHostNodeNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUgraph;[Ljcuda/driver/CUgraphNode;JLjcuda/driver/CUDA_HOST_NODE_PARAMS;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphAddHostNodeNative
    (JNIEnv*, jclass, jobject, jobject, jobjectArray, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphHostNodeGetParamsNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUDA_HOST_NODE_PARAMS;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphHostNodeGetParamsNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphHostNodeSetParamsNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUDA_HOST_NODE_PARAMS;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphHostNodeSetParamsNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphAddChildGraphNodeNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUgraph;[Ljcuda/driver/CUgraphNode;JLjcuda/driver/CUgraph;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphAddChildGraphNodeNative
    (JNIEnv*, jclass, jobject, jobject, jobjectArray, jlong, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphChildGraphNodeGetGraphNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUgraph;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphChildGraphNodeGetGraphNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphAddEmptyNodeNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUgraph;[Ljcuda/driver/CUgraphNode;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphAddEmptyNodeNative
    (JNIEnv*, jclass, jobject, jobject, jobjectArray, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphCloneNative
     * Signature: (Ljcuda/driver/CUgraph;Ljcuda/driver/CUgraph;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphCloneNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphNodeFindInCloneNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUgraph;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphNodeFindInCloneNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphNodeGetTypeNative
     * Signature: (Ljcuda/driver/CUgraphNode;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphNodeGetTypeNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphGetNodesNative
     * Signature: (Ljcuda/driver/CUgraph;[Ljcuda/driver/CUgraphNode;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphGetNodesNative
    (JNIEnv*, jclass, jobject, jobjectArray, jlongArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphGetRootNodesNative
     * Signature: (Ljcuda/driver/CUgraph;[Ljcuda/driver/CUgraphNode;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphGetRootNodesNative
    (JNIEnv*, jclass, jobject, jobjectArray, jlongArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphGetEdgesNative
     * Signature: (Ljcuda/driver/CUgraph;[Ljcuda/driver/CUgraphNode;[Ljcuda/driver/CUgraphNode;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphGetEdgesNative
    (JNIEnv*, jclass, jobject, jobjectArray, jobjectArray, jlongArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphNodeGetDependenciesNative
     * Signature: (Ljcuda/driver/CUgraphNode;[Ljcuda/driver/CUgraphNode;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphNodeGetDependenciesNative
    (JNIEnv*, jclass, jobject, jobjectArray, jlongArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphNodeGetDependentNodesNative
     * Signature: (Ljcuda/driver/CUgraphNode;[Ljcuda/driver/CUgraphNode;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphNodeGetDependentNodesNative
    (JNIEnv*, jclass, jobject, jobjectArray, jlongArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphAddDependenciesNative
     * Signature: (Ljcuda/driver/CUgraph;[Ljcuda/driver/CUgraphNode;[Ljcuda/driver/CUgraphNode;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphAddDependenciesNative
    (JNIEnv*, jclass, jobject, jobjectArray, jobjectArray, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphRemoveDependenciesNative
     * Signature: (Ljcuda/driver/CUgraph;[Ljcuda/driver/CUgraphNode;[Ljcuda/driver/CUgraphNode;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphRemoveDependenciesNative
    (JNIEnv*, jclass, jobject, jobjectArray, jobjectArray, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphDestroyNodeNative
     * Signature: (Ljcuda/driver/CUgraphNode;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphDestroyNodeNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphInstantiateNative
     * Signature: (Ljcuda/driver/CUgraphExec;Ljcuda/driver/CUgraph;Ljcuda/driver/CUgraphNode;[BJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphInstantiateNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jbyteArray, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphExecKernelNodeSetParamsNative
     * Signature: (Ljcuda/driver/CUgraphExec;Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUDA_KERNEL_NODE_PARAMS;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphExecKernelNodeSetParamsNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphExecMemcpyNodeSetParamsNative
     * Signature: (Ljcuda/driver/CUgraphExec;Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUDA_MEMCPY3D;Ljcuda/driver/CUcontext;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphExecMemcpyNodeSetParamsNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphExecMemsetNodeSetParamsNative
     * Signature: (Ljcuda/driver/CUgraphExec;Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUDA_MEMSET_NODE_PARAMS;Ljcuda/driver/CUcontext;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphExecMemsetNodeSetParamsNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphExecHostNodeSetParamsNative
     * Signature: (Ljcuda/driver/CUgraphExec;Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUDA_HOST_NODE_PARAMS;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphExecHostNodeSetParamsNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphLaunchNative
     * Signature: (Ljcuda/driver/CUgraphExec;Ljcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphLaunchNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphExecDestroyNative
     * Signature: (Ljcuda/driver/CUgraphExec;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphExecDestroyNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphDestroyNative
     * Signature: (Ljcuda/driver/CUgraph;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphDestroyNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphExecUpdateNative
     * Signature: (Ljcuda/driver/CUgraphExec;Ljcuda/driver/CUgraph;Ljcuda/driver/CUgraphNode;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphExecUpdateNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphKernelNodeCopyAttributesNative
     * Signature: (Ljcuda/driver/CUgraphNode;Ljcuda/driver/CUgraphNode;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphKernelNodeCopyAttributesNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphKernelNodeGetAttributeNative
     * Signature: (Ljcuda/driver/CUgraphNode;ILjcuda/driver/CUkernelNodeAttrValue;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphKernelNodeGetAttributeNative
    (JNIEnv*, jclass, jobject, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphKernelNodeSetAttributeNative
     * Signature: (Ljcuda/driver/CUgraphNode;ILjcuda/driver/CUkernelNodeAttrValue;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphKernelNodeSetAttributeNative
    (JNIEnv*, jclass, jobject, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuOccupancyMaxActiveBlocksPerMultiprocessorNative
     * Signature: ([ILjcuda/driver/CUfunction;IJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuOccupancyMaxActiveBlocksPerMultiprocessorNative
    (JNIEnv*, jclass, jintArray, jobject, jint, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlagsNative
     * Signature: ([ILjcuda/driver/CUfunction;IJI)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlagsNative
    (JNIEnv*, jclass, jintArray, jobject, jint, jlong, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuOccupancyAvailableDynamicSMemPerBlockNative
     * Signature: ([JLjcuda/driver/CUfunction;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuOccupancyAvailableDynamicSMemPerBlockNative
    (JNIEnv*, jclass, jlongArray, jobject, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuOccupancyMaxPotentialBlockSizeNative
     * Signature: ([I[ILjcuda/driver/CUfunction;Ljcuda/driver/CUoccupancyB2DSize;JI)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuOccupancyMaxPotentialBlockSizeNative
    (JNIEnv*, jclass, jintArray, jintArray, jobject, jobject, jlong, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuOccupancyMaxPotentialBlockSizeWithFlagsNative
     * Signature: ([I[ILjcuda/driver/CUfunction;Ljcuda/driver/CUoccupancyB2DSize;JII)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuOccupancyMaxPotentialBlockSizeWithFlagsNative
    (JNIEnv*, jclass, jintArray, jintArray, jobject, jobject, jlong, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuLaunchNative
     * Signature: (Ljcuda/driver/CUfunction;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuLaunchNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuLaunchGridNative
     * Signature: (Ljcuda/driver/CUfunction;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuLaunchGridNative
    (JNIEnv*, jclass, jobject, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuLaunchGridAsyncNative
     * Signature: (Ljcuda/driver/CUfunction;IILjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuLaunchGridAsyncNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuEventCreateNative
     * Signature: (Ljcuda/driver/CUevent;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuEventCreateNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuEventRecordNative
     * Signature: (Ljcuda/driver/CUevent;Ljcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuEventRecordNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuEventQueryNative
     * Signature: (Ljcuda/driver/CUevent;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuEventQueryNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuEventSynchronizeNative
     * Signature: (Ljcuda/driver/CUevent;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuEventSynchronizeNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuEventDestroyNative
     * Signature: (Ljcuda/driver/CUevent;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuEventDestroyNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuEventElapsedTimeNative
     * Signature: ([FLjcuda/driver/CUevent;Ljcuda/driver/CUevent;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuEventElapsedTimeNative
    (JNIEnv*, jclass, jfloatArray, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamWaitValue32Native
     * Signature: (Ljcuda/driver/CUstream;Ljcuda/driver/CUdeviceptr;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamWaitValue32Native
    (JNIEnv*, jclass, jobject, jobject, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamWriteValue32Native
     * Signature: (Ljcuda/driver/CUstream;Ljcuda/driver/CUdeviceptr;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamWriteValue32Native
    (JNIEnv*, jclass, jobject, jobject, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamWaitValue64Native
     * Signature: (Ljcuda/driver/CUstream;Ljcuda/driver/CUdeviceptr;JI)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamWaitValue64Native
    (JNIEnv*, jclass, jobject, jobject, jlong, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamWriteValue64Native
     * Signature: (Ljcuda/driver/CUstream;Ljcuda/driver/CUdeviceptr;JI)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamWriteValue64Native
    (JNIEnv*, jclass, jobject, jobject, jlong, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuPointerGetAttributeNative
     * Signature: (Ljcuda/Pointer;ILjcuda/driver/CUdeviceptr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuPointerGetAttributeNative
    (JNIEnv*, jclass, jobject, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemPrefetchAsyncNative
     * Signature: (Ljcuda/driver/CUdeviceptr;JLjcuda/driver/CUdevice;Ljcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemPrefetchAsyncNative
    (JNIEnv*, jclass, jobject, jlong, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemAdviseNative
     * Signature: (Ljcuda/driver/CUdeviceptr;JILjcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemAdviseNative
    (JNIEnv*, jclass, jobject, jlong, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemRangeGetAttributeNative
     * Signature: (Ljcuda/Pointer;JILjcuda/driver/CUdeviceptr;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemRangeGetAttributeNative
    (JNIEnv*, jclass, jobject, jlong, jint, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuMemRangeGetAttributesNative
     * Signature: ([Ljcuda/Pointer;[J[IJLjcuda/driver/CUdeviceptr;J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuMemRangeGetAttributesNative
    (JNIEnv*, jclass, jobjectArray, jlongArray, jintArray, jlong, jobject, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuPointerSetAttributeNative
     * Signature: (Ljcuda/Pointer;ILjcuda/driver/CUdeviceptr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuPointerSetAttributeNative
    (JNIEnv*, jclass, jobject, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuPointerGetAttributesNative
     * Signature: (I[ILjcuda/Pointer;Ljcuda/driver/CUdeviceptr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuPointerGetAttributesNative
    (JNIEnv*, jclass, jint, jintArray, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamCreateNative
     * Signature: (Ljcuda/driver/CUstream;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamCreateNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamCreateWithPriorityNative
     * Signature: (Ljcuda/driver/CUstream;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamCreateWithPriorityNative
    (JNIEnv*, jclass, jobject, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamGetPriorityNative
     * Signature: (Ljcuda/driver/CUstream;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamGetPriorityNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamGetFlagsNative
     * Signature: (Ljcuda/driver/CUstream;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamGetFlagsNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamGetCtxNative
     * Signature: (Ljcuda/driver/CUstream;Ljcuda/driver/CUcontext;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamGetCtxNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamWaitEventNative
     * Signature: (Ljcuda/driver/CUstream;Ljcuda/driver/CUevent;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamWaitEventNative
    (JNIEnv*, jclass, jobject, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamAddCallbackNative
     * Signature: (Ljcuda/driver/CUstream;Ljcuda/driver/CUstreamCallback;Ljava/lang/Object;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamAddCallbackNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamBeginCaptureNative
     * Signature: (Ljcuda/driver/CUstream;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamBeginCaptureNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuThreadExchangeStreamCaptureModeNative
     * Signature: ([I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuThreadExchangeStreamCaptureModeNative
    (JNIEnv*, jclass, jintArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamEndCaptureNative
     * Signature: (Ljcuda/driver/CUstream;Ljcuda/driver/CUgraph;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamEndCaptureNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamIsCapturingNative
     * Signature: (Ljcuda/driver/CUstream;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamIsCapturingNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamGetCaptureInfoNative
     * Signature: (Ljcuda/driver/CUstream;[I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamGetCaptureInfoNative
    (JNIEnv*, jclass, jobject, jintArray, jlongArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamAttachMemAsyncNative
     * Signature: (Ljcuda/driver/CUstream;Ljcuda/driver/CUdeviceptr;JI)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamAttachMemAsyncNative
    (JNIEnv*, jclass, jobject, jobject, jlong, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamQueryNative
     * Signature: (Ljcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamQueryNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamSynchronizeNative
     * Signature: (Ljcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamSynchronizeNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamDestroyNative
     * Signature: (Ljcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamDestroyNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamCopyAttributesNative
     * Signature: (Ljcuda/driver/CUstream;Ljcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamCopyAttributesNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamGetAttributeNative
     * Signature: (Ljcuda/driver/CUstream;ILjcuda/driver/CUstreamAttrValue;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamGetAttributeNative
    (JNIEnv*, jclass, jobject, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuStreamSetAttributeNative
     * Signature: (Ljcuda/driver/CUstream;ILjcuda/driver/CUstreamAttrValue;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuStreamSetAttributeNative
    (JNIEnv*, jclass, jobject, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGLInitNative
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGLInitNative
    (JNIEnv*, jclass);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGLCtxCreateNative
     * Signature: (Ljcuda/driver/CUcontext;ILjcuda/driver/CUdevice;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGLCtxCreateNative
    (JNIEnv*, jclass, jobject, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGLGetDevicesNative
     * Signature: ([I[Ljcuda/driver/CUdevice;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGLGetDevicesNative
    (JNIEnv*, jclass, jintArray, jobjectArray, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphicsGLRegisterBufferNative
     * Signature: (Ljcuda/driver/CUgraphicsResource;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphicsGLRegisterBufferNative
    (JNIEnv*, jclass, jobject, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphicsGLRegisterImageNative
     * Signature: (Ljcuda/driver/CUgraphicsResource;III)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphicsGLRegisterImageNative
    (JNIEnv*, jclass, jobject, jint, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGLMapBufferObjectNative
     * Signature: (Ljcuda/driver/CUdeviceptr;[JI)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGLMapBufferObjectNative
    (JNIEnv*, jclass, jobject, jlongArray, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGLUnmapBufferObjectNative
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGLUnmapBufferObjectNative
    (JNIEnv*, jclass, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGLUnregisterBufferObjectNative
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGLUnregisterBufferObjectNative
    (JNIEnv*, jclass, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGLSetBufferObjectMapFlagsNative
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGLSetBufferObjectMapFlagsNative
    (JNIEnv*, jclass, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGLMapBufferObjectAsyncNative
     * Signature: (Ljcuda/driver/CUdeviceptr;[JILjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGLMapBufferObjectAsyncNative
    (JNIEnv*, jclass, jobject, jlongArray, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGLUnmapBufferObjectAsyncNative
     * Signature: (ILjcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGLUnmapBufferObjectAsyncNative
    (JNIEnv*, jclass, jint, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphicsUnregisterResourceNative
     * Signature: (Ljcuda/driver/CUgraphicsResource;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphicsUnregisterResourceNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphicsSubResourceGetMappedArrayNative
     * Signature: (Ljcuda/driver/CUarray;Ljcuda/driver/CUgraphicsResource;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphicsSubResourceGetMappedArrayNative
    (JNIEnv*, jclass, jobject, jobject, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphicsResourceGetMappedMipmappedArrayNative
     * Signature: (Ljcuda/driver/CUmipmappedArray;Ljcuda/driver/CUgraphicsResource;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphicsResourceGetMappedMipmappedArrayNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphicsResourceGetMappedPointerNative
     * Signature: (Ljcuda/driver/CUdeviceptr;[JLjcuda/driver/CUgraphicsResource;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphicsResourceGetMappedPointerNative
    (JNIEnv*, jclass, jobject, jlongArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphicsResourceSetMapFlagsNative
     * Signature: (Ljcuda/driver/CUgraphicsResource;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphicsResourceSetMapFlagsNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphicsMapResourcesNative
     * Signature: (I[Ljcuda/driver/CUgraphicsResource;Ljcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphicsMapResourcesNative
    (JNIEnv*, jclass, jint, jobjectArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuGraphicsUnmapResourcesNative
     * Signature: (I[Ljcuda/driver/CUgraphicsResource;Ljcuda/driver/CUstream;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuGraphicsUnmapResourcesNative
    (JNIEnv*, jclass, jint, jobjectArray, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuFuncGetModuleNative
     * Signature: (Ljcuda/driver/CUmodule;Ljcuda/driver/CUfunction;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuFuncGetModuleNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxSetLimitNative
     * Signature: (IJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxSetLimitNative
    (JNIEnv*, jclass, jint, jlong);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxGetCacheConfigNative
     * Signature: ([I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxGetCacheConfigNative
    (JNIEnv*, jclass, jintArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxSetCacheConfigNative
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxSetCacheConfigNative
    (JNIEnv*, jclass, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxGetSharedMemConfigNative
     * Signature: ([I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxGetSharedMemConfigNative
    (JNIEnv*, jclass, jintArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxSetSharedMemConfigNative
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxSetSharedMemConfigNative
    (JNIEnv*, jclass, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxGetApiVersionNative
     * Signature: (Ljcuda/driver/CUcontext;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxGetApiVersionNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxGetStreamPriorityRangeNative
     * Signature: ([I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxGetStreamPriorityRangeNative
    (JNIEnv*, jclass, jintArray, jintArray);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxResetPersistingL2CacheNative
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxResetPersistingL2CacheNative
    (JNIEnv*, jclass);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuLaunchKernelNative
     * Signature: (Ljcuda/driver/CUfunction;IIIIIIILjcuda/driver/CUstream;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuLaunchKernelNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuLaunchCooperativeKernelNative
     * Signature: (Ljcuda/driver/CUfunction;IIIIIIILjcuda/driver/CUstream;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuLaunchCooperativeKernelNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jint, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuLaunchCooperativeKernelMultiDeviceNative
     * Signature: ([Ljcuda/driver/CUDA_LAUNCH_PARAMS;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuLaunchCooperativeKernelMultiDeviceNative
    (JNIEnv*, jclass, jobjectArray, jint, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuLaunchHostFuncNative
     * Signature: (Ljcuda/driver/CUstream;Ljcuda/driver/CUhostFn;Ljava/lang/Object;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuLaunchHostFuncNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuCtxGetLimitNative
     * Signature: ([JI)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuCtxGetLimitNative
    (JNIEnv*, jclass, jlongArray, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuProfilerInitializeNative
     * Signature: (Ljava/lang/String;Ljava/lang/String;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuProfilerInitializeNative
    (JNIEnv*, jclass, jstring, jstring, jint);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuProfilerStartNative
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuProfilerStartNative
    (JNIEnv*, jclass);

    /*
     * Class:     jcuda_driver_JCudaDriver
     * Method:    cuProfilerStopNative
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_jcuda_driver_JCudaDriver_cuProfilerStopNative
    (JNIEnv*, jclass);

#ifdef __cplusplus
}
#endif
#endif
