/*
 * JCudnn - Java bindings for cuDNN, the NVIDIA CUDA
 * Deep Neural Network library, to be used with JCuda
 *
 * Copyright (c) 2015-2016 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/* DO NOT EDIT THIS FILE - it is machine generated */
#include <jni.h>
/* Header for class jcuda_jcudnn_JCudnn */

#ifndef _Included_jcuda_jcudnn_JCudnn
#define _Included_jcuda_jcudnn_JCudnn
#ifdef __cplusplus
extern "C" {
#endif
#undef jcuda_jcudnn_JCudnn_CUDNN_MAJOR
#define jcuda_jcudnn_JCudnn_CUDNN_MAJOR 5L
#undef jcuda_jcudnn_JCudnn_CUDNN_MINOR
#define jcuda_jcudnn_JCudnn_CUDNN_MINOR 1L
#undef jcuda_jcudnn_JCudnn_CUDNN_PATCHLEVEL
#define jcuda_jcudnn_JCudnn_CUDNN_PATCHLEVEL 5L
#undef jcuda_jcudnn_JCudnn_CUDNN_VERSION
#define jcuda_jcudnn_JCudnn_CUDNN_VERSION 5105L
#undef jcuda_jcudnn_JCudnn_CUDNN_DIM_MAX
#define jcuda_jcudnn_JCudnn_CUDNN_DIM_MAX 8L
#undef jcuda_jcudnn_JCudnn_CUDNN_BN_MIN_EPSILON
#define jcuda_jcudnn_JCudnn_CUDNN_BN_MIN_EPSILON 1.0E-5
    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    setLogLevelNative
    * Signature: (I)V
    */
    JNIEXPORT void JNICALL Java_jcuda_jcudnn_JCudnn_setLogLevelNative
        (JNIEnv *, jclass, jint);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetVersionNative
    * Signature: ()J
    */
    JNIEXPORT jlong JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetVersionNative
        (JNIEnv *, jclass);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetErrorStringNative
    * Signature: (I)Ljava/lang/String;
    */
    JNIEXPORT jstring JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetErrorStringNative
        (JNIEnv *, jclass, jint);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnCreateNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnCreateNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDestroyNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDestroyNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetStreamNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetStreamNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetStreamNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetStreamNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnCreateTensorDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnTensorDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnCreateTensorDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetTensor4dDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnTensorDescriptor;IIIIII)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetTensor4dDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetTensor4dDescriptorExNative
    * Signature: (Ljcuda/jcudnn/cudnnTensorDescriptor;IIIIIIIII)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetTensor4dDescriptorExNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jint, jint, jint);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetTensor4dDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnTensorDescriptor;[I[I[I[I[I[I[I[I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetTensor4dDescriptorNative
        (JNIEnv *, jclass, jobject, jintArray, jintArray, jintArray, jintArray, jintArray, jintArray, jintArray, jintArray, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetTensorNdDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnTensorDescriptor;II[I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetTensorNdDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jint, jintArray, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetTensorNdDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnTensorDescriptor;I[I[I[I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetTensorNdDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jintArray, jintArray, jintArray, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDestroyTensorDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnTensorDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDestroyTensorDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnTransformTensorNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnTransformTensorNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnAddTensorNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnAddTensorNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnCreateOpTensorDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnOpTensorDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnCreateOpTensorDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetOpTensorDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnOpTensorDescriptor;III)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetOpTensorDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jint, jint);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetOpTensorDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnOpTensorDescriptor;[I[I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetOpTensorDescriptorNative
        (JNIEnv *, jclass, jobject, jintArray, jintArray, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDestroyOpTensorDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnOpTensorDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDestroyOpTensorDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnOpTensorNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnOpTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnOpTensorNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetTensorNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetTensorNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnScaleTensorNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnScaleTensorNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnCreateFilterDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnFilterDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnCreateFilterDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetFilter4dDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnFilterDescriptor;IIIIII)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetFilter4dDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetFilter4dDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnFilterDescriptor;[I[I[I[I[I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetFilter4dDescriptorNative
        (JNIEnv *, jclass, jobject, jintArray, jintArray, jintArray, jintArray, jintArray, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetFilterNdDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnFilterDescriptor;III[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetFilterNdDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetFilterNdDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnFilterDescriptor;I[I[I[I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetFilterNdDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jintArray, jintArray, jintArray, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDestroyFilterDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnFilterDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDestroyFilterDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnCreateConvolutionDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnConvolutionDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnCreateConvolutionDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetConvolution2dDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnConvolutionDescriptor;IIIIIII)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetConvolution2dDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jint);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetConvolution2dDescriptor_v5Native
    * Signature: (Ljcuda/jcudnn/cudnnConvolutionDescriptor;IIIIIIII)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetConvolution2dDescriptor_1v5Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jint, jint);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetConvolution2dDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnConvolutionDescriptor;[I[I[I[I[I[I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetConvolution2dDescriptorNative
        (JNIEnv *, jclass, jobject, jintArray, jintArray, jintArray, jintArray, jintArray, jintArray, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetConvolution2dDescriptor_v5Native
    * Signature: (Ljcuda/jcudnn/cudnnConvolutionDescriptor;[I[I[I[I[I[I[I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetConvolution2dDescriptor_1v5Native
        (JNIEnv *, jclass, jobject, jintArray, jintArray, jintArray, jintArray, jintArray, jintArray, jintArray, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetConvolution2dForwardOutputDimNative
    * Signature: (Ljcuda/jcudnn/cudnnConvolutionDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnFilterDescriptor;[I[I[I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetConvolution2dForwardOutputDimNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jintArray, jintArray, jintArray, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetConvolutionNdDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnConvolutionDescriptor;I[I[I[III)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetConvolutionNdDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jintArray, jintArray, jintArray, jint, jint);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetConvolutionNdDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnConvolutionDescriptor;I[I[I[I[I[I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetConvolutionNdDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jintArray, jintArray, jintArray, jintArray, jintArray, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetConvolutionNdForwardOutputDimNative
    * Signature: (Ljcuda/jcudnn/cudnnConvolutionDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnFilterDescriptor;I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetConvolutionNdForwardOutputDimNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jint, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDestroyConvolutionDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnConvolutionDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDestroyConvolutionDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnFindConvolutionForwardAlgorithmNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/jcudnn/cudnnConvolutionDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;I[I[Ljcuda/jcudnn/cudnnConvolutionFwdAlgoPerf;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnFindConvolutionForwardAlgorithmNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jint, jintArray, jobjectArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnFindConvolutionForwardAlgorithmExNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnConvolutionDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;I[I[Ljcuda/jcudnn/cudnnConvolutionFwdAlgoPerf;Ljcuda/Pointer;J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnFindConvolutionForwardAlgorithmExNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jintArray, jobjectArray, jobject, jlong);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetConvolutionForwardAlgorithmNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/jcudnn/cudnnConvolutionDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;IJ[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetConvolutionForwardAlgorithmNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jint, jlong, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetConvolutionForwardWorkspaceSizeNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/jcudnn/cudnnConvolutionDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;I[J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetConvolutionForwardWorkspaceSizeNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnConvolutionForwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnConvolutionDescriptor;ILjcuda/Pointer;JLjcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnConvolutionForwardNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jlong, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnConvolutionBackwardBiasNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnConvolutionBackwardBiasNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnFindConvolutionBackwardFilterAlgorithmNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnConvolutionDescriptor;Ljcuda/jcudnn/cudnnFilterDescriptor;I[I[Ljcuda/jcudnn/cudnnConvolutionBwdFilterAlgoPerf;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnFindConvolutionBackwardFilterAlgorithmNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jint, jintArray, jobjectArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnFindConvolutionBackwardFilterAlgorithmExNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnConvolutionDescriptor;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/Pointer;I[I[Ljcuda/jcudnn/cudnnConvolutionBwdFilterAlgoPerf;Ljcuda/Pointer;J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnFindConvolutionBackwardFilterAlgorithmExNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jintArray, jobjectArray, jobject, jlong);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetConvolutionBackwardFilterAlgorithmNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnConvolutionDescriptor;Ljcuda/jcudnn/cudnnFilterDescriptor;IJ[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetConvolutionBackwardFilterAlgorithmNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jint, jlong, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetConvolutionBackwardFilterWorkspaceSizeNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnConvolutionDescriptor;Ljcuda/jcudnn/cudnnFilterDescriptor;I[J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetConvolutionBackwardFilterWorkspaceSizeNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnConvolutionBackwardFilterNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnConvolutionDescriptor;ILjcuda/Pointer;JLjcuda/Pointer;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnConvolutionBackwardFilterNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jlong, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnFindConvolutionBackwardDataAlgorithmNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnConvolutionDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;I[I[Ljcuda/jcudnn/cudnnConvolutionBwdDataAlgoPerf;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnFindConvolutionBackwardDataAlgorithmNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jint, jintArray, jobjectArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnFindConvolutionBackwardDataAlgorithmExNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnConvolutionDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;I[I[Ljcuda/jcudnn/cudnnConvolutionBwdDataAlgoPerf;Ljcuda/Pointer;J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnFindConvolutionBackwardDataAlgorithmExNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jintArray, jobjectArray, jobject, jlong);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetConvolutionBackwardDataAlgorithmNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnConvolutionDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;IJ[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetConvolutionBackwardDataAlgorithmNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jint, jlong, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetConvolutionBackwardDataWorkspaceSizeNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnConvolutionDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;I[J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetConvolutionBackwardDataWorkspaceSizeNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnConvolutionBackwardDataNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnConvolutionDescriptor;ILjcuda/Pointer;JLjcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnConvolutionBackwardDataNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jlong, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnIm2ColNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/jcudnn/cudnnConvolutionDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnIm2ColNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSoftmaxForwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;IILjcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSoftmaxForwardNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSoftmaxBackwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;IILjcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSoftmaxBackwardNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnCreatePoolingDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnPoolingDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnCreatePoolingDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetPooling2dDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnPoolingDescriptor;IIIIIIII)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetPooling2dDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jint, jint);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetPooling2dDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnPoolingDescriptor;[I[I[I[I[I[I[I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetPooling2dDescriptorNative
        (JNIEnv *, jclass, jobject, jintArray, jintArray, jintArray, jintArray, jintArray, jintArray, jintArray, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetPoolingNdDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnPoolingDescriptor;III[I[I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetPoolingNdDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jintArray, jintArray, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetPoolingNdDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnPoolingDescriptor;I[I[I[I[I[I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetPoolingNdDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jintArray, jintArray, jintArray, jintArray, jintArray, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetPoolingNdForwardOutputDimNative
    * Signature: (Ljcuda/jcudnn/cudnnPoolingDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetPoolingNdForwardOutputDimNative
        (JNIEnv *, jclass, jobject, jobject, jint, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetPooling2dForwardOutputDimNative
    * Signature: (Ljcuda/jcudnn/cudnnPoolingDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;[I[I[I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetPooling2dForwardOutputDimNative
        (JNIEnv *, jclass, jobject, jobject, jintArray, jintArray, jintArray, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDestroyPoolingDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnPoolingDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDestroyPoolingDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnPoolingForwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnPoolingDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnPoolingForwardNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnPoolingBackwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnPoolingDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnPoolingBackwardNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnCreateActivationDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnActivationDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnCreateActivationDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetActivationDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnActivationDescriptor;IID)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetActivationDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jint, jdouble);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetActivationDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnActivationDescriptor;[I[I[D)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetActivationDescriptorNative
        (JNIEnv *, jclass, jobject, jintArray, jintArray, jdoubleArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDestroyActivationDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnActivationDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDestroyActivationDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnActivationForwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnActivationDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnActivationForwardNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnActivationBackwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnActivationDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnActivationBackwardNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnCreateLRNDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnLRNDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnCreateLRNDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetLRNDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnLRNDescriptor;IDDD)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetLRNDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jdouble, jdouble, jdouble);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetLRNDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnLRNDescriptor;[I[D[D[D)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetLRNDescriptorNative
        (JNIEnv *, jclass, jobject, jintArray, jdoubleArray, jdoubleArray, jdoubleArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDestroyLRNDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnLRNDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDestroyLRNDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnLRNCrossChannelForwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnLRNDescriptor;ILjcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnLRNCrossChannelForwardNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnLRNCrossChannelBackwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnLRNDescriptor;ILjcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnLRNCrossChannelBackwardNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDivisiveNormalizationForwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnLRNDescriptor;ILjcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDivisiveNormalizationForwardNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDivisiveNormalizationBackwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnLRNDescriptor;ILjcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDivisiveNormalizationBackwardNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDeriveBNTensorDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDeriveBNTensorDescriptorNative
        (JNIEnv *, jclass, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnBatchNormalizationForwardTrainingNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;DLjcuda/Pointer;Ljcuda/Pointer;DLjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnBatchNormalizationForwardTrainingNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jdouble, jobject, jobject, jdouble, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnBatchNormalizationForwardInferenceNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;D)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnBatchNormalizationForwardInferenceNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jdouble);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnBatchNormalizationBackwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;DLjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnBatchNormalizationBackwardNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jdouble, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnCreateSpatialTransformerDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnSpatialTransformerDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnCreateSpatialTransformerDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetSpatialTransformerNdDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnSpatialTransformerDescriptor;III[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetSpatialTransformerNdDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDestroySpatialTransformerDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnSpatialTransformerDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDestroySpatialTransformerDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSpatialTfGridGeneratorForwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnSpatialTransformerDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSpatialTfGridGeneratorForwardNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSpatialTfGridGeneratorBackwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnSpatialTransformerDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSpatialTfGridGeneratorBackwardNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSpatialTfSamplerForwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnSpatialTransformerDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSpatialTfSamplerForwardNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSpatialTfSamplerBackwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnSpatialTransformerDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSpatialTfSamplerBackwardNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnCreateDropoutDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnDropoutDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnCreateDropoutDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDestroyDropoutDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnDropoutDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDestroyDropoutDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDropoutGetStatesSizeNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;[J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDropoutGetStatesSizeNative
        (JNIEnv *, jclass, jobject, jlongArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDropoutGetReserveSpaceSizeNative
    * Signature: (Ljcuda/jcudnn/cudnnTensorDescriptor;[J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDropoutGetReserveSpaceSizeNative
        (JNIEnv *, jclass, jobject, jlongArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetDropoutDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnDropoutDescriptor;Ljcuda/jcudnn/cudnnHandle;FLjcuda/Pointer;JJ)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetDropoutDescriptorNative
        (JNIEnv *, jclass, jobject, jobject, jfloat, jobject, jlong, jlong);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDropoutForwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnDropoutDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDropoutForwardNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jlong);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDropoutBackwardNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnDropoutDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDropoutBackwardNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jlong);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnCreateRNNDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnRNNDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnCreateRNNDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnDestroyRNNDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnRNNDescriptor;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnDestroyRNNDescriptorNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnSetRNNDescriptorNative
    * Signature: (Ljcuda/jcudnn/cudnnRNNDescriptor;IILjcuda/jcudnn/cudnnDropoutDescriptor;IIII)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnSetRNNDescriptorNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jint, jint, jint, jint);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetRNNWorkspaceSizeNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnRNNDescriptor;ILjcuda/jcudnn/cudnnTensorDescriptor;[J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetRNNWorkspaceSizeNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jlongArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetRNNTrainingReserveSizeNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnRNNDescriptor;ILjcuda/jcudnn/cudnnTensorDescriptor;[J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetRNNTrainingReserveSizeNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jlongArray);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetRNNParamsSizeNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnRNNDescriptor;Ljcuda/jcudnn/cudnnTensorDescriptor;[JI)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetRNNParamsSizeNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jlongArray, jint);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetRNNLinLayerMatrixParamsNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnRNNDescriptor;ILjcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/Pointer;ILjcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetRNNLinLayerMatrixParamsNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnGetRNNLinLayerBiasParamsNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnRNNDescriptor;ILjcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/Pointer;ILjcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnGetRNNLinLayerBiasParamsNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnRNNForwardInferenceNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnRNNDescriptor;ILjcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnRNNForwardInferenceNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jlong);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnRNNForwardTrainingNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnRNNDescriptor;ILjcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;JLjcuda/Pointer;J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnRNNForwardTrainingNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jlong, jobject, jlong);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnRNNBackwardDataNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnRNNDescriptor;ILjcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;JLjcuda/Pointer;J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnRNNBackwardDataNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jlong, jobject, jlong);

    /*
    * Class:     jcuda_jcudnn_JCudnn
    * Method:    cudnnRNNBackwardWeightsNative
    * Signature: (Ljcuda/jcudnn/cudnnHandle;Ljcuda/jcudnn/cudnnRNNDescriptor;ILjcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/jcudnn/cudnnTensorDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;JLjcuda/jcudnn/cudnnFilterDescriptor;Ljcuda/Pointer;Ljcuda/Pointer;J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcudnn_JCudnn_cudnnRNNBackwardWeightsNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jlong, jobject, jobject, jobject, jlong);

#ifdef __cplusplus
}
#endif
#endif
