/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcudnn;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.jcudnn.cudnnActivationDescriptor;
import jcuda.jcudnn.cudnnConvolutionBwdDataAlgoPerf;
import jcuda.jcudnn.cudnnConvolutionBwdFilterAlgoPerf;
import jcuda.jcudnn.cudnnConvolutionDescriptor;
import jcuda.jcudnn.cudnnConvolutionFwdAlgoPerf;
import jcuda.jcudnn.cudnnDropoutDescriptor;
import jcuda.jcudnn.cudnnFilterDescriptor;
import jcuda.jcudnn.cudnnHandle;
import jcuda.jcudnn.cudnnLRNDescriptor;
import jcuda.jcudnn.cudnnOpTensorDescriptor;
import jcuda.jcudnn.cudnnPoolingDescriptor;
import jcuda.jcudnn.cudnnRNNDescriptor;
import jcuda.jcudnn.cudnnSpatialTransformerDescriptor;
import jcuda.jcudnn.cudnnStatus;
import jcuda.jcudnn.cudnnTensorDescriptor;
import jcuda.runtime.JCuda;
import jcuda.runtime.cudaStream_t;

public class JCudnn {
    public static final int CUDNN_MAJOR = 5;
    public static final int CUDNN_MINOR = 1;
    public static final int CUDNN_PATCHLEVEL = 5;
    public static final int CUDNN_VERSION = 5105;
    public static final int CUDNN_DIM_MAX = 8;
    public static final double CUDNN_BN_MIN_EPSILON = 1.0E-5;
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    private JCudnn() {
    }

    public static void initialize() {
        if (!initialized) {
            String libraryBaseName = "JCudnn-" + JCuda.getJCudaVersion();
            String libraryName = LibUtils.createPlatformLibraryName((String)libraryBaseName);
            LibUtils.loadLibrary((String)libraryName, (String[])new String[0]);
            initialized = true;
        }
    }

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(cudnnStatus.stringFor(result));
        }
        return result;
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCudnn.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    public static long cudnnGetVersion() {
        return JCudnn.cudnnGetVersionNative();
    }

    private static native long cudnnGetVersionNative();

    public static String cudnnGetErrorString(int status) {
        return JCudnn.cudnnGetErrorStringNative(status);
    }

    private static native String cudnnGetErrorStringNative(int var0);

    public static int cudnnCreate(cudnnHandle handle) {
        return JCudnn.checkResult(JCudnn.cudnnCreateNative(handle));
    }

    private static native int cudnnCreateNative(cudnnHandle var0);

    public static int cudnnDestroy(cudnnHandle handle) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyNative(handle));
    }

    private static native int cudnnDestroyNative(cudnnHandle var0);

    public static int cudnnSetStream(cudnnHandle handle, cudaStream_t streamId) {
        return JCudnn.checkResult(JCudnn.cudnnSetStreamNative(handle, streamId));
    }

    private static native int cudnnSetStreamNative(cudnnHandle var0, cudaStream_t var1);

    public static int cudnnGetStream(cudnnHandle handle, cudaStream_t streamId) {
        return JCudnn.checkResult(JCudnn.cudnnGetStreamNative(handle, streamId));
    }

    private static native int cudnnGetStreamNative(cudnnHandle var0, cudaStream_t var1);

    public static int cudnnCreateTensorDescriptor(cudnnTensorDescriptor tensorDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateTensorDescriptorNative(tensorDesc));
    }

    private static native int cudnnCreateTensorDescriptorNative(cudnnTensorDescriptor var0);

    public static int cudnnSetTensor4dDescriptor(cudnnTensorDescriptor tensorDesc, int format, int dataType, int n, int c, int h, int w) {
        return JCudnn.checkResult(JCudnn.cudnnSetTensor4dDescriptorNative(tensorDesc, format, dataType, n, c, h, w));
    }

    private static native int cudnnSetTensor4dDescriptorNative(cudnnTensorDescriptor var0, int var1, int var2, int var3, int var4, int var5, int var6);

    public static int cudnnSetTensor4dDescriptorEx(cudnnTensorDescriptor tensorDesc, int dataType, int n, int c, int h, int w, int nStride, int cStride, int hStride, int wStride) {
        return JCudnn.checkResult(JCudnn.cudnnSetTensor4dDescriptorExNative(tensorDesc, dataType, n, c, h, w, nStride, cStride, hStride, wStride));
    }

    private static native int cudnnSetTensor4dDescriptorExNative(cudnnTensorDescriptor var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public static int cudnnGetTensor4dDescriptor(cudnnTensorDescriptor tensorDesc, int[] dataType, int[] n, int[] c, int[] h, int[] w, int[] nStride, int[] cStride, int[] hStride, int[] wStride) {
        return JCudnn.checkResult(JCudnn.cudnnGetTensor4dDescriptorNative(tensorDesc, dataType, n, c, h, w, nStride, cStride, hStride, wStride));
    }

    private static native int cudnnGetTensor4dDescriptorNative(cudnnTensorDescriptor var0, int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9);

    public static int cudnnSetTensorNdDescriptor(cudnnTensorDescriptor tensorDesc, int dataType, int nbDims, int[] dimA, int[] strideA) {
        return JCudnn.checkResult(JCudnn.cudnnSetTensorNdDescriptorNative(tensorDesc, dataType, nbDims, dimA, strideA));
    }

    private static native int cudnnSetTensorNdDescriptorNative(cudnnTensorDescriptor var0, int var1, int var2, int[] var3, int[] var4);

    public static int cudnnGetTensorNdDescriptor(cudnnTensorDescriptor tensorDesc, int nbDimsRequested, int[] dataType, int[] nbDims, int[] dimA, int[] strideA) {
        return JCudnn.checkResult(JCudnn.cudnnGetTensorNdDescriptorNative(tensorDesc, nbDimsRequested, dataType, nbDims, dimA, strideA));
    }

    private static native int cudnnGetTensorNdDescriptorNative(cudnnTensorDescriptor var0, int var1, int[] var2, int[] var3, int[] var4, int[] var5);

    public static int cudnnDestroyTensorDescriptor(cudnnTensorDescriptor tensorDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyTensorDescriptorNative(tensorDesc));
    }

    private static native int cudnnDestroyTensorDescriptorNative(cudnnTensorDescriptor var0);

    public static int cudnnTransformTensor(cudnnHandle handle, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnTransformTensorNative(handle, alpha, xDesc, x, beta, yDesc, y));
    }

    private static native int cudnnTransformTensorNative(cudnnHandle var0, Pointer var1, cudnnTensorDescriptor var2, Pointer var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6);

    public static int cudnnAddTensor(cudnnHandle handle, Pointer alpha, cudnnTensorDescriptor aDesc, Pointer A, Pointer beta, cudnnTensorDescriptor cDesc, Pointer C) {
        return JCudnn.checkResult(JCudnn.cudnnAddTensorNative(handle, alpha, aDesc, A, beta, cDesc, C));
    }

    private static native int cudnnAddTensorNative(cudnnHandle var0, Pointer var1, cudnnTensorDescriptor var2, Pointer var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6);

    public static int cudnnCreateOpTensorDescriptor(cudnnOpTensorDescriptor opTensorDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateOpTensorDescriptorNative(opTensorDesc));
    }

    private static native int cudnnCreateOpTensorDescriptorNative(cudnnOpTensorDescriptor var0);

    public static int cudnnSetOpTensorDescriptor(cudnnOpTensorDescriptor opTensorDesc, int opTensorOp, int opTensorCompType, int opTensorNanOpt) {
        return JCudnn.checkResult(JCudnn.cudnnSetOpTensorDescriptorNative(opTensorDesc, opTensorOp, opTensorCompType, opTensorNanOpt));
    }

    private static native int cudnnSetOpTensorDescriptorNative(cudnnOpTensorDescriptor var0, int var1, int var2, int var3);

    public static int cudnnGetOpTensorDescriptor(cudnnOpTensorDescriptor opTensorDesc, int[] opTensorOp, int[] opTensorCompType, int[] opTensorNanOpt) {
        return JCudnn.checkResult(JCudnn.cudnnGetOpTensorDescriptorNative(opTensorDesc, opTensorOp, opTensorCompType, opTensorNanOpt));
    }

    private static native int cudnnGetOpTensorDescriptorNative(cudnnOpTensorDescriptor var0, int[] var1, int[] var2, int[] var3);

    public static int cudnnDestroyOpTensorDescriptor(cudnnOpTensorDescriptor opTensorDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyOpTensorDescriptorNative(opTensorDesc));
    }

    private static native int cudnnDestroyOpTensorDescriptorNative(cudnnOpTensorDescriptor var0);

    public static int cudnnOpTensor(cudnnHandle handle, cudnnOpTensorDescriptor opTensorDesc, Pointer alpha1, cudnnTensorDescriptor aDesc, Pointer A, Pointer alpha2, cudnnTensorDescriptor bDesc, Pointer B, Pointer beta, cudnnTensorDescriptor cDesc, Pointer C) {
        return JCudnn.checkResult(JCudnn.cudnnOpTensorNative(handle, opTensorDesc, alpha1, aDesc, A, alpha2, bDesc, B, beta, cDesc, C));
    }

    private static native int cudnnOpTensorNative(cudnnHandle var0, cudnnOpTensorDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, Pointer var8, cudnnTensorDescriptor var9, Pointer var10);

    public static int cudnnSetTensor(cudnnHandle handle, cudnnTensorDescriptor yDesc, Pointer y, Pointer valuePtr) {
        return JCudnn.checkResult(JCudnn.cudnnSetTensorNative(handle, yDesc, y, valuePtr));
    }

    private static native int cudnnSetTensorNative(cudnnHandle var0, cudnnTensorDescriptor var1, Pointer var2, Pointer var3);

    public static int cudnnScaleTensor(cudnnHandle handle, cudnnTensorDescriptor yDesc, Pointer y, Pointer alpha) {
        return JCudnn.checkResult(JCudnn.cudnnScaleTensorNative(handle, yDesc, y, alpha));
    }

    private static native int cudnnScaleTensorNative(cudnnHandle var0, cudnnTensorDescriptor var1, Pointer var2, Pointer var3);

    public static int cudnnCreateFilterDescriptor(cudnnFilterDescriptor filterDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateFilterDescriptorNative(filterDesc));
    }

    private static native int cudnnCreateFilterDescriptorNative(cudnnFilterDescriptor var0);

    public static int cudnnSetFilter4dDescriptor(cudnnFilterDescriptor filterDesc, int dataType, int format, int k, int c, int h, int w) {
        return JCudnn.checkResult(JCudnn.cudnnSetFilter4dDescriptorNative(filterDesc, dataType, format, k, c, h, w));
    }

    private static native int cudnnSetFilter4dDescriptorNative(cudnnFilterDescriptor var0, int var1, int var2, int var3, int var4, int var5, int var6);

    public static int cudnnGetFilter4dDescriptor(cudnnFilterDescriptor filterDesc, int[] dataType, int[] format, int[] k, int[] c, int[] h, int[] w) {
        return JCudnn.checkResult(JCudnn.cudnnGetFilter4dDescriptorNative(filterDesc, dataType, format, k, c, h, w));
    }

    private static native int cudnnGetFilter4dDescriptorNative(cudnnFilterDescriptor var0, int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6);

    public static int cudnnSetFilterNdDescriptor(cudnnFilterDescriptor filterDesc, int dataType, int format, int nbDims, int[] filterDimA) {
        return JCudnn.checkResult(JCudnn.cudnnSetFilterNdDescriptorNative(filterDesc, dataType, format, nbDims, filterDimA));
    }

    private static native int cudnnSetFilterNdDescriptorNative(cudnnFilterDescriptor var0, int var1, int var2, int var3, int[] var4);

    public static int cudnnGetFilterNdDescriptor(cudnnFilterDescriptor filterDesc, int nbDimsRequested, int[] dataType, int[] format, int[] nbDims, int[] filterDimA) {
        return JCudnn.checkResult(JCudnn.cudnnGetFilterNdDescriptorNative(filterDesc, nbDimsRequested, dataType, format, nbDims, filterDimA));
    }

    private static native int cudnnGetFilterNdDescriptorNative(cudnnFilterDescriptor var0, int var1, int[] var2, int[] var3, int[] var4, int[] var5);

    public static int cudnnDestroyFilterDescriptor(cudnnFilterDescriptor filterDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyFilterDescriptorNative(filterDesc));
    }

    private static native int cudnnDestroyFilterDescriptorNative(cudnnFilterDescriptor var0);

    public static int cudnnCreateConvolutionDescriptor(cudnnConvolutionDescriptor convDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateConvolutionDescriptorNative(convDesc));
    }

    private static native int cudnnCreateConvolutionDescriptorNative(cudnnConvolutionDescriptor var0);

    public static int cudnnSetConvolution2dDescriptor(cudnnConvolutionDescriptor convDesc, int pad_h, int pad_w, int u, int v, int upscalex, int upscaley, int mode) {
        return JCudnn.checkResult(JCudnn.cudnnSetConvolution2dDescriptorNative(convDesc, pad_h, pad_w, u, v, upscalex, upscaley, mode));
    }

    private static native int cudnnSetConvolution2dDescriptorNative(cudnnConvolutionDescriptor var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static int cudnnSetConvolution2dDescriptor_v5(cudnnConvolutionDescriptor convDesc, int pad_h, int pad_w, int u, int v, int upscalex, int upscaley, int mode, int dataType) {
        return JCudnn.checkResult(JCudnn.cudnnSetConvolution2dDescriptor_v5Native(convDesc, pad_h, pad_w, u, v, upscalex, upscaley, mode, dataType));
    }

    private static native int cudnnSetConvolution2dDescriptor_v5Native(cudnnConvolutionDescriptor var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static int cudnnGetConvolution2dDescriptor(cudnnConvolutionDescriptor convDesc, int[] pad_h, int[] pad_w, int[] u, int[] v, int[] upscalex, int[] upscaley, int[] mode) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolution2dDescriptorNative(convDesc, pad_h, pad_w, u, v, upscalex, upscaley, mode));
    }

    private static native int cudnnGetConvolution2dDescriptorNative(cudnnConvolutionDescriptor var0, int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7);

    public static int cudnnGetConvolution2dDescriptor_v5(cudnnConvolutionDescriptor convDesc, int[] pad_h, int[] pad_w, int[] u, int[] v, int[] upscalex, int[] upscaley, int[] mode, int[] dataType) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolution2dDescriptor_v5Native(convDesc, pad_h, pad_w, u, v, upscalex, upscaley, mode, dataType));
    }

    private static native int cudnnGetConvolution2dDescriptor_v5Native(cudnnConvolutionDescriptor var0, int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    public static int cudnnGetConvolution2dForwardOutputDim(cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor inputTensorDesc, cudnnFilterDescriptor filterDesc, int[] n, int[] c, int[] h, int[] w) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolution2dForwardOutputDimNative(convDesc, inputTensorDesc, filterDesc, n, c, h, w));
    }

    private static native int cudnnGetConvolution2dForwardOutputDimNative(cudnnConvolutionDescriptor var0, cudnnTensorDescriptor var1, cudnnFilterDescriptor var2, int[] var3, int[] var4, int[] var5, int[] var6);

    public static int cudnnSetConvolutionNdDescriptor(cudnnConvolutionDescriptor convDesc, int arrayLength, int[] padA, int[] filterStrideA, int[] upscaleA, int mode, int dataType) {
        return JCudnn.checkResult(JCudnn.cudnnSetConvolutionNdDescriptorNative(convDesc, arrayLength, padA, filterStrideA, upscaleA, mode, dataType));
    }

    private static native int cudnnSetConvolutionNdDescriptorNative(cudnnConvolutionDescriptor var0, int var1, int[] var2, int[] var3, int[] var4, int var5, int var6);

    public static int cudnnGetConvolutionNdDescriptor(cudnnConvolutionDescriptor convDesc, int arrayLengthRequested, int[] arrayLength, int[] padA, int[] strideA, int[] upscaleA, int[] mode, int[] dataType) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionNdDescriptorNative(convDesc, arrayLengthRequested, arrayLength, padA, strideA, upscaleA, mode, dataType));
    }

    private static native int cudnnGetConvolutionNdDescriptorNative(cudnnConvolutionDescriptor var0, int var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7);

    public static int cudnnGetConvolutionNdForwardOutputDim(cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor inputTensorDesc, cudnnFilterDescriptor filterDesc, int nbDims, int[] tensorOuputDimA) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionNdForwardOutputDimNative(convDesc, inputTensorDesc, filterDesc, nbDims, tensorOuputDimA));
    }

    private static native int cudnnGetConvolutionNdForwardOutputDimNative(cudnnConvolutionDescriptor var0, cudnnTensorDescriptor var1, cudnnFilterDescriptor var2, int var3, int[] var4);

    public static int cudnnDestroyConvolutionDescriptor(cudnnConvolutionDescriptor convDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyConvolutionDescriptorNative(convDesc));
    }

    private static native int cudnnDestroyConvolutionDescriptorNative(cudnnConvolutionDescriptor var0);

    public static int cudnnFindConvolutionForwardAlgorithm(cudnnHandle handle, cudnnTensorDescriptor xDesc, cudnnFilterDescriptor wDesc, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor yDesc, int requestedAlgoCount, int[] returnedAlgoCount, cudnnConvolutionFwdAlgoPerf[] perfResults) {
        return JCudnn.checkResult(JCudnn.cudnnFindConvolutionForwardAlgorithmNative(handle, xDesc, wDesc, convDesc, yDesc, requestedAlgoCount, returnedAlgoCount, perfResults));
    }

    private static native int cudnnFindConvolutionForwardAlgorithmNative(cudnnHandle var0, cudnnTensorDescriptor var1, cudnnFilterDescriptor var2, cudnnConvolutionDescriptor var3, cudnnTensorDescriptor var4, int var5, int[] var6, cudnnConvolutionFwdAlgoPerf[] var7);

    public static int cudnnFindConvolutionForwardAlgorithmEx(cudnnHandle handle, cudnnTensorDescriptor xDesc, Pointer x, cudnnFilterDescriptor wDesc, Pointer w, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor yDesc, Pointer y, int requestedAlgoCount, int[] returnedAlgoCount, cudnnConvolutionFwdAlgoPerf[] perfResults, Pointer workSpace, long workSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnFindConvolutionForwardAlgorithmExNative(handle, xDesc, x, wDesc, w, convDesc, yDesc, y, requestedAlgoCount, returnedAlgoCount, perfResults, workSpace, workSpaceSizeInBytes));
    }

    private static native int cudnnFindConvolutionForwardAlgorithmExNative(cudnnHandle var0, cudnnTensorDescriptor var1, Pointer var2, cudnnFilterDescriptor var3, Pointer var4, cudnnConvolutionDescriptor var5, cudnnTensorDescriptor var6, Pointer var7, int var8, int[] var9, cudnnConvolutionFwdAlgoPerf[] var10, Pointer var11, long var12);

    public static int cudnnGetConvolutionForwardAlgorithm(cudnnHandle handle, cudnnTensorDescriptor xDesc, cudnnFilterDescriptor wDesc, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor yDesc, int preference, long memoryLimitInBytes, int[] algo) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionForwardAlgorithmNative(handle, xDesc, wDesc, convDesc, yDesc, preference, memoryLimitInBytes, algo));
    }

    private static native int cudnnGetConvolutionForwardAlgorithmNative(cudnnHandle var0, cudnnTensorDescriptor var1, cudnnFilterDescriptor var2, cudnnConvolutionDescriptor var3, cudnnTensorDescriptor var4, int var5, long var6, int[] var8);

    public static int cudnnGetConvolutionForwardWorkspaceSize(cudnnHandle handle, cudnnTensorDescriptor xDesc, cudnnFilterDescriptor wDesc, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor yDesc, int algo, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionForwardWorkspaceSizeNative(handle, xDesc, wDesc, convDesc, yDesc, algo, sizeInBytes));
    }

    private static native int cudnnGetConvolutionForwardWorkspaceSizeNative(cudnnHandle var0, cudnnTensorDescriptor var1, cudnnFilterDescriptor var2, cudnnConvolutionDescriptor var3, cudnnTensorDescriptor var4, int var5, long[] var6);

    public static int cudnnConvolutionForward(cudnnHandle handle, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, cudnnFilterDescriptor wDesc, Pointer w, cudnnConvolutionDescriptor convDesc, int algo, Pointer workSpace, long workSpaceSizeInBytes, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnConvolutionForwardNative(handle, alpha, xDesc, x, wDesc, w, convDesc, algo, workSpace, workSpaceSizeInBytes, beta, yDesc, y));
    }

    private static native int cudnnConvolutionForwardNative(cudnnHandle var0, Pointer var1, cudnnTensorDescriptor var2, Pointer var3, cudnnFilterDescriptor var4, Pointer var5, cudnnConvolutionDescriptor var6, int var7, Pointer var8, long var9, Pointer var11, cudnnTensorDescriptor var12, Pointer var13);

    public static int cudnnConvolutionBackwardBias(cudnnHandle handle, Pointer alpha, cudnnTensorDescriptor dyDesc, Pointer dy, Pointer beta, cudnnTensorDescriptor dbDesc, Pointer db) {
        return JCudnn.checkResult(JCudnn.cudnnConvolutionBackwardBiasNative(handle, alpha, dyDesc, dy, beta, dbDesc, db));
    }

    private static native int cudnnConvolutionBackwardBiasNative(cudnnHandle var0, Pointer var1, cudnnTensorDescriptor var2, Pointer var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6);

    public static int cudnnFindConvolutionBackwardFilterAlgorithm(cudnnHandle handle, cudnnTensorDescriptor xDesc, cudnnTensorDescriptor dyDesc, cudnnConvolutionDescriptor convDesc, cudnnFilterDescriptor dwDesc, int requestedAlgoCount, int[] returnedAlgoCount, cudnnConvolutionBwdFilterAlgoPerf[] perfResults) {
        return JCudnn.checkResult(JCudnn.cudnnFindConvolutionBackwardFilterAlgorithmNative(handle, xDesc, dyDesc, convDesc, dwDesc, requestedAlgoCount, returnedAlgoCount, perfResults));
    }

    private static native int cudnnFindConvolutionBackwardFilterAlgorithmNative(cudnnHandle var0, cudnnTensorDescriptor var1, cudnnTensorDescriptor var2, cudnnConvolutionDescriptor var3, cudnnFilterDescriptor var4, int var5, int[] var6, cudnnConvolutionBwdFilterAlgoPerf[] var7);

    public static int cudnnFindConvolutionBackwardFilterAlgorithmEx(cudnnHandle handle, cudnnTensorDescriptor xDesc, Pointer x, cudnnTensorDescriptor dyDesc, Pointer y, cudnnConvolutionDescriptor convDesc, cudnnFilterDescriptor dwDesc, Pointer dw, int requestedAlgoCount, int[] returnedAlgoCount, cudnnConvolutionBwdFilterAlgoPerf[] perfResults, Pointer workSpace, long workSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnFindConvolutionBackwardFilterAlgorithmExNative(handle, xDesc, x, dyDesc, y, convDesc, dwDesc, dw, requestedAlgoCount, returnedAlgoCount, perfResults, workSpace, workSpaceSizeInBytes));
    }

    private static native int cudnnFindConvolutionBackwardFilterAlgorithmExNative(cudnnHandle var0, cudnnTensorDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, cudnnConvolutionDescriptor var5, cudnnFilterDescriptor var6, Pointer var7, int var8, int[] var9, cudnnConvolutionBwdFilterAlgoPerf[] var10, Pointer var11, long var12);

    public static int cudnnGetConvolutionBackwardFilterAlgorithm(cudnnHandle handle, cudnnTensorDescriptor xDesc, cudnnTensorDescriptor dyDesc, cudnnConvolutionDescriptor convDesc, cudnnFilterDescriptor dwDesc, int preference, long memoryLimitInBytes, int[] algo) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionBackwardFilterAlgorithmNative(handle, xDesc, dyDesc, convDesc, dwDesc, preference, memoryLimitInBytes, algo));
    }

    private static native int cudnnGetConvolutionBackwardFilterAlgorithmNative(cudnnHandle var0, cudnnTensorDescriptor var1, cudnnTensorDescriptor var2, cudnnConvolutionDescriptor var3, cudnnFilterDescriptor var4, int var5, long var6, int[] var8);

    public static int cudnnGetConvolutionBackwardFilterWorkspaceSize(cudnnHandle handle, cudnnTensorDescriptor xDesc, cudnnTensorDescriptor dyDesc, cudnnConvolutionDescriptor convDesc, cudnnFilterDescriptor gradDesc, int algo, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionBackwardFilterWorkspaceSizeNative(handle, xDesc, dyDesc, convDesc, gradDesc, algo, sizeInBytes));
    }

    private static native int cudnnGetConvolutionBackwardFilterWorkspaceSizeNative(cudnnHandle var0, cudnnTensorDescriptor var1, cudnnTensorDescriptor var2, cudnnConvolutionDescriptor var3, cudnnFilterDescriptor var4, int var5, long[] var6);

    public static int cudnnConvolutionBackwardFilter(cudnnHandle handle, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, cudnnTensorDescriptor dyDesc, Pointer dy, cudnnConvolutionDescriptor convDesc, int algo, Pointer workSpace, long workSpaceSizeInBytes, Pointer beta, cudnnFilterDescriptor dwDesc, Pointer dw) {
        return JCudnn.checkResult(JCudnn.cudnnConvolutionBackwardFilterNative(handle, alpha, xDesc, x, dyDesc, dy, convDesc, algo, workSpace, workSpaceSizeInBytes, beta, dwDesc, dw));
    }

    private static native int cudnnConvolutionBackwardFilterNative(cudnnHandle var0, Pointer var1, cudnnTensorDescriptor var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, cudnnConvolutionDescriptor var6, int var7, Pointer var8, long var9, Pointer var11, cudnnFilterDescriptor var12, Pointer var13);

    public static int cudnnFindConvolutionBackwardDataAlgorithm(cudnnHandle handle, cudnnFilterDescriptor wDesc, cudnnTensorDescriptor dyDesc, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor dxDesc, int requestedAlgoCount, int[] returnedAlgoCount, cudnnConvolutionBwdDataAlgoPerf[] perfResults) {
        return JCudnn.checkResult(JCudnn.cudnnFindConvolutionBackwardDataAlgorithmNative(handle, wDesc, dyDesc, convDesc, dxDesc, requestedAlgoCount, returnedAlgoCount, perfResults));
    }

    private static native int cudnnFindConvolutionBackwardDataAlgorithmNative(cudnnHandle var0, cudnnFilterDescriptor var1, cudnnTensorDescriptor var2, cudnnConvolutionDescriptor var3, cudnnTensorDescriptor var4, int var5, int[] var6, cudnnConvolutionBwdDataAlgoPerf[] var7);

    public static int cudnnFindConvolutionBackwardDataAlgorithmEx(cudnnHandle handle, cudnnFilterDescriptor wDesc, Pointer w, cudnnTensorDescriptor dyDesc, Pointer dy, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor dxDesc, Pointer dx, int requestedAlgoCount, int[] returnedAlgoCount, cudnnConvolutionBwdDataAlgoPerf[] perfResults, Pointer workSpace, long workSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnFindConvolutionBackwardDataAlgorithmExNative(handle, wDesc, w, dyDesc, dy, convDesc, dxDesc, dx, requestedAlgoCount, returnedAlgoCount, perfResults, workSpace, workSpaceSizeInBytes));
    }

    private static native int cudnnFindConvolutionBackwardDataAlgorithmExNative(cudnnHandle var0, cudnnFilterDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, cudnnConvolutionDescriptor var5, cudnnTensorDescriptor var6, Pointer var7, int var8, int[] var9, cudnnConvolutionBwdDataAlgoPerf[] var10, Pointer var11, long var12);

    public static int cudnnGetConvolutionBackwardDataAlgorithm(cudnnHandle handle, cudnnFilterDescriptor wDesc, cudnnTensorDescriptor dyDesc, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor dxDesc, int preference, long memoryLimitInBytes, int[] algo) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionBackwardDataAlgorithmNative(handle, wDesc, dyDesc, convDesc, dxDesc, preference, memoryLimitInBytes, algo));
    }

    private static native int cudnnGetConvolutionBackwardDataAlgorithmNative(cudnnHandle var0, cudnnFilterDescriptor var1, cudnnTensorDescriptor var2, cudnnConvolutionDescriptor var3, cudnnTensorDescriptor var4, int var5, long var6, int[] var8);

    public static int cudnnGetConvolutionBackwardDataWorkspaceSize(cudnnHandle handle, cudnnFilterDescriptor wDesc, cudnnTensorDescriptor dyDesc, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor dxDesc, int algo, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionBackwardDataWorkspaceSizeNative(handle, wDesc, dyDesc, convDesc, dxDesc, algo, sizeInBytes));
    }

    private static native int cudnnGetConvolutionBackwardDataWorkspaceSizeNative(cudnnHandle var0, cudnnFilterDescriptor var1, cudnnTensorDescriptor var2, cudnnConvolutionDescriptor var3, cudnnTensorDescriptor var4, int var5, long[] var6);

    public static int cudnnConvolutionBackwardData(cudnnHandle handle, Pointer alpha, cudnnFilterDescriptor wDesc, Pointer w, cudnnTensorDescriptor dyDesc, Pointer dy, cudnnConvolutionDescriptor convDesc, int algo, Pointer workSpace, long workSpaceSizeInBytes, Pointer beta, cudnnTensorDescriptor dxDesc, Pointer dx) {
        return JCudnn.checkResult(JCudnn.cudnnConvolutionBackwardDataNative(handle, alpha, wDesc, w, dyDesc, dy, convDesc, algo, workSpace, workSpaceSizeInBytes, beta, dxDesc, dx));
    }

    private static native int cudnnConvolutionBackwardDataNative(cudnnHandle var0, Pointer var1, cudnnFilterDescriptor var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, cudnnConvolutionDescriptor var6, int var7, Pointer var8, long var9, Pointer var11, cudnnTensorDescriptor var12, Pointer var13);

    public static int cudnnIm2Col(cudnnHandle handle, cudnnTensorDescriptor xDesc, Pointer x, cudnnFilterDescriptor wDesc, cudnnConvolutionDescriptor convDesc, Pointer colBuffer) {
        return JCudnn.checkResult(JCudnn.cudnnIm2ColNative(handle, xDesc, x, wDesc, convDesc, colBuffer));
    }

    private static native int cudnnIm2ColNative(cudnnHandle var0, cudnnTensorDescriptor var1, Pointer var2, cudnnFilterDescriptor var3, cudnnConvolutionDescriptor var4, Pointer var5);

    public static int cudnnSoftmaxForward(cudnnHandle handle, int algo, int mode, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnSoftmaxForwardNative(handle, algo, mode, alpha, xDesc, x, beta, yDesc, y));
    }

    private static native int cudnnSoftmaxForwardNative(cudnnHandle var0, int var1, int var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8);

    public static int cudnnSoftmaxBackward(cudnnHandle handle, int algo, int mode, Pointer alpha, cudnnTensorDescriptor yDesc, Pointer y, cudnnTensorDescriptor dyDesc, Pointer dy, Pointer beta, cudnnTensorDescriptor dxDesc, Pointer dx) {
        return JCudnn.checkResult(JCudnn.cudnnSoftmaxBackwardNative(handle, algo, mode, alpha, yDesc, y, dyDesc, dy, beta, dxDesc, dx));
    }

    private static native int cudnnSoftmaxBackwardNative(cudnnHandle var0, int var1, int var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, Pointer var8, cudnnTensorDescriptor var9, Pointer var10);

    public static int cudnnCreatePoolingDescriptor(cudnnPoolingDescriptor poolingDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreatePoolingDescriptorNative(poolingDesc));
    }

    private static native int cudnnCreatePoolingDescriptorNative(cudnnPoolingDescriptor var0);

    public static int cudnnSetPooling2dDescriptor(cudnnPoolingDescriptor poolingDesc, int mode, int maxpoolingNanOpt, int windowHeight, int windowWidth, int verticalPadding, int horizontalPadding, int verticalStride, int horizontalStride) {
        return JCudnn.checkResult(JCudnn.cudnnSetPooling2dDescriptorNative(poolingDesc, mode, maxpoolingNanOpt, windowHeight, windowWidth, verticalPadding, horizontalPadding, verticalStride, horizontalStride));
    }

    private static native int cudnnSetPooling2dDescriptorNative(cudnnPoolingDescriptor var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static int cudnnGetPooling2dDescriptor(cudnnPoolingDescriptor poolingDesc, int[] mode, int[] maxpoolingNanOpt, int[] windowHeight, int[] windowWidth, int[] verticalPadding, int[] horizontalPadding, int[] verticalStride, int[] horizontalStride) {
        return JCudnn.checkResult(JCudnn.cudnnGetPooling2dDescriptorNative(poolingDesc, mode, maxpoolingNanOpt, windowHeight, windowWidth, verticalPadding, horizontalPadding, verticalStride, horizontalStride));
    }

    private static native int cudnnGetPooling2dDescriptorNative(cudnnPoolingDescriptor var0, int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    public static int cudnnSetPoolingNdDescriptor(cudnnPoolingDescriptor poolingDesc, int mode, int maxpoolingNanOpt, int nbDims, int[] windowDimA, int[] paddingA, int[] strideA) {
        return JCudnn.checkResult(JCudnn.cudnnSetPoolingNdDescriptorNative(poolingDesc, mode, maxpoolingNanOpt, nbDims, windowDimA, paddingA, strideA));
    }

    private static native int cudnnSetPoolingNdDescriptorNative(cudnnPoolingDescriptor var0, int var1, int var2, int var3, int[] var4, int[] var5, int[] var6);

    public static int cudnnGetPoolingNdDescriptor(cudnnPoolingDescriptor poolingDesc, int nbDimsRequested, int[] mode, int[] maxpoolingNanOpt, int[] nbDims, int[] windowDimA, int[] paddingA, int[] strideA) {
        return JCudnn.checkResult(JCudnn.cudnnGetPoolingNdDescriptorNative(poolingDesc, nbDimsRequested, mode, maxpoolingNanOpt, nbDims, windowDimA, paddingA, strideA));
    }

    private static native int cudnnGetPoolingNdDescriptorNative(cudnnPoolingDescriptor var0, int var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7);

    public static int cudnnGetPoolingNdForwardOutputDim(cudnnPoolingDescriptor poolingDesc, cudnnTensorDescriptor inputTensorDesc, int nbDims, int[] outputTensorDimA) {
        return JCudnn.checkResult(JCudnn.cudnnGetPoolingNdForwardOutputDimNative(poolingDesc, inputTensorDesc, nbDims, outputTensorDimA));
    }

    private static native int cudnnGetPoolingNdForwardOutputDimNative(cudnnPoolingDescriptor var0, cudnnTensorDescriptor var1, int var2, int[] var3);

    public static int cudnnGetPooling2dForwardOutputDim(cudnnPoolingDescriptor poolingDesc, cudnnTensorDescriptor inputTensorDesc, int[] n, int[] c, int[] h, int[] w) {
        return JCudnn.checkResult(JCudnn.cudnnGetPooling2dForwardOutputDimNative(poolingDesc, inputTensorDesc, n, c, h, w));
    }

    private static native int cudnnGetPooling2dForwardOutputDimNative(cudnnPoolingDescriptor var0, cudnnTensorDescriptor var1, int[] var2, int[] var3, int[] var4, int[] var5);

    public static int cudnnDestroyPoolingDescriptor(cudnnPoolingDescriptor poolingDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyPoolingDescriptorNative(poolingDesc));
    }

    private static native int cudnnDestroyPoolingDescriptorNative(cudnnPoolingDescriptor var0);

    public static int cudnnPoolingForward(cudnnHandle handle, cudnnPoolingDescriptor poolingDesc, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnPoolingForwardNative(handle, poolingDesc, alpha, xDesc, x, beta, yDesc, y));
    }

    private static native int cudnnPoolingForwardNative(cudnnHandle var0, cudnnPoolingDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7);

    public static int cudnnPoolingBackward(cudnnHandle handle, cudnnPoolingDescriptor poolingDesc, Pointer alpha, cudnnTensorDescriptor yDesc, Pointer y, cudnnTensorDescriptor dyDesc, Pointer dy, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor dxDesc, Pointer dx) {
        return JCudnn.checkResult(JCudnn.cudnnPoolingBackwardNative(handle, poolingDesc, alpha, yDesc, y, dyDesc, dy, xDesc, x, beta, dxDesc, dx));
    }

    private static native int cudnnPoolingBackwardNative(cudnnHandle var0, cudnnPoolingDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, Pointer var9, cudnnTensorDescriptor var10, Pointer var11);

    public static int cudnnCreateActivationDescriptor(cudnnActivationDescriptor activationDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateActivationDescriptorNative(activationDesc));
    }

    private static native int cudnnCreateActivationDescriptorNative(cudnnActivationDescriptor var0);

    public static int cudnnSetActivationDescriptor(cudnnActivationDescriptor activationDesc, int mode, int reluNanOpt, double reluCeiling) {
        return JCudnn.checkResult(JCudnn.cudnnSetActivationDescriptorNative(activationDesc, mode, reluNanOpt, reluCeiling));
    }

    private static native int cudnnSetActivationDescriptorNative(cudnnActivationDescriptor var0, int var1, int var2, double var3);

    public static int cudnnGetActivationDescriptor(cudnnActivationDescriptor activationDesc, int[] mode, int[] reluNanOpt, double[] reluCeiling) {
        return JCudnn.checkResult(JCudnn.cudnnGetActivationDescriptorNative(activationDesc, mode, reluNanOpt, reluCeiling));
    }

    private static native int cudnnGetActivationDescriptorNative(cudnnActivationDescriptor var0, int[] var1, int[] var2, double[] var3);

    public static int cudnnDestroyActivationDescriptor(cudnnActivationDescriptor activationDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyActivationDescriptorNative(activationDesc));
    }

    private static native int cudnnDestroyActivationDescriptorNative(cudnnActivationDescriptor var0);

    public static int cudnnActivationForward(cudnnHandle handle, cudnnActivationDescriptor activationDesc, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnActivationForwardNative(handle, activationDesc, alpha, xDesc, x, beta, yDesc, y));
    }

    private static native int cudnnActivationForwardNative(cudnnHandle var0, cudnnActivationDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7);

    public static int cudnnActivationBackward(cudnnHandle handle, cudnnActivationDescriptor activationDesc, Pointer alpha, cudnnTensorDescriptor yDesc, Pointer y, cudnnTensorDescriptor dyDesc, Pointer dy, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor dxDesc, Pointer dx) {
        return JCudnn.checkResult(JCudnn.cudnnActivationBackwardNative(handle, activationDesc, alpha, yDesc, y, dyDesc, dy, xDesc, x, beta, dxDesc, dx));
    }

    private static native int cudnnActivationBackwardNative(cudnnHandle var0, cudnnActivationDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, Pointer var9, cudnnTensorDescriptor var10, Pointer var11);

    public static int cudnnCreateLRNDescriptor(cudnnLRNDescriptor normDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateLRNDescriptorNative(normDesc));
    }

    private static native int cudnnCreateLRNDescriptorNative(cudnnLRNDescriptor var0);

    public static int cudnnSetLRNDescriptor(cudnnLRNDescriptor normDesc, int lrnN, double lrnAlpha, double lrnBeta, double lrnK) {
        return JCudnn.checkResult(JCudnn.cudnnSetLRNDescriptorNative(normDesc, lrnN, lrnAlpha, lrnBeta, lrnK));
    }

    private static native int cudnnSetLRNDescriptorNative(cudnnLRNDescriptor var0, int var1, double var2, double var4, double var6);

    public static int cudnnGetLRNDescriptor(cudnnLRNDescriptor normDesc, int[] lrnN, double[] lrnAlpha, double[] lrnBeta, double[] lrnK) {
        return JCudnn.checkResult(JCudnn.cudnnGetLRNDescriptorNative(normDesc, lrnN, lrnAlpha, lrnBeta, lrnK));
    }

    private static native int cudnnGetLRNDescriptorNative(cudnnLRNDescriptor var0, int[] var1, double[] var2, double[] var3, double[] var4);

    public static int cudnnDestroyLRNDescriptor(cudnnLRNDescriptor lrnDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyLRNDescriptorNative(lrnDesc));
    }

    private static native int cudnnDestroyLRNDescriptorNative(cudnnLRNDescriptor var0);

    public static int cudnnLRNCrossChannelForward(cudnnHandle handle, cudnnLRNDescriptor normDesc, int lrnMode, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnLRNCrossChannelForwardNative(handle, normDesc, lrnMode, alpha, xDesc, x, beta, yDesc, y));
    }

    private static native int cudnnLRNCrossChannelForwardNative(cudnnHandle var0, cudnnLRNDescriptor var1, int var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8);

    public static int cudnnLRNCrossChannelBackward(cudnnHandle handle, cudnnLRNDescriptor normDesc, int lrnMode, Pointer alpha, cudnnTensorDescriptor yDesc, Pointer y, cudnnTensorDescriptor dyDesc, Pointer dy, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor dxDesc, Pointer dx) {
        return JCudnn.checkResult(JCudnn.cudnnLRNCrossChannelBackwardNative(handle, normDesc, lrnMode, alpha, yDesc, y, dyDesc, dy, xDesc, x, beta, dxDesc, dx));
    }

    private static native int cudnnLRNCrossChannelBackwardNative(cudnnHandle var0, cudnnLRNDescriptor var1, int var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, cudnnTensorDescriptor var8, Pointer var9, Pointer var10, cudnnTensorDescriptor var11, Pointer var12);

    public static int cudnnDivisiveNormalizationForward(cudnnHandle handle, cudnnLRNDescriptor normDesc, int mode, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer means, Pointer temp, Pointer temp2, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnDivisiveNormalizationForwardNative(handle, normDesc, mode, alpha, xDesc, x, means, temp, temp2, beta, yDesc, y));
    }

    private static native int cudnnDivisiveNormalizationForwardNative(cudnnHandle var0, cudnnLRNDescriptor var1, int var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cudnnTensorDescriptor var10, Pointer var11);

    public static int cudnnDivisiveNormalizationBackward(cudnnHandle handle, cudnnLRNDescriptor normDesc, int mode, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer means, Pointer dy, Pointer temp, Pointer temp2, Pointer beta, cudnnTensorDescriptor dXdMeansDesc, Pointer dx, Pointer dMeans) {
        return JCudnn.checkResult(JCudnn.cudnnDivisiveNormalizationBackwardNative(handle, normDesc, mode, alpha, xDesc, x, means, dy, temp, temp2, beta, dXdMeansDesc, dx, dMeans));
    }

    private static native int cudnnDivisiveNormalizationBackwardNative(cudnnHandle var0, cudnnLRNDescriptor var1, int var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, cudnnTensorDescriptor var11, Pointer var12, Pointer var13);

    public static int cudnnDeriveBNTensorDescriptor(cudnnTensorDescriptor derivedBnDesc, cudnnTensorDescriptor xDesc, int mode) {
        return JCudnn.checkResult(JCudnn.cudnnDeriveBNTensorDescriptorNative(derivedBnDesc, xDesc, mode));
    }

    private static native int cudnnDeriveBNTensorDescriptorNative(cudnnTensorDescriptor var0, cudnnTensorDescriptor var1, int var2);

    public static int cudnnBatchNormalizationForwardTraining(cudnnHandle handle, int mode, Pointer alpha, Pointer beta, cudnnTensorDescriptor xDesc, Pointer x, cudnnTensorDescriptor yDesc, Pointer y, cudnnTensorDescriptor bnScaleBiasMeanVarDesc, Pointer bnScale, Pointer bnBias, double exponentialAverageFactor, Pointer resultRunningMean, Pointer resultRunningVariance, double epsilon, Pointer resultSaveMean, Pointer resultSaveInvVariance) {
        return JCudnn.checkResult(JCudnn.cudnnBatchNormalizationForwardTrainingNative(handle, mode, alpha, beta, xDesc, x, yDesc, y, bnScaleBiasMeanVarDesc, bnScale, bnBias, exponentialAverageFactor, resultRunningMean, resultRunningVariance, epsilon, resultSaveMean, resultSaveInvVariance));
    }

    private static native int cudnnBatchNormalizationForwardTrainingNative(cudnnHandle var0, int var1, Pointer var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, cudnnTensorDescriptor var8, Pointer var9, Pointer var10, double var11, Pointer var13, Pointer var14, double var15, Pointer var17, Pointer var18);

    public static int cudnnBatchNormalizationForwardInference(cudnnHandle handle, int mode, Pointer alpha, Pointer beta, cudnnTensorDescriptor xDesc, Pointer x, cudnnTensorDescriptor yDesc, Pointer y, cudnnTensorDescriptor bnScaleBiasMeanVarDesc, Pointer bnScale, Pointer bnBias, Pointer estimatedMean, Pointer estimatedVariance, double epsilon) {
        return JCudnn.checkResult(JCudnn.cudnnBatchNormalizationForwardInferenceNative(handle, mode, alpha, beta, xDesc, x, yDesc, y, bnScaleBiasMeanVarDesc, bnScale, bnBias, estimatedMean, estimatedVariance, epsilon));
    }

    private static native int cudnnBatchNormalizationForwardInferenceNative(cudnnHandle var0, int var1, Pointer var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, cudnnTensorDescriptor var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, double var13);

    public static int cudnnBatchNormalizationBackward(cudnnHandle handle, int mode, Pointer alphaDataDiff, Pointer betaDataDiff, Pointer alphaParamDiff, Pointer betaParamDiff, cudnnTensorDescriptor xDesc, Pointer x, cudnnTensorDescriptor dyDesc, Pointer dy, cudnnTensorDescriptor dxDesc, Pointer dx, cudnnTensorDescriptor dBnScaleBiasDesc, Pointer bnScale, Pointer dBnScaleResult, Pointer dBnBiasResult, double epsilon, Pointer savedMean, Pointer savedInvVariance) {
        return JCudnn.checkResult(JCudnn.cudnnBatchNormalizationBackwardNative(handle, mode, alphaDataDiff, betaDataDiff, alphaParamDiff, betaParamDiff, xDesc, x, dyDesc, dy, dxDesc, dx, dBnScaleBiasDesc, bnScale, dBnScaleResult, dBnBiasResult, epsilon, savedMean, savedInvVariance));
    }

    private static native int cudnnBatchNormalizationBackwardNative(cudnnHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, cudnnTensorDescriptor var8, Pointer var9, cudnnTensorDescriptor var10, Pointer var11, cudnnTensorDescriptor var12, Pointer var13, Pointer var14, Pointer var15, double var16, Pointer var18, Pointer var19);

    public static int cudnnCreateSpatialTransformerDescriptor(cudnnSpatialTransformerDescriptor stDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateSpatialTransformerDescriptorNative(stDesc));
    }

    private static native int cudnnCreateSpatialTransformerDescriptorNative(cudnnSpatialTransformerDescriptor var0);

    public static int cudnnSetSpatialTransformerNdDescriptor(cudnnSpatialTransformerDescriptor stDesc, int samplerType, int dataType, int nbDims, int[] dimA) {
        return JCudnn.checkResult(JCudnn.cudnnSetSpatialTransformerNdDescriptorNative(stDesc, samplerType, dataType, nbDims, dimA));
    }

    private static native int cudnnSetSpatialTransformerNdDescriptorNative(cudnnSpatialTransformerDescriptor var0, int var1, int var2, int var3, int[] var4);

    public static int cudnnDestroySpatialTransformerDescriptor(cudnnSpatialTransformerDescriptor stDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroySpatialTransformerDescriptorNative(stDesc));
    }

    private static native int cudnnDestroySpatialTransformerDescriptorNative(cudnnSpatialTransformerDescriptor var0);

    public static int cudnnSpatialTfGridGeneratorForward(cudnnHandle handle, cudnnSpatialTransformerDescriptor stDesc, Pointer theta, Pointer grid) {
        return JCudnn.checkResult(JCudnn.cudnnSpatialTfGridGeneratorForwardNative(handle, stDesc, theta, grid));
    }

    private static native int cudnnSpatialTfGridGeneratorForwardNative(cudnnHandle var0, cudnnSpatialTransformerDescriptor var1, Pointer var2, Pointer var3);

    public static int cudnnSpatialTfGridGeneratorBackward(cudnnHandle handle, cudnnSpatialTransformerDescriptor stDesc, Pointer dgrid, Pointer dtheta) {
        return JCudnn.checkResult(JCudnn.cudnnSpatialTfGridGeneratorBackwardNative(handle, stDesc, dgrid, dtheta));
    }

    private static native int cudnnSpatialTfGridGeneratorBackwardNative(cudnnHandle var0, cudnnSpatialTransformerDescriptor var1, Pointer var2, Pointer var3);

    public static int cudnnSpatialTfSamplerForward(cudnnHandle handle, cudnnSpatialTransformerDescriptor stDesc, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer grid, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnSpatialTfSamplerForwardNative(handle, stDesc, alpha, xDesc, x, grid, beta, yDesc, y));
    }

    private static native int cudnnSpatialTfSamplerForwardNative(cudnnHandle var0, cudnnSpatialTransformerDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, Pointer var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8);

    public static int cudnnSpatialTfSamplerBackward(cudnnHandle handle, cudnnSpatialTransformerDescriptor stDesc, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor dxDesc, Pointer dx, Pointer alphaDgrid, cudnnTensorDescriptor dyDesc, Pointer dy, Pointer grid, Pointer betaDgrid, Pointer dgrid) {
        return JCudnn.checkResult(JCudnn.cudnnSpatialTfSamplerBackwardNative(handle, stDesc, alpha, xDesc, x, beta, dxDesc, dx, alphaDgrid, dyDesc, dy, grid, betaDgrid, dgrid));
    }

    private static native int cudnnSpatialTfSamplerBackwardNative(cudnnHandle var0, cudnnSpatialTransformerDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, Pointer var8, cudnnTensorDescriptor var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13);

    public static int cudnnCreateDropoutDescriptor(cudnnDropoutDescriptor dropoutDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateDropoutDescriptorNative(dropoutDesc));
    }

    private static native int cudnnCreateDropoutDescriptorNative(cudnnDropoutDescriptor var0);

    public static int cudnnDestroyDropoutDescriptor(cudnnDropoutDescriptor dropoutDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyDropoutDescriptorNative(dropoutDesc));
    }

    private static native int cudnnDestroyDropoutDescriptorNative(cudnnDropoutDescriptor var0);

    public static int cudnnDropoutGetStatesSize(cudnnHandle handle, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnDropoutGetStatesSizeNative(handle, sizeInBytes));
    }

    private static native int cudnnDropoutGetStatesSizeNative(cudnnHandle var0, long[] var1);

    public static int cudnnDropoutGetReserveSpaceSize(cudnnTensorDescriptor xdesc, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnDropoutGetReserveSpaceSizeNative(xdesc, sizeInBytes));
    }

    private static native int cudnnDropoutGetReserveSpaceSizeNative(cudnnTensorDescriptor var0, long[] var1);

    public static int cudnnSetDropoutDescriptor(cudnnDropoutDescriptor dropoutDesc, cudnnHandle handle, float dropout, Pointer states, long stateSizeInBytes, long seed) {
        return JCudnn.checkResult(JCudnn.cudnnSetDropoutDescriptorNative(dropoutDesc, handle, dropout, states, stateSizeInBytes, seed));
    }

    private static native int cudnnSetDropoutDescriptorNative(cudnnDropoutDescriptor var0, cudnnHandle var1, float var2, Pointer var3, long var4, long var6);

    public static int cudnnDropoutForward(cudnnHandle handle, cudnnDropoutDescriptor dropoutDesc, cudnnTensorDescriptor xdesc, Pointer x, cudnnTensorDescriptor ydesc, Pointer y, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnDropoutForwardNative(handle, dropoutDesc, xdesc, x, ydesc, y, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnDropoutForwardNative(cudnnHandle var0, cudnnDropoutDescriptor var1, cudnnTensorDescriptor var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, Pointer var6, long var7);

    public static int cudnnDropoutBackward(cudnnHandle handle, cudnnDropoutDescriptor dropoutDesc, cudnnTensorDescriptor dydesc, Pointer dy, cudnnTensorDescriptor dxdesc, Pointer dx, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnDropoutBackwardNative(handle, dropoutDesc, dydesc, dy, dxdesc, dx, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnDropoutBackwardNative(cudnnHandle var0, cudnnDropoutDescriptor var1, cudnnTensorDescriptor var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, Pointer var6, long var7);

    public static int cudnnCreateRNNDescriptor(cudnnRNNDescriptor rnnDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateRNNDescriptorNative(rnnDesc));
    }

    private static native int cudnnCreateRNNDescriptorNative(cudnnRNNDescriptor var0);

    public static int cudnnDestroyRNNDescriptor(cudnnRNNDescriptor rnnDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyRNNDescriptorNative(rnnDesc));
    }

    private static native int cudnnDestroyRNNDescriptorNative(cudnnRNNDescriptor var0);

    public static int cudnnSetRNNDescriptor(cudnnRNNDescriptor rnnDesc, int hiddenSize, int numLayers, cudnnDropoutDescriptor dropoutDesc, int inputMode, int direction, int mode, int dataType) {
        return JCudnn.checkResult(JCudnn.cudnnSetRNNDescriptorNative(rnnDesc, hiddenSize, numLayers, dropoutDesc, inputMode, direction, mode, dataType));
    }

    private static native int cudnnSetRNNDescriptorNative(cudnnRNNDescriptor var0, int var1, int var2, cudnnDropoutDescriptor var3, int var4, int var5, int var6, int var7);

    public static int cudnnGetRNNWorkspaceSize(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor xDesc, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNWorkspaceSizeNative(handle, rnnDesc, seqLength, xDesc, sizeInBytes));
    }

    private static native int cudnnGetRNNWorkspaceSizeNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor var3, long[] var4);

    public static int cudnnGetRNNTrainingReserveSize(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor xDesc, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNTrainingReserveSizeNative(handle, rnnDesc, seqLength, xDesc, sizeInBytes));
    }

    private static native int cudnnGetRNNTrainingReserveSizeNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor var3, long[] var4);

    public static int cudnnGetRNNParamsSize(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, cudnnTensorDescriptor xDesc, long[] sizeInBytes, int dataType) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNParamsSizeNative(handle, rnnDesc, xDesc, sizeInBytes, dataType));
    }

    private static native int cudnnGetRNNParamsSizeNative(cudnnHandle var0, cudnnRNNDescriptor var1, cudnnTensorDescriptor var2, long[] var3, int var4);

    public static int cudnnGetRNNLinLayerMatrixParams(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int layer, cudnnTensorDescriptor xDesc, cudnnFilterDescriptor wDesc, Pointer w, int linLayerID, cudnnFilterDescriptor linLayerMatDesc, Pointer linLayerMat) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNLinLayerMatrixParamsNative(handle, rnnDesc, layer, xDesc, wDesc, w, linLayerID, linLayerMatDesc, linLayerMat));
    }

    private static native int cudnnGetRNNLinLayerMatrixParamsNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor var3, cudnnFilterDescriptor var4, Pointer var5, int var6, cudnnFilterDescriptor var7, Pointer var8);

    public static int cudnnGetRNNLinLayerBiasParams(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int layer, cudnnTensorDescriptor xDesc, cudnnFilterDescriptor wDesc, Pointer w, int linLayerID, cudnnFilterDescriptor linLayerBiasDesc, Pointer linLayerBias) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNLinLayerBiasParamsNative(handle, rnnDesc, layer, xDesc, wDesc, w, linLayerID, linLayerBiasDesc, linLayerBias));
    }

    private static native int cudnnGetRNNLinLayerBiasParamsNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor var3, cudnnFilterDescriptor var4, Pointer var5, int var6, cudnnFilterDescriptor var7, Pointer var8);

    public static int cudnnRNNForwardInference(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor xDesc, Pointer x, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnTensorDescriptor cxDesc, Pointer cx, cudnnFilterDescriptor wDesc, Pointer w, cudnnTensorDescriptor yDesc, Pointer y, cudnnTensorDescriptor hyDesc, Pointer hy, cudnnTensorDescriptor cyDesc, Pointer cy, Pointer workspace, long workSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnRNNForwardInferenceNative(handle, rnnDesc, seqLength, xDesc, x, hxDesc, hx, cxDesc, cx, wDesc, w, yDesc, y, hyDesc, hy, cyDesc, cy, workspace, workSpaceSizeInBytes));
    }

    private static native int cudnnRNNForwardInferenceNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, cudnnFilterDescriptor var9, Pointer var10, cudnnTensorDescriptor var11, Pointer var12, cudnnTensorDescriptor var13, Pointer var14, cudnnTensorDescriptor var15, Pointer var16, Pointer var17, long var18);

    public static int cudnnRNNForwardTraining(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor xDesc, Pointer x, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnTensorDescriptor cxDesc, Pointer cx, cudnnFilterDescriptor wDesc, Pointer w, cudnnTensorDescriptor yDesc, Pointer y, cudnnTensorDescriptor hyDesc, Pointer hy, cudnnTensorDescriptor cyDesc, Pointer cy, Pointer workspace, long workSpaceSizeInBytes, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnRNNForwardTrainingNative(handle, rnnDesc, seqLength, xDesc, x, hxDesc, hx, cxDesc, cx, wDesc, w, yDesc, y, hyDesc, hy, cyDesc, cy, workspace, workSpaceSizeInBytes, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnRNNForwardTrainingNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, cudnnFilterDescriptor var9, Pointer var10, cudnnTensorDescriptor var11, Pointer var12, cudnnTensorDescriptor var13, Pointer var14, cudnnTensorDescriptor var15, Pointer var16, Pointer var17, long var18, Pointer var20, long var21);

    public static int cudnnRNNBackwardData(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor yDesc, Pointer y, cudnnTensorDescriptor dyDesc, Pointer dy, cudnnTensorDescriptor dhyDesc, Pointer dhy, cudnnTensorDescriptor dcyDesc, Pointer dcy, cudnnFilterDescriptor wDesc, Pointer w, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnTensorDescriptor cxDesc, Pointer cx, cudnnTensorDescriptor dxDesc, Pointer dx, cudnnTensorDescriptor dhxDesc, Pointer dhx, cudnnTensorDescriptor dcxDesc, Pointer dcx, Pointer workspace, long workSpaceSizeInBytes, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnRNNBackwardDataNative(handle, rnnDesc, seqLength, yDesc, y, dyDesc, dy, dhyDesc, dhy, dcyDesc, dcy, wDesc, w, hxDesc, hx, cxDesc, cx, dxDesc, dx, dhxDesc, dhx, dcxDesc, dcx, workspace, workSpaceSizeInBytes, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnRNNBackwardDataNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, cudnnTensorDescriptor var9, Pointer var10, cudnnFilterDescriptor var11, Pointer var12, cudnnTensorDescriptor var13, Pointer var14, cudnnTensorDescriptor var15, Pointer var16, cudnnTensorDescriptor var17, Pointer var18, cudnnTensorDescriptor var19, Pointer var20, cudnnTensorDescriptor var21, Pointer var22, Pointer var23, long var24, Pointer var26, long var27);

    public static int cudnnRNNBackwardWeights(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor xDesc, Pointer x, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnTensorDescriptor yDesc, Pointer y, Pointer workspace, long workSpaceSizeInBytes, cudnnFilterDescriptor dwDesc, Pointer dw, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnRNNBackwardWeightsNative(handle, rnnDesc, seqLength, xDesc, x, hxDesc, hx, yDesc, y, workspace, workSpaceSizeInBytes, dwDesc, dw, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnRNNBackwardWeightsNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, Pointer var9, long var10, cudnnFilterDescriptor var12, Pointer var13, Pointer var14, long var15);

    static {
        JCudnn.initialize();
    }
}

