/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcudnn;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.jcudnn.cudnnActivationDescriptor;
import jcuda.jcudnn.cudnnAlgorithmDescriptor;
import jcuda.jcudnn.cudnnAlgorithmPerformance;
import jcuda.jcudnn.cudnnCTCLossDescriptor;
import jcuda.jcudnn.cudnnCallback;
import jcuda.jcudnn.cudnnConvolutionBwdDataAlgoPerf;
import jcuda.jcudnn.cudnnConvolutionBwdFilterAlgoPerf;
import jcuda.jcudnn.cudnnConvolutionDescriptor;
import jcuda.jcudnn.cudnnConvolutionFwdAlgoPerf;
import jcuda.jcudnn.cudnnDropoutDescriptor;
import jcuda.jcudnn.cudnnFilterDescriptor;
import jcuda.jcudnn.cudnnHandle;
import jcuda.jcudnn.cudnnLRNDescriptor;
import jcuda.jcudnn.cudnnOpTensorDescriptor;
import jcuda.jcudnn.cudnnPersistentRNNPlan;
import jcuda.jcudnn.cudnnPoolingDescriptor;
import jcuda.jcudnn.cudnnRNNDataDescriptor;
import jcuda.jcudnn.cudnnRNNDescriptor;
import jcuda.jcudnn.cudnnReduceTensorDescriptor;
import jcuda.jcudnn.cudnnRuntimeTag;
import jcuda.jcudnn.cudnnSpatialTransformerDescriptor;
import jcuda.jcudnn.cudnnStatus;
import jcuda.jcudnn.cudnnTensorDescriptor;
import jcuda.runtime.JCuda;
import jcuda.runtime.cudaStream_t;

public class JCudnn {
    public static final int CUDNN_MAJOR = 7;
    public static final int CUDNN_MINOR = 4;
    public static final int CUDNN_PATCHLEVEL = 1;
    public static final int CUDNN_VERSION = 7401;
    public static final int CUDNN_DIM_MAX = 8;
    public static final double CUDNN_BN_MIN_EPSILON = 1.0E-5;
    public static final int CUDNN_SEV_ERROR_EN = 2;
    public static final int CUDNN_SEV_WARNING_EN = 4;
    public static final int CUDNN_SEV_INFO_EN = 8;
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    private JCudnn() {
    }

    public static void initialize() {
        if (!initialized) {
            String libraryBaseName = "JCudnn-" + JCuda.getJCudaVersion();
            String libraryName = LibUtils.createPlatformLibraryName((String)libraryBaseName);
            LibUtils.loadLibrary((String)libraryName, (String[])new String[0]);
            initialized = true;
        }
    }

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(cudnnStatus.stringFor(result));
        }
        return result;
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCudnn.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    public static long cudnnGetVersion() {
        return JCudnn.cudnnGetVersionNative();
    }

    private static native long cudnnGetVersionNative();

    public static long cudnnGetCudartVersion() {
        return JCudnn.cudnnGetCudartVersionNative();
    }

    private static native long cudnnGetCudartVersionNative();

    public static String cudnnGetErrorString(int status) {
        return JCudnn.cudnnGetErrorStringNative(status);
    }

    private static native String cudnnGetErrorStringNative(int var0);

    public static int cudnnQueryRuntimeError(cudnnHandle handle, int[] rstatus, int mode, cudnnRuntimeTag tag) {
        return JCudnn.checkResult(JCudnn.cudnnQueryRuntimeErrorNative(handle, rstatus, mode, tag));
    }

    private static native int cudnnQueryRuntimeErrorNative(cudnnHandle var0, int[] var1, int var2, cudnnRuntimeTag var3);

    public static int cudnnGetProperty(int type, int[] value) {
        return JCudnn.checkResult(JCudnn.cudnnGetPropertyNative(type, value));
    }

    private static native int cudnnGetPropertyNative(int var0, int[] var1);

    public static int cudnnCreate(cudnnHandle handle) {
        return JCudnn.checkResult(JCudnn.cudnnCreateNative(handle));
    }

    private static native int cudnnCreateNative(cudnnHandle var0);

    public static int cudnnDestroy(cudnnHandle handle) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyNative(handle));
    }

    private static native int cudnnDestroyNative(cudnnHandle var0);

    public static int cudnnSetStream(cudnnHandle handle, cudaStream_t streamId) {
        return JCudnn.checkResult(JCudnn.cudnnSetStreamNative(handle, streamId));
    }

    private static native int cudnnSetStreamNative(cudnnHandle var0, cudaStream_t var1);

    public static int cudnnGetStream(cudnnHandle handle, cudaStream_t streamId) {
        return JCudnn.checkResult(JCudnn.cudnnGetStreamNative(handle, streamId));
    }

    private static native int cudnnGetStreamNative(cudnnHandle var0, cudaStream_t var1);

    public static int cudnnCreateTensorDescriptor(cudnnTensorDescriptor tensorDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateTensorDescriptorNative(tensorDesc));
    }

    private static native int cudnnCreateTensorDescriptorNative(cudnnTensorDescriptor var0);

    public static int cudnnSetTensor4dDescriptor(cudnnTensorDescriptor tensorDesc, int format, int dataType, int n, int c, int h, int w) {
        return JCudnn.checkResult(JCudnn.cudnnSetTensor4dDescriptorNative(tensorDesc, format, dataType, n, c, h, w));
    }

    private static native int cudnnSetTensor4dDescriptorNative(cudnnTensorDescriptor var0, int var1, int var2, int var3, int var4, int var5, int var6);

    public static int cudnnSetTensor4dDescriptorEx(cudnnTensorDescriptor tensorDesc, int dataType, int n, int c, int h, int w, int nStride, int cStride, int hStride, int wStride) {
        return JCudnn.checkResult(JCudnn.cudnnSetTensor4dDescriptorExNative(tensorDesc, dataType, n, c, h, w, nStride, cStride, hStride, wStride));
    }

    private static native int cudnnSetTensor4dDescriptorExNative(cudnnTensorDescriptor var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public static int cudnnGetTensor4dDescriptor(cudnnTensorDescriptor tensorDesc, int[] dataType, int[] n, int[] c, int[] h, int[] w, int[] nStride, int[] cStride, int[] hStride, int[] wStride) {
        return JCudnn.checkResult(JCudnn.cudnnGetTensor4dDescriptorNative(tensorDesc, dataType, n, c, h, w, nStride, cStride, hStride, wStride));
    }

    private static native int cudnnGetTensor4dDescriptorNative(cudnnTensorDescriptor var0, int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9);

    public static int cudnnSetTensorNdDescriptor(cudnnTensorDescriptor tensorDesc, int dataType, int nbDims, int[] dimA, int[] strideA) {
        return JCudnn.checkResult(JCudnn.cudnnSetTensorNdDescriptorNative(tensorDesc, dataType, nbDims, dimA, strideA));
    }

    private static native int cudnnSetTensorNdDescriptorNative(cudnnTensorDescriptor var0, int var1, int var2, int[] var3, int[] var4);

    public static int cudnnSetTensorNdDescriptorEx(cudnnTensorDescriptor tensorDesc, int format, int dataType, int nbDims, int[] dimA) {
        return JCudnn.checkResult(JCudnn.cudnnSetTensorNdDescriptorExNative(tensorDesc, format, dataType, nbDims, dimA));
    }

    private static native int cudnnSetTensorNdDescriptorExNative(cudnnTensorDescriptor var0, int var1, int var2, int var3, int[] var4);

    public static int cudnnGetTensorNdDescriptor(cudnnTensorDescriptor tensorDesc, int nbDimsRequested, int[] dataType, int[] nbDims, int[] dimA, int[] strideA) {
        return JCudnn.checkResult(JCudnn.cudnnGetTensorNdDescriptorNative(tensorDesc, nbDimsRequested, dataType, nbDims, dimA, strideA));
    }

    private static native int cudnnGetTensorNdDescriptorNative(cudnnTensorDescriptor var0, int var1, int[] var2, int[] var3, int[] var4, int[] var5);

    public static int cudnnGetTensorSizeInBytes(cudnnTensorDescriptor tensorDesc, long[] size) {
        return JCudnn.checkResult(JCudnn.cudnnGetTensorSizeInBytesNative(tensorDesc, size));
    }

    private static native int cudnnGetTensorSizeInBytesNative(cudnnTensorDescriptor var0, long[] var1);

    public static int cudnnDestroyTensorDescriptor(cudnnTensorDescriptor tensorDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyTensorDescriptorNative(tensorDesc));
    }

    private static native int cudnnDestroyTensorDescriptorNative(cudnnTensorDescriptor var0);

    public static int cudnnTransformTensor(cudnnHandle handle, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnTransformTensorNative(handle, alpha, xDesc, x, beta, yDesc, y));
    }

    private static native int cudnnTransformTensorNative(cudnnHandle var0, Pointer var1, cudnnTensorDescriptor var2, Pointer var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6);

    public static int cudnnAddTensor(cudnnHandle handle, Pointer alpha, cudnnTensorDescriptor aDesc, Pointer A, Pointer beta, cudnnTensorDescriptor cDesc, Pointer C) {
        return JCudnn.checkResult(JCudnn.cudnnAddTensorNative(handle, alpha, aDesc, A, beta, cDesc, C));
    }

    private static native int cudnnAddTensorNative(cudnnHandle var0, Pointer var1, cudnnTensorDescriptor var2, Pointer var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6);

    public static int cudnnCreateOpTensorDescriptor(cudnnOpTensorDescriptor opTensorDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateOpTensorDescriptorNative(opTensorDesc));
    }

    private static native int cudnnCreateOpTensorDescriptorNative(cudnnOpTensorDescriptor var0);

    public static int cudnnSetOpTensorDescriptor(cudnnOpTensorDescriptor opTensorDesc, int opTensorOp, int opTensorCompType, int opTensorNanOpt) {
        return JCudnn.checkResult(JCudnn.cudnnSetOpTensorDescriptorNative(opTensorDesc, opTensorOp, opTensorCompType, opTensorNanOpt));
    }

    private static native int cudnnSetOpTensorDescriptorNative(cudnnOpTensorDescriptor var0, int var1, int var2, int var3);

    public static int cudnnGetOpTensorDescriptor(cudnnOpTensorDescriptor opTensorDesc, int[] opTensorOp, int[] opTensorCompType, int[] opTensorNanOpt) {
        return JCudnn.checkResult(JCudnn.cudnnGetOpTensorDescriptorNative(opTensorDesc, opTensorOp, opTensorCompType, opTensorNanOpt));
    }

    private static native int cudnnGetOpTensorDescriptorNative(cudnnOpTensorDescriptor var0, int[] var1, int[] var2, int[] var3);

    public static int cudnnDestroyOpTensorDescriptor(cudnnOpTensorDescriptor opTensorDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyOpTensorDescriptorNative(opTensorDesc));
    }

    private static native int cudnnDestroyOpTensorDescriptorNative(cudnnOpTensorDescriptor var0);

    public static int cudnnOpTensor(cudnnHandle handle, cudnnOpTensorDescriptor opTensorDesc, Pointer alpha1, cudnnTensorDescriptor aDesc, Pointer A, Pointer alpha2, cudnnTensorDescriptor bDesc, Pointer B, Pointer beta, cudnnTensorDescriptor cDesc, Pointer C) {
        return JCudnn.checkResult(JCudnn.cudnnOpTensorNative(handle, opTensorDesc, alpha1, aDesc, A, alpha2, bDesc, B, beta, cDesc, C));
    }

    private static native int cudnnOpTensorNative(cudnnHandle var0, cudnnOpTensorDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, Pointer var8, cudnnTensorDescriptor var9, Pointer var10);

    public static int cudnnCreateReduceTensorDescriptor(cudnnReduceTensorDescriptor reduceTensorDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateReduceTensorDescriptorNative(reduceTensorDesc));
    }

    private static native int cudnnCreateReduceTensorDescriptorNative(cudnnReduceTensorDescriptor var0);

    public static int cudnnSetReduceTensorDescriptor(cudnnReduceTensorDescriptor reduceTensorDesc, int reduceTensorOp, int reduceTensorCompType, int reduceTensorNanOpt, int reduceTensorIndices, int reduceTensorIndicesType) {
        return JCudnn.checkResult(JCudnn.cudnnSetReduceTensorDescriptorNative(reduceTensorDesc, reduceTensorOp, reduceTensorCompType, reduceTensorNanOpt, reduceTensorIndices, reduceTensorIndicesType));
    }

    private static native int cudnnSetReduceTensorDescriptorNative(cudnnReduceTensorDescriptor var0, int var1, int var2, int var3, int var4, int var5);

    public static int cudnnGetReduceTensorDescriptor(cudnnReduceTensorDescriptor reduceTensorDesc, int[] reduceTensorOp, int[] reduceTensorCompType, int[] reduceTensorNanOpt, int[] reduceTensorIndices, int[] reduceTensorIndicesType) {
        return JCudnn.checkResult(JCudnn.cudnnGetReduceTensorDescriptorNative(reduceTensorDesc, reduceTensorOp, reduceTensorCompType, reduceTensorNanOpt, reduceTensorIndices, reduceTensorIndicesType));
    }

    private static native int cudnnGetReduceTensorDescriptorNative(cudnnReduceTensorDescriptor var0, int[] var1, int[] var2, int[] var3, int[] var4, int[] var5);

    public static int cudnnDestroyReduceTensorDescriptor(cudnnReduceTensorDescriptor reduceTensorDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyReduceTensorDescriptorNative(reduceTensorDesc));
    }

    private static native int cudnnDestroyReduceTensorDescriptorNative(cudnnReduceTensorDescriptor var0);

    public static int cudnnGetReductionIndicesSize(cudnnHandle handle, cudnnReduceTensorDescriptor reduceTensorDesc, cudnnTensorDescriptor aDesc, cudnnTensorDescriptor cDesc, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetReductionIndicesSizeNative(handle, reduceTensorDesc, aDesc, cDesc, sizeInBytes));
    }

    private static native int cudnnGetReductionIndicesSizeNative(cudnnHandle var0, cudnnReduceTensorDescriptor var1, cudnnTensorDescriptor var2, cudnnTensorDescriptor var3, long[] var4);

    public static int cudnnGetReductionWorkspaceSize(cudnnHandle handle, cudnnReduceTensorDescriptor reduceTensorDesc, cudnnTensorDescriptor aDesc, cudnnTensorDescriptor cDesc, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetReductionWorkspaceSizeNative(handle, reduceTensorDesc, aDesc, cDesc, sizeInBytes));
    }

    private static native int cudnnGetReductionWorkspaceSizeNative(cudnnHandle var0, cudnnReduceTensorDescriptor var1, cudnnTensorDescriptor var2, cudnnTensorDescriptor var3, long[] var4);

    public static int cudnnReduceTensor(cudnnHandle handle, cudnnReduceTensorDescriptor reduceTensorDesc, Pointer indices, long indicesSizeInBytes, Pointer workspace, long workspaceSizeInBytes, Pointer alpha, cudnnTensorDescriptor aDesc, Pointer A, Pointer beta, cudnnTensorDescriptor cDesc, Pointer C) {
        return JCudnn.checkResult(JCudnn.cudnnReduceTensorNative(handle, reduceTensorDesc, indices, indicesSizeInBytes, workspace, workspaceSizeInBytes, alpha, aDesc, A, beta, cDesc, C));
    }

    private static native int cudnnReduceTensorNative(cudnnHandle var0, cudnnReduceTensorDescriptor var1, Pointer var2, long var3, Pointer var5, long var6, Pointer var8, cudnnTensorDescriptor var9, Pointer var10, Pointer var11, cudnnTensorDescriptor var12, Pointer var13);

    public static int cudnnSetTensor(cudnnHandle handle, cudnnTensorDescriptor yDesc, Pointer y, Pointer valuePtr) {
        return JCudnn.checkResult(JCudnn.cudnnSetTensorNative(handle, yDesc, y, valuePtr));
    }

    private static native int cudnnSetTensorNative(cudnnHandle var0, cudnnTensorDescriptor var1, Pointer var2, Pointer var3);

    public static int cudnnScaleTensor(cudnnHandle handle, cudnnTensorDescriptor yDesc, Pointer y, Pointer alpha) {
        return JCudnn.checkResult(JCudnn.cudnnScaleTensorNative(handle, yDesc, y, alpha));
    }

    private static native int cudnnScaleTensorNative(cudnnHandle var0, cudnnTensorDescriptor var1, Pointer var2, Pointer var3);

    public static int cudnnCreateFilterDescriptor(cudnnFilterDescriptor filterDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateFilterDescriptorNative(filterDesc));
    }

    private static native int cudnnCreateFilterDescriptorNative(cudnnFilterDescriptor var0);

    public static int cudnnSetFilter4dDescriptor(cudnnFilterDescriptor filterDesc, int dataType, int format, int k, int c, int h, int w) {
        return JCudnn.checkResult(JCudnn.cudnnSetFilter4dDescriptorNative(filterDesc, dataType, format, k, c, h, w));
    }

    private static native int cudnnSetFilter4dDescriptorNative(cudnnFilterDescriptor var0, int var1, int var2, int var3, int var4, int var5, int var6);

    public static int cudnnGetFilter4dDescriptor(cudnnFilterDescriptor filterDesc, int[] dataType, int[] format, int[] k, int[] c, int[] h, int[] w) {
        return JCudnn.checkResult(JCudnn.cudnnGetFilter4dDescriptorNative(filterDesc, dataType, format, k, c, h, w));
    }

    private static native int cudnnGetFilter4dDescriptorNative(cudnnFilterDescriptor var0, int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6);

    public static int cudnnSetFilterNdDescriptor(cudnnFilterDescriptor filterDesc, int dataType, int format, int nbDims, int[] filterDimA) {
        return JCudnn.checkResult(JCudnn.cudnnSetFilterNdDescriptorNative(filterDesc, dataType, format, nbDims, filterDimA));
    }

    private static native int cudnnSetFilterNdDescriptorNative(cudnnFilterDescriptor var0, int var1, int var2, int var3, int[] var4);

    public static int cudnnGetFilterNdDescriptor(cudnnFilterDescriptor filterDesc, int nbDimsRequested, int[] dataType, int[] format, int[] nbDims, int[] filterDimA) {
        return JCudnn.checkResult(JCudnn.cudnnGetFilterNdDescriptorNative(filterDesc, nbDimsRequested, dataType, format, nbDims, filterDimA));
    }

    private static native int cudnnGetFilterNdDescriptorNative(cudnnFilterDescriptor var0, int var1, int[] var2, int[] var3, int[] var4, int[] var5);

    public static int cudnnDestroyFilterDescriptor(cudnnFilterDescriptor filterDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyFilterDescriptorNative(filterDesc));
    }

    private static native int cudnnDestroyFilterDescriptorNative(cudnnFilterDescriptor var0);

    public static int cudnnCreateConvolutionDescriptor(cudnnConvolutionDescriptor convDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateConvolutionDescriptorNative(convDesc));
    }

    private static native int cudnnCreateConvolutionDescriptorNative(cudnnConvolutionDescriptor var0);

    public static int cudnnSetConvolutionMathType(cudnnConvolutionDescriptor convDesc, int mathType) {
        return JCudnn.checkResult(JCudnn.cudnnSetConvolutionMathTypeNative(convDesc, mathType));
    }

    private static native int cudnnSetConvolutionMathTypeNative(cudnnConvolutionDescriptor var0, int var1);

    public static int cudnnGetConvolutionMathType(cudnnConvolutionDescriptor convDesc, int[] mathType) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionMathTypeNative(convDesc, mathType));
    }

    private static native int cudnnGetConvolutionMathTypeNative(cudnnConvolutionDescriptor var0, int[] var1);

    public static int cudnnSetConvolutionGroupCount(cudnnConvolutionDescriptor convDesc, int groupCount) {
        return JCudnn.checkResult(JCudnn.cudnnSetConvolutionGroupCountNative(convDesc, groupCount));
    }

    private static native int cudnnSetConvolutionGroupCountNative(cudnnConvolutionDescriptor var0, int var1);

    public static int cudnnGetConvolutionGroupCount(cudnnConvolutionDescriptor convDesc, int[] groupCount) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionGroupCountNative(convDesc, groupCount));
    }

    private static native int cudnnGetConvolutionGroupCountNative(cudnnConvolutionDescriptor var0, int[] var1);

    public static int cudnnSetConvolution2dDescriptor(cudnnConvolutionDescriptor convDesc, int pad_h, int pad_w, int u, int v, int dilation_h, int dilation_w, int mode, int computeType) {
        return JCudnn.checkResult(JCudnn.cudnnSetConvolution2dDescriptorNative(convDesc, pad_h, pad_w, u, v, dilation_h, dilation_w, mode, computeType));
    }

    private static native int cudnnSetConvolution2dDescriptorNative(cudnnConvolutionDescriptor var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static int cudnnGetConvolution2dDescriptor(cudnnConvolutionDescriptor convDesc, int[] pad_h, int[] pad_w, int[] u, int[] v, int[] dilation_h, int[] dilation_w, int[] mode, int[] computeType) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolution2dDescriptorNative(convDesc, pad_h, pad_w, u, v, dilation_h, dilation_w, mode, computeType));
    }

    private static native int cudnnGetConvolution2dDescriptorNative(cudnnConvolutionDescriptor var0, int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    public static int cudnnGetConvolution2dForwardOutputDim(cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor inputTensorDesc, cudnnFilterDescriptor filterDesc, int[] n, int[] c, int[] h, int[] w) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolution2dForwardOutputDimNative(convDesc, inputTensorDesc, filterDesc, n, c, h, w));
    }

    private static native int cudnnGetConvolution2dForwardOutputDimNative(cudnnConvolutionDescriptor var0, cudnnTensorDescriptor var1, cudnnFilterDescriptor var2, int[] var3, int[] var4, int[] var5, int[] var6);

    public static int cudnnSetConvolutionNdDescriptor(cudnnConvolutionDescriptor convDesc, int arrayLength, int[] padA, int[] filterStrideA, int[] dilationA, int mode, int computeType) {
        return JCudnn.checkResult(JCudnn.cudnnSetConvolutionNdDescriptorNative(convDesc, arrayLength, padA, filterStrideA, dilationA, mode, computeType));
    }

    private static native int cudnnSetConvolutionNdDescriptorNative(cudnnConvolutionDescriptor var0, int var1, int[] var2, int[] var3, int[] var4, int var5, int var6);

    public static int cudnnGetConvolutionNdDescriptor(cudnnConvolutionDescriptor convDesc, int arrayLengthRequested, int[] arrayLength, int[] padA, int[] strideA, int[] dilationA, int[] mode, int[] computeType) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionNdDescriptorNative(convDesc, arrayLengthRequested, arrayLength, padA, strideA, dilationA, mode, computeType));
    }

    private static native int cudnnGetConvolutionNdDescriptorNative(cudnnConvolutionDescriptor var0, int var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7);

    public static int cudnnGetConvolutionNdForwardOutputDim(cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor inputTensorDesc, cudnnFilterDescriptor filterDesc, int nbDims, int[] tensorOuputDimA) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionNdForwardOutputDimNative(convDesc, inputTensorDesc, filterDesc, nbDims, tensorOuputDimA));
    }

    private static native int cudnnGetConvolutionNdForwardOutputDimNative(cudnnConvolutionDescriptor var0, cudnnTensorDescriptor var1, cudnnFilterDescriptor var2, int var3, int[] var4);

    public static int cudnnDestroyConvolutionDescriptor(cudnnConvolutionDescriptor convDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyConvolutionDescriptorNative(convDesc));
    }

    private static native int cudnnDestroyConvolutionDescriptorNative(cudnnConvolutionDescriptor var0);

    public static int cudnnGetConvolutionForwardAlgorithmMaxCount(cudnnHandle handle, int[] count) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionForwardAlgorithmMaxCountNative(handle, count));
    }

    private static native int cudnnGetConvolutionForwardAlgorithmMaxCountNative(cudnnHandle var0, int[] var1);

    public static int cudnnFindConvolutionForwardAlgorithm(cudnnHandle handle, cudnnTensorDescriptor xDesc, cudnnFilterDescriptor wDesc, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor yDesc, int requestedAlgoCount, int[] returnedAlgoCount, cudnnConvolutionFwdAlgoPerf[] perfResults) {
        return JCudnn.checkResult(JCudnn.cudnnFindConvolutionForwardAlgorithmNative(handle, xDesc, wDesc, convDesc, yDesc, requestedAlgoCount, returnedAlgoCount, perfResults));
    }

    private static native int cudnnFindConvolutionForwardAlgorithmNative(cudnnHandle var0, cudnnTensorDescriptor var1, cudnnFilterDescriptor var2, cudnnConvolutionDescriptor var3, cudnnTensorDescriptor var4, int var5, int[] var6, cudnnConvolutionFwdAlgoPerf[] var7);

    public static int cudnnFindConvolutionForwardAlgorithmEx(cudnnHandle handle, cudnnTensorDescriptor xDesc, Pointer x, cudnnFilterDescriptor wDesc, Pointer w, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor yDesc, Pointer y, int requestedAlgoCount, int[] returnedAlgoCount, cudnnConvolutionFwdAlgoPerf[] perfResults, Pointer workSpace, long workSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnFindConvolutionForwardAlgorithmExNative(handle, xDesc, x, wDesc, w, convDesc, yDesc, y, requestedAlgoCount, returnedAlgoCount, perfResults, workSpace, workSpaceSizeInBytes));
    }

    private static native int cudnnFindConvolutionForwardAlgorithmExNative(cudnnHandle var0, cudnnTensorDescriptor var1, Pointer var2, cudnnFilterDescriptor var3, Pointer var4, cudnnConvolutionDescriptor var5, cudnnTensorDescriptor var6, Pointer var7, int var8, int[] var9, cudnnConvolutionFwdAlgoPerf[] var10, Pointer var11, long var12);

    public static int cudnnGetConvolutionForwardAlgorithm(cudnnHandle handle, cudnnTensorDescriptor xDesc, cudnnFilterDescriptor wDesc, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor yDesc, int preference, long memoryLimitInBytes, int[] algo) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionForwardAlgorithmNative(handle, xDesc, wDesc, convDesc, yDesc, preference, memoryLimitInBytes, algo));
    }

    private static native int cudnnGetConvolutionForwardAlgorithmNative(cudnnHandle var0, cudnnTensorDescriptor var1, cudnnFilterDescriptor var2, cudnnConvolutionDescriptor var3, cudnnTensorDescriptor var4, int var5, long var6, int[] var8);

    public static int cudnnGetConvolutionForwardAlgorithm_v7(cudnnHandle handle, cudnnTensorDescriptor srcDesc, cudnnFilterDescriptor filterDesc, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor destDesc, int requestedAlgoCount, int[] returnedAlgoCount, cudnnConvolutionFwdAlgoPerf[] perfResults) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionForwardAlgorithm_v7Native(handle, srcDesc, filterDesc, convDesc, destDesc, requestedAlgoCount, returnedAlgoCount, perfResults));
    }

    private static native int cudnnGetConvolutionForwardAlgorithm_v7Native(cudnnHandle var0, cudnnTensorDescriptor var1, cudnnFilterDescriptor var2, cudnnConvolutionDescriptor var3, cudnnTensorDescriptor var4, int var5, int[] var6, cudnnConvolutionFwdAlgoPerf[] var7);

    public static int cudnnGetConvolutionForwardWorkspaceSize(cudnnHandle handle, cudnnTensorDescriptor xDesc, cudnnFilterDescriptor wDesc, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor yDesc, int algo, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionForwardWorkspaceSizeNative(handle, xDesc, wDesc, convDesc, yDesc, algo, sizeInBytes));
    }

    private static native int cudnnGetConvolutionForwardWorkspaceSizeNative(cudnnHandle var0, cudnnTensorDescriptor var1, cudnnFilterDescriptor var2, cudnnConvolutionDescriptor var3, cudnnTensorDescriptor var4, int var5, long[] var6);

    public static int cudnnConvolutionForward(cudnnHandle handle, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, cudnnFilterDescriptor wDesc, Pointer w, cudnnConvolutionDescriptor convDesc, int algo, Pointer workSpace, long workSpaceSizeInBytes, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnConvolutionForwardNative(handle, alpha, xDesc, x, wDesc, w, convDesc, algo, workSpace, workSpaceSizeInBytes, beta, yDesc, y));
    }

    private static native int cudnnConvolutionForwardNative(cudnnHandle var0, Pointer var1, cudnnTensorDescriptor var2, Pointer var3, cudnnFilterDescriptor var4, Pointer var5, cudnnConvolutionDescriptor var6, int var7, Pointer var8, long var9, Pointer var11, cudnnTensorDescriptor var12, Pointer var13);

    public static int cudnnConvolutionBiasActivationForward(cudnnHandle handle, Pointer alpha1, cudnnTensorDescriptor xDesc, Pointer x, cudnnFilterDescriptor wDesc, Pointer w, cudnnConvolutionDescriptor convDesc, int algo, Pointer workSpace, long workSpaceSizeInBytes, Pointer alpha2, cudnnTensorDescriptor zDesc, Pointer z, cudnnTensorDescriptor biasDesc, Pointer bias, cudnnActivationDescriptor activationDesc, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnConvolutionBiasActivationForwardNative(handle, alpha1, xDesc, x, wDesc, w, convDesc, algo, workSpace, workSpaceSizeInBytes, alpha2, zDesc, z, biasDesc, bias, activationDesc, yDesc, y));
    }

    private static native int cudnnConvolutionBiasActivationForwardNative(cudnnHandle var0, Pointer var1, cudnnTensorDescriptor var2, Pointer var3, cudnnFilterDescriptor var4, Pointer var5, cudnnConvolutionDescriptor var6, int var7, Pointer var8, long var9, Pointer var11, cudnnTensorDescriptor var12, Pointer var13, cudnnTensorDescriptor var14, Pointer var15, cudnnActivationDescriptor var16, cudnnTensorDescriptor var17, Pointer var18);

    public static int cudnnConvolutionBackwardBias(cudnnHandle handle, Pointer alpha, cudnnTensorDescriptor dyDesc, Pointer dy, Pointer beta, cudnnTensorDescriptor dbDesc, Pointer db) {
        return JCudnn.checkResult(JCudnn.cudnnConvolutionBackwardBiasNative(handle, alpha, dyDesc, dy, beta, dbDesc, db));
    }

    private static native int cudnnConvolutionBackwardBiasNative(cudnnHandle var0, Pointer var1, cudnnTensorDescriptor var2, Pointer var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6);

    public static int cudnnGetConvolutionBackwardFilterAlgorithmMaxCount(cudnnHandle handle, int[] count) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionBackwardFilterAlgorithmMaxCountNative(handle, count));
    }

    private static native int cudnnGetConvolutionBackwardFilterAlgorithmMaxCountNative(cudnnHandle var0, int[] var1);

    public static int cudnnFindConvolutionBackwardFilterAlgorithm(cudnnHandle handle, cudnnTensorDescriptor xDesc, cudnnTensorDescriptor dyDesc, cudnnConvolutionDescriptor convDesc, cudnnFilterDescriptor dwDesc, int requestedAlgoCount, int[] returnedAlgoCount, cudnnConvolutionBwdFilterAlgoPerf[] perfResults) {
        return JCudnn.checkResult(JCudnn.cudnnFindConvolutionBackwardFilterAlgorithmNative(handle, xDesc, dyDesc, convDesc, dwDesc, requestedAlgoCount, returnedAlgoCount, perfResults));
    }

    private static native int cudnnFindConvolutionBackwardFilterAlgorithmNative(cudnnHandle var0, cudnnTensorDescriptor var1, cudnnTensorDescriptor var2, cudnnConvolutionDescriptor var3, cudnnFilterDescriptor var4, int var5, int[] var6, cudnnConvolutionBwdFilterAlgoPerf[] var7);

    public static int cudnnFindConvolutionBackwardFilterAlgorithmEx(cudnnHandle handle, cudnnTensorDescriptor xDesc, Pointer x, cudnnTensorDescriptor dyDesc, Pointer y, cudnnConvolutionDescriptor convDesc, cudnnFilterDescriptor dwDesc, Pointer dw, int requestedAlgoCount, int[] returnedAlgoCount, cudnnConvolutionBwdFilterAlgoPerf[] perfResults, Pointer workSpace, long workSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnFindConvolutionBackwardFilterAlgorithmExNative(handle, xDesc, x, dyDesc, y, convDesc, dwDesc, dw, requestedAlgoCount, returnedAlgoCount, perfResults, workSpace, workSpaceSizeInBytes));
    }

    private static native int cudnnFindConvolutionBackwardFilterAlgorithmExNative(cudnnHandle var0, cudnnTensorDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, cudnnConvolutionDescriptor var5, cudnnFilterDescriptor var6, Pointer var7, int var8, int[] var9, cudnnConvolutionBwdFilterAlgoPerf[] var10, Pointer var11, long var12);

    public static int cudnnGetConvolutionBackwardFilterAlgorithm(cudnnHandle handle, cudnnTensorDescriptor xDesc, cudnnTensorDescriptor dyDesc, cudnnConvolutionDescriptor convDesc, cudnnFilterDescriptor dwDesc, int preference, long memoryLimitInBytes, int[] algo) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionBackwardFilterAlgorithmNative(handle, xDesc, dyDesc, convDesc, dwDesc, preference, memoryLimitInBytes, algo));
    }

    private static native int cudnnGetConvolutionBackwardFilterAlgorithmNative(cudnnHandle var0, cudnnTensorDescriptor var1, cudnnTensorDescriptor var2, cudnnConvolutionDescriptor var3, cudnnFilterDescriptor var4, int var5, long var6, int[] var8);

    public static int cudnnGetConvolutionBackwardFilterAlgorithm_v7(cudnnHandle handle, cudnnTensorDescriptor srcDesc, cudnnTensorDescriptor diffDesc, cudnnConvolutionDescriptor convDesc, cudnnFilterDescriptor gradDesc, int requestedAlgoCount, int[] returnedAlgoCount, cudnnConvolutionBwdFilterAlgoPerf[] perfResults) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionBackwardFilterAlgorithm_v7Native(handle, srcDesc, diffDesc, convDesc, gradDesc, requestedAlgoCount, returnedAlgoCount, perfResults));
    }

    private static native int cudnnGetConvolutionBackwardFilterAlgorithm_v7Native(cudnnHandle var0, cudnnTensorDescriptor var1, cudnnTensorDescriptor var2, cudnnConvolutionDescriptor var3, cudnnFilterDescriptor var4, int var5, int[] var6, cudnnConvolutionBwdFilterAlgoPerf[] var7);

    public static int cudnnGetConvolutionBackwardFilterWorkspaceSize(cudnnHandle handle, cudnnTensorDescriptor xDesc, cudnnTensorDescriptor dyDesc, cudnnConvolutionDescriptor convDesc, cudnnFilterDescriptor gradDesc, int algo, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionBackwardFilterWorkspaceSizeNative(handle, xDesc, dyDesc, convDesc, gradDesc, algo, sizeInBytes));
    }

    private static native int cudnnGetConvolutionBackwardFilterWorkspaceSizeNative(cudnnHandle var0, cudnnTensorDescriptor var1, cudnnTensorDescriptor var2, cudnnConvolutionDescriptor var3, cudnnFilterDescriptor var4, int var5, long[] var6);

    public static int cudnnConvolutionBackwardFilter(cudnnHandle handle, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, cudnnTensorDescriptor dyDesc, Pointer dy, cudnnConvolutionDescriptor convDesc, int algo, Pointer workSpace, long workSpaceSizeInBytes, Pointer beta, cudnnFilterDescriptor dwDesc, Pointer dw) {
        return JCudnn.checkResult(JCudnn.cudnnConvolutionBackwardFilterNative(handle, alpha, xDesc, x, dyDesc, dy, convDesc, algo, workSpace, workSpaceSizeInBytes, beta, dwDesc, dw));
    }

    private static native int cudnnConvolutionBackwardFilterNative(cudnnHandle var0, Pointer var1, cudnnTensorDescriptor var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, cudnnConvolutionDescriptor var6, int var7, Pointer var8, long var9, Pointer var11, cudnnFilterDescriptor var12, Pointer var13);

    public static int cudnnGetConvolutionBackwardDataAlgorithmMaxCount(cudnnHandle handle, int[] count) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionBackwardDataAlgorithmMaxCountNative(handle, count));
    }

    private static native int cudnnGetConvolutionBackwardDataAlgorithmMaxCountNative(cudnnHandle var0, int[] var1);

    public static int cudnnFindConvolutionBackwardDataAlgorithm(cudnnHandle handle, cudnnFilterDescriptor wDesc, cudnnTensorDescriptor dyDesc, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor dxDesc, int requestedAlgoCount, int[] returnedAlgoCount, cudnnConvolutionBwdDataAlgoPerf[] perfResults) {
        return JCudnn.checkResult(JCudnn.cudnnFindConvolutionBackwardDataAlgorithmNative(handle, wDesc, dyDesc, convDesc, dxDesc, requestedAlgoCount, returnedAlgoCount, perfResults));
    }

    private static native int cudnnFindConvolutionBackwardDataAlgorithmNative(cudnnHandle var0, cudnnFilterDescriptor var1, cudnnTensorDescriptor var2, cudnnConvolutionDescriptor var3, cudnnTensorDescriptor var4, int var5, int[] var6, cudnnConvolutionBwdDataAlgoPerf[] var7);

    public static int cudnnFindConvolutionBackwardDataAlgorithmEx(cudnnHandle handle, cudnnFilterDescriptor wDesc, Pointer w, cudnnTensorDescriptor dyDesc, Pointer dy, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor dxDesc, Pointer dx, int requestedAlgoCount, int[] returnedAlgoCount, cudnnConvolutionBwdDataAlgoPerf[] perfResults, Pointer workSpace, long workSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnFindConvolutionBackwardDataAlgorithmExNative(handle, wDesc, w, dyDesc, dy, convDesc, dxDesc, dx, requestedAlgoCount, returnedAlgoCount, perfResults, workSpace, workSpaceSizeInBytes));
    }

    private static native int cudnnFindConvolutionBackwardDataAlgorithmExNative(cudnnHandle var0, cudnnFilterDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, cudnnConvolutionDescriptor var5, cudnnTensorDescriptor var6, Pointer var7, int var8, int[] var9, cudnnConvolutionBwdDataAlgoPerf[] var10, Pointer var11, long var12);

    public static int cudnnGetConvolutionBackwardDataAlgorithm(cudnnHandle handle, cudnnFilterDescriptor wDesc, cudnnTensorDescriptor dyDesc, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor dxDesc, int preference, long memoryLimitInBytes, int[] algo) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionBackwardDataAlgorithmNative(handle, wDesc, dyDesc, convDesc, dxDesc, preference, memoryLimitInBytes, algo));
    }

    private static native int cudnnGetConvolutionBackwardDataAlgorithmNative(cudnnHandle var0, cudnnFilterDescriptor var1, cudnnTensorDescriptor var2, cudnnConvolutionDescriptor var3, cudnnTensorDescriptor var4, int var5, long var6, int[] var8);

    public static int cudnnGetConvolutionBackwardDataAlgorithm_v7(cudnnHandle handle, cudnnFilterDescriptor filterDesc, cudnnTensorDescriptor diffDesc, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor gradDesc, int requestedAlgoCount, int[] returnedAlgoCount, cudnnConvolutionBwdDataAlgoPerf[] perfResults) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionBackwardDataAlgorithm_v7Native(handle, filterDesc, diffDesc, convDesc, gradDesc, requestedAlgoCount, returnedAlgoCount, perfResults));
    }

    private static native int cudnnGetConvolutionBackwardDataAlgorithm_v7Native(cudnnHandle var0, cudnnFilterDescriptor var1, cudnnTensorDescriptor var2, cudnnConvolutionDescriptor var3, cudnnTensorDescriptor var4, int var5, int[] var6, cudnnConvolutionBwdDataAlgoPerf[] var7);

    public static int cudnnGetConvolutionBackwardDataWorkspaceSize(cudnnHandle handle, cudnnFilterDescriptor wDesc, cudnnTensorDescriptor dyDesc, cudnnConvolutionDescriptor convDesc, cudnnTensorDescriptor dxDesc, int algo, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetConvolutionBackwardDataWorkspaceSizeNative(handle, wDesc, dyDesc, convDesc, dxDesc, algo, sizeInBytes));
    }

    private static native int cudnnGetConvolutionBackwardDataWorkspaceSizeNative(cudnnHandle var0, cudnnFilterDescriptor var1, cudnnTensorDescriptor var2, cudnnConvolutionDescriptor var3, cudnnTensorDescriptor var4, int var5, long[] var6);

    public static int cudnnConvolutionBackwardData(cudnnHandle handle, Pointer alpha, cudnnFilterDescriptor wDesc, Pointer w, cudnnTensorDescriptor dyDesc, Pointer dy, cudnnConvolutionDescriptor convDesc, int algo, Pointer workSpace, long workSpaceSizeInBytes, Pointer beta, cudnnTensorDescriptor dxDesc, Pointer dx) {
        return JCudnn.checkResult(JCudnn.cudnnConvolutionBackwardDataNative(handle, alpha, wDesc, w, dyDesc, dy, convDesc, algo, workSpace, workSpaceSizeInBytes, beta, dxDesc, dx));
    }

    private static native int cudnnConvolutionBackwardDataNative(cudnnHandle var0, Pointer var1, cudnnFilterDescriptor var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, cudnnConvolutionDescriptor var6, int var7, Pointer var8, long var9, Pointer var11, cudnnTensorDescriptor var12, Pointer var13);

    public static int cudnnIm2Col(cudnnHandle handle, cudnnTensorDescriptor xDesc, Pointer x, cudnnFilterDescriptor wDesc, cudnnConvolutionDescriptor convDesc, Pointer colBuffer) {
        return JCudnn.checkResult(JCudnn.cudnnIm2ColNative(handle, xDesc, x, wDesc, convDesc, colBuffer));
    }

    private static native int cudnnIm2ColNative(cudnnHandle var0, cudnnTensorDescriptor var1, Pointer var2, cudnnFilterDescriptor var3, cudnnConvolutionDescriptor var4, Pointer var5);

    public static int cudnnSoftmaxForward(cudnnHandle handle, int algo, int mode, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnSoftmaxForwardNative(handle, algo, mode, alpha, xDesc, x, beta, yDesc, y));
    }

    private static native int cudnnSoftmaxForwardNative(cudnnHandle var0, int var1, int var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8);

    public static int cudnnSoftmaxBackward(cudnnHandle handle, int algo, int mode, Pointer alpha, cudnnTensorDescriptor yDesc, Pointer y, cudnnTensorDescriptor dyDesc, Pointer dy, Pointer beta, cudnnTensorDescriptor dxDesc, Pointer dx) {
        return JCudnn.checkResult(JCudnn.cudnnSoftmaxBackwardNative(handle, algo, mode, alpha, yDesc, y, dyDesc, dy, beta, dxDesc, dx));
    }

    private static native int cudnnSoftmaxBackwardNative(cudnnHandle var0, int var1, int var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, Pointer var8, cudnnTensorDescriptor var9, Pointer var10);

    public static int cudnnCreatePoolingDescriptor(cudnnPoolingDescriptor poolingDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreatePoolingDescriptorNative(poolingDesc));
    }

    private static native int cudnnCreatePoolingDescriptorNative(cudnnPoolingDescriptor var0);

    public static int cudnnSetPooling2dDescriptor(cudnnPoolingDescriptor poolingDesc, int mode, int maxpoolingNanOpt, int windowHeight, int windowWidth, int verticalPadding, int horizontalPadding, int verticalStride, int horizontalStride) {
        return JCudnn.checkResult(JCudnn.cudnnSetPooling2dDescriptorNative(poolingDesc, mode, maxpoolingNanOpt, windowHeight, windowWidth, verticalPadding, horizontalPadding, verticalStride, horizontalStride));
    }

    private static native int cudnnSetPooling2dDescriptorNative(cudnnPoolingDescriptor var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static int cudnnGetPooling2dDescriptor(cudnnPoolingDescriptor poolingDesc, int[] mode, int[] maxpoolingNanOpt, int[] windowHeight, int[] windowWidth, int[] verticalPadding, int[] horizontalPadding, int[] verticalStride, int[] horizontalStride) {
        return JCudnn.checkResult(JCudnn.cudnnGetPooling2dDescriptorNative(poolingDesc, mode, maxpoolingNanOpt, windowHeight, windowWidth, verticalPadding, horizontalPadding, verticalStride, horizontalStride));
    }

    private static native int cudnnGetPooling2dDescriptorNative(cudnnPoolingDescriptor var0, int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    public static int cudnnSetPoolingNdDescriptor(cudnnPoolingDescriptor poolingDesc, int mode, int maxpoolingNanOpt, int nbDims, int[] windowDimA, int[] paddingA, int[] strideA) {
        return JCudnn.checkResult(JCudnn.cudnnSetPoolingNdDescriptorNative(poolingDesc, mode, maxpoolingNanOpt, nbDims, windowDimA, paddingA, strideA));
    }

    private static native int cudnnSetPoolingNdDescriptorNative(cudnnPoolingDescriptor var0, int var1, int var2, int var3, int[] var4, int[] var5, int[] var6);

    public static int cudnnGetPoolingNdDescriptor(cudnnPoolingDescriptor poolingDesc, int nbDimsRequested, int[] mode, int[] maxpoolingNanOpt, int[] nbDims, int[] windowDimA, int[] paddingA, int[] strideA) {
        return JCudnn.checkResult(JCudnn.cudnnGetPoolingNdDescriptorNative(poolingDesc, nbDimsRequested, mode, maxpoolingNanOpt, nbDims, windowDimA, paddingA, strideA));
    }

    private static native int cudnnGetPoolingNdDescriptorNative(cudnnPoolingDescriptor var0, int var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7);

    public static int cudnnGetPoolingNdForwardOutputDim(cudnnPoolingDescriptor poolingDesc, cudnnTensorDescriptor inputTensorDesc, int nbDims, int[] outputTensorDimA) {
        return JCudnn.checkResult(JCudnn.cudnnGetPoolingNdForwardOutputDimNative(poolingDesc, inputTensorDesc, nbDims, outputTensorDimA));
    }

    private static native int cudnnGetPoolingNdForwardOutputDimNative(cudnnPoolingDescriptor var0, cudnnTensorDescriptor var1, int var2, int[] var3);

    public static int cudnnGetPooling2dForwardOutputDim(cudnnPoolingDescriptor poolingDesc, cudnnTensorDescriptor inputTensorDesc, int[] n, int[] c, int[] h, int[] w) {
        return JCudnn.checkResult(JCudnn.cudnnGetPooling2dForwardOutputDimNative(poolingDesc, inputTensorDesc, n, c, h, w));
    }

    private static native int cudnnGetPooling2dForwardOutputDimNative(cudnnPoolingDescriptor var0, cudnnTensorDescriptor var1, int[] var2, int[] var3, int[] var4, int[] var5);

    public static int cudnnDestroyPoolingDescriptor(cudnnPoolingDescriptor poolingDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyPoolingDescriptorNative(poolingDesc));
    }

    private static native int cudnnDestroyPoolingDescriptorNative(cudnnPoolingDescriptor var0);

    public static int cudnnPoolingForward(cudnnHandle handle, cudnnPoolingDescriptor poolingDesc, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnPoolingForwardNative(handle, poolingDesc, alpha, xDesc, x, beta, yDesc, y));
    }

    private static native int cudnnPoolingForwardNative(cudnnHandle var0, cudnnPoolingDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7);

    public static int cudnnPoolingBackward(cudnnHandle handle, cudnnPoolingDescriptor poolingDesc, Pointer alpha, cudnnTensorDescriptor yDesc, Pointer y, cudnnTensorDescriptor dyDesc, Pointer dy, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor dxDesc, Pointer dx) {
        return JCudnn.checkResult(JCudnn.cudnnPoolingBackwardNative(handle, poolingDesc, alpha, yDesc, y, dyDesc, dy, xDesc, x, beta, dxDesc, dx));
    }

    private static native int cudnnPoolingBackwardNative(cudnnHandle var0, cudnnPoolingDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, Pointer var9, cudnnTensorDescriptor var10, Pointer var11);

    public static int cudnnCreateActivationDescriptor(cudnnActivationDescriptor activationDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateActivationDescriptorNative(activationDesc));
    }

    private static native int cudnnCreateActivationDescriptorNative(cudnnActivationDescriptor var0);

    public static int cudnnSetActivationDescriptor(cudnnActivationDescriptor activationDesc, int mode, int reluNanOpt, double coef) {
        return JCudnn.checkResult(JCudnn.cudnnSetActivationDescriptorNative(activationDesc, mode, reluNanOpt, coef));
    }

    private static native int cudnnSetActivationDescriptorNative(cudnnActivationDescriptor var0, int var1, int var2, double var3);

    public static int cudnnGetActivationDescriptor(cudnnActivationDescriptor activationDesc, int[] mode, int[] reluNanOpt, double[] coef) {
        return JCudnn.checkResult(JCudnn.cudnnGetActivationDescriptorNative(activationDesc, mode, reluNanOpt, coef));
    }

    private static native int cudnnGetActivationDescriptorNative(cudnnActivationDescriptor var0, int[] var1, int[] var2, double[] var3);

    public static int cudnnDestroyActivationDescriptor(cudnnActivationDescriptor activationDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyActivationDescriptorNative(activationDesc));
    }

    private static native int cudnnDestroyActivationDescriptorNative(cudnnActivationDescriptor var0);

    public static int cudnnActivationForward(cudnnHandle handle, cudnnActivationDescriptor activationDesc, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnActivationForwardNative(handle, activationDesc, alpha, xDesc, x, beta, yDesc, y));
    }

    private static native int cudnnActivationForwardNative(cudnnHandle var0, cudnnActivationDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7);

    public static int cudnnActivationBackward(cudnnHandle handle, cudnnActivationDescriptor activationDesc, Pointer alpha, cudnnTensorDescriptor yDesc, Pointer y, cudnnTensorDescriptor dyDesc, Pointer dy, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor dxDesc, Pointer dx) {
        return JCudnn.checkResult(JCudnn.cudnnActivationBackwardNative(handle, activationDesc, alpha, yDesc, y, dyDesc, dy, xDesc, x, beta, dxDesc, dx));
    }

    private static native int cudnnActivationBackwardNative(cudnnHandle var0, cudnnActivationDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, Pointer var9, cudnnTensorDescriptor var10, Pointer var11);

    public static int cudnnCreateLRNDescriptor(cudnnLRNDescriptor normDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateLRNDescriptorNative(normDesc));
    }

    private static native int cudnnCreateLRNDescriptorNative(cudnnLRNDescriptor var0);

    public static int cudnnSetLRNDescriptor(cudnnLRNDescriptor normDesc, int lrnN, double lrnAlpha, double lrnBeta, double lrnK) {
        return JCudnn.checkResult(JCudnn.cudnnSetLRNDescriptorNative(normDesc, lrnN, lrnAlpha, lrnBeta, lrnK));
    }

    private static native int cudnnSetLRNDescriptorNative(cudnnLRNDescriptor var0, int var1, double var2, double var4, double var6);

    public static int cudnnGetLRNDescriptor(cudnnLRNDescriptor normDesc, int[] lrnN, double[] lrnAlpha, double[] lrnBeta, double[] lrnK) {
        return JCudnn.checkResult(JCudnn.cudnnGetLRNDescriptorNative(normDesc, lrnN, lrnAlpha, lrnBeta, lrnK));
    }

    private static native int cudnnGetLRNDescriptorNative(cudnnLRNDescriptor var0, int[] var1, double[] var2, double[] var3, double[] var4);

    public static int cudnnDestroyLRNDescriptor(cudnnLRNDescriptor lrnDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyLRNDescriptorNative(lrnDesc));
    }

    private static native int cudnnDestroyLRNDescriptorNative(cudnnLRNDescriptor var0);

    public static int cudnnLRNCrossChannelForward(cudnnHandle handle, cudnnLRNDescriptor normDesc, int lrnMode, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnLRNCrossChannelForwardNative(handle, normDesc, lrnMode, alpha, xDesc, x, beta, yDesc, y));
    }

    private static native int cudnnLRNCrossChannelForwardNative(cudnnHandle var0, cudnnLRNDescriptor var1, int var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8);

    public static int cudnnLRNCrossChannelBackward(cudnnHandle handle, cudnnLRNDescriptor normDesc, int lrnMode, Pointer alpha, cudnnTensorDescriptor yDesc, Pointer y, cudnnTensorDescriptor dyDesc, Pointer dy, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor dxDesc, Pointer dx) {
        return JCudnn.checkResult(JCudnn.cudnnLRNCrossChannelBackwardNative(handle, normDesc, lrnMode, alpha, yDesc, y, dyDesc, dy, xDesc, x, beta, dxDesc, dx));
    }

    private static native int cudnnLRNCrossChannelBackwardNative(cudnnHandle var0, cudnnLRNDescriptor var1, int var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, cudnnTensorDescriptor var8, Pointer var9, Pointer var10, cudnnTensorDescriptor var11, Pointer var12);

    public static int cudnnDivisiveNormalizationForward(cudnnHandle handle, cudnnLRNDescriptor normDesc, int mode, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer means, Pointer temp, Pointer temp2, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnDivisiveNormalizationForwardNative(handle, normDesc, mode, alpha, xDesc, x, means, temp, temp2, beta, yDesc, y));
    }

    private static native int cudnnDivisiveNormalizationForwardNative(cudnnHandle var0, cudnnLRNDescriptor var1, int var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cudnnTensorDescriptor var10, Pointer var11);

    public static int cudnnDivisiveNormalizationBackward(cudnnHandle handle, cudnnLRNDescriptor normDesc, int mode, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer means, Pointer dy, Pointer temp, Pointer temp2, Pointer beta, cudnnTensorDescriptor dXdMeansDesc, Pointer dx, Pointer dMeans) {
        return JCudnn.checkResult(JCudnn.cudnnDivisiveNormalizationBackwardNative(handle, normDesc, mode, alpha, xDesc, x, means, dy, temp, temp2, beta, dXdMeansDesc, dx, dMeans));
    }

    private static native int cudnnDivisiveNormalizationBackwardNative(cudnnHandle var0, cudnnLRNDescriptor var1, int var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, cudnnTensorDescriptor var11, Pointer var12, Pointer var13);

    public static int cudnnDeriveBNTensorDescriptor(cudnnTensorDescriptor derivedBnDesc, cudnnTensorDescriptor xDesc, int mode) {
        return JCudnn.checkResult(JCudnn.cudnnDeriveBNTensorDescriptorNative(derivedBnDesc, xDesc, mode));
    }

    private static native int cudnnDeriveBNTensorDescriptorNative(cudnnTensorDescriptor var0, cudnnTensorDescriptor var1, int var2);

    public static int cudnnGetBatchNormalizationForwardTrainingExWorkspaceSize(cudnnHandle handle, int mode, int bnOps, cudnnTensorDescriptor xDesc, cudnnTensorDescriptor zDesc, cudnnTensorDescriptor yDesc, cudnnTensorDescriptor bnScaleBiasMeanVarDesc, cudnnActivationDescriptor activationDesc, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetBatchNormalizationForwardTrainingExWorkspaceSizeNative(handle, mode, bnOps, xDesc, zDesc, yDesc, bnScaleBiasMeanVarDesc, activationDesc, sizeInBytes));
    }

    private static native int cudnnGetBatchNormalizationForwardTrainingExWorkspaceSizeNative(cudnnHandle var0, int var1, int var2, cudnnTensorDescriptor var3, cudnnTensorDescriptor var4, cudnnTensorDescriptor var5, cudnnTensorDescriptor var6, cudnnActivationDescriptor var7, long[] var8);

    public static int cudnnGetBatchNormalizationBackwardExWorkspaceSize(cudnnHandle handle, int mode, int bnOps, cudnnTensorDescriptor xDesc, cudnnTensorDescriptor yDesc, cudnnTensorDescriptor dyDesc, cudnnTensorDescriptor dzDesc, cudnnTensorDescriptor dxDesc, cudnnTensorDescriptor dBnScaleBiasDesc, cudnnActivationDescriptor activationDesc, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetBatchNormalizationBackwardExWorkspaceSizeNative(handle, mode, bnOps, xDesc, yDesc, dyDesc, dzDesc, dxDesc, dBnScaleBiasDesc, activationDesc, sizeInBytes));
    }

    private static native int cudnnGetBatchNormalizationBackwardExWorkspaceSizeNative(cudnnHandle var0, int var1, int var2, cudnnTensorDescriptor var3, cudnnTensorDescriptor var4, cudnnTensorDescriptor var5, cudnnTensorDescriptor var6, cudnnTensorDescriptor var7, cudnnTensorDescriptor var8, cudnnActivationDescriptor var9, long[] var10);

    public static int cudnnGetBatchNormalizationTrainingExReserveSpaceSize(cudnnHandle handle, int mode, int bnOps, cudnnActivationDescriptor activationDesc, cudnnTensorDescriptor xDesc, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetBatchNormalizationTrainingExReserveSpaceSizeNative(handle, mode, bnOps, activationDesc, xDesc, sizeInBytes));
    }

    private static native int cudnnGetBatchNormalizationTrainingExReserveSpaceSizeNative(cudnnHandle var0, int var1, int var2, cudnnActivationDescriptor var3, cudnnTensorDescriptor var4, long[] var5);

    public static int cudnnBatchNormalizationForwardTraining(cudnnHandle handle, int mode, Pointer alpha, Pointer beta, cudnnTensorDescriptor xDesc, Pointer x, cudnnTensorDescriptor yDesc, Pointer y, cudnnTensorDescriptor bnScaleBiasMeanVarDesc, Pointer bnScale, Pointer bnBias, double exponentialAverageFactor, Pointer resultRunningMean, Pointer resultRunningVariance, double epsilon, Pointer resultSaveMean, Pointer resultSaveInvVariance) {
        return JCudnn.checkResult(JCudnn.cudnnBatchNormalizationForwardTrainingNative(handle, mode, alpha, beta, xDesc, x, yDesc, y, bnScaleBiasMeanVarDesc, bnScale, bnBias, exponentialAverageFactor, resultRunningMean, resultRunningVariance, epsilon, resultSaveMean, resultSaveInvVariance));
    }

    private static native int cudnnBatchNormalizationForwardTrainingNative(cudnnHandle var0, int var1, Pointer var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, cudnnTensorDescriptor var8, Pointer var9, Pointer var10, double var11, Pointer var13, Pointer var14, double var15, Pointer var17, Pointer var18);

    public static int cudnnBatchNormalizationForwardTrainingEx(cudnnHandle handle, int mode, int bnOps, Pointer alpha, Pointer beta, cudnnTensorDescriptor xDesc, Pointer xData, cudnnTensorDescriptor zDesc, Pointer zData, cudnnTensorDescriptor yDesc, Pointer yData, cudnnTensorDescriptor bnScaleBiasMeanVarDesc, Pointer bnScale, Pointer bnBias, double exponentialAverageFactor, Pointer resultRunningMean, Pointer resultRunningVariance, double epsilon, Pointer resultSaveMean, Pointer resultSaveInvVariance, cudnnActivationDescriptor activationDesc, Pointer workspace, long workSpaceSizeInBytes, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnBatchNormalizationForwardTrainingExNative(handle, mode, bnOps, alpha, beta, xDesc, xData, zDesc, zData, yDesc, yData, bnScaleBiasMeanVarDesc, bnScale, bnBias, exponentialAverageFactor, resultRunningMean, resultRunningVariance, epsilon, resultSaveMean, resultSaveInvVariance, activationDesc, workspace, workSpaceSizeInBytes, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnBatchNormalizationForwardTrainingExNative(cudnnHandle var0, int var1, int var2, Pointer var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, cudnnTensorDescriptor var9, Pointer var10, cudnnTensorDescriptor var11, Pointer var12, Pointer var13, double var14, Pointer var16, Pointer var17, double var18, Pointer var20, Pointer var21, cudnnActivationDescriptor var22, Pointer var23, long var24, Pointer var26, long var27);

    public static int cudnnBatchNormalizationForwardInference(cudnnHandle handle, int mode, Pointer alpha, Pointer beta, cudnnTensorDescriptor xDesc, Pointer x, cudnnTensorDescriptor yDesc, Pointer y, cudnnTensorDescriptor bnScaleBiasMeanVarDesc, Pointer bnScale, Pointer bnBias, Pointer estimatedMean, Pointer estimatedVariance, double epsilon) {
        return JCudnn.checkResult(JCudnn.cudnnBatchNormalizationForwardInferenceNative(handle, mode, alpha, beta, xDesc, x, yDesc, y, bnScaleBiasMeanVarDesc, bnScale, bnBias, estimatedMean, estimatedVariance, epsilon));
    }

    private static native int cudnnBatchNormalizationForwardInferenceNative(cudnnHandle var0, int var1, Pointer var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, cudnnTensorDescriptor var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, double var13);

    public static int cudnnBatchNormalizationBackward(cudnnHandle handle, int mode, Pointer alphaDataDiff, Pointer betaDataDiff, Pointer alphaParamDiff, Pointer betaParamDiff, cudnnTensorDescriptor xDesc, Pointer x, cudnnTensorDescriptor dyDesc, Pointer dy, cudnnTensorDescriptor dxDesc, Pointer dx, cudnnTensorDescriptor dBnScaleBiasDesc, Pointer bnScale, Pointer dBnScaleResult, Pointer dBnBiasResult, double epsilon, Pointer savedMean, Pointer savedInvVariance) {
        return JCudnn.checkResult(JCudnn.cudnnBatchNormalizationBackwardNative(handle, mode, alphaDataDiff, betaDataDiff, alphaParamDiff, betaParamDiff, xDesc, x, dyDesc, dy, dxDesc, dx, dBnScaleBiasDesc, bnScale, dBnScaleResult, dBnBiasResult, epsilon, savedMean, savedInvVariance));
    }

    private static native int cudnnBatchNormalizationBackwardNative(cudnnHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, cudnnTensorDescriptor var8, Pointer var9, cudnnTensorDescriptor var10, Pointer var11, cudnnTensorDescriptor var12, Pointer var13, Pointer var14, Pointer var15, double var16, Pointer var18, Pointer var19);

    public static int cudnnBatchNormalizationBackwardEx(cudnnHandle handle, int mode, int bnOps, Pointer alphaDataDiff, Pointer betaDataDiff, Pointer alphaParamDiff, Pointer betaParamDiff, cudnnTensorDescriptor xDesc, Pointer xData, cudnnTensorDescriptor yDesc, Pointer yData, cudnnTensorDescriptor dyDesc, Pointer dyData, cudnnTensorDescriptor dzDesc, Pointer dzData, cudnnTensorDescriptor dxDesc, Pointer dxData, cudnnTensorDescriptor dBnScaleBiasDesc, Pointer bnScaleData, Pointer bnBiasData, Pointer dBnScaleData, Pointer dBnBiasData, double epsilon, Pointer savedMean, Pointer savedInvVariance, cudnnActivationDescriptor activationDesc, Pointer workSpace, long workSpaceSizeInBytes, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnBatchNormalizationBackwardExNative(handle, mode, bnOps, alphaDataDiff, betaDataDiff, alphaParamDiff, betaParamDiff, xDesc, xData, yDesc, yData, dyDesc, dyData, dzDesc, dzData, dxDesc, dxData, dBnScaleBiasDesc, bnScaleData, bnBiasData, dBnScaleData, dBnBiasData, epsilon, savedMean, savedInvVariance, activationDesc, workSpace, workSpaceSizeInBytes, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnBatchNormalizationBackwardExNative(cudnnHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, cudnnTensorDescriptor var9, Pointer var10, cudnnTensorDescriptor var11, Pointer var12, cudnnTensorDescriptor var13, Pointer var14, cudnnTensorDescriptor var15, Pointer var16, cudnnTensorDescriptor var17, Pointer var18, Pointer var19, Pointer var20, Pointer var21, double var22, Pointer var24, Pointer var25, cudnnActivationDescriptor var26, Pointer var27, long var28, Pointer var30, long var31);

    public static int cudnnCreateSpatialTransformerDescriptor(cudnnSpatialTransformerDescriptor stDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateSpatialTransformerDescriptorNative(stDesc));
    }

    private static native int cudnnCreateSpatialTransformerDescriptorNative(cudnnSpatialTransformerDescriptor var0);

    public static int cudnnSetSpatialTransformerNdDescriptor(cudnnSpatialTransformerDescriptor stDesc, int samplerType, int dataType, int nbDims, int[] dimA) {
        return JCudnn.checkResult(JCudnn.cudnnSetSpatialTransformerNdDescriptorNative(stDesc, samplerType, dataType, nbDims, dimA));
    }

    private static native int cudnnSetSpatialTransformerNdDescriptorNative(cudnnSpatialTransformerDescriptor var0, int var1, int var2, int var3, int[] var4);

    public static int cudnnDestroySpatialTransformerDescriptor(cudnnSpatialTransformerDescriptor stDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroySpatialTransformerDescriptorNative(stDesc));
    }

    private static native int cudnnDestroySpatialTransformerDescriptorNative(cudnnSpatialTransformerDescriptor var0);

    public static int cudnnSpatialTfGridGeneratorForward(cudnnHandle handle, cudnnSpatialTransformerDescriptor stDesc, Pointer theta, Pointer grid) {
        return JCudnn.checkResult(JCudnn.cudnnSpatialTfGridGeneratorForwardNative(handle, stDesc, theta, grid));
    }

    private static native int cudnnSpatialTfGridGeneratorForwardNative(cudnnHandle var0, cudnnSpatialTransformerDescriptor var1, Pointer var2, Pointer var3);

    public static int cudnnSpatialTfGridGeneratorBackward(cudnnHandle handle, cudnnSpatialTransformerDescriptor stDesc, Pointer dgrid, Pointer dtheta) {
        return JCudnn.checkResult(JCudnn.cudnnSpatialTfGridGeneratorBackwardNative(handle, stDesc, dgrid, dtheta));
    }

    private static native int cudnnSpatialTfGridGeneratorBackwardNative(cudnnHandle var0, cudnnSpatialTransformerDescriptor var1, Pointer var2, Pointer var3);

    public static int cudnnSpatialTfSamplerForward(cudnnHandle handle, cudnnSpatialTransformerDescriptor stDesc, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer grid, Pointer beta, cudnnTensorDescriptor yDesc, Pointer y) {
        return JCudnn.checkResult(JCudnn.cudnnSpatialTfSamplerForwardNative(handle, stDesc, alpha, xDesc, x, grid, beta, yDesc, y));
    }

    private static native int cudnnSpatialTfSamplerForwardNative(cudnnHandle var0, cudnnSpatialTransformerDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, Pointer var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8);

    public static int cudnnSpatialTfSamplerBackward(cudnnHandle handle, cudnnSpatialTransformerDescriptor stDesc, Pointer alpha, cudnnTensorDescriptor xDesc, Pointer x, Pointer beta, cudnnTensorDescriptor dxDesc, Pointer dx, Pointer alphaDgrid, cudnnTensorDescriptor dyDesc, Pointer dy, Pointer grid, Pointer betaDgrid, Pointer dgrid) {
        return JCudnn.checkResult(JCudnn.cudnnSpatialTfSamplerBackwardNative(handle, stDesc, alpha, xDesc, x, beta, dxDesc, dx, alphaDgrid, dyDesc, dy, grid, betaDgrid, dgrid));
    }

    private static native int cudnnSpatialTfSamplerBackwardNative(cudnnHandle var0, cudnnSpatialTransformerDescriptor var1, Pointer var2, cudnnTensorDescriptor var3, Pointer var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, Pointer var8, cudnnTensorDescriptor var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13);

    public static int cudnnCreateDropoutDescriptor(cudnnDropoutDescriptor dropoutDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateDropoutDescriptorNative(dropoutDesc));
    }

    private static native int cudnnCreateDropoutDescriptorNative(cudnnDropoutDescriptor var0);

    public static int cudnnDestroyDropoutDescriptor(cudnnDropoutDescriptor dropoutDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyDropoutDescriptorNative(dropoutDesc));
    }

    private static native int cudnnDestroyDropoutDescriptorNative(cudnnDropoutDescriptor var0);

    public static int cudnnDropoutGetStatesSize(cudnnHandle handle, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnDropoutGetStatesSizeNative(handle, sizeInBytes));
    }

    private static native int cudnnDropoutGetStatesSizeNative(cudnnHandle var0, long[] var1);

    public static int cudnnDropoutGetReserveSpaceSize(cudnnTensorDescriptor xdesc, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnDropoutGetReserveSpaceSizeNative(xdesc, sizeInBytes));
    }

    private static native int cudnnDropoutGetReserveSpaceSizeNative(cudnnTensorDescriptor var0, long[] var1);

    public static int cudnnSetDropoutDescriptor(cudnnDropoutDescriptor dropoutDesc, cudnnHandle handle, float dropout, Pointer states, long stateSizeInBytes, long seed) {
        return JCudnn.checkResult(JCudnn.cudnnSetDropoutDescriptorNative(dropoutDesc, handle, dropout, states, stateSizeInBytes, seed));
    }

    private static native int cudnnSetDropoutDescriptorNative(cudnnDropoutDescriptor var0, cudnnHandle var1, float var2, Pointer var3, long var4, long var6);

    public static int cudnnRestoreDropoutDescriptor(cudnnDropoutDescriptor dropoutDesc, cudnnHandle handle, float dropout, Pointer states, long stateSizeInBytes, long seed) {
        return JCudnn.checkResult(JCudnn.cudnnRestoreDropoutDescriptorNative(dropoutDesc, handle, dropout, states, stateSizeInBytes, seed));
    }

    private static native int cudnnRestoreDropoutDescriptorNative(cudnnDropoutDescriptor var0, cudnnHandle var1, float var2, Pointer var3, long var4, long var6);

    public static int cudnnGetDropoutDescriptor(cudnnDropoutDescriptor dropoutDesc, cudnnHandle handle, float[] dropout, Pointer states, long[] seed) {
        return JCudnn.checkResult(JCudnn.cudnnGetDropoutDescriptorNative(dropoutDesc, handle, dropout, states, seed));
    }

    private static native int cudnnGetDropoutDescriptorNative(cudnnDropoutDescriptor var0, cudnnHandle var1, float[] var2, Pointer var3, long[] var4);

    public static int cudnnDropoutForward(cudnnHandle handle, cudnnDropoutDescriptor dropoutDesc, cudnnTensorDescriptor xdesc, Pointer x, cudnnTensorDescriptor ydesc, Pointer y, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnDropoutForwardNative(handle, dropoutDesc, xdesc, x, ydesc, y, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnDropoutForwardNative(cudnnHandle var0, cudnnDropoutDescriptor var1, cudnnTensorDescriptor var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, Pointer var6, long var7);

    public static int cudnnDropoutBackward(cudnnHandle handle, cudnnDropoutDescriptor dropoutDesc, cudnnTensorDescriptor dydesc, Pointer dy, cudnnTensorDescriptor dxdesc, Pointer dx, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnDropoutBackwardNative(handle, dropoutDesc, dydesc, dy, dxdesc, dx, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnDropoutBackwardNative(cudnnHandle var0, cudnnDropoutDescriptor var1, cudnnTensorDescriptor var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, Pointer var6, long var7);

    public static int cudnnCreateRNNDescriptor(cudnnRNNDescriptor rnnDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateRNNDescriptorNative(rnnDesc));
    }

    private static native int cudnnCreateRNNDescriptorNative(cudnnRNNDescriptor var0);

    public static int cudnnDestroyRNNDescriptor(cudnnRNNDescriptor rnnDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyRNNDescriptorNative(rnnDesc));
    }

    private static native int cudnnDestroyRNNDescriptorNative(cudnnRNNDescriptor var0);

    public static int cudnnGetRNNForwardInferenceAlgorithmMaxCount(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int[] count) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNForwardInferenceAlgorithmMaxCountNative(handle, rnnDesc, count));
    }

    private static native int cudnnGetRNNForwardInferenceAlgorithmMaxCountNative(cudnnHandle var0, cudnnRNNDescriptor var1, int[] var2);

    public static int cudnnFindRNNForwardInferenceAlgorithmEx(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor[] xDesc, Pointer x, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnTensorDescriptor cxDesc, Pointer cx, cudnnFilterDescriptor wDesc, Pointer w, cudnnTensorDescriptor[] yDesc, Pointer y, cudnnTensorDescriptor hyDesc, Pointer hy, cudnnTensorDescriptor cyDesc, Pointer cy, float findIntensity, int requestedAlgoCount, int[] returnedAlgoCount, cudnnAlgorithmPerformance[] perfResults, Pointer workspace, long workSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnFindRNNForwardInferenceAlgorithmExNative(handle, rnnDesc, seqLength, xDesc, x, hxDesc, hx, cxDesc, cx, wDesc, w, yDesc, y, hyDesc, hy, cyDesc, cy, findIntensity, requestedAlgoCount, returnedAlgoCount, perfResults, workspace, workSpaceSizeInBytes));
    }

    private static native int cudnnFindRNNForwardInferenceAlgorithmExNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor[] var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, cudnnFilterDescriptor var9, Pointer var10, cudnnTensorDescriptor[] var11, Pointer var12, cudnnTensorDescriptor var13, Pointer var14, cudnnTensorDescriptor var15, Pointer var16, float var17, int var18, int[] var19, cudnnAlgorithmPerformance[] var20, Pointer var21, long var22);

    public static int cudnnGetRNNForwardTrainingAlgorithmMaxCount(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int[] count) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNForwardTrainingAlgorithmMaxCountNative(handle, rnnDesc, count));
    }

    private static native int cudnnGetRNNForwardTrainingAlgorithmMaxCountNative(cudnnHandle var0, cudnnRNNDescriptor var1, int[] var2);

    public static int cudnnFindRNNForwardTrainingAlgorithmEx(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor[] xDesc, Pointer x, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnTensorDescriptor cxDesc, Pointer cx, cudnnFilterDescriptor wDesc, Pointer w, cudnnTensorDescriptor[] yDesc, Pointer y, cudnnTensorDescriptor hyDesc, Pointer hy, cudnnTensorDescriptor cyDesc, Pointer cy, float findIntensity, int requestedAlgoCount, int[] returnedAlgoCount, cudnnAlgorithmPerformance[] perfResults, Pointer workspace, long workSpaceSizeInBytes, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnFindRNNForwardTrainingAlgorithmExNative(handle, rnnDesc, seqLength, xDesc, x, hxDesc, hx, cxDesc, cx, wDesc, w, yDesc, y, hyDesc, hy, cyDesc, cy, findIntensity, requestedAlgoCount, returnedAlgoCount, perfResults, workspace, workSpaceSizeInBytes, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnFindRNNForwardTrainingAlgorithmExNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor[] var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, cudnnFilterDescriptor var9, Pointer var10, cudnnTensorDescriptor[] var11, Pointer var12, cudnnTensorDescriptor var13, Pointer var14, cudnnTensorDescriptor var15, Pointer var16, float var17, int var18, int[] var19, cudnnAlgorithmPerformance[] var20, Pointer var21, long var22, Pointer var24, long var25);

    public static int cudnnGetRNNBackwardDataAlgorithmMaxCount(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int[] count) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNBackwardDataAlgorithmMaxCountNative(handle, rnnDesc, count));
    }

    private static native int cudnnGetRNNBackwardDataAlgorithmMaxCountNative(cudnnHandle var0, cudnnRNNDescriptor var1, int[] var2);

    public static int cudnnFindRNNBackwardDataAlgorithmEx(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor[] yDesc, Pointer y, cudnnTensorDescriptor[] dyDesc, Pointer dy, cudnnTensorDescriptor dhyDesc, Pointer dhy, cudnnTensorDescriptor dcyDesc, Pointer dcy, cudnnFilterDescriptor wDesc, Pointer w, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnTensorDescriptor cxDesc, Pointer cx, cudnnTensorDescriptor[] dxDesc, Pointer dx, cudnnTensorDescriptor dhxDesc, Pointer dhx, cudnnTensorDescriptor dcxDesc, Pointer dcx, float findIntensity, int requestedAlgoCount, int[] returnedAlgoCount, cudnnAlgorithmPerformance[] perfResults, Pointer workspace, long workSpaceSizeInBytes, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnFindRNNBackwardDataAlgorithmExNative(handle, rnnDesc, seqLength, yDesc, y, dyDesc, dy, dhyDesc, dhy, dcyDesc, dcy, wDesc, w, hxDesc, hx, cxDesc, cx, dxDesc, dx, dhxDesc, dhx, dcxDesc, dcx, findIntensity, requestedAlgoCount, returnedAlgoCount, perfResults, workspace, workSpaceSizeInBytes, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnFindRNNBackwardDataAlgorithmExNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor[] var3, Pointer var4, cudnnTensorDescriptor[] var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, cudnnTensorDescriptor var9, Pointer var10, cudnnFilterDescriptor var11, Pointer var12, cudnnTensorDescriptor var13, Pointer var14, cudnnTensorDescriptor var15, Pointer var16, cudnnTensorDescriptor[] var17, Pointer var18, cudnnTensorDescriptor var19, Pointer var20, cudnnTensorDescriptor var21, Pointer var22, float var23, int var24, int[] var25, cudnnAlgorithmPerformance[] var26, Pointer var27, long var28, Pointer var30, long var31);

    public static int cudnnGetRNNBackwardWeightsAlgorithmMaxCount(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int[] count) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNBackwardWeightsAlgorithmMaxCountNative(handle, rnnDesc, count));
    }

    private static native int cudnnGetRNNBackwardWeightsAlgorithmMaxCountNative(cudnnHandle var0, cudnnRNNDescriptor var1, int[] var2);

    public static int cudnnFindRNNBackwardWeightsAlgorithmEx(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor[] xDesc, Pointer x, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnTensorDescriptor[] yDesc, Pointer y, float findIntensity, int requestedAlgoCount, int[] returnedAlgoCount, cudnnAlgorithmPerformance[] perfResults, Pointer workspace, long workSpaceSizeInBytes, cudnnFilterDescriptor dwDesc, Pointer dw, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnFindRNNBackwardWeightsAlgorithmExNative(handle, rnnDesc, seqLength, xDesc, x, hxDesc, hx, yDesc, y, findIntensity, requestedAlgoCount, returnedAlgoCount, perfResults, workspace, workSpaceSizeInBytes, dwDesc, dw, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnFindRNNBackwardWeightsAlgorithmExNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor[] var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6, cudnnTensorDescriptor[] var7, Pointer var8, float var9, int var10, int[] var11, cudnnAlgorithmPerformance[] var12, Pointer var13, long var14, cudnnFilterDescriptor var16, Pointer var17, Pointer var18, long var19);

    public static int cudnnCreatePersistentRNNPlan(cudnnRNNDescriptor rnnDesc, int minibatch, int dataType, cudnnPersistentRNNPlan plan) {
        return JCudnn.checkResult(JCudnn.cudnnCreatePersistentRNNPlanNative(rnnDesc, minibatch, dataType, plan));
    }

    private static native int cudnnCreatePersistentRNNPlanNative(cudnnRNNDescriptor var0, int var1, int var2, cudnnPersistentRNNPlan var3);

    public static int cudnnSetPersistentRNNPlan(cudnnRNNDescriptor rnnDesc, cudnnPersistentRNNPlan plan) {
        return JCudnn.checkResult(JCudnn.cudnnSetPersistentRNNPlanNative(rnnDesc, plan));
    }

    private static native int cudnnSetPersistentRNNPlanNative(cudnnRNNDescriptor var0, cudnnPersistentRNNPlan var1);

    public static int cudnnDestroyPersistentRNNPlan(cudnnPersistentRNNPlan plan) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyPersistentRNNPlanNative(plan));
    }

    private static native int cudnnDestroyPersistentRNNPlanNative(cudnnPersistentRNNPlan var0);

    public static int cudnnSetRNNDescriptor(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int hiddenSize, int numLayers, cudnnDropoutDescriptor dropoutDesc, int inputMode, int direction, int mode, int algo, int dataType) {
        return JCudnn.checkResult(JCudnn.cudnnSetRNNDescriptorNative(handle, rnnDesc, hiddenSize, numLayers, dropoutDesc, inputMode, direction, mode, algo, dataType));
    }

    private static native int cudnnSetRNNDescriptorNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, int var3, cudnnDropoutDescriptor var4, int var5, int var6, int var7, int var8, int var9);

    public static int cudnnSetRNNProjectionLayers(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int recProjSize, int outProjSize) {
        return JCudnn.checkResult(JCudnn.cudnnSetRNNProjectionLayersNative(handle, rnnDesc, recProjSize, outProjSize));
    }

    private static native int cudnnSetRNNProjectionLayersNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, int var3);

    public static int cudnnGetRNNProjectionLayers(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int[] recProjSize, int[] outProjSize) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNProjectionLayersNative(handle, rnnDesc, recProjSize, outProjSize));
    }

    private static native int cudnnGetRNNProjectionLayersNative(cudnnHandle var0, cudnnRNNDescriptor var1, int[] var2, int[] var3);

    public static int cudnnSetRNNAlgorithmDescriptor(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, cudnnAlgorithmDescriptor algoDesc) {
        return JCudnn.checkResult(JCudnn.cudnnSetRNNAlgorithmDescriptorNative(handle, rnnDesc, algoDesc));
    }

    private static native int cudnnSetRNNAlgorithmDescriptorNative(cudnnHandle var0, cudnnRNNDescriptor var1, cudnnAlgorithmDescriptor var2);

    public static int cudnnGetRNNDescriptor(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int[] hiddenSize, int[] numLayers, cudnnDropoutDescriptor dropoutDesc, int[] inputMode, int[] direction, int[] mode, int[] algo, int[] dataType) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNDescriptorNative(handle, rnnDesc, hiddenSize, numLayers, dropoutDesc, inputMode, direction, mode, algo, dataType));
    }

    private static native int cudnnGetRNNDescriptorNative(cudnnHandle var0, cudnnRNNDescriptor var1, int[] var2, int[] var3, cudnnDropoutDescriptor var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9);

    public static int cudnnSetRNNMatrixMathType(cudnnRNNDescriptor rnnDesc, int mType) {
        return JCudnn.checkResult(JCudnn.cudnnSetRNNMatrixMathTypeNative(rnnDesc, mType));
    }

    private static native int cudnnSetRNNMatrixMathTypeNative(cudnnRNNDescriptor var0, int var1);

    public static int cudnnGetRNNMatrixMathType(cudnnRNNDescriptor rnnDesc, int[] mType) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNMatrixMathTypeNative(rnnDesc, mType));
    }

    private static native int cudnnGetRNNMatrixMathTypeNative(cudnnRNNDescriptor var0, int[] var1);

    public static int cudnnGetRNNWorkspaceSize(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor[] xDesc, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNWorkspaceSizeNative(handle, rnnDesc, seqLength, xDesc, sizeInBytes));
    }

    private static native int cudnnGetRNNWorkspaceSizeNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor[] var3, long[] var4);

    public static int cudnnGetRNNTrainingReserveSize(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor[] xDesc, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNTrainingReserveSizeNative(handle, rnnDesc, seqLength, xDesc, sizeInBytes));
    }

    private static native int cudnnGetRNNTrainingReserveSizeNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor[] var3, long[] var4);

    public static int cudnnGetRNNParamsSize(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, cudnnTensorDescriptor xDesc, long[] sizeInBytes, int dataType) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNParamsSizeNative(handle, rnnDesc, xDesc, sizeInBytes, dataType));
    }

    private static native int cudnnGetRNNParamsSizeNative(cudnnHandle var0, cudnnRNNDescriptor var1, cudnnTensorDescriptor var2, long[] var3, int var4);

    public static int cudnnGetRNNLinLayerMatrixParams(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int pseudoLayer, cudnnTensorDescriptor xDesc, cudnnFilterDescriptor wDesc, Pointer w, int linLayerID, cudnnFilterDescriptor linLayerMatDesc, Pointer linLayerMat) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNLinLayerMatrixParamsNative(handle, rnnDesc, pseudoLayer, xDesc, wDesc, w, linLayerID, linLayerMatDesc, linLayerMat));
    }

    private static native int cudnnGetRNNLinLayerMatrixParamsNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor var3, cudnnFilterDescriptor var4, Pointer var5, int var6, cudnnFilterDescriptor var7, Pointer var8);

    public static int cudnnGetRNNLinLayerBiasParams(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int pseudoLayer, cudnnTensorDescriptor xDesc, cudnnFilterDescriptor wDesc, Pointer w, int linLayerID, cudnnFilterDescriptor linLayerBiasDesc, Pointer linLayerBias) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNLinLayerBiasParamsNative(handle, rnnDesc, pseudoLayer, xDesc, wDesc, w, linLayerID, linLayerBiasDesc, linLayerBias));
    }

    private static native int cudnnGetRNNLinLayerBiasParamsNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor var3, cudnnFilterDescriptor var4, Pointer var5, int var6, cudnnFilterDescriptor var7, Pointer var8);

    public static int cudnnRNNForwardInference(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor[] xDesc, Pointer x, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnTensorDescriptor cxDesc, Pointer cx, cudnnFilterDescriptor wDesc, Pointer w, cudnnTensorDescriptor[] yDesc, Pointer y, cudnnTensorDescriptor hyDesc, Pointer hy, cudnnTensorDescriptor cyDesc, Pointer cy, Pointer workspace, long workSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnRNNForwardInferenceNative(handle, rnnDesc, seqLength, xDesc, x, hxDesc, hx, cxDesc, cx, wDesc, w, yDesc, y, hyDesc, hy, cyDesc, cy, workspace, workSpaceSizeInBytes));
    }

    private static native int cudnnRNNForwardInferenceNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor[] var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, cudnnFilterDescriptor var9, Pointer var10, cudnnTensorDescriptor[] var11, Pointer var12, cudnnTensorDescriptor var13, Pointer var14, cudnnTensorDescriptor var15, Pointer var16, Pointer var17, long var18);

    public static int cudnnRNNForwardTraining(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor[] xDesc, Pointer x, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnTensorDescriptor cxDesc, Pointer cx, cudnnFilterDescriptor wDesc, Pointer w, cudnnTensorDescriptor[] yDesc, Pointer y, cudnnTensorDescriptor hyDesc, Pointer hy, cudnnTensorDescriptor cyDesc, Pointer cy, Pointer workspace, long workSpaceSizeInBytes, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnRNNForwardTrainingNative(handle, rnnDesc, seqLength, xDesc, x, hxDesc, hx, cxDesc, cx, wDesc, w, yDesc, y, hyDesc, hy, cyDesc, cy, workspace, workSpaceSizeInBytes, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnRNNForwardTrainingNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor[] var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, cudnnFilterDescriptor var9, Pointer var10, cudnnTensorDescriptor[] var11, Pointer var12, cudnnTensorDescriptor var13, Pointer var14, cudnnTensorDescriptor var15, Pointer var16, Pointer var17, long var18, Pointer var20, long var21);

    public static int cudnnRNNBackwardData(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor[] yDesc, Pointer y, cudnnTensorDescriptor[] dyDesc, Pointer dy, cudnnTensorDescriptor dhyDesc, Pointer dhy, cudnnTensorDescriptor dcyDesc, Pointer dcy, cudnnFilterDescriptor wDesc, Pointer w, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnTensorDescriptor cxDesc, Pointer cx, cudnnTensorDescriptor[] dxDesc, Pointer dx, cudnnTensorDescriptor dhxDesc, Pointer dhx, cudnnTensorDescriptor dcxDesc, Pointer dcx, Pointer workspace, long workSpaceSizeInBytes, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnRNNBackwardDataNative(handle, rnnDesc, seqLength, yDesc, y, dyDesc, dy, dhyDesc, dhy, dcyDesc, dcy, wDesc, w, hxDesc, hx, cxDesc, cx, dxDesc, dx, dhxDesc, dhx, dcxDesc, dcx, workspace, workSpaceSizeInBytes, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnRNNBackwardDataNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor[] var3, Pointer var4, cudnnTensorDescriptor[] var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, cudnnTensorDescriptor var9, Pointer var10, cudnnFilterDescriptor var11, Pointer var12, cudnnTensorDescriptor var13, Pointer var14, cudnnTensorDescriptor var15, Pointer var16, cudnnTensorDescriptor[] var17, Pointer var18, cudnnTensorDescriptor var19, Pointer var20, cudnnTensorDescriptor var21, Pointer var22, Pointer var23, long var24, Pointer var26, long var27);

    public static int cudnnRNNBackwardWeights(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int seqLength, cudnnTensorDescriptor[] xDesc, Pointer x, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnTensorDescriptor[] yDesc, Pointer y, Pointer workspace, long workSpaceSizeInBytes, cudnnFilterDescriptor dwDesc, Pointer dw, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnRNNBackwardWeightsNative(handle, rnnDesc, seqLength, xDesc, x, hxDesc, hx, yDesc, y, workspace, workSpaceSizeInBytes, dwDesc, dw, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnRNNBackwardWeightsNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, cudnnTensorDescriptor[] var3, Pointer var4, cudnnTensorDescriptor var5, Pointer var6, cudnnTensorDescriptor[] var7, Pointer var8, Pointer var9, long var10, cudnnFilterDescriptor var12, Pointer var13, Pointer var14, long var15);

    public static int cudnnCreateCTCLossDescriptor(cudnnCTCLossDescriptor ctcLossDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateCTCLossDescriptorNative(ctcLossDesc));
    }

    private static native int cudnnCreateCTCLossDescriptorNative(cudnnCTCLossDescriptor var0);

    public static int cudnnSetCTCLossDescriptor(cudnnCTCLossDescriptor ctcLossDesc, int compType) {
        return JCudnn.checkResult(JCudnn.cudnnSetCTCLossDescriptorNative(ctcLossDesc, compType));
    }

    private static native int cudnnSetCTCLossDescriptorNative(cudnnCTCLossDescriptor var0, int var1);

    public static int cudnnGetCTCLossDescriptor(cudnnCTCLossDescriptor ctcLossDesc, int[] compType) {
        return JCudnn.checkResult(JCudnn.cudnnGetCTCLossDescriptorNative(ctcLossDesc, compType));
    }

    private static native int cudnnGetCTCLossDescriptorNative(cudnnCTCLossDescriptor var0, int[] var1);

    public static int cudnnDestroyCTCLossDescriptor(cudnnCTCLossDescriptor ctcLossDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyCTCLossDescriptorNative(ctcLossDesc));
    }

    private static native int cudnnDestroyCTCLossDescriptorNative(cudnnCTCLossDescriptor var0);

    public static int cudnnCTCLoss(cudnnHandle handle, cudnnTensorDescriptor probsDesc, Pointer probs, int[] labels, int[] labelLengths, int[] inputLengths, Pointer costs, cudnnTensorDescriptor gradientsDesc, Pointer gradients, int algo, cudnnCTCLossDescriptor ctcLossDesc, Pointer workspace, long workSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnCTCLossNative(handle, probsDesc, probs, labels, labelLengths, inputLengths, costs, gradientsDesc, gradients, algo, ctcLossDesc, workspace, workSpaceSizeInBytes));
    }

    private static native int cudnnCTCLossNative(cudnnHandle var0, cudnnTensorDescriptor var1, Pointer var2, int[] var3, int[] var4, int[] var5, Pointer var6, cudnnTensorDescriptor var7, Pointer var8, int var9, cudnnCTCLossDescriptor var10, Pointer var11, long var12);

    public static int cudnnGetCTCLossWorkspaceSize(cudnnHandle handle, cudnnTensorDescriptor probsDesc, cudnnTensorDescriptor gradientsDesc, int[] labels, int[] labelLengths, int[] inputLengths, int algo, cudnnCTCLossDescriptor ctcLossDesc, long[] sizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetCTCLossWorkspaceSizeNative(handle, probsDesc, gradientsDesc, labels, labelLengths, inputLengths, algo, ctcLossDesc, sizeInBytes));
    }

    private static native int cudnnGetCTCLossWorkspaceSizeNative(cudnnHandle var0, cudnnTensorDescriptor var1, cudnnTensorDescriptor var2, int[] var3, int[] var4, int[] var5, int var6, cudnnCTCLossDescriptor var7, long[] var8);

    public static int cudnnCreateAlgorithmDescriptor(cudnnAlgorithmDescriptor algoDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateAlgorithmDescriptorNative(algoDesc));
    }

    private static native int cudnnCreateAlgorithmDescriptorNative(cudnnAlgorithmDescriptor var0);

    public static int cudnnSetAlgorithmDescriptor(cudnnAlgorithmDescriptor algoDesc, int algorithm) {
        return JCudnn.checkResult(JCudnn.cudnnSetAlgorithmDescriptorNative(algoDesc, algorithm));
    }

    private static native int cudnnSetAlgorithmDescriptorNative(cudnnAlgorithmDescriptor var0, int var1);

    public static int cudnnGetAlgorithmDescriptor(cudnnAlgorithmDescriptor algoDesc, int[] algorithm) {
        return JCudnn.checkResult(JCudnn.cudnnGetAlgorithmDescriptorNative(algoDesc, algorithm));
    }

    private static native int cudnnGetAlgorithmDescriptorNative(cudnnAlgorithmDescriptor var0, int[] var1);

    public static int cudnnCopyAlgorithmDescriptor(cudnnAlgorithmDescriptor src, cudnnAlgorithmDescriptor dest) {
        return JCudnn.checkResult(JCudnn.cudnnCopyAlgorithmDescriptorNative(src, dest));
    }

    private static native int cudnnCopyAlgorithmDescriptorNative(cudnnAlgorithmDescriptor var0, cudnnAlgorithmDescriptor var1);

    public static int cudnnDestroyAlgorithmDescriptor(cudnnAlgorithmDescriptor algoDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyAlgorithmDescriptorNative(algoDesc));
    }

    private static native int cudnnDestroyAlgorithmDescriptorNative(cudnnAlgorithmDescriptor var0);

    public static int cudnnCreateAlgorithmPerformance(cudnnAlgorithmPerformance[] algoPerf, int numberToCreate) {
        return JCudnn.checkResult(JCudnn.cudnnCreateAlgorithmPerformanceNative(algoPerf, numberToCreate));
    }

    private static native int cudnnCreateAlgorithmPerformanceNative(cudnnAlgorithmPerformance[] var0, int var1);

    public static int cudnnSetAlgorithmPerformance(cudnnAlgorithmPerformance algoPerf, cudnnAlgorithmDescriptor algoDesc, int status, float time, long memory) {
        return JCudnn.checkResult(JCudnn.cudnnSetAlgorithmPerformanceNative(algoPerf, algoDesc, status, time, memory));
    }

    private static native int cudnnSetAlgorithmPerformanceNative(cudnnAlgorithmPerformance var0, cudnnAlgorithmDescriptor var1, int var2, float var3, long var4);

    public static int cudnnGetAlgorithmPerformance(cudnnAlgorithmPerformance algoPerf, cudnnAlgorithmDescriptor algoDesc, int[] status, float[] time, long[] memory) {
        return JCudnn.checkResult(JCudnn.cudnnGetAlgorithmPerformanceNative(algoPerf, algoDesc, status, time, memory));
    }

    private static native int cudnnGetAlgorithmPerformanceNative(cudnnAlgorithmPerformance var0, cudnnAlgorithmDescriptor var1, int[] var2, float[] var3, long[] var4);

    public static int cudnnDestroyAlgorithmPerformance(cudnnAlgorithmPerformance[] algoPerf, int numberToDestroy) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyAlgorithmPerformanceNative(algoPerf, numberToDestroy));
    }

    private static native int cudnnDestroyAlgorithmPerformanceNative(cudnnAlgorithmPerformance[] var0, int var1);

    public static int cudnnGetAlgorithmSpaceSize(cudnnHandle handle, cudnnAlgorithmDescriptor algoDesc, long[] algoSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnGetAlgorithmSpaceSizeNative(handle, algoDesc, algoSpaceSizeInBytes));
    }

    private static native int cudnnGetAlgorithmSpaceSizeNative(cudnnHandle var0, cudnnAlgorithmDescriptor var1, long[] var2);

    public static int cudnnSaveAlgorithm(cudnnHandle handle, cudnnAlgorithmDescriptor algoDesc, Pointer algoSpace, long algoSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnSaveAlgorithmNative(handle, algoDesc, algoSpace, algoSpaceSizeInBytes));
    }

    private static native int cudnnSaveAlgorithmNative(cudnnHandle var0, cudnnAlgorithmDescriptor var1, Pointer var2, long var3);

    public static int cudnnRestoreAlgorithm(cudnnHandle handle, Pointer algoSpace, long algoSpaceSizeInBytes, cudnnAlgorithmDescriptor algoDesc) {
        return JCudnn.checkResult(JCudnn.cudnnRestoreAlgorithmNative(handle, algoSpace, algoSpaceSizeInBytes, algoDesc));
    }

    private static native int cudnnRestoreAlgorithmNative(cudnnHandle var0, Pointer var1, long var2, cudnnAlgorithmDescriptor var4);

    public static int cudnnRNNSetClip(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int clipMode, int clipNanOpt, double lclip, double rclip) {
        return JCudnn.checkResult(JCudnn.cudnnRNNSetClipNative(handle, rnnDesc, clipMode, clipNanOpt, lclip, rclip));
    }

    private static native int cudnnRNNSetClipNative(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, int var3, double var4, double var6);

    public static int cudnnRNNGetClip(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int[] clipMode, int[] clipNanOpt, double[] lclip, double[] rclip) {
        return JCudnn.checkResult(JCudnn.cudnnRNNGetClipNative(handle, rnnDesc, clipMode, clipNanOpt, lclip, rclip));
    }

    private static native int cudnnRNNGetClipNative(cudnnHandle var0, cudnnRNNDescriptor var1, int[] var2, int[] var3, double[] var4, double[] var5);

    public static int cudnnSetCallback(int mask, Object udata, cudnnCallback fptr) {
        return JCudnn.checkResult(JCudnn.cudnnSetCallbackNative(mask, udata, fptr));
    }

    private static native int cudnnSetCallbackNative(int var0, Object var1, cudnnCallback var2);

    public static int cudnnGetCallback(int[] mask, Object udata, cudnnCallback[] fptr) {
        return JCudnn.checkResult(JCudnn.cudnnGetCallbackNative(mask, udata, fptr));
    }

    private static native int cudnnGetCallbackNative(int[] var0, Object var1, cudnnCallback[] var2);

    public static int cudnnSetRNNPaddingMode(cudnnRNNDescriptor rnnDesc, int paddingMode) {
        return JCudnn.checkResult(JCudnn.cudnnSetRNNPaddingModeNative(rnnDesc, paddingMode));
    }

    private static native int cudnnSetRNNPaddingModeNative(cudnnRNNDescriptor var0, int var1);

    public static int cudnnGetRNNPaddingMode(cudnnRNNDescriptor rnnDesc, int[] paddingMode) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNPaddingModeNative(rnnDesc, paddingMode));
    }

    private static native int cudnnGetRNNPaddingModeNative(cudnnRNNDescriptor var0, int[] var1);

    public static int cudnnCreateRNNDataDescriptor(cudnnRNNDataDescriptor RNNDataDesc) {
        return JCudnn.checkResult(JCudnn.cudnnCreateRNNDataDescriptorNative(RNNDataDesc));
    }

    private static native int cudnnCreateRNNDataDescriptorNative(cudnnRNNDataDescriptor var0);

    public static int cudnnDestroyRNNDataDescriptor(cudnnRNNDataDescriptor RNNDataDesc) {
        return JCudnn.checkResult(JCudnn.cudnnDestroyRNNDataDescriptorNative(RNNDataDesc));
    }

    private static native int cudnnDestroyRNNDataDescriptorNative(cudnnRNNDataDescriptor var0);

    public static int cudnnSetRNNDataDescriptor(cudnnRNNDataDescriptor RNNDataDesc, int dataType, int layout, int maxSeqLength, int batchSize, int vectorSize, int[] seqLengthArray, Pointer paddingFill) {
        return JCudnn.checkResult(JCudnn.cudnnSetRNNDataDescriptorNative(RNNDataDesc, dataType, layout, maxSeqLength, batchSize, vectorSize, seqLengthArray, paddingFill));
    }

    private static native int cudnnSetRNNDataDescriptorNative(cudnnRNNDataDescriptor var0, int var1, int var2, int var3, int var4, int var5, int[] var6, Pointer var7);

    public static int cudnnGetRNNDataDescriptor(cudnnRNNDataDescriptor RNNDataDesc, int[] dataType, int[] layout, int[] maxSeqLength, int[] batchSize, int[] vectorSize, int arrayLengthRequested, int[] seqLengthArray, Pointer paddingFill) {
        return JCudnn.checkResult(JCudnn.cudnnGetRNNDataDescriptorNative(RNNDataDesc, dataType, layout, maxSeqLength, batchSize, vectorSize, arrayLengthRequested, seqLengthArray, paddingFill));
    }

    private static native int cudnnGetRNNDataDescriptorNative(cudnnRNNDataDescriptor var0, int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int var6, int[] var7, Pointer var8);

    public static int cudnnRNNForwardTrainingEx(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, cudnnRNNDataDescriptor xDesc, Pointer x, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnTensorDescriptor cxDesc, Pointer cx, cudnnFilterDescriptor wDesc, Pointer w, cudnnRNNDataDescriptor yDesc, Pointer y, cudnnTensorDescriptor hyDesc, Pointer hy, cudnnTensorDescriptor cyDesc, Pointer cy, cudnnRNNDataDescriptor kDesc, Pointer keys, cudnnRNNDataDescriptor cDesc, Pointer cAttn, cudnnRNNDataDescriptor iDesc, Pointer iAttn, cudnnRNNDataDescriptor qDesc, Pointer queries, Pointer workSpace, long workSpaceSizeInBytes, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnRNNForwardTrainingExNative(handle, rnnDesc, xDesc, x, hxDesc, hx, cxDesc, cx, wDesc, w, yDesc, y, hyDesc, hy, cyDesc, cy, kDesc, keys, cDesc, cAttn, iDesc, iAttn, qDesc, queries, workSpace, workSpaceSizeInBytes, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnRNNForwardTrainingExNative(cudnnHandle var0, cudnnRNNDescriptor var1, cudnnRNNDataDescriptor var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, cudnnFilterDescriptor var8, Pointer var9, cudnnRNNDataDescriptor var10, Pointer var11, cudnnTensorDescriptor var12, Pointer var13, cudnnTensorDescriptor var14, Pointer var15, cudnnRNNDataDescriptor var16, Pointer var17, cudnnRNNDataDescriptor var18, Pointer var19, cudnnRNNDataDescriptor var20, Pointer var21, cudnnRNNDataDescriptor var22, Pointer var23, Pointer var24, long var25, Pointer var27, long var28);

    public static int cudnnRNNForwardInferenceEx(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, cudnnRNNDataDescriptor xDesc, Pointer x, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnTensorDescriptor cxDesc, Pointer cx, cudnnFilterDescriptor wDesc, Pointer w, cudnnRNNDataDescriptor yDesc, Pointer y, cudnnTensorDescriptor hyDesc, Pointer hy, cudnnTensorDescriptor cyDesc, Pointer cy, cudnnRNNDataDescriptor kDesc, Pointer keys, cudnnRNNDataDescriptor cDesc, Pointer cAttn, cudnnRNNDataDescriptor iDesc, Pointer iAttn, cudnnRNNDataDescriptor qDesc, Pointer queries, Pointer workSpace, long workSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnRNNForwardInferenceExNative(handle, rnnDesc, xDesc, x, hxDesc, hx, cxDesc, cx, wDesc, w, yDesc, y, hyDesc, hy, cyDesc, cy, kDesc, keys, cDesc, cAttn, iDesc, iAttn, qDesc, queries, workSpace, workSpaceSizeInBytes));
    }

    private static native int cudnnRNNForwardInferenceExNative(cudnnHandle var0, cudnnRNNDescriptor var1, cudnnRNNDataDescriptor var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, cudnnTensorDescriptor var6, Pointer var7, cudnnFilterDescriptor var8, Pointer var9, cudnnRNNDataDescriptor var10, Pointer var11, cudnnTensorDescriptor var12, Pointer var13, cudnnTensorDescriptor var14, Pointer var15, cudnnRNNDataDescriptor var16, Pointer var17, cudnnRNNDataDescriptor var18, Pointer var19, cudnnRNNDataDescriptor var20, Pointer var21, cudnnRNNDataDescriptor var22, Pointer var23, Pointer var24, long var25);

    public static int cudnnRNNBackwardDataEx(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, cudnnRNNDataDescriptor yDesc, Pointer y, cudnnRNNDataDescriptor dyDesc, Pointer dy, cudnnRNNDataDescriptor dcDesc, Pointer dcAttn, cudnnTensorDescriptor dhyDesc, Pointer dhy, cudnnTensorDescriptor dcyDesc, Pointer dcy, cudnnFilterDescriptor wDesc, Pointer w, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnTensorDescriptor cxDesc, Pointer cx, cudnnRNNDataDescriptor dxDesc, Pointer dx, cudnnTensorDescriptor dhxDesc, Pointer dhx, cudnnTensorDescriptor dcxDesc, Pointer dcx, cudnnRNNDataDescriptor dkDesc, Pointer dkeys, Pointer workSpace, long workSpaceSizeInBytes, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnRNNBackwardDataExNative(handle, rnnDesc, yDesc, y, dyDesc, dy, dcDesc, dcAttn, dhyDesc, dhy, dcyDesc, dcy, wDesc, w, hxDesc, hx, cxDesc, cx, dxDesc, dx, dhxDesc, dhx, dcxDesc, dcx, dkDesc, dkeys, workSpace, workSpaceSizeInBytes, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnRNNBackwardDataExNative(cudnnHandle var0, cudnnRNNDescriptor var1, cudnnRNNDataDescriptor var2, Pointer var3, cudnnRNNDataDescriptor var4, Pointer var5, cudnnRNNDataDescriptor var6, Pointer var7, cudnnTensorDescriptor var8, Pointer var9, cudnnTensorDescriptor var10, Pointer var11, cudnnFilterDescriptor var12, Pointer var13, cudnnTensorDescriptor var14, Pointer var15, cudnnTensorDescriptor var16, Pointer var17, cudnnRNNDataDescriptor var18, Pointer var19, cudnnTensorDescriptor var20, Pointer var21, cudnnTensorDescriptor var22, Pointer var23, cudnnRNNDataDescriptor var24, Pointer var25, Pointer var26, long var27, Pointer var29, long var30);

    public static int cudnnRNNBackwardWeightsEx(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, cudnnRNNDataDescriptor xDesc, Pointer x, cudnnTensorDescriptor hxDesc, Pointer hx, cudnnRNNDataDescriptor yDesc, Pointer y, Pointer workSpace, long workSpaceSizeInBytes, cudnnFilterDescriptor dwDesc, Pointer dw, Pointer reserveSpace, long reserveSpaceSizeInBytes) {
        return JCudnn.checkResult(JCudnn.cudnnRNNBackwardWeightsExNative(handle, rnnDesc, xDesc, x, hxDesc, hx, yDesc, y, workSpace, workSpaceSizeInBytes, dwDesc, dw, reserveSpace, reserveSpaceSizeInBytes));
    }

    private static native int cudnnRNNBackwardWeightsExNative(cudnnHandle var0, cudnnRNNDescriptor var1, cudnnRNNDataDescriptor var2, Pointer var3, cudnnTensorDescriptor var4, Pointer var5, cudnnRNNDataDescriptor var6, Pointer var7, Pointer var8, long var9, cudnnFilterDescriptor var11, Pointer var12, Pointer var13, long var14);

    public static int cudnnSetRNNDescriptor_v6(cudnnHandle handle, cudnnRNNDescriptor rnnDesc, int hiddenSize, int numLayers, cudnnDropoutDescriptor dropoutDesc, int inputMode, int direction, int mode, int algo, int dataType) {
        return JCudnn.checkResult(JCudnn.cudnnSetRNNDescriptor_v6Native(handle, rnnDesc, hiddenSize, numLayers, dropoutDesc, inputMode, direction, mode, algo, dataType));
    }

    private static native int cudnnSetRNNDescriptor_v6Native(cudnnHandle var0, cudnnRNNDescriptor var1, int var2, int var3, cudnnDropoutDescriptor var4, int var5, int var6, int var7, int var8, int var9);

    public static int cudnnSetRNNDescriptor_v5(cudnnRNNDescriptor rnnDesc, int hiddenSize, int numLayers, cudnnDropoutDescriptor dropoutDesc, int inputMode, int direction, int mode, int dataType) {
        return JCudnn.checkResult(JCudnn.cudnnSetRNNDescriptor_v5Native(rnnDesc, hiddenSize, numLayers, dropoutDesc, inputMode, direction, mode, dataType));
    }

    private static native int cudnnSetRNNDescriptor_v5Native(cudnnRNNDescriptor var0, int var1, int var2, cudnnDropoutDescriptor var3, int var4, int var5, int var6, int var7);

    static {
        JCudnn.initialize();
    }
}

