/*
 * JCudnn - Java bindings for cuDNN, the NVIDIA CUDA
 * Deep Neural Network library, to be used with JCuda
 *
 * Copyright (c) 2015-2018 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */
package jcuda.jcudnn;

/**
 * CUDNN return codes
 */
public class cudnnStatus
{
    public static final int CUDNN_STATUS_SUCCESS = 0;
    /** Uncategorized errors */
    public static final int CUDNN_STATUS_NOT_INITIALIZED = 1001;
    public static final int CUDNN_STATUS_SUBLIBRARY_VERSION_MISMATCH = 1002;
    public static final int CUDNN_STATUS_SERIALIZATION_VERSION_MISMATCH = 1003;
    public static final int CUDNN_STATUS_DEPRECATED = 1004;
    public static final int CUDNN_STATUS_LICENSE_ERROR = 1005;
    public static final int CUDNN_STATUS_RUNTIME_IN_PROGRESS = 1006;
    public static final int CUDNN_STATUS_RUNTIME_FP_OVERFLOW = 1007;
    public static final int CUDNN_STATUS_SUBLIBRARY_LOADING_FAILED = 1008;
    public static final int CUDNN_STATUS_BAD_PARAM = 2000;
    public static final int CUDNN_STATUS_BAD_PARAM_NULL_POINTER = 2002;
    public static final int CUDNN_STATUS_BAD_PARAM_MISALIGNED_POINTER = 2003;
    public static final int CUDNN_STATUS_BAD_PARAM_NOT_FINALIZED = 2004;
    public static final int CUDNN_STATUS_BAD_PARAM_OUT_OF_BOUND = 2005;
    public static final int CUDNN_STATUS_BAD_PARAM_SIZE_INSUFFICIENT = 2006;
    public static final int CUDNN_STATUS_BAD_PARAM_STREAM_MISMATCH = 2007;
    public static final int CUDNN_STATUS_BAD_PARAM_SHAPE_MISMATCH = 2008;
    public static final int CUDNN_STATUS_BAD_PARAM_DUPLICATED_ENTRIES = 2009;
    public static final int CUDNN_STATUS_BAD_PARAM_ATTRIBUTE_TYPE = 2010;
    public static final int CUDNN_STATUS_BAD_PARAM_CUDA_GRAPH_MISMATCH = 2011;
    public static final int CUDNN_STATUS_NOT_SUPPORTED = 3000;
    public static final int CUDNN_STATUS_NOT_SUPPORTED_GRAPH_PATTERN = 3001;
    public static final int CUDNN_STATUS_NOT_SUPPORTED_SHAPE = 3002;
    public static final int CUDNN_STATUS_NOT_SUPPORTED_DATA_TYPE = 3003;
    public static final int CUDNN_STATUS_NOT_SUPPORTED_LAYOUT = 3004;
    public static final int CUDNN_STATUS_NOT_SUPPORTED_INCOMPATIBLE_CUDA_DRIVER = 3005;
    public static final int CUDNN_STATUS_NOT_SUPPORTED_INCOMPATIBLE_CUDART = 3006;
    public static final int CUDNN_STATUS_NOT_SUPPORTED_ARCH_MISMATCH = 3007;
    public static final int CUDNN_STATUS_NOT_SUPPORTED_RUNTIME_PREREQUISITE_MISSING = 3008;
    public static final int CUDNN_STATUS_NOT_SUPPORTED_SUBLIBRARY_UNAVAILABLE = 3009;
    public static final int CUDNN_STATUS_NOT_SUPPORTED_SHARED_MEMORY_INSUFFICIENT = 3010;
    public static final int CUDNN_STATUS_NOT_SUPPORTED_PADDING = 3011;
    public static final int CUDNN_STATUS_NOT_SUPPORTED_BAD_LAUNCH_PARAM = 3012;
    public static final int CUDNN_STATUS_NOT_SUPPORTED_CUDA_GRAPH_NATIVE_API = 3013;
    public static final int CUDNN_STATUS_INTERNAL_ERROR = 4000;
    public static final int CUDNN_STATUS_INTERNAL_ERROR_COMPILATION_FAILED = 4001;
    public static final int CUDNN_STATUS_INTERNAL_ERROR_UNEXPECTED_VALUE = 4002;
    public static final int CUDNN_STATUS_INTERNAL_ERROR_HOST_ALLOCATION_FAILED = 4003;
    public static final int CUDNN_STATUS_INTERNAL_ERROR_DEVICE_ALLOCATION_FAILED = 4004;
    public static final int CUDNN_STATUS_INTERNAL_ERROR_BAD_LAUNCH_PARAM = 4005;
    public static final int CUDNN_STATUS_INTERNAL_ERROR_TEXTURE_CREATION_FAILED = 4006;
    public static final int CUDNN_STATUS_EXECUTION_FAILED = 5000;
    public static final int CUDNN_STATUS_EXECUTION_FAILED_CUDA_DRIVER = 5001;
    public static final int CUDNN_STATUS_EXECUTION_FAILED_CUBLAS = 5002;
    public static final int CUDNN_STATUS_EXECUTION_FAILED_CUDART = 5003;
    public static final int CUDNN_STATUS_EXECUTION_FAILED_CURAND = 5004;
    public static final int CUDNN_STATUS_ALLOC_FAILED = CUDNN_STATUS_INTERNAL_ERROR_HOST_ALLOCATION_FAILED;
    /**
     * please transition to CUDNN_STATUS_BAD_PARAM instead 
     */
    public static final int CUDNN_STATUS_INVALID_VALUE = 2001;
    public static final int CUDNN_STATUS_ARCH_MISMATCH = CUDNN_STATUS_NOT_SUPPORTED_ARCH_MISMATCH;
    public static final int CUDNN_STATUS_MAPPING_ERROR = CUDNN_STATUS_INTERNAL_ERROR_TEXTURE_CREATION_FAILED;
    public static final int CUDNN_STATUS_RUNTIME_PREREQUISITE_MISSING = CUDNN_STATUS_NOT_SUPPORTED_RUNTIME_PREREQUISITE_MISSING;
    public static final int CUDNN_STATUS_VERSION_MISMATCH = CUDNN_STATUS_SUBLIBRARY_VERSION_MISMATCH;

    /**
     * Private constructor to prevent instantiation
     */
    private cudnnStatus()
    {
        // Private constructor to prevent instantiation
    }

    /**
     * Returns a string representation of the given constant
     *
     * @return A string representation of the given constant
     */
    public static String stringFor(int n)
    {
        switch (n)
        {
            case CUDNN_STATUS_SUCCESS: return "CUDNN_STATUS_SUCCESS";
            case CUDNN_STATUS_NOT_INITIALIZED: return "CUDNN_STATUS_NOT_INITIALIZED";
            case CUDNN_STATUS_SUBLIBRARY_VERSION_MISMATCH: return "(CUDNN_STATUS_SUBLIBRARY_VERSION_MISMATCH or CUDNN_STATUS_VERSION_MISMATCH)";
            case CUDNN_STATUS_SERIALIZATION_VERSION_MISMATCH: return "CUDNN_STATUS_SERIALIZATION_VERSION_MISMATCH";
            case CUDNN_STATUS_DEPRECATED: return "CUDNN_STATUS_DEPRECATED";
            case CUDNN_STATUS_LICENSE_ERROR: return "CUDNN_STATUS_LICENSE_ERROR";
            case CUDNN_STATUS_RUNTIME_IN_PROGRESS: return "CUDNN_STATUS_RUNTIME_IN_PROGRESS";
            case CUDNN_STATUS_RUNTIME_FP_OVERFLOW: return "CUDNN_STATUS_RUNTIME_FP_OVERFLOW";
            case CUDNN_STATUS_SUBLIBRARY_LOADING_FAILED: return "CUDNN_STATUS_SUBLIBRARY_LOADING_FAILED";
            case CUDNN_STATUS_BAD_PARAM: return "CUDNN_STATUS_BAD_PARAM";
            case CUDNN_STATUS_BAD_PARAM_NULL_POINTER: return "CUDNN_STATUS_BAD_PARAM_NULL_POINTER";
            case CUDNN_STATUS_BAD_PARAM_MISALIGNED_POINTER: return "CUDNN_STATUS_BAD_PARAM_MISALIGNED_POINTER";
            case CUDNN_STATUS_BAD_PARAM_NOT_FINALIZED: return "CUDNN_STATUS_BAD_PARAM_NOT_FINALIZED";
            case CUDNN_STATUS_BAD_PARAM_OUT_OF_BOUND: return "CUDNN_STATUS_BAD_PARAM_OUT_OF_BOUND";
            case CUDNN_STATUS_BAD_PARAM_SIZE_INSUFFICIENT: return "CUDNN_STATUS_BAD_PARAM_SIZE_INSUFFICIENT";
            case CUDNN_STATUS_BAD_PARAM_STREAM_MISMATCH: return "CUDNN_STATUS_BAD_PARAM_STREAM_MISMATCH";
            case CUDNN_STATUS_BAD_PARAM_SHAPE_MISMATCH: return "CUDNN_STATUS_BAD_PARAM_SHAPE_MISMATCH";
            case CUDNN_STATUS_BAD_PARAM_DUPLICATED_ENTRIES: return "CUDNN_STATUS_BAD_PARAM_DUPLICATED_ENTRIES";
            case CUDNN_STATUS_BAD_PARAM_ATTRIBUTE_TYPE: return "CUDNN_STATUS_BAD_PARAM_ATTRIBUTE_TYPE";
            case CUDNN_STATUS_BAD_PARAM_CUDA_GRAPH_MISMATCH: return "CUDNN_STATUS_BAD_PARAM_CUDA_GRAPH_MISMATCH";
            case CUDNN_STATUS_NOT_SUPPORTED: return "CUDNN_STATUS_NOT_SUPPORTED";
            case CUDNN_STATUS_NOT_SUPPORTED_GRAPH_PATTERN: return "CUDNN_STATUS_NOT_SUPPORTED_GRAPH_PATTERN";
            case CUDNN_STATUS_NOT_SUPPORTED_SHAPE: return "CUDNN_STATUS_NOT_SUPPORTED_SHAPE";
            case CUDNN_STATUS_NOT_SUPPORTED_DATA_TYPE: return "CUDNN_STATUS_NOT_SUPPORTED_DATA_TYPE";
            case CUDNN_STATUS_NOT_SUPPORTED_LAYOUT: return "CUDNN_STATUS_NOT_SUPPORTED_LAYOUT";
            case CUDNN_STATUS_NOT_SUPPORTED_INCOMPATIBLE_CUDA_DRIVER: return "CUDNN_STATUS_NOT_SUPPORTED_INCOMPATIBLE_CUDA_DRIVER";
            case CUDNN_STATUS_NOT_SUPPORTED_INCOMPATIBLE_CUDART: return "CUDNN_STATUS_NOT_SUPPORTED_INCOMPATIBLE_CUDART";
            case CUDNN_STATUS_NOT_SUPPORTED_ARCH_MISMATCH: return "(CUDNN_STATUS_NOT_SUPPORTED_ARCH_MISMATCH or CUDNN_STATUS_ARCH_MISMATCH)";
            case CUDNN_STATUS_NOT_SUPPORTED_RUNTIME_PREREQUISITE_MISSING: return "(CUDNN_STATUS_NOT_SUPPORTED_RUNTIME_PREREQUISITE_MISSING or CUDNN_STATUS_RUNTIME_PREREQUISITE_MISSING)";
            case CUDNN_STATUS_NOT_SUPPORTED_SUBLIBRARY_UNAVAILABLE: return "CUDNN_STATUS_NOT_SUPPORTED_SUBLIBRARY_UNAVAILABLE";
            case CUDNN_STATUS_NOT_SUPPORTED_SHARED_MEMORY_INSUFFICIENT: return "CUDNN_STATUS_NOT_SUPPORTED_SHARED_MEMORY_INSUFFICIENT";
            case CUDNN_STATUS_NOT_SUPPORTED_PADDING: return "CUDNN_STATUS_NOT_SUPPORTED_PADDING";
            case CUDNN_STATUS_NOT_SUPPORTED_BAD_LAUNCH_PARAM: return "CUDNN_STATUS_NOT_SUPPORTED_BAD_LAUNCH_PARAM";
            case CUDNN_STATUS_NOT_SUPPORTED_CUDA_GRAPH_NATIVE_API: return "CUDNN_STATUS_NOT_SUPPORTED_CUDA_GRAPH_NATIVE_API";
            case CUDNN_STATUS_INTERNAL_ERROR: return "CUDNN_STATUS_INTERNAL_ERROR";
            case CUDNN_STATUS_INTERNAL_ERROR_COMPILATION_FAILED: return "CUDNN_STATUS_INTERNAL_ERROR_COMPILATION_FAILED";
            case CUDNN_STATUS_INTERNAL_ERROR_UNEXPECTED_VALUE: return "CUDNN_STATUS_INTERNAL_ERROR_UNEXPECTED_VALUE";
            case CUDNN_STATUS_INTERNAL_ERROR_HOST_ALLOCATION_FAILED: return "(CUDNN_STATUS_INTERNAL_ERROR_HOST_ALLOCATION_FAILED or CUDNN_STATUS_ALLOC_FAILED)";
            case CUDNN_STATUS_INTERNAL_ERROR_DEVICE_ALLOCATION_FAILED: return "CUDNN_STATUS_INTERNAL_ERROR_DEVICE_ALLOCATION_FAILED";
            case CUDNN_STATUS_INTERNAL_ERROR_BAD_LAUNCH_PARAM: return "CUDNN_STATUS_INTERNAL_ERROR_BAD_LAUNCH_PARAM";
            case CUDNN_STATUS_INTERNAL_ERROR_TEXTURE_CREATION_FAILED: return "(CUDNN_STATUS_INTERNAL_ERROR_TEXTURE_CREATION_FAILED or CUDNN_STATUS_MAPPING_ERROR)";
            case CUDNN_STATUS_EXECUTION_FAILED: return "CUDNN_STATUS_EXECUTION_FAILED";
            case CUDNN_STATUS_EXECUTION_FAILED_CUDA_DRIVER: return "CUDNN_STATUS_EXECUTION_FAILED_CUDA_DRIVER";
            case CUDNN_STATUS_EXECUTION_FAILED_CUBLAS: return "CUDNN_STATUS_EXECUTION_FAILED_CUBLAS";
            case CUDNN_STATUS_EXECUTION_FAILED_CUDART: return "CUDNN_STATUS_EXECUTION_FAILED_CUDART";
            case CUDNN_STATUS_EXECUTION_FAILED_CURAND: return "CUDNN_STATUS_EXECUTION_FAILED_CURAND";
            // CUDNN_STATUS_ALLOC_FAILED already covered
            case CUDNN_STATUS_INVALID_VALUE: return "CUDNN_STATUS_INVALID_VALUE";
            // CUDNN_STATUS_ARCH_MISMATCH already covered
            // CUDNN_STATUS_MAPPING_ERROR already covered
            // CUDNN_STATUS_RUNTIME_PREREQUISITE_MISSING already covered
            // CUDNN_STATUS_VERSION_MISMATCH already covered
        }
        return "INVALID cudnnStatus: "+n;
    }
}

