/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcufft;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.jcufft.cufftHandle;
import jcuda.jcufft.cufftResult;
import jcuda.runtime.JCuda;
import jcuda.runtime.cudaError;
import jcuda.runtime.cudaStream_t;

public class JCufft {
    public static final int CUFFT_FORWARD = -1;
    public static final int CUFFT_INVERSE = 1;
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    private JCufft() {
    }

    public static void initialize() {
        if (!initialized) {
            String libraryBaseName = "JCufft-" + JCuda.getJCudaVersion();
            String libraryName = LibUtils.createPlatformLibraryName((String)libraryBaseName);
            LibUtils.loadLibrary((String)libraryName, (String[])new String[0]);
            initialized = true;
        }
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCufft.setLogLevel(logLevel.ordinal());
    }

    private static native void setLogLevel(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(cufftResult.stringFor(result));
        }
        return result;
    }

    public static int cufftGetVersion(int[] version) {
        return JCufft.cufftGetVersionNative(version);
    }

    private static native int cufftGetVersionNative(int[] var0);

    public static int cufftGetProperty(int type, int[] value) {
        return JCufft.checkResult(JCufft.cufftGetPropertyNative(type, value));
    }

    private static native int cufftGetPropertyNative(int var0, int[] var1);

    public static int cufftPlan1d(cufftHandle plan, int nx, int type, int batch) {
        plan.setDimension(1);
        plan.setType(type);
        plan.setSize(nx, 0, 0);
        plan.setBatchSize(batch);
        return JCufft.checkResult(JCufft.cufftPlan1dNative(plan, nx, type, batch));
    }

    private static native int cufftPlan1dNative(cufftHandle var0, int var1, int var2, int var3);

    public static int cufftPlan2d(cufftHandle plan, int nx, int ny, int type) {
        plan.setDimension(2);
        plan.setType(type);
        plan.setSize(nx, ny, 0);
        return JCufft.checkResult(JCufft.cufftPlan2dNative(plan, nx, ny, type));
    }

    private static native int cufftPlan2dNative(cufftHandle var0, int var1, int var2, int var3);

    public static int cufftPlan3d(cufftHandle plan, int nx, int ny, int nz, int type) {
        plan.setDimension(3);
        plan.setType(type);
        plan.setSize(nx, ny, nz);
        return JCufft.checkResult(JCufft.cufftPlan3dNative(plan, nx, ny, nz, type));
    }

    private static native int cufftPlan3dNative(cufftHandle var0, int var1, int var2, int var3, int var4);

    public static int cufftPlanMany(cufftHandle plan, int rank, int[] n, int[] inembed, int istride, int idist, int[] onembed, int ostride, int odist, int type, int batch) {
        return JCufft.checkResult(JCufft.cufftPlanManyNative(plan, rank, n, inembed, istride, idist, onembed, ostride, odist, type, batch));
    }

    private static native int cufftPlanManyNative(cufftHandle var0, int var1, int[] var2, int[] var3, int var4, int var5, int[] var6, int var7, int var8, int var9, int var10);

    public static int cufftMakePlan1d(cufftHandle plan, int nx, int type, int batch, long[] workSize) {
        return JCufft.checkResult(JCufft.cufftMakePlan1dNative(plan, nx, type, batch, workSize));
    }

    private static native int cufftMakePlan1dNative(cufftHandle var0, int var1, int var2, int var3, long[] var4);

    public static int cufftMakePlan2d(cufftHandle plan, int nx, int ny, int type, long[] workSize) {
        return JCufft.checkResult(JCufft.cufftMakePlan2dNative(plan, nx, ny, type, workSize));
    }

    private static native int cufftMakePlan2dNative(cufftHandle var0, int var1, int var2, int var3, long[] var4);

    public static int cufftMakePlan3d(cufftHandle plan, int nx, int ny, int nz, int type, long[] workSize) {
        return JCufft.checkResult(JCufft.cufftMakePlan3dNative(plan, nx, ny, nz, type, workSize));
    }

    private static native int cufftMakePlan3dNative(cufftHandle var0, int var1, int var2, int var3, int var4, long[] var5);

    public static int cufftMakePlanMany(cufftHandle plan, int rank, int[] n, int[] inembed, int istride, int idist, int[] onembed, int ostride, int odist, int type, int batch, long[] workSize) {
        return JCufft.checkResult(JCufft.cufftMakePlanManyNative(plan, rank, n, inembed, istride, idist, onembed, ostride, odist, type, batch, workSize));
    }

    private static native int cufftMakePlanManyNative(cufftHandle var0, int var1, int[] var2, int[] var3, int var4, int var5, int[] var6, int var7, int var8, int var9, int var10, long[] var11);

    public static int cufftMakePlanMany64(cufftHandle plan, int rank, long[] n, long[] inembed, long istride, long idist, long[] onembed, long ostride, long odist, int type, long batch, long[] workSize) {
        return JCufft.checkResult(JCufft.cufftMakePlanManyNative64(plan, rank, n, inembed, istride, idist, onembed, ostride, odist, type, batch, workSize));
    }

    private static native int cufftMakePlanManyNative64(cufftHandle var0, int var1, long[] var2, long[] var3, long var4, long var6, long[] var8, long var9, long var11, int var13, long var14, long[] var16);

    public static int cufftGetSizeMany64(cufftHandle plan, int rank, long[] n, long[] inembed, long istride, long idist, long[] onembed, long ostride, long odist, int type, long batch, long[] workSize) {
        return JCufft.checkResult(JCufft.cufftGetSizeMany64Native(plan, rank, n, inembed, istride, idist, onembed, ostride, odist, type, batch, workSize));
    }

    private static native int cufftGetSizeMany64Native(cufftHandle var0, int var1, long[] var2, long[] var3, long var4, long var6, long[] var8, long var9, long var11, int var13, long var14, long[] var16);

    public static int cufftEstimate1d(int nx, int type, int batch, long[] workSize) {
        return JCufft.checkResult(JCufft.cufftEstimate1dNative(nx, type, batch, workSize));
    }

    private static native int cufftEstimate1dNative(int var0, int var1, int var2, long[] var3);

    public static int cufftEstimate2d(int nx, int ny, int type, long[] workSize) {
        return JCufft.checkResult(JCufft.cufftEstimate2dNative(nx, ny, type, workSize));
    }

    private static native int cufftEstimate2dNative(int var0, int var1, int var2, long[] var3);

    public static int cufftEstimate3d(int nx, int ny, int nz, int type, long[] workSize) {
        return JCufft.checkResult(JCufft.cufftEstimate3dNative(nx, ny, nz, type, workSize));
    }

    private static native int cufftEstimate3dNative(int var0, int var1, int var2, int var3, long[] var4);

    public static int cufftEstimateMany(int rank, int[] n, int[] inembed, int istride, int idist, int[] onembed, int ostride, int odist, int type, int batch, long[] workSize) {
        return JCufft.checkResult(JCufft.cufftEstimateManyNative(rank, n, inembed, istride, idist, onembed, ostride, odist, type, batch, workSize));
    }

    private static native int cufftEstimateManyNative(int var0, int[] var1, int[] var2, int var3, int var4, int[] var5, int var6, int var7, int var8, int var9, long[] var10);

    public static int cufftCreate(cufftHandle cufftHandle2) {
        return JCufft.checkResult(JCufft.cufftCreateNative(cufftHandle2));
    }

    private static native int cufftCreateNative(cufftHandle var0);

    public static int cufftGetSize1d(cufftHandle handle, int nx, int type, int batch, long[] workSize) {
        return JCufft.checkResult(JCufft.cufftGetSize1dNative(handle, nx, type, batch, workSize));
    }

    private static native int cufftGetSize1dNative(cufftHandle var0, int var1, int var2, int var3, long[] var4);

    public static int cufftGetSize2d(cufftHandle handle, int nx, int ny, int type, long[] workSize) {
        return JCufft.checkResult(JCufft.cufftGetSize2dNative(handle, nx, ny, type, workSize));
    }

    private static native int cufftGetSize2dNative(cufftHandle var0, int var1, int var2, int var3, long[] var4);

    public static int cufftGetSize3d(cufftHandle handle, int nx, int ny, int nz, int type, long[] workSize) {
        return JCufft.checkResult(JCufft.cufftGetSize3dNative(handle, nx, ny, nz, type, workSize));
    }

    private static native int cufftGetSize3dNative(cufftHandle var0, int var1, int var2, int var3, int var4, long[] var5);

    public static int cufftGetSizeMany(cufftHandle handle, int rank, int[] n, int[] inembed, int istride, int idist, int[] onembed, int ostride, int odist, int type, int batch, long[] workArea) {
        return JCufft.checkResult(JCufft.cufftGetSizeManyNative(handle, rank, n, inembed, istride, idist, onembed, ostride, odist, type, batch, workArea));
    }

    private static native int cufftGetSizeManyNative(cufftHandle var0, int var1, int[] var2, int[] var3, int var4, int var5, int[] var6, int var7, int var8, int var9, int var10, long[] var11);

    public static int cufftGetSize(cufftHandle handle, long[] workSize) {
        return JCufft.checkResult(JCufft.cufftGetSizeNative(handle, workSize));
    }

    private static native int cufftGetSizeNative(cufftHandle var0, long[] var1);

    public static int cufftSetWorkArea(cufftHandle plan, Pointer workArea) {
        return JCufft.checkResult(JCufft.cufftSetWorkAreaNative(plan, workArea));
    }

    private static native int cufftSetWorkAreaNative(cufftHandle var0, Pointer var1);

    public static int cufftSetAutoAllocation(cufftHandle plan, int autoAllocate) {
        return JCufft.checkResult(JCufft.cufftSetAutoAllocationNative(plan, autoAllocate));
    }

    private static native int cufftSetAutoAllocationNative(cufftHandle var0, int var1);

    public static int cufftDestroy(cufftHandle plan) {
        return JCufft.checkResult(JCufft.cufftDestroyNative(plan));
    }

    private static native int cufftDestroyNative(cufftHandle var0);

    public static int cufftSetStream(cufftHandle plan, cudaStream_t stream) {
        return JCufft.checkResult(JCufft.cufftSetStreamNative(plan, stream));
    }

    private static native int cufftSetStreamNative(cufftHandle var0, cudaStream_t var1);

    public static int cufftSetCompatibilityMode(cufftHandle plan, int mode) {
        return JCufft.checkResult(JCufft.cufftSetCompatibilityModeNative(plan, mode));
    }

    private static native int cufftSetCompatibilityModeNative(cufftHandle var0, int var1);

    public static int cufftExecC2C(cufftHandle plan, Pointer cIdata, Pointer cOdata, int direction) {
        return JCufft.checkResult(JCufft.cufftExecC2CNative(plan, cIdata, cOdata, direction));
    }

    private static native int cufftExecC2CNative(cufftHandle var0, Pointer var1, Pointer var2, int var3);

    public static int cufftExecC2C(cufftHandle plan, float[] cIdata, float[] cOdata, int direction) {
        int cudaResult = 0;
        boolean inPlace = cIdata == cOdata;
        Pointer hostCIdata = Pointer.to((float[])cIdata);
        Pointer deviceCIdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceCIdata, (long)(cIdata.length * 4));
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        Pointer hostCOdata = null;
        Pointer deviceCOdata = null;
        if (inPlace) {
            hostCOdata = hostCIdata;
            deviceCOdata = deviceCIdata;
        } else {
            hostCOdata = Pointer.to((float[])cOdata);
            deviceCOdata = new Pointer();
            cudaResult = JCuda.cudaMalloc((Pointer)deviceCOdata, (long)(cOdata.length * 4));
            if (cudaResult != 0) {
                JCuda.cudaFree((Pointer)deviceCIdata);
                if (exceptionsEnabled) {
                    throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
                }
                return 255;
            }
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)deviceCIdata, (Pointer)hostCIdata, (long)(cIdata.length * 4), (int)1);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        int result = 0;
        try {
            result = JCufft.cufftExecC2C(plan, deviceCIdata, deviceCOdata, direction);
        }
        catch (CudaException e) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            result = 255;
        }
        if (result != 0) {
            if (exceptionsEnabled) {
                throw new CudaException(cufftResult.stringFor(result));
            }
            return result;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)hostCOdata, (Pointer)deviceCOdata, (long)(cOdata.length * 4), (int)2);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceCIdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        if (!inPlace && (cudaResult = JCuda.cudaFree((Pointer)deviceCOdata)) != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        return result;
    }

    public static int cufftExecR2C(cufftHandle plan, Pointer rIdata, Pointer cOdata) {
        return JCufft.checkResult(JCufft.cufftExecR2CNative(plan, rIdata, cOdata));
    }

    private static native int cufftExecR2CNative(cufftHandle var0, Pointer var1, Pointer var2);

    public static int cufftExecR2C(cufftHandle plan, float[] rIdata, float[] cOdata) {
        int cudaResult = 0;
        boolean inPlace = rIdata == cOdata;
        Pointer hostRIdata = Pointer.to((float[])rIdata);
        Pointer deviceRIdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceRIdata, (long)(rIdata.length * 4));
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        Pointer hostCOdata = null;
        Pointer deviceCOdata = null;
        if (inPlace) {
            hostCOdata = hostRIdata;
            deviceCOdata = deviceRIdata;
        } else {
            hostCOdata = Pointer.to((float[])cOdata);
            deviceCOdata = new Pointer();
            cudaResult = JCuda.cudaMalloc((Pointer)deviceCOdata, (long)(cOdata.length * 4));
            if (cudaResult != 0) {
                JCuda.cudaFree((Pointer)deviceCOdata);
                if (exceptionsEnabled) {
                    throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
                }
                return 255;
            }
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)deviceRIdata, (Pointer)hostRIdata, (long)(rIdata.length * 4), (int)1);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceRIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        int result = 0;
        try {
            result = JCufft.cufftExecR2C(plan, deviceRIdata, deviceCOdata);
        }
        catch (CudaException e) {
            JCuda.cudaFree((Pointer)deviceRIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            result = 255;
        }
        if (result != 0) {
            if (exceptionsEnabled) {
                throw new CudaException(cufftResult.stringFor(cudaResult));
            }
            return result;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)hostCOdata, (Pointer)deviceCOdata, (long)(cOdata.length * 4), (int)2);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceRIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceRIdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        if (!inPlace && (cudaResult = JCuda.cudaFree((Pointer)deviceCOdata)) != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        return result;
    }

    public static int cufftExecC2R(cufftHandle plan, Pointer cIdata, Pointer rOdata) {
        return JCufft.checkResult(JCufft.cufftExecC2RNative(plan, cIdata, rOdata));
    }

    private static native int cufftExecC2RNative(cufftHandle var0, Pointer var1, Pointer var2);

    public static int cufftExecC2R(cufftHandle plan, float[] cIdata, float[] rOdata) {
        int cudaResult = 0;
        boolean inPlace = cIdata == rOdata;
        Pointer hostCIdata = Pointer.to((float[])cIdata);
        Pointer deviceCIdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceCIdata, (long)(cIdata.length * 4));
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        Pointer hostROdata = null;
        Pointer deviceROdata = null;
        if (inPlace) {
            hostROdata = hostCIdata;
            deviceROdata = deviceCIdata;
        } else {
            hostROdata = Pointer.to((float[])rOdata);
            deviceROdata = new Pointer();
            cudaResult = JCuda.cudaMalloc((Pointer)deviceROdata, (long)(rOdata.length * 4));
            if (cudaResult != 0) {
                JCuda.cudaFree((Pointer)deviceCIdata);
                if (exceptionsEnabled) {
                    throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
                }
                return 255;
            }
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)deviceCIdata, (Pointer)hostCIdata, (long)(cIdata.length * 4), (int)1);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceROdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        int result = 0;
        try {
            result = JCufft.cufftExecC2R(plan, deviceCIdata, deviceROdata);
        }
        catch (CudaException e) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceROdata);
            }
            result = 255;
        }
        if (result != 0) {
            if (exceptionsEnabled) {
                throw new CudaException(cufftResult.stringFor(cudaResult));
            }
            return result;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)hostROdata, (Pointer)deviceROdata, (long)(rOdata.length * 4), (int)2);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceROdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceCIdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        if (!inPlace && (cudaResult = JCuda.cudaFree((Pointer)deviceROdata)) != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        return result;
    }

    public static int cufftExecZ2Z(cufftHandle plan, Pointer cIdata, Pointer cOdata, int direction) {
        return JCufft.checkResult(JCufft.cufftExecZ2ZNative(plan, cIdata, cOdata, direction));
    }

    private static native int cufftExecZ2ZNative(cufftHandle var0, Pointer var1, Pointer var2, int var3);

    public static int cufftExecZ2Z(cufftHandle plan, double[] cIdata, double[] cOdata, int direction) {
        int cudaResult = 0;
        boolean inPlace = cIdata == cOdata;
        Pointer hostCIdata = Pointer.to((double[])cIdata);
        Pointer deviceCIdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceCIdata, (long)(cIdata.length * 8));
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        Pointer hostCOdata = null;
        Pointer deviceCOdata = null;
        if (inPlace) {
            hostCOdata = hostCIdata;
            deviceCOdata = deviceCIdata;
        } else {
            hostCOdata = Pointer.to((double[])cOdata);
            deviceCOdata = new Pointer();
            cudaResult = JCuda.cudaMalloc((Pointer)deviceCOdata, (long)(cOdata.length * 8));
            if (cudaResult != 0) {
                JCuda.cudaFree((Pointer)deviceCIdata);
                if (exceptionsEnabled) {
                    throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
                }
                return 255;
            }
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)deviceCIdata, (Pointer)hostCIdata, (long)(cIdata.length * 8), (int)1);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        int result = 0;
        try {
            result = JCufft.cufftExecZ2Z(plan, deviceCIdata, deviceCOdata, direction);
        }
        catch (CudaException e) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            result = 255;
        }
        if (result != 0) {
            if (exceptionsEnabled) {
                throw new CudaException(cufftResult.stringFor(cudaResult));
            }
            return result;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)hostCOdata, (Pointer)deviceCOdata, (long)(cOdata.length * 8), (int)2);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceCIdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        if (!inPlace && (cudaResult = JCuda.cudaFree((Pointer)deviceCOdata)) != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        return result;
    }

    public static int cufftExecD2Z(cufftHandle plan, Pointer rIdata, Pointer cOdata) {
        return JCufft.checkResult(JCufft.cufftExecD2ZNative(plan, rIdata, cOdata));
    }

    private static native int cufftExecD2ZNative(cufftHandle var0, Pointer var1, Pointer var2);

    public static int cufftExecD2Z(cufftHandle plan, double[] rIdata, double[] cOdata) {
        int cudaResult = 0;
        boolean inPlace = rIdata == cOdata;
        Pointer hostRIdata = Pointer.to((double[])rIdata);
        Pointer deviceRIdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceRIdata, (long)(rIdata.length * 8));
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        Pointer hostCOdata = null;
        Pointer deviceCOdata = null;
        if (inPlace) {
            hostCOdata = hostRIdata;
            deviceCOdata = deviceRIdata;
        } else {
            hostCOdata = Pointer.to((double[])cOdata);
            deviceCOdata = new Pointer();
            cudaResult = JCuda.cudaMalloc((Pointer)deviceCOdata, (long)(cOdata.length * 8));
            if (cudaResult != 0) {
                JCuda.cudaFree((Pointer)deviceCOdata);
                if (exceptionsEnabled) {
                    throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
                }
                return 255;
            }
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)deviceRIdata, (Pointer)hostRIdata, (long)(rIdata.length * 8), (int)1);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceRIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        int result = 0;
        try {
            result = JCufft.cufftExecD2Z(plan, deviceRIdata, deviceCOdata);
        }
        catch (CudaException e) {
            JCuda.cudaFree((Pointer)deviceRIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            result = 255;
        }
        if (result != 0) {
            if (exceptionsEnabled) {
                throw new CudaException(cufftResult.stringFor(cudaResult));
            }
            return result;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)hostCOdata, (Pointer)deviceCOdata, (long)(cOdata.length * 8), (int)2);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceRIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceCOdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceRIdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        if (!inPlace && (cudaResult = JCuda.cudaFree((Pointer)deviceCOdata)) != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        return result;
    }

    public static int cufftExecZ2D(cufftHandle plan, Pointer cIdata, Pointer rOdata) {
        return JCufft.checkResult(JCufft.cufftExecZ2DNative(plan, cIdata, rOdata));
    }

    private static native int cufftExecZ2DNative(cufftHandle var0, Pointer var1, Pointer var2);

    public static int cufftExecZ2D(cufftHandle plan, double[] cIdata, double[] rOdata) {
        int cudaResult = 0;
        boolean inPlace = cIdata == rOdata;
        Pointer hostCIdata = Pointer.to((double[])cIdata);
        Pointer deviceCIdata = new Pointer();
        cudaResult = JCuda.cudaMalloc((Pointer)deviceCIdata, (long)(cIdata.length * 8));
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        Pointer hostROdata = null;
        Pointer deviceROdata = null;
        if (inPlace) {
            hostROdata = hostCIdata;
            deviceROdata = deviceCIdata;
        } else {
            hostROdata = Pointer.to((double[])rOdata);
            deviceROdata = new Pointer();
            cudaResult = JCuda.cudaMalloc((Pointer)deviceROdata, (long)(rOdata.length * 8));
            if (cudaResult != 0) {
                JCuda.cudaFree((Pointer)deviceCIdata);
                if (exceptionsEnabled) {
                    throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
                }
                return 255;
            }
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)deviceCIdata, (Pointer)hostCIdata, (long)(cIdata.length * 8), (int)1);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceROdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        int result = 0;
        try {
            result = JCufft.cufftExecZ2D(plan, deviceCIdata, deviceROdata);
        }
        catch (CudaException e) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceROdata);
            }
            result = 255;
        }
        if (result != 0) {
            if (exceptionsEnabled) {
                throw new CudaException(cufftResult.stringFor(cudaResult));
            }
            return result;
        }
        cudaResult = JCuda.cudaMemcpy((Pointer)hostROdata, (Pointer)deviceROdata, (long)(rOdata.length * 8), (int)2);
        if (cudaResult != 0) {
            JCuda.cudaFree((Pointer)deviceCIdata);
            if (!inPlace) {
                JCuda.cudaFree((Pointer)deviceROdata);
            }
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        cudaResult = JCuda.cudaFree((Pointer)deviceCIdata);
        if (cudaResult != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        if (!inPlace && (cudaResult = JCuda.cudaFree((Pointer)deviceROdata)) != 0) {
            if (exceptionsEnabled) {
                throw new CudaException("JCuda error: " + cudaError.stringFor((int)cudaResult));
            }
            return 255;
        }
        return result;
    }

    static {
        JCufft.initialize();
    }
}

