/*
 * JCusolver - Java bindings for CUSOLVER, the NVIDIA CUDA solver
 * library, to be used with JCuda
 *
 * Copyright (c) 2010-2017 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

 /* DO NOT EDIT THIS FILE - it is machine generated */
#include <jni.h>
/* Header for class jcuda_jcusolver_JCusolverDn */

#ifndef _Included_jcuda_jcusolver_JCusolverDn
#define _Included_jcuda_jcusolver_JCusolverDn
#ifdef __cplusplus
extern "C" {
#endif
    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCreateNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCreateNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDestroyNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDestroyNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSetStreamNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/runtime/cudaStream_t;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSetStreamNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnGetStreamNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/runtime/cudaStream_t;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnGetStreamNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSParamsCreateNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSParams;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSParamsCreateNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSParamsDestroyNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSParams;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSParamsDestroyNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSParamsSetRefinementSolverNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSParams;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSParamsSetRefinementSolverNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSParamsSetSolverMainPrecisionNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSParams;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSParamsSetSolverMainPrecisionNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSParamsSetSolverLowestPrecisionNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSParams;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSParamsSetSolverLowestPrecisionNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSParamsSetSolverPrecisionsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSParams;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSParamsSetSolverPrecisionsNative
    (JNIEnv*, jclass, jobject, jint, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSParamsSetTolNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSParams;D)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSParamsSetTolNative
    (JNIEnv*, jclass, jobject, jdouble);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSParamsSetTolInnerNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSParams;D)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSParamsSetTolInnerNative
    (JNIEnv*, jclass, jobject, jdouble);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSParamsSetMaxItersNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSParams;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSParamsSetMaxItersNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSParamsSetMaxItersInnerNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSParams;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSParamsSetMaxItersInnerNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSParamsGetMaxItersNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSParams;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSParamsGetMaxItersNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSParamsEnableFallbackNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSParams;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSParamsEnableFallbackNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSParamsDisableFallbackNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSParams;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSParamsDisableFallbackNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSInfosDestroyNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSInfos;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSInfosDestroyNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSInfosCreateNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSInfos;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSInfosCreateNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSInfosGetNitersNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSInfos;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSInfosGetNitersNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSInfosGetOuterNitersNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSInfos;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSInfosGetOuterNitersNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSInfosRequestResidualNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSInfos;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSInfosRequestResidualNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSInfosGetResidualHistoryNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSInfos;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSInfosGetResidualHistoryNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSInfosGetMaxItersNative
     * Signature: (Ljcuda/jcusolver/cusolverDnIRSInfos;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSInfosGetMaxItersNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZZgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZZgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZCgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZCgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZKgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZKgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZEgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZEgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZYgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZYgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCCgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCCgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCEgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCEgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCKgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCKgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCYgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCYgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDDgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDDgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDSgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDSgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDHgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDHgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDBgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDBgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDXgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDXgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSSgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSSgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSHgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSHgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSBgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSBgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSXgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSXgesvNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZZgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZZgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZCgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZCgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZKgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZKgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZEgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZEgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZYgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZYgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCCgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCCgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCKgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCKgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCEgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCEgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCYgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCYgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDDgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDDgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDSgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDSgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDHgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDHgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDBgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDBgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDXgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDXgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSSgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSSgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSHgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSHgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSBgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSBgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSXgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSXgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZZgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZZgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZCgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZCgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZKgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZKgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZEgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZEgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZYgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZYgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCCgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCCgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCKgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCKgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCEgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCEgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCYgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCYgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDDgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDDgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDSgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDSgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDHgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDHgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDBgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDBgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDXgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDXgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSSgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSSgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSHgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSHgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSBgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSBgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSXgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSXgelsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZZgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZZgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZCgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZCgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZKgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZKgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZEgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZEgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZYgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZYgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCCgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCCgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCKgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCKgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCEgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCEgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCYgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCYgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDDgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDDgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDSgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDSgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDHgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDHgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDBgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDBgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDXgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDXgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSSgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSSgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSHgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSHgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSBgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSBgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSXgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSXgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSXgesvNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnIRSParams;Ljcuda/jcusolver/cusolverDnIRSInfos;IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSXgesvNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSXgesv_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnIRSParams;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSXgesv_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSXgelsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnIRSParams;Ljcuda/jcusolver/cusolverDnIRSInfos;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;J[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSXgelsNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint, jobject, jlong, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnIRSXgels_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnIRSParams;III[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnIRSXgels_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jobject, jint, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSpotrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSpotrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDpotrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDpotrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCpotrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCpotrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZpotrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZpotrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSpotrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSpotrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDpotrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDpotrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCpotrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCpotrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZpotrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZpotrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSpotrsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSpotrsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDpotrsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDpotrsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCpotrsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCpotrsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZpotrsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZpotrsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSpotrfBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSpotrfBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDpotrfBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDpotrfBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCpotrfBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCpotrfBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZpotrfBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZpotrfBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSpotrsBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSpotrsBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDpotrsBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDpotrsBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCpotrsBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCpotrsBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZpotrsBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZpotrsBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSpotri_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSpotri_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDpotri_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDpotri_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCpotri_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCpotri_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZpotri_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZpotri_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSpotriNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSpotriNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDpotriNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDpotriNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCpotriNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCpotriNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZpotriNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZpotriNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnStrtri_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnStrtri_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDtrtri_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDtrtri_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCtrtri_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCtrtri_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZtrtri_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZtrtri_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnStrtriNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnStrtriNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDtrtriNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDtrtriNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCtrtriNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCtrtriNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZtrtriNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZtrtriNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSlauum_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSlauum_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDlauum_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDlauum_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnClauum_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnClauum_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZlauum_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZlauum_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSlauumNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSlauumNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDlauumNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDlauumNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnClauumNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnClauumNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZlauumNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZlauumNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSgetrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSgetrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDgetrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDgetrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCgetrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCgetrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZgetrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZgetrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSgetrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSgetrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDgetrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDgetrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCgetrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCgetrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZgetrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZgetrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSlaswpNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;ILjcuda/Pointer;IIILjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSlaswpNative
    (JNIEnv*, jclass, jobject, jint, jobject, jint, jint, jint, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDlaswpNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;ILjcuda/Pointer;IIILjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDlaswpNative
    (JNIEnv*, jclass, jobject, jint, jobject, jint, jint, jint, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnClaswpNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;ILjcuda/Pointer;IIILjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnClaswpNative
    (JNIEnv*, jclass, jobject, jint, jobject, jint, jint, jint, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZlaswpNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;ILjcuda/Pointer;IIILjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZlaswpNative
    (JNIEnv*, jclass, jobject, jint, jobject, jint, jint, jint, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSgetrsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSgetrsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDgetrsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDgetrsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCgetrsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCgetrsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZgetrsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZgetrsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSgeqrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSgeqrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDgeqrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDgeqrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCgeqrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCgeqrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZgeqrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZgeqrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSgeqrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSgeqrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDgeqrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDgeqrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCgeqrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCgeqrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZgeqrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZgeqrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSorgqr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSorgqr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDorgqr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDorgqr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCungqr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCungqr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZungqr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZungqr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSorgqrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSorgqrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDorgqrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDorgqrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCungqrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCungqrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZungqrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZungqrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSormqr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSormqr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDormqr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDormqr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCunmqr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCunmqr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZunmqr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZunmqr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSormqrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSormqrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDormqrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDormqrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCunmqrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCunmqrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZunmqrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZunmqrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsytrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;ILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsytrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsytrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;ILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsytrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCsytrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;ILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCsytrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZsytrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;ILjcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZsytrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsytrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsytrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsytrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsytrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCsytrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCsytrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZsytrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZsytrfNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsytrs_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsytrs_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsytrs_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsytrs_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCsytrs_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCsytrs_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZsytrs_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZsytrs_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsytrsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsytrsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsytrsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsytrsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCsytrsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCsytrsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZsytrsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZsytrsNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsytri_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsytri_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsytri_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsytri_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCsytri_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCsytri_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZsytri_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZsytri_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsytriNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsytriNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsytriNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsytriNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCsytriNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCsytriNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZsytriNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZsytriNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSgebrd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSgebrd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDgebrd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDgebrd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCgebrd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCgebrd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZgebrd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZgebrd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSgebrdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSgebrdNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDgebrdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDgebrdNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCgebrdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCgebrdNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZgebrdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZgebrdNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSorgbr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSorgbr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDorgbr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDorgbr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCungbr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCungbr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZungbr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZungbr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSorgbrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSorgbrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDorgbrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDorgbrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCungbrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCungbrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZungbrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZungbrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsytrd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsytrd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsytrd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsytrd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnChetrd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnChetrd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZhetrd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZhetrd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsytrdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsytrdNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsytrdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsytrdNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnChetrdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnChetrdNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZhetrdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZhetrdNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSorgtr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSorgtr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDorgtr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDorgtr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCungtr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCungtr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZungtr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZungtr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSorgtrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSorgtrNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDorgtrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDorgtrNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCungtrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCungtrNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZungtrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZungtrNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSormtr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSormtr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDormtr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDormtr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCunmtr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCunmtr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZunmtr_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZunmtr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSormtrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSormtrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDormtrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDormtrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCunmtrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCunmtrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZunmtrNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZunmtrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSgesvd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSgesvd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDgesvd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDgesvd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCgesvd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCgesvd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZgesvd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZgesvd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSgesvdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;CCIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSgesvdNative
    (JNIEnv*, jclass, jobject, jchar, jchar, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDgesvdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;CCIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDgesvdNative
    (JNIEnv*, jclass, jobject, jchar, jchar, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCgesvdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;CCIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCgesvdNative
    (JNIEnv*, jclass, jobject, jchar, jchar, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZgesvdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;CCIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZgesvdNative
    (JNIEnv*, jclass, jobject, jchar, jchar, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsyevd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsyevd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsyevd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsyevd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCheevd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCheevd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZheevd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZheevd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsyevdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsyevdNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsyevdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsyevdNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCheevdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCheevdNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZheevdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZheevdNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsyevdx_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IFFIILjcuda/Pointer;Ljcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsyevdx_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jfloat, jfloat, jint, jint, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsyevdx_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IDDIILjcuda/Pointer;Ljcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsyevdx_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jdouble, jdouble, jint, jint, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCheevdx_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IFFIILjcuda/Pointer;Ljcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCheevdx_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jfloat, jfloat, jint, jint, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZheevdx_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IDDIILjcuda/Pointer;Ljcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZheevdx_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jdouble, jdouble, jint, jint, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsyevdxNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IFFIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsyevdxNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jfloat, jfloat, jint, jint, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsyevdxNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IDDIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsyevdxNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jdouble, jdouble, jint, jint, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCheevdxNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IFFIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCheevdxNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jfloat, jfloat, jint, jint, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZheevdxNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IDDIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZheevdxNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jdouble, jdouble, jint, jint, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsygvdx_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;IFFIILjcuda/Pointer;Ljcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsygvdx_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint, jfloat, jfloat, jint, jint, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsygvdx_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;IDDIILjcuda/Pointer;Ljcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsygvdx_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint, jdouble, jdouble, jint, jint, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnChegvdx_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;IFFIILjcuda/Pointer;Ljcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnChegvdx_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint, jfloat, jfloat, jint, jint, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZhegvdx_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;IDDIILjcuda/Pointer;Ljcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZhegvdx_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint, jdouble, jdouble, jint, jint, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsygvdxNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;IFFIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsygvdxNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint, jfloat, jfloat, jint, jint, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsygvdxNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;IDDIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsygvdxNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint, jdouble, jdouble, jint, jint, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnChegvdxNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;IFFIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnChegvdxNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint, jfloat, jfloat, jint, jint, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZhegvdxNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIIILjcuda/Pointer;ILjcuda/Pointer;IDDIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZhegvdxNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jint, jdouble, jdouble, jint, jint, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsygvd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsygvd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsygvd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsygvd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnChegvd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnChegvd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZhegvd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZhegvd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsygvdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsygvdNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsygvdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsygvdNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnChegvdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnChegvdNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZhegvdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZhegvdNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCreateSyevjInfoNative
     * Signature: (Ljcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCreateSyevjInfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDestroySyevjInfoNative
     * Signature: (Ljcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDestroySyevjInfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnXsyevjSetToleranceNative
     * Signature: (Ljcuda/jcusolver/syevjInfo;D)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnXsyevjSetToleranceNative
    (JNIEnv*, jclass, jobject, jdouble);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnXsyevjSetMaxSweepsNative
     * Signature: (Ljcuda/jcusolver/syevjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnXsyevjSetMaxSweepsNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnXsyevjSetSortEigNative
     * Signature: (Ljcuda/jcusolver/syevjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnXsyevjSetSortEigNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnXsyevjGetResidualNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/syevjInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnXsyevjGetResidualNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnXsyevjGetSweepsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/syevjInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnXsyevjGetSweepsNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsyevjBatched_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[ILjcuda/jcusolver/syevjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsyevjBatched_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsyevjBatched_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[ILjcuda/jcusolver/syevjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsyevjBatched_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCheevjBatched_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[ILjcuda/jcusolver/syevjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCheevjBatched_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZheevjBatched_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[ILjcuda/jcusolver/syevjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZheevjBatched_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsyevjBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/syevjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsyevjBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsyevjBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/syevjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsyevjBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCheevjBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/syevjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCheevjBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZheevjBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/syevjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZheevjBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsyevj_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[ILjcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsyevj_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsyevj_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[ILjcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsyevj_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCheevj_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[ILjcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCheevj_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZheevj_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;[ILjcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZheevj_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jintArray, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsyevjNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsyevjNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsyevjNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsyevjNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCheevjNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCheevjNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZheevjNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZheevjNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsygvj_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[ILjcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsygvj_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jintArray, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsygvj_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[ILjcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsygvj_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jintArray, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnChegvj_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[ILjcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnChegvj_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jintArray, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZhegvj_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;[ILjcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZhegvj_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jintArray, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSsygvjNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSsygvjNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDsygvjNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDsygvjNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnChegvjNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnChegvjNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZhegvjNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/syevjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZhegvjNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jint, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCreateGesvdjInfoNative
     * Signature: (Ljcuda/jcusolver/gesvdjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCreateGesvdjInfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDestroyGesvdjInfoNative
     * Signature: (Ljcuda/jcusolver/gesvdjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDestroyGesvdjInfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnXgesvdjSetToleranceNative
     * Signature: (Ljcuda/jcusolver/gesvdjInfo;D)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnXgesvdjSetToleranceNative
    (JNIEnv*, jclass, jobject, jdouble);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnXgesvdjSetMaxSweepsNative
     * Signature: (Ljcuda/jcusolver/gesvdjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnXgesvdjSetMaxSweepsNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnXgesvdjSetSortEigNative
     * Signature: (Ljcuda/jcusolver/gesvdjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnXgesvdjSetSortEigNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnXgesvdjGetResidualNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/gesvdjInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnXgesvdjGetResidualNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnXgesvdjGetSweepsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/gesvdjInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnXgesvdjGetSweepsNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSgesvdjBatched_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I[ILjcuda/jcusolver/gesvdjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSgesvdjBatched_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jintArray, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDgesvdjBatched_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I[ILjcuda/jcusolver/gesvdjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDgesvdjBatched_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jintArray, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCgesvdjBatched_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I[ILjcuda/jcusolver/gesvdjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCgesvdjBatched_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jintArray, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZgesvdjBatched_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I[ILjcuda/jcusolver/gesvdjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZgesvdjBatched_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jintArray, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSgesvdjBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/gesvdjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSgesvdjBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDgesvdjBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/gesvdjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDgesvdjBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCgesvdjBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/gesvdjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCgesvdjBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZgesvdjBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/gesvdjInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZgesvdjBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSgesvdj_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I[ILjcuda/jcusolver/gesvdjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSgesvdj_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jintArray, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDgesvdj_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I[ILjcuda/jcusolver/gesvdjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDgesvdj_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jintArray, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCgesvdj_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I[ILjcuda/jcusolver/gesvdjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCgesvdj_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jintArray, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZgesvdj_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;I[ILjcuda/jcusolver/gesvdjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZgesvdj_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jintArray, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSgesvdjNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/gesvdjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSgesvdjNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDgesvdjNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/gesvdjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDgesvdjNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCgesvdjNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/gesvdjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCgesvdjNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZgesvdjNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusolver/gesvdjInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZgesvdjNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jint, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSgesvdaStridedBatched_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IJLjcuda/Pointer;JLjcuda/Pointer;IJLjcuda/Pointer;IJ[II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSgesvdaStridedBatched_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jlong, jobject, jlong, jobject, jint, jlong, jobject, jint, jlong, jintArray, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDgesvdaStridedBatched_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IJLjcuda/Pointer;JLjcuda/Pointer;IJLjcuda/Pointer;IJ[II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDgesvdaStridedBatched_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jlong, jobject, jlong, jobject, jint, jlong, jobject, jint, jlong, jintArray, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCgesvdaStridedBatched_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IJLjcuda/Pointer;JLjcuda/Pointer;IJLjcuda/Pointer;IJ[II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCgesvdaStridedBatched_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jlong, jobject, jlong, jobject, jint, jlong, jobject, jint, jlong, jintArray, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZgesvdaStridedBatched_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IJLjcuda/Pointer;JLjcuda/Pointer;IJLjcuda/Pointer;IJ[II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZgesvdaStridedBatched_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jlong, jobject, jlong, jobject, jint, jlong, jobject, jint, jlong, jintArray, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSgesvdaStridedBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IJLjcuda/Pointer;JLjcuda/Pointer;IJLjcuda/Pointer;IJLjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSgesvdaStridedBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jlong, jobject, jlong, jobject, jint, jlong, jobject, jint, jlong, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDgesvdaStridedBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IJLjcuda/Pointer;JLjcuda/Pointer;IJLjcuda/Pointer;IJLjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDgesvdaStridedBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jlong, jobject, jlong, jobject, jint, jlong, jobject, jint, jlong, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCgesvdaStridedBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IJLjcuda/Pointer;JLjcuda/Pointer;IJLjcuda/Pointer;IJLjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCgesvdaStridedBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jlong, jobject, jlong, jobject, jint, jlong, jobject, jint, jlong, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnZgesvdaStridedBatchedNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;IIIILjcuda/Pointer;IJLjcuda/Pointer;JLjcuda/Pointer;IJLjcuda/Pointer;IJLjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnZgesvdaStridedBatchedNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jint, jlong, jobject, jlong, jobject, jint, jlong, jobject, jint, jlong, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnCreateParamsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnParams;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnCreateParamsNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnDestroyParamsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnParams;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnDestroyParamsNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSetAdvOptionsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnParams;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSetAdvOptionsNative
    (JNIEnv*, jclass, jobject, jint, jint);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnPotrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnParams;IJILjcuda/Pointer;JI[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnPotrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jobject, jint, jlong, jint, jobject, jlong, jint, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnPotrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnParams;IJILjcuda/Pointer;JILjcuda/Pointer;JLjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnPotrfNative
    (JNIEnv*, jclass, jobject, jobject, jint, jlong, jint, jobject, jlong, jint, jobject, jlong, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnPotrsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnParams;IJJILjcuda/Pointer;JILjcuda/Pointer;JLjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnPotrsNative
    (JNIEnv*, jclass, jobject, jobject, jint, jlong, jlong, jint, jobject, jlong, jint, jobject, jlong, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnGeqrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnParams;JJILjcuda/Pointer;JILjcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnGeqrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jobject, jlong, jlong, jint, jobject, jlong, jint, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnGeqrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnParams;JJILjcuda/Pointer;JILjcuda/Pointer;ILjcuda/Pointer;JLjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnGeqrfNative
    (JNIEnv*, jclass, jobject, jobject, jlong, jlong, jint, jobject, jlong, jint, jobject, jint, jobject, jlong, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnGetrf_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnParams;JJILjcuda/Pointer;JI[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnGetrf_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jobject, jlong, jlong, jint, jobject, jlong, jint, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnGetrfNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnParams;JJILjcuda/Pointer;J[JILjcuda/Pointer;JLjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnGetrfNative
    (JNIEnv*, jclass, jobject, jobject, jlong, jlong, jint, jobject, jlong, jlongArray, jint, jobject, jlong, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnGetrsNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnParams;IJJILjcuda/Pointer;J[JILjcuda/Pointer;JLjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnGetrsNative
    (JNIEnv*, jclass, jobject, jobject, jint, jlong, jlong, jint, jobject, jlong, jlongArray, jint, jobject, jlong, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSyevd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnParams;IIJILjcuda/Pointer;JILjcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSyevd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jobject, jint, jint, jlong, jint, jobject, jlong, jint, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSyevdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnParams;IIJILjcuda/Pointer;JILjcuda/Pointer;ILjcuda/Pointer;JLjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSyevdNative
    (JNIEnv*, jclass, jobject, jobject, jint, jint, jlong, jint, jobject, jlong, jint, jobject, jint, jobject, jlong, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSyevdx_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnParams;IIIJILjcuda/Pointer;JLjcuda/Pointer;Ljcuda/Pointer;JJ[JILjcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSyevdx_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jobject, jint, jint, jint, jlong, jint, jobject, jlong, jobject, jobject, jlong, jlong, jlongArray, jint, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnSyevdxNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnParams;IIIJILjcuda/Pointer;JLjcuda/Pointer;Ljcuda/Pointer;JJ[JILjcuda/Pointer;ILjcuda/Pointer;JLjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnSyevdxNative
    (JNIEnv*, jclass, jobject, jobject, jint, jint, jint, jlong, jint, jobject, jlong, jobject, jobject, jlong, jlong, jlongArray, jint, jobject, jint, jobject, jlong, jobject);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnGesvd_bufferSizeNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnParams;CCJJILjcuda/Pointer;JILjcuda/Pointer;ILjcuda/Pointer;JILjcuda/Pointer;JI[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnGesvd_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jobject, jchar, jchar, jlong, jlong, jint, jobject, jlong, jint, jobject, jint, jobject, jlong, jint, jobject, jlong, jint, jlongArray);

    /*
     * Class:     jcuda_jcusolver_JCusolverDn
     * Method:    cusolverDnGesvdNative
     * Signature: (Ljcuda/jcusolver/cusolverDnHandle;Ljcuda/jcusolver/cusolverDnParams;CCJJILjcuda/Pointer;JILjcuda/Pointer;ILjcuda/Pointer;JILjcuda/Pointer;JILjcuda/Pointer;JLjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusolver_JCusolverDn_cusolverDnGesvdNative
    (JNIEnv*, jclass, jobject, jobject, jchar, jchar, jlong, jlong, jint, jobject, jlong, jint, jobject, jint, jobject, jlong, jint, jobject, jlong, jint, jobject, jlong, jobject);

#ifdef __cplusplus
}
#endif
#endif
