/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcusolver;

import jcuda.CudaException;
import jcuda.JCudaVersion;
import jcuda.LibUtils;
import jcuda.LibUtilsCuda;
import jcuda.LogLevel;
import jcuda.jcusolver.cusolverStatus;

public class JCusolver {
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    private JCusolver() {
    }

    public static void initialize() {
        if (!initialized) {
            String libraryBaseName = "JCusolver-" + JCudaVersion.get();
            String libraryName = LibUtils.createPlatformLibraryName((String)libraryBaseName);
            LibUtilsCuda.loadLibrary((String)libraryName, (String[])new String[0]);
            initialized = true;
        }
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCusolver.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(cusolverStatus.stringFor(result));
        }
        return result;
    }

    public static int cusolverGetProperty(int type, int[] value) {
        return JCusolver.checkResult(JCusolver.cusolverGetPropertyNative(type, value));
    }

    private static native int cusolverGetPropertyNative(int var0, int[] var1);

    public static int cusolverGetVersion(int[] version) {
        return JCusolver.checkResult(JCusolver.cusolverGetVersionNative(version));
    }

    private static native int cusolverGetVersionNative(int[] var0);

    static {
        JCusolver.initialize();
    }
}

