/*
 * JCusparse - Java bindings for CUSPARSE, the NVIDIA CUDA sparse
 * matrix library, to be used with JCuda
 *
 * Copyright (c) 2010-2016 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/* DO NOT EDIT THIS FILE - it is machine generated */
#include <jni.h>
/* Header for class jcuda_jcusparse_JCusparse */

#ifndef _Included_jcuda_jcusparse_JCusparse
#define _Included_jcuda_jcusparse_JCusparse
#ifdef __cplusplus
extern "C" {
#endif
    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    setLogLevelNative
    * Signature: (I)V
    */
    JNIEXPORT void JNICALL Java_jcuda_jcusparse_JCusparse_setLogLevelNative
        (JNIEnv *, jclass, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCreateNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDestroyNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseGetVersionNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetVersionNative
        (JNIEnv *, jclass, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseGetPropertyNative
    * Signature: (I[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetPropertyNative
        (JNIEnv *, jclass, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSetStreamNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSetStreamNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseGetStreamNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/runtime/cudaStream_t;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetStreamNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseGetPointerModeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetPointerModeNative
        (JNIEnv *, jclass, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSetPointerModeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSetPointerModeNative
        (JNIEnv *, jclass, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCreateMatDescrNative
    * Signature: (Ljcuda/jcusparse/cusparseMatDescr;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateMatDescrNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDestroyMatDescrNative
    * Signature: (Ljcuda/jcusparse/cusparseMatDescr;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyMatDescrNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCopyMatDescrNative
    * Signature: (Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseMatDescr;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCopyMatDescrNative
        (JNIEnv *, jclass, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSetMatTypeNative
    * Signature: (Ljcuda/jcusparse/cusparseMatDescr;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSetMatTypeNative
        (JNIEnv *, jclass, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseGetMatTypeNative
    * Signature: (Ljcuda/jcusparse/cusparseMatDescr;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetMatTypeNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSetMatFillModeNative
    * Signature: (Ljcuda/jcusparse/cusparseMatDescr;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSetMatFillModeNative
        (JNIEnv *, jclass, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseGetMatFillModeNative
    * Signature: (Ljcuda/jcusparse/cusparseMatDescr;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetMatFillModeNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSetMatDiagTypeNative
    * Signature: (Ljcuda/jcusparse/cusparseMatDescr;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSetMatDiagTypeNative
        (JNIEnv *, jclass, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseGetMatDiagTypeNative
    * Signature: (Ljcuda/jcusparse/cusparseMatDescr;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetMatDiagTypeNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSetMatIndexBaseNative
    * Signature: (Ljcuda/jcusparse/cusparseMatDescr;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSetMatIndexBaseNative
        (JNIEnv *, jclass, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseGetMatIndexBaseNative
    * Signature: (Ljcuda/jcusparse/cusparseMatDescr;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetMatIndexBaseNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCreateSolveAnalysisInfoNative
    * Signature: (Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateSolveAnalysisInfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDestroySolveAnalysisInfoNative
    * Signature: (Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroySolveAnalysisInfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseGetLevelInfoNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;[ILjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetLevelInfoNative
        (JNIEnv *, jclass, jobject, jobject, jintArray, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCreateCsrsv2InfoNative
    * Signature: (Ljcuda/jcusparse/csrsv2Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateCsrsv2InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDestroyCsrsv2InfoNative
    * Signature: (Ljcuda/jcusparse/csrsv2Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyCsrsv2InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCreateCsric02InfoNative
    * Signature: (Ljcuda/jcusparse/csric02Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateCsric02InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDestroyCsric02InfoNative
    * Signature: (Ljcuda/jcusparse/csric02Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyCsric02InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCreateBsric02InfoNative
    * Signature: (Ljcuda/jcusparse/bsric02Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateBsric02InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDestroyBsric02InfoNative
    * Signature: (Ljcuda/jcusparse/bsric02Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyBsric02InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCreateCsrilu02InfoNative
    * Signature: (Ljcuda/jcusparse/csrilu02Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateCsrilu02InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDestroyCsrilu02InfoNative
    * Signature: (Ljcuda/jcusparse/csrilu02Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyCsrilu02InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCreateBsrilu02InfoNative
    * Signature: (Ljcuda/jcusparse/bsrilu02Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateBsrilu02InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDestroyBsrilu02InfoNative
    * Signature: (Ljcuda/jcusparse/bsrilu02Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyBsrilu02InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCreateBsrsv2InfoNative
    * Signature: (Ljcuda/jcusparse/bsrsv2Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateBsrsv2InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDestroyBsrsv2InfoNative
    * Signature: (Ljcuda/jcusparse/bsrsv2Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyBsrsv2InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCreateBsrsm2InfoNative
    * Signature: (Ljcuda/jcusparse/bsrsm2Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateBsrsm2InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDestroyBsrsm2InfoNative
    * Signature: (Ljcuda/jcusparse/bsrsm2Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyBsrsm2InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCreateHybMatNative
    * Signature: (Ljcuda/jcusparse/cusparseHybMat;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateHybMatNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDestroyHybMatNative
    * Signature: (Ljcuda/jcusparse/cusparseHybMat;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyHybMatNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCreateCsru2csrInfoNative
    * Signature: (Ljcuda/jcusparse/csru2csrInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateCsru2csrInfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDestroyCsru2csrInfoNative
    * Signature: (Ljcuda/jcusparse/csru2csrInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyCsru2csrInfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCreateColorInfoNative
    * Signature: (Ljcuda/jcusparse/cusparseColorInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateColorInfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDestroyColorInfoNative
    * Signature: (Ljcuda/jcusparse/cusparseColorInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyColorInfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSetColorAlgsNative
    * Signature: (Ljcuda/jcusparse/cusparseColorInfo;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSetColorAlgsNative
        (JNIEnv *, jclass, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseGetColorAlgsNative
    * Signature: (Ljcuda/jcusparse/cusparseColorInfo;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetColorAlgsNative
        (JNIEnv *, jclass, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSaxpyiNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSaxpyiNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDaxpyiNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDaxpyiNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCaxpyiNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCaxpyiNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZaxpyiNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZaxpyiNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSdotiNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSdotiNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDdotiNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDdotiNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCdotiNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCdotiNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZdotiNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZdotiNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCdotciNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCdotciNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZdotciNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZdotciNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSgthrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgthrNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDgthrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgthrNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCgthrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgthrNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZgthrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgthrNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSgthrzNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgthrzNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDgthrzNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgthrzNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCgthrzNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgthrzNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZgthrzNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgthrzNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSsctrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSsctrNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDsctrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDsctrNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCsctrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCsctrNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZsctrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZsctrNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSrotiNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSrotiNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDrotiNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDrotiNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSgemviNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgemviNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSgemvi_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIII[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgemvi_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDgemviNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgemviNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDgemvi_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIII[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgemvi_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCgemviNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgemviNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCgemvi_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIII[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgemvi_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZgemviNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgemviNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZgemvi_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIII[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgemvi_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrmvNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrmvNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrmvNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrmvNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCsrmvEx_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;II[J)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCsrmvEx_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jint, jobject, jint, jint, jlongArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCsrmvExNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCsrmvExNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jint, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrmv_mpNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrmv_1mpNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrmv_mpNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrmv_1mpNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrmv_mpNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrmv_1mpNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrmv_mpNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrmv_1mpNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseShybmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseShybmvNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDhybmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDhybmvNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseChybmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseChybmvNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZhybmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZhybmvNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrmvNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrmvNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrmvNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrmvNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrxmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrxmvNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrxmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrxmvNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrxmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrxmvNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrxmvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrxmvNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCsrsv_analysisExNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCsrsv_1analysisExNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrsv_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrsv_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrsv_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrsv_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrsv_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrsv_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrsv_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrsv_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCsrsv_solveExNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;Ljcuda/Pointer;ILjcuda/Pointer;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCsrsv_1solveExNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrsv_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrsv_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrsv_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrsv_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrsv_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrsv_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrsv_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrsv_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcsrsv2_zeroPivotNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/csrsv2Info;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsrsv2_1zeroPivotNative
        (JNIEnv *, jclass, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrsv2_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrsv2_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrsv2_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrsv2_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrsv2_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrsv2_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrsv2_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrsv2_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrsv2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrsv2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrsv2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrsv2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrsv2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrsv2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrsv2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrsv2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrsv2_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrsv2_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrsv2_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrsv2_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrsv2_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrsv2_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrsv2_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrsv2_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrsv2_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrsv2_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrsv2_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrsv2_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrsv2_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrsv2_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrsv2_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrsv2_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXbsrsv2_zeroPivotNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsrsv2Info;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXbsrsv2_1zeroPivotNative
        (JNIEnv *, jclass, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrsv2_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsv2_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrsv2_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsv2_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrsv2_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsv2_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrsv2_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsv2_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrsv2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsv2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrsv2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsv2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrsv2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsv2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrsv2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsv2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrsv2_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsv2_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrsv2_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsv2_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrsv2_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsv2_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrsv2_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsv2_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrsv2_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsv2_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrsv2_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsv2_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrsv2_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsv2_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrsv2_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsv2_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseShybsv_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseShybsv_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDhybsv_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDhybsv_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseChybsv_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseChybsv_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZhybsv_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZhybsv_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseShybsv_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseShybsv_1solveNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseChybsv_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseChybsv_1solveNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDhybsv_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDhybsv_1solveNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZhybsv_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZhybsv_1solveNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrmmNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrmmNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrmmNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrmmNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrmmNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrmmNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrmmNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrmmNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrmm2Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrmm2Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrmm2Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrmm2Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrmm2Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrmm2Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrmm2Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrmm2Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrmmNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrmmNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrmmNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrmmNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrmmNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrmmNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrmmNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrmmNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSgemmiNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgemmiNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDgemmiNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgemmiNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCgemmiNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgemmiNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZgemmiNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgemmiNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrsm_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrsm_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrsm_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrsm_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrsm_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrsm_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrsm_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrsm_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrsm_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;Ljcuda/Pointer;ILjcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrsm_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrsm_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;Ljcuda/Pointer;ILjcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrsm_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrsm_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;Ljcuda/Pointer;ILjcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrsm_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrsm_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;Ljcuda/Pointer;ILjcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrsm_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXbsrsm2_zeroPivotNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsrsm2Info;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXbsrsm2_1zeroPivotNative
        (JNIEnv *, jclass, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrsm2_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsm2_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrsm2_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsm2_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrsm2_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsm2_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrsm2_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsm2_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrsm2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsm2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrsm2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsm2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrsm2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsm2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrsm2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsm2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrsm2_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsm2_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrsm2_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsm2_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrsm2_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsm2_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrsm2_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsm2_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrsm2_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;Ljcuda/Pointer;ILjcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsm2_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrsm2_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;Ljcuda/Pointer;ILjcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsm2_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrsm2_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;Ljcuda/Pointer;ILjcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsm2_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrsm2_solveNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;Ljcuda/Pointer;ILjcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsm2_1solveNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCsrilu0ExNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCsrilu0ExNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrilu0Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrilu0Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrilu0Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrilu0Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrilu0Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrilu0Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrilu0Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrilu0Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrilu02_numericBoostNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrilu02_1numericBoostNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrilu02_numericBoostNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrilu02_1numericBoostNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrilu02_numericBoostNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrilu02_1numericBoostNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrilu02_numericBoostNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrilu02_1numericBoostNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcsrilu02_zeroPivotNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/csrilu02Info;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsrilu02_1zeroPivotNative
        (JNIEnv *, jclass, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrilu02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrilu02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrilu02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrilu02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrilu02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrilu02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrilu02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrilu02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrilu02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrilu02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrilu02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrilu02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrilu02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrilu02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrilu02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrilu02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrilu02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrilu02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrilu02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrilu02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrilu02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrilu02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrilu02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrilu02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrilu02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrilu02Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrilu02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrilu02Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrilu02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrilu02Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrilu02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrilu02Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrilu02_numericBoostNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrilu02_1numericBoostNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrilu02_numericBoostNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrilu02_1numericBoostNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrilu02_numericBoostNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrilu02_1numericBoostNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrilu02_numericBoostNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrilu02_1numericBoostNative
        (JNIEnv *, jclass, jobject, jobject, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXbsrilu02_zeroPivotNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsrilu02Info;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXbsrilu02_1zeroPivotNative
        (JNIEnv *, jclass, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrilu02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrilu02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrilu02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrilu02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrilu02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrilu02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrilu02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrilu02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrilu02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrilu02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrilu02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrilu02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrilu02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrilu02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrilu02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrilu02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrilu02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrilu02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrilu02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrilu02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrilu02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrilu02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrilu02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrilu02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsrilu02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrilu02Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsrilu02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrilu02Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsrilu02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrilu02Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsrilu02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrilu02Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsric0Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsric0Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsric0Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsric0Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsric0Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsric0Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsric0Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSolveAnalysisInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsric0Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcsric02_zeroPivotNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/csric02Info;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsric02_1zeroPivotNative
        (JNIEnv *, jclass, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsric02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsric02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsric02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsric02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsric02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsric02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsric02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsric02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsric02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsric02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsric02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsric02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsric02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsric02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsric02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsric02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsric02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsric02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsric02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsric02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsric02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsric02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsric02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsric02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsric02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsric02Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsric02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsric02Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsric02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsric02Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsric02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsric02Native
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXbsric02_zeroPivotNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsric02Info;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXbsric02_1zeroPivotNative
        (JNIEnv *, jclass, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsric02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsric02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsric02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsric02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsric02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsric02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsric02_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsric02_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsric02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsric02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsric02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsric02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsric02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsric02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsric02_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsric02_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsric02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsric02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsric02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsric02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsric02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsric02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsric02_analysisNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsric02_1analysisNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsric02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsric02Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsric02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsric02Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsric02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsric02Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsric02Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsric02Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSgtsvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgtsvNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDgtsvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgtsvNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCgtsvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgtsvNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZgtsvNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgtsvNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSgtsv_nopivotNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgtsv_1nopivotNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDgtsv_nopivotNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgtsv_1nopivotNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCgtsv_nopivotNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgtsv_1nopivotNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZgtsv_nopivotNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgtsv_1nopivotNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSgtsvStridedBatchNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgtsvStridedBatchNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDgtsvStridedBatchNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgtsvStridedBatchNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCgtsvStridedBatchNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgtsvStridedBatchNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZgtsvStridedBatchNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgtsvStridedBatchNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcsrgemmNnzNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsrgemmNnzNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrgemmNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrgemmNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrgemmNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrgemmNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrgemmNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrgemmNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrgemmNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrgemmNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCreateCsrgemm2InfoNative
    * Signature: (Ljcuda/jcusparse/csrgemm2Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateCsrgemm2InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDestroyCsrgemm2InfoNative
    * Signature: (Ljcuda/jcusparse/csrgemm2Info;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyCsrgemm2InfoNative
        (JNIEnv *, jclass, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrgemm2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrgemm2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrgemm2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrgemm2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrgemm2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrgemm2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrgemm2_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrgemm2_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcsrgemm2NnzNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsrgemm2NnzNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrgemm2Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrgemm2Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrgemm2Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrgemm2Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrgemm2Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrgemm2Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrgemm2Native
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrgemm2Native
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcsrgeamNnzNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsrgeamNnzNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrgeamNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrgeamNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrgeamNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrgeamNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrgeamNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrgeamNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrgeamNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrgeamNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsrcolorNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseColorInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrcolorNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsrcolorNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseColorInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrcolorNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsrcolorNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseColorInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrcolorNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsrcolorNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseColorInfo;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrcolorNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSnnzNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSnnzNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDnnzNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDnnzNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCnnzNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCnnzNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZnnzNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZnnzNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSnnz_compressNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;F)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSnnz_1compressNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jfloat);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDnnz_compressNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;D)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDnnz_1compressNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jdouble);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCnnz_compressNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/cuComplex;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCnnz_1compressNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZnnz_compressNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/cuDoubleComplex;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZnnz_1compressNative
        (JNIEnv *, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsr2csr_compressNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;F)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2csr_1compressNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jfloat);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsr2csr_compressNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;D)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2csr_1compressNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jdouble);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsr2csr_compressNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/cuComplex;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2csr_1compressNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsr2csr_compressNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/cuDoubleComplex;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2csr_1compressNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSdense2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSdense2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDdense2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDdense2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCdense2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCdense2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZdense2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZdense2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsr2denseNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2denseNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsr2denseNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2denseNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsr2denseNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2denseNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsr2denseNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2denseNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSdense2cscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSdense2cscNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDdense2cscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDdense2cscNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCdense2cscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCdense2cscNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZdense2cscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZdense2cscNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsc2denseNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsc2denseNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsc2denseNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsc2denseNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsc2denseNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsc2denseNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsc2denseNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsc2denseNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcoo2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/Pointer;IILjcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcoo2csrNative
        (JNIEnv *, jclass, jobject, jobject, jint, jint, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcsr2cooNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/Pointer;IILjcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsr2cooNative
        (JNIEnv *, jclass, jobject, jobject, jint, jint, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCsr2cscExNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;III)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCsr2cscExNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jint, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsr2cscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2cscNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsr2cscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2cscNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsr2cscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2cscNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsr2cscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2cscNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSdense2hybNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseHybMat;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSdense2hybNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDdense2hybNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseHybMat;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDdense2hybNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCdense2hybNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseHybMat;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCdense2hybNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZdense2hybNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseHybMat;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZdense2hybNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseShyb2denseNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseShyb2denseNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDhyb2denseNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDhyb2denseNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseChyb2denseNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseChyb2denseNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZhyb2denseNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZhyb2denseNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsr2hybNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseHybMat;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2hybNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsr2hybNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseHybMat;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2hybNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsr2hybNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseHybMat;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2hybNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsr2hybNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseHybMat;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2hybNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseShyb2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseShyb2csrNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDhyb2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDhyb2csrNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseChyb2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseChyb2csrNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZhyb2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZhyb2csrNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsc2hybNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseHybMat;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsc2hybNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsc2hybNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseHybMat;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsc2hybNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsc2hybNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseHybMat;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsc2hybNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsc2hybNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseHybMat;II)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsc2hybNative
        (JNIEnv *, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jint);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseShyb2cscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseShyb2cscNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDhyb2cscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDhyb2cscNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseChyb2cscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseChyb2cscNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZhyb2cscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseHybMat;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZhyb2cscNative
        (JNIEnv *, jclass, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcsr2bsrNnzNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsr2bsrNnzNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsr2bsrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2bsrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsr2bsrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2bsrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsr2bsrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2bsrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsr2bsrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2bsrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSbsr2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsr2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDbsr2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsr2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCbsr2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsr2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZbsr2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsr2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSgebsr2gebsc_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgebsr2gebsc_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDgebsr2gebsc_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgebsr2gebsc_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCgebsr2gebsc_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgebsr2gebsc_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZgebsr2gebsc_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgebsr2gebsc_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSgebsr2gebsc_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgebsr2gebsc_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDgebsr2gebsc_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgebsr2gebsc_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCgebsr2gebsc_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgebsr2gebsc_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZgebsr2gebsc_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgebsr2gebsc_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSgebsr2gebscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgebsr2gebscNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDgebsr2gebscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgebsr2gebscNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCgebsr2gebscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgebsr2gebscNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZgebsr2gebscNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgebsr2gebscNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXgebsr2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXgebsr2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSgebsr2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgebsr2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDgebsr2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgebsr2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCgebsr2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgebsr2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZgebsr2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgebsr2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsr2gebsr_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2gebsr_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsr2gebsr_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2gebsr_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsr2gebsr_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2gebsr_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsr2gebsr_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2gebsr_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsr2gebsr_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2gebsr_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsr2gebsr_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2gebsr_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsr2gebsr_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2gebsr_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsr2gebsr_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2gebsr_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcsr2gebsrNnzNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsr2gebsrNnzNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsr2gebsrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2gebsrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsr2gebsrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2gebsrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsr2gebsrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2gebsrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsr2gebsrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2gebsrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSgebsr2gebsr_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgebsr2gebsr_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDgebsr2gebsr_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgebsr2gebsr_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCgebsr2gebsr_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgebsr2gebsr_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZgebsr2gebsr_bufferSizeNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgebsr2gebsr_1bufferSizeNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSgebsr2gebsr_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgebsr2gebsr_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDgebsr2gebsr_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgebsr2gebsr_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCgebsr2gebsr_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgebsr2gebsr_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZgebsr2gebsr_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgebsr2gebsr_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXgebsr2gebsrNnzNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXgebsr2gebsrNnzNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jint, jint, jobject, jobject, jint, jint, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseSgebsr2gebsrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgebsr2gebsrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDgebsr2gebsrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgebsr2gebsrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCgebsr2gebsrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgebsr2gebsrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZgebsr2gebsrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgebsr2gebsrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCreateIdentityPermutationNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateIdentityPermutationNative
        (JNIEnv *, jclass, jobject, jint, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcoosort_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcoosort_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcoosortByRowNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcoosortByRowNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcoosortByColumnNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcoosortByColumnNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcsrsort_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsrsort_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcsrsortNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsrsortNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcscsort_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcscsort_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseXcscsortNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcscsortNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsru2csr_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsru2csr_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsru2csr_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsru2csr_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsru2csr_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsru2csr_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsru2csr_bufferSizeExtNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;[I)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsru2csr_1bufferSizeExtNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jintArray);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsru2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsru2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsru2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsru2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsru2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsru2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsru2csrNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsru2csrNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseScsr2csruNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2csruNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseDcsr2csruNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2csruNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseCcsr2csruNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2csruNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
    * Class:     jcuda_jcusparse_JCusparse
    * Method:    cusparseZcsr2csruNative
    * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
    */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2csruNative
        (JNIEnv *, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

#ifdef __cplusplus
}
#endif
#endif
