/*
 * JCusparse - Java bindings for CUSPARSE, the NVIDIA CUDA sparse
 * matrix library, to be used with JCuda
 *
 * Copyright (c) 2010-2016 Marco Hutter - http://www.jcuda.org
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

 /* DO NOT EDIT THIS FILE - it is machine generated */
#include <jni.h>
/* Header for class jcuda_jcusparse_JCusparse */

#ifndef _Included_jcuda_jcusparse_JCusparse
#define _Included_jcuda_jcusparse_JCusparse
#ifdef __cplusplus
extern "C" {
#endif
    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    setLogLevelNative
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_jcuda_jcusparse_JCusparse_setLogLevelNative
    (JNIEnv*, jclass, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseGetVersionNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetVersionNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseGetPropertyNative
     * Signature: (I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetPropertyNative
    (JNIEnv*, jclass, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseGetErrorNameNative
     * Signature: (I)Ljava/lang/String;
     */
    JNIEXPORT jstring JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetErrorNameNative
    (JNIEnv*, jclass, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseGetErrorStringNative
     * Signature: (I)Ljava/lang/String;
     */
    JNIEXPORT jstring JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetErrorStringNative
    (JNIEnv*, jclass, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSetStreamNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/runtime/cudaStream_t;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSetStreamNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseGetStreamNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/runtime/cudaStream_t;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetStreamNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseGetPointerModeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetPointerModeNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSetPointerModeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSetPointerModeNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateMatDescrNative
     * Signature: (Ljcuda/jcusparse/cusparseMatDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateMatDescrNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyMatDescrNative
     * Signature: (Ljcuda/jcusparse/cusparseMatDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyMatDescrNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCopyMatDescrNative
     * Signature: (Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/jcusparse/cusparseMatDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCopyMatDescrNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSetMatTypeNative
     * Signature: (Ljcuda/jcusparse/cusparseMatDescr;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSetMatTypeNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseGetMatTypeNative
     * Signature: (Ljcuda/jcusparse/cusparseMatDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetMatTypeNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSetMatFillModeNative
     * Signature: (Ljcuda/jcusparse/cusparseMatDescr;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSetMatFillModeNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseGetMatFillModeNative
     * Signature: (Ljcuda/jcusparse/cusparseMatDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetMatFillModeNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSetMatDiagTypeNative
     * Signature: (Ljcuda/jcusparse/cusparseMatDescr;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSetMatDiagTypeNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseGetMatDiagTypeNative
     * Signature: (Ljcuda/jcusparse/cusparseMatDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetMatDiagTypeNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSetMatIndexBaseNative
     * Signature: (Ljcuda/jcusparse/cusparseMatDescr;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSetMatIndexBaseNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseGetMatIndexBaseNative
     * Signature: (Ljcuda/jcusparse/cusparseMatDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetMatIndexBaseNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateCsrsv2InfoNative
     * Signature: (Ljcuda/jcusparse/csrsv2Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateCsrsv2InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyCsrsv2InfoNative
     * Signature: (Ljcuda/jcusparse/csrsv2Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyCsrsv2InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateCsric02InfoNative
     * Signature: (Ljcuda/jcusparse/csric02Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateCsric02InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyCsric02InfoNative
     * Signature: (Ljcuda/jcusparse/csric02Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyCsric02InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateBsric02InfoNative
     * Signature: (Ljcuda/jcusparse/bsric02Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateBsric02InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyBsric02InfoNative
     * Signature: (Ljcuda/jcusparse/bsric02Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyBsric02InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateCsrilu02InfoNative
     * Signature: (Ljcuda/jcusparse/csrilu02Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateCsrilu02InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyCsrilu02InfoNative
     * Signature: (Ljcuda/jcusparse/csrilu02Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyCsrilu02InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateBsrilu02InfoNative
     * Signature: (Ljcuda/jcusparse/bsrilu02Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateBsrilu02InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyBsrilu02InfoNative
     * Signature: (Ljcuda/jcusparse/bsrilu02Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyBsrilu02InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateBsrsv2InfoNative
     * Signature: (Ljcuda/jcusparse/bsrsv2Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateBsrsv2InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyBsrsv2InfoNative
     * Signature: (Ljcuda/jcusparse/bsrsv2Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyBsrsv2InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateBsrsm2InfoNative
     * Signature: (Ljcuda/jcusparse/bsrsm2Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateBsrsm2InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyBsrsm2InfoNative
     * Signature: (Ljcuda/jcusparse/bsrsm2Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyBsrsm2InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateCsru2csrInfoNative
     * Signature: (Ljcuda/jcusparse/csru2csrInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateCsru2csrInfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyCsru2csrInfoNative
     * Signature: (Ljcuda/jcusparse/csru2csrInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyCsru2csrInfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateColorInfoNative
     * Signature: (Ljcuda/jcusparse/cusparseColorInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateColorInfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyColorInfoNative
     * Signature: (Ljcuda/jcusparse/cusparseColorInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyColorInfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSetColorAlgsNative
     * Signature: (Ljcuda/jcusparse/cusparseColorInfo;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSetColorAlgsNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseGetColorAlgsNative
     * Signature: (Ljcuda/jcusparse/cusparseColorInfo;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGetColorAlgsNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreatePruneInfoNative
     * Signature: (Ljcuda/jcusparse/pruneInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreatePruneInfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyPruneInfoNative
     * Signature: (Ljcuda/jcusparse/pruneInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyPruneInfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSaxpyiNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSaxpyiNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDaxpyiNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDaxpyiNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCaxpyiNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCaxpyiNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZaxpyiNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZaxpyiNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgthrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgthrNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgthrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgthrNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgthrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgthrNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgthrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgthrNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgthrzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgthrzNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgthrzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgthrzNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgthrzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgthrzNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgthrzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgthrzNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSsctrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSsctrNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDsctrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDsctrNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCsctrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCsctrNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZsctrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZsctrNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSrotiNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSrotiNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDrotiNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDrotiNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgemviNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgemviNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgemvi_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIII[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgemvi_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgemviNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgemviNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgemvi_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIII[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgemvi_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgemviNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgemviNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgemvi_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIII[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgemvi_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgemviNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgemviNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgemvi_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIII[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgemvi_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCsrmvEx_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCsrmvEx_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jint, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCsrmvExNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCsrmvExNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jint, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jint, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrmvNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrmvNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrmvNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrmvNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrmvNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrmvNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrmvNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrmvNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrxmvNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrxmvNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrxmvNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrxmvNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrxmvNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrxmvNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrxmvNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrxmvNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcsrsv2_zeroPivotNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/csrsv2Info;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsrsv2_1zeroPivotNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrsv2_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrsv2_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrsv2_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrsv2_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrsv2_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrsv2_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrsv2_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrsv2_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrsv2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrsv2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrsv2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrsv2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrsv2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrsv2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrsv2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrsv2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrsv2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrsv2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrsv2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrsv2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrsv2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrsv2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrsv2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrsv2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrsv2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrsv2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrsv2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrsv2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrsv2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrsv2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrsv2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrsv2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXbsrsv2_zeroPivotNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsrsv2Info;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXbsrsv2_1zeroPivotNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrsv2_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsv2_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrsv2_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsv2_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrsv2_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsv2_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrsv2_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsv2_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrsv2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsv2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrsv2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsv2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrsv2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsv2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrsv2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsv2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrsv2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsv2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrsv2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsv2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrsv2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsv2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrsv2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsv2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrsv2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsv2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrsv2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsv2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrsv2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsv2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrsv2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsv2Info;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsv2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrmmNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrmmNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrmmNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrmmNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrmmNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrmmNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrmmNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrmmNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgemmiNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgemmiNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgemmiNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgemmiNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgemmiNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgemmiNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgemmiNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgemmiNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateCsrsm2InfoNative
     * Signature: (Ljcuda/jcusparse/csrsm2Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateCsrsm2InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyCsrsm2InfoNative
     * Signature: (Ljcuda/jcusparse/csrsm2Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyCsrsm2InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcsrsm2_zeroPivotNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/csrsm2Info;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsrsm2_1zeroPivotNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrsm2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/csrsm2Info;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrsm2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrsm2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/csrsm2Info;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrsm2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrsm2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/csrsm2Info;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrsm2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrsm2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/csrsm2Info;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrsm2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrsm2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/csrsm2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrsm2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrsm2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/csrsm2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrsm2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrsm2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/csrsm2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrsm2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrsm2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/csrsm2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrsm2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrsm2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/csrsm2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrsm2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrsm2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/csrsm2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrsm2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrsm2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/csrsm2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrsm2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrsm2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/csrsm2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrsm2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXbsrsm2_zeroPivotNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsrsm2Info;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXbsrsm2_1zeroPivotNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrsm2_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsm2_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrsm2_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsm2_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrsm2_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsm2_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrsm2_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsm2_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrsm2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsm2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrsm2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsm2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrsm2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsm2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrsm2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsm2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrsm2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsm2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrsm2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsm2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrsm2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsm2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrsm2_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsm2_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrsm2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;Ljcuda/Pointer;ILjcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrsm2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrsm2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;Ljcuda/Pointer;ILjcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrsm2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrsm2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;Ljcuda/Pointer;ILjcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrsm2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrsm2_solveNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIIIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrsm2Info;Ljcuda/Pointer;ILjcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrsm2_1solveNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jint, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrilu02_numericBoostNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrilu02_1numericBoostNative
    (JNIEnv*, jclass, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrilu02_numericBoostNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrilu02_1numericBoostNative
    (JNIEnv*, jclass, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrilu02_numericBoostNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrilu02_1numericBoostNative
    (JNIEnv*, jclass, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrilu02_numericBoostNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrilu02_1numericBoostNative
    (JNIEnv*, jclass, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcsrilu02_zeroPivotNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/csrilu02Info;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsrilu02_1zeroPivotNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrilu02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrilu02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrilu02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrilu02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrilu02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrilu02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrilu02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrilu02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrilu02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrilu02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrilu02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrilu02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrilu02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrilu02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrilu02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrilu02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrilu02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrilu02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrilu02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrilu02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrilu02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrilu02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrilu02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrilu02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrilu02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrilu02Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrilu02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrilu02Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrilu02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrilu02Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrilu02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrilu02Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrilu02_numericBoostNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrilu02_1numericBoostNative
    (JNIEnv*, jclass, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrilu02_numericBoostNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrilu02_1numericBoostNative
    (JNIEnv*, jclass, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrilu02_numericBoostNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrilu02_1numericBoostNative
    (JNIEnv*, jclass, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrilu02_numericBoostNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrilu02_1numericBoostNative
    (JNIEnv*, jclass, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXbsrilu02_zeroPivotNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsrilu02Info;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXbsrilu02_1zeroPivotNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrilu02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrilu02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrilu02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrilu02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrilu02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrilu02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrilu02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrilu02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrilu02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrilu02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrilu02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrilu02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrilu02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrilu02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrilu02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrilu02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrilu02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrilu02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrilu02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrilu02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrilu02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrilu02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrilu02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrilu02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsrilu02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsrilu02Native
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsrilu02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsrilu02Native
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsrilu02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsrilu02Native
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsrilu02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsrilu02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsrilu02Native
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcsric02_zeroPivotNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/csric02Info;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsric02_1zeroPivotNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsric02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsric02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsric02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsric02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsric02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsric02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsric02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsric02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsric02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsric02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsric02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsric02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsric02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsric02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsric02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsric02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsric02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsric02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsric02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsric02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsric02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsric02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsric02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsric02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsric02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsric02Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsric02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsric02Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsric02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsric02Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsric02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsric02Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXbsric02_zeroPivotNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/bsric02Info;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXbsric02_1zeroPivotNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsric02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsric02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsric02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsric02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsric02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsric02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsric02_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsric02_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsric02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsric02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsric02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsric02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsric02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsric02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsric02_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsric02_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsric02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsric02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsric02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsric02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsric02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsric02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsric02_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsric02_1analysisNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsric02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsric02Native
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsric02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsric02Native
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsric02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsric02Native
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsric02Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/bsric02Info;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsric02Native
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgtsv2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgtsv2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgtsv2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgtsv2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgtsv2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgtsv2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgtsv2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgtsv2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgtsv2Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgtsv2Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgtsv2Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgtsv2Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgtsv2Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgtsv2Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgtsv2Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgtsv2Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgtsv2_nopivot_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgtsv2_1nopivot_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgtsv2_nopivot_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgtsv2_1nopivot_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgtsv2_nopivot_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgtsv2_1nopivot_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgtsv2_nopivot_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgtsv2_1nopivot_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgtsv2_nopivotNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgtsv2_1nopivotNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgtsv2_nopivotNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgtsv2_1nopivotNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgtsv2_nopivotNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgtsv2_1nopivotNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgtsv2_nopivotNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgtsv2_1nopivotNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgtsv2StridedBatch_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgtsv2StridedBatch_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgtsv2StridedBatch_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgtsv2StridedBatch_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgtsv2StridedBatch_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgtsv2StridedBatch_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgtsv2StridedBatch_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgtsv2StridedBatch_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgtsv2StridedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgtsv2StridedBatchNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgtsv2StridedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgtsv2StridedBatchNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgtsv2StridedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgtsv2StridedBatchNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgtsv2StridedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgtsv2StridedBatchNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgtsvInterleavedBatch_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgtsvInterleavedBatch_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgtsvInterleavedBatch_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgtsvInterleavedBatch_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgtsvInterleavedBatch_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgtsvInterleavedBatch_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgtsvInterleavedBatch_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgtsvInterleavedBatch_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgtsvInterleavedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgtsvInterleavedBatchNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgtsvInterleavedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgtsvInterleavedBatchNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgtsvInterleavedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgtsvInterleavedBatchNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgtsvInterleavedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgtsvInterleavedBatchNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgpsvInterleavedBatch_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgpsvInterleavedBatch_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgpsvInterleavedBatch_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgpsvInterleavedBatch_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgpsvInterleavedBatch_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgpsvInterleavedBatch_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgpsvInterleavedBatch_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgpsvInterleavedBatch_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgpsvInterleavedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgpsvInterleavedBatchNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgpsvInterleavedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgpsvInterleavedBatchNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgpsvInterleavedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgpsvInterleavedBatchNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgpsvInterleavedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgpsvInterleavedBatchNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateCsrgemm2InfoNative
     * Signature: (Ljcuda/jcusparse/csrgemm2Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateCsrgemm2InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyCsrgemm2InfoNative
     * Signature: (Ljcuda/jcusparse/csrgemm2Info;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyCsrgemm2InfoNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrgemm2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrgemm2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrgemm2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrgemm2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrgemm2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrgemm2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrgemm2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrgemm2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcsrgemm2NnzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsrgemm2NnzNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrgemm2Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrgemm2Native
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrgemm2Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrgemm2Native
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrgemm2Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrgemm2Native
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrgemm2Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csrgemm2Info;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrgemm2Native
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrgeam2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrgeam2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrgeam2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrgeam2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrgeam2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrgeam2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrgeam2_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrgeam2_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcsrgeam2NnzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsrgeam2NnzNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrgeam2Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrgeam2Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrgeam2Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrgeam2Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrgeam2Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrgeam2Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrgeam2Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrgeam2Native
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsrcolorNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseColorInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsrcolorNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsrcolorNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseColorInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsrcolorNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsrcolorNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseColorInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsrcolorNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsrcolorNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseColorInfo;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsrcolorNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSnnzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSnnzNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDnnzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDnnzNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCnnzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCnnzNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZnnzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZnnzNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSnnz_compressNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;F)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSnnz_1compressNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jfloat);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDnnz_compressNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;D)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDnnz_1compressNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jdouble);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCnnz_compressNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/cuComplex;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCnnz_1compressNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZnnz_compressNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/cuDoubleComplex;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZnnz_1compressNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsr2csr_compressNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;F)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2csr_1compressNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jfloat);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsr2csr_compressNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;D)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2csr_1compressNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jdouble);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsr2csr_compressNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/cuComplex;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2csr_1compressNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsr2csr_compressNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/cuDoubleComplex;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2csr_1compressNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSdense2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSdense2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDdense2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDdense2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCdense2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCdense2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZdense2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZdense2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsr2denseNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2denseNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsr2denseNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2denseNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsr2denseNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2denseNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsr2denseNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2denseNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSdense2cscNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSdense2cscNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDdense2cscNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDdense2cscNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCdense2cscNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCdense2cscNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZdense2cscNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;ILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZdense2cscNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsc2denseNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsc2denseNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsc2denseNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsc2denseNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsc2denseNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsc2denseNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsc2denseNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsc2denseNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcoo2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/Pointer;IILjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcoo2csrNative
    (JNIEnv*, jclass, jobject, jobject, jint, jint, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcsr2cooNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/Pointer;IILjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsr2cooNative
    (JNIEnv*, jclass, jobject, jobject, jint, jint, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcsr2bsrNnzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsr2bsrNnzNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsr2bsrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2bsrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsr2bsrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2bsrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsr2bsrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2bsrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsr2bsrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2bsrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSbsr2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSbsr2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDbsr2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDbsr2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCbsr2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCbsr2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZbsr2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;ILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZbsr2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgebsr2gebsc_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgebsr2gebsc_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgebsr2gebsc_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgebsr2gebsc_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgebsr2gebsc_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgebsr2gebsc_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgebsr2gebsc_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgebsr2gebsc_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgebsr2gebsc_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgebsr2gebsc_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgebsr2gebsc_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgebsr2gebsc_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgebsr2gebsc_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgebsr2gebsc_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgebsr2gebsc_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgebsr2gebsc_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgebsr2gebscNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgebsr2gebscNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgebsr2gebscNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgebsr2gebscNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgebsr2gebscNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgebsr2gebscNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgebsr2gebscNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgebsr2gebscNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXgebsr2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXgebsr2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgebsr2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgebsr2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgebsr2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgebsr2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgebsr2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgebsr2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgebsr2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgebsr2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsr2gebsr_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2gebsr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsr2gebsr_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2gebsr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsr2gebsr_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2gebsr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsr2gebsr_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2gebsr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsr2gebsr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2gebsr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsr2gebsr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2gebsr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsr2gebsr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2gebsr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsr2gebsr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2gebsr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcsr2gebsrNnzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsr2gebsrNnzNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsr2gebsrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2gebsrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsr2gebsrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2gebsrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsr2gebsrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2gebsrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsr2gebsrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2gebsrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgebsr2gebsr_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgebsr2gebsr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgebsr2gebsr_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgebsr2gebsr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgebsr2gebsr_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgebsr2gebsr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgebsr2gebsr_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgebsr2gebsr_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgebsr2gebsr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgebsr2gebsr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgebsr2gebsr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgebsr2gebsr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgebsr2gebsr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgebsr2gebsr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgebsr2gebsr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgebsr2gebsr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXgebsr2gebsrNnzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;IILjcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXgebsr2gebsrNnzNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jint, jint, jobject, jobject, jint, jint, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSgebsr2gebsrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSgebsr2gebsrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDgebsr2gebsrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDgebsr2gebsrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCgebsr2gebsrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCgebsr2gebsrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZgebsr2gebsrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZgebsr2gebsrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateIdentityPermutationNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateIdentityPermutationNative
    (JNIEnv*, jclass, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcoosort_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcoosort_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcoosortByRowNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcoosortByRowNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcoosortByColumnNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcoosortByColumnNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcsrsort_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsrsort_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcsrsortNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcsrsortNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcscsort_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcscsort_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseXcscsortNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseXcscsortNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsru2csr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsru2csr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsru2csr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsru2csr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsru2csr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsru2csr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsru2csr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsru2csr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsru2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsru2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsru2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsru2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsru2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsru2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsru2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsru2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScsr2csruNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScsr2csruNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDcsr2csruNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDcsr2csruNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCcsr2csruNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCcsr2csruNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseZcsr2csruNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/csru2csrInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseZcsr2csruNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpruneDense2csr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpruneDense2csr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDpruneDense2csr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDpruneDense2csr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpruneDense2csrNnzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpruneDense2csrNnzNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDpruneDense2csrNnzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDpruneDense2csrNnzNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpruneDense2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpruneDense2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDpruneDense2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDpruneDense2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpruneCsr2csr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpruneCsr2csr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDpruneCsr2csr_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDpruneCsr2csr_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpruneCsr2csrNnzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpruneCsr2csrNnzNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDpruneCsr2csrNnzNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDpruneCsr2csrNnzNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpruneCsr2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpruneCsr2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDpruneCsr2csrNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDpruneCsr2csrNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpruneDense2csrByPercentage_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;IFLjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/pruneInfo;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpruneDense2csrByPercentage_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jfloat, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDpruneDense2csrByPercentage_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;IFLjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/pruneInfo;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDpruneDense2csrByPercentage_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jfloat, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpruneDense2csrNnzByPercentageNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;IFLjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/pruneInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpruneDense2csrNnzByPercentageNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jfloat, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDpruneDense2csrNnzByPercentageNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;IFLjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/pruneInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDpruneDense2csrNnzByPercentageNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jfloat, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpruneDense2csrByPercentageNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;IFLjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/pruneInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpruneDense2csrByPercentageNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jfloat, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDpruneDense2csrByPercentageNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;IFLjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/pruneInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDpruneDense2csrByPercentageNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jint, jfloat, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpruneCsr2csrByPercentage_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;FLjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/pruneInfo;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpruneCsr2csrByPercentage_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jfloat, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDpruneCsr2csrByPercentage_bufferSizeExtNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;FLjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/pruneInfo;[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDpruneCsr2csrByPercentage_1bufferSizeExtNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jfloat, jobject, jobject, jobject, jobject, jobject, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpruneCsr2csrNnzByPercentageNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;FLjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/pruneInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpruneCsr2csrNnzByPercentageNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jfloat, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDpruneCsr2csrNnzByPercentageNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;FLjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/pruneInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDpruneCsr2csrNnzByPercentageNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jfloat, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpruneCsr2csrByPercentageNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;FLjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/pruneInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpruneCsr2csrByPercentageNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jfloat, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDpruneCsr2csrByPercentageNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;FLjcuda/jcusparse/cusparseMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/pruneInfo;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDpruneCsr2csrByPercentageNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jfloat, jobject, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCsr2cscEx2Native
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIIILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCsr2cscEx2Native
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCsr2cscEx2_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IIILjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCsr2cscEx2_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jint, jobject, jobject, jobject, jobject, jobject, jobject, jint, jint, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateSpVecNative
     * Signature: (Ljcuda/jcusparse/cusparseSpVecDescr;JJLjcuda/Pointer;Ljcuda/Pointer;III)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateSpVecNative
    (JNIEnv*, jclass, jobject, jlong, jlong, jobject, jobject, jint, jint, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroySpVecNative
     * Signature: (Ljcuda/jcusparse/cusparseSpVecDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroySpVecNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpVecGetNative
     * Signature: (Ljcuda/jcusparse/cusparseSpVecDescr;[J[JLjcuda/Pointer;Ljcuda/Pointer;[I[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpVecGetNative
    (JNIEnv*, jclass, jobject, jlongArray, jlongArray, jobject, jobject, jintArray, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpVecGetIndexBaseNative
     * Signature: (Ljcuda/jcusparse/cusparseSpVecDescr;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpVecGetIndexBaseNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpVecGetValuesNative
     * Signature: (Ljcuda/jcusparse/cusparseSpVecDescr;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpVecGetValuesNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpVecSetValuesNative
     * Signature: (Ljcuda/jcusparse/cusparseSpVecDescr;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpVecSetValuesNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateDnVecNative
     * Signature: (Ljcuda/jcusparse/cusparseDnVecDescr;JLjcuda/Pointer;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateDnVecNative
    (JNIEnv*, jclass, jobject, jlong, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyDnVecNative
     * Signature: (Ljcuda/jcusparse/cusparseDnVecDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyDnVecNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDnVecGetNative
     * Signature: (Ljcuda/jcusparse/cusparseDnVecDescr;[JLjcuda/Pointer;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDnVecGetNative
    (JNIEnv*, jclass, jobject, jlongArray, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDnVecGetValuesNative
     * Signature: (Ljcuda/jcusparse/cusparseDnVecDescr;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDnVecGetValuesNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDnVecSetValuesNative
     * Signature: (Ljcuda/jcusparse/cusparseDnVecDescr;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDnVecSetValuesNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroySpMatNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroySpMatNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpMatGetFormatNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpMatGetFormatNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpMatGetIndexBaseNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpMatGetIndexBaseNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpMatGetValuesNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpMatGetValuesNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpMatSetValuesNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpMatSetValuesNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpMatGetSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;[J[J[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpMatGetSizeNative
    (JNIEnv*, jclass, jobject, jlongArray, jlongArray, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpMatSetStridedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpMatSetStridedBatchNative
    (JNIEnv*, jclass, jobject, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpMatGetStridedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpMatGetStridedBatchNative
    (JNIEnv*, jclass, jobject, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCooSetStridedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;IJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCooSetStridedBatchNative
    (JNIEnv*, jclass, jobject, jint, jlong);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCsrSetStridedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;IJJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCsrSetStridedBatchNative
    (JNIEnv*, jclass, jobject, jint, jlong, jlong);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateCsrNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;JJJLjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateCsrNative
    (JNIEnv*, jclass, jobject, jlong, jlong, jlong, jobject, jobject, jobject, jint, jint, jint, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateCscNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;JJJLjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;IIII)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateCscNative
    (JNIEnv*, jclass, jobject, jlong, jlong, jlong, jobject, jobject, jobject, jint, jint, jint, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCsrGetNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;[J[J[JLjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;[I[I[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCsrGetNative
    (JNIEnv*, jclass, jobject, jlongArray, jlongArray, jlongArray, jobject, jobject, jobject, jintArray, jintArray, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCsrSetPointersNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCsrSetPointersNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCscSetPointersNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCscSetPointersNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateCooNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;JJJLjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;III)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateCooNative
    (JNIEnv*, jclass, jobject, jlong, jlong, jlong, jobject, jobject, jobject, jint, jint, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateCooAoSNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;JJJLjcuda/Pointer;Ljcuda/Pointer;III)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateCooAoSNative
    (JNIEnv*, jclass, jobject, jlong, jlong, jlong, jobject, jobject, jint, jint, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCooGetNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;[J[J[JLjcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;[I[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCooGetNative
    (JNIEnv*, jclass, jobject, jlongArray, jlongArray, jlongArray, jobject, jobject, jobject, jintArray, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCooAoSGetNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;[J[J[JLjcuda/Pointer;Ljcuda/Pointer;[I[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCooAoSGetNative
    (JNIEnv*, jclass, jobject, jlongArray, jlongArray, jlongArray, jobject, jobject, jintArray, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCooSetPointersNative
     * Signature: (Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCooSetPointersNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseCreateDnMatNative
     * Signature: (Ljcuda/jcusparse/cusparseDnMatDescr;JJJLjcuda/Pointer;II)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseCreateDnMatNative
    (JNIEnv*, jclass, jobject, jlong, jlong, jlong, jobject, jint, jint);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDestroyDnMatNative
     * Signature: (Ljcuda/jcusparse/cusparseDnMatDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDestroyDnMatNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDnMatGetNative
     * Signature: (Ljcuda/jcusparse/cusparseDnMatDescr;[J[J[JLjcuda/Pointer;[I[I)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDnMatGetNative
    (JNIEnv*, jclass, jobject, jlongArray, jlongArray, jlongArray, jobject, jintArray, jintArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDnMatGetValuesNative
     * Signature: (Ljcuda/jcusparse/cusparseDnMatDescr;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDnMatGetValuesNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDnMatSetValuesNative
     * Signature: (Ljcuda/jcusparse/cusparseDnMatDescr;Ljcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDnMatSetValuesNative
    (JNIEnv*, jclass, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDnMatSetStridedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseDnMatDescr;IJ)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDnMatSetStridedBatchNative
    (JNIEnv*, jclass, jobject, jint, jlong);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDnMatGetStridedBatchNative
     * Signature: (Ljcuda/jcusparse/cusparseDnMatDescr;[I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDnMatGetStridedBatchNative
    (JNIEnv*, jclass, jobject, jintArray, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseAxpbyNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSpVecDescr;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseDnVecDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseAxpbyNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseGatherNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseDnVecDescr;Ljcuda/jcusparse/cusparseSpVecDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseGatherNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseScatterNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseSpVecDescr;Ljcuda/jcusparse/cusparseDnVecDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseScatterNative
    (JNIEnv*, jclass, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseRotNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/Pointer;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSpVecDescr;Ljcuda/jcusparse/cusparseDnVecDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseRotNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jobject, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpVV_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/jcusparse/cusparseSpVecDescr;Ljcuda/jcusparse/cusparseDnVecDescr;Ljcuda/Pointer;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpVV_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpVVNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/jcusparse/cusparseSpVecDescr;Ljcuda/jcusparse/cusparseDnVecDescr;Ljcuda/Pointer;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpVVNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSparseToDense_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/jcusparse/cusparseDnMatDescr;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSparseToDense_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSparseToDenseNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/jcusparse/cusparseDnMatDescr;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSparseToDenseNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDenseToSparse_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseDnMatDescr;Ljcuda/jcusparse/cusparseSpMatDescr;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDenseToSparse_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDenseToSparse_analysisNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseDnMatDescr;Ljcuda/jcusparse/cusparseSpMatDescr;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDenseToSparse_1analysisNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseDenseToSparse_convertNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;Ljcuda/jcusparse/cusparseDnMatDescr;Ljcuda/jcusparse/cusparseSpMatDescr;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseDenseToSparse_1convertNative
    (JNIEnv*, jclass, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpMVNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/jcusparse/cusparseDnVecDescr;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseDnVecDescr;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpMVNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpMV_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;ILjcuda/Pointer;Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/jcusparse/cusparseDnVecDescr;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseDnVecDescr;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpMV_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jobject, jobject, jobject, jobject, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpMMNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/jcusparse/cusparseDnMatDescr;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseDnMatDescr;IILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpMMNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpMM_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/jcusparse/cusparseDnMatDescr;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseDnMatDescr;II[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpMM_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jint, jlongArray);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpGEMM_createDescrNative
     * Signature: (Ljcuda/jcusparse/cusparseSpGEMMDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpGEMM_1createDescrNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpGEMM_destroyDescrNative
     * Signature: (Ljcuda/jcusparse/cusparseSpGEMMDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpGEMM_1destroyDescrNative
    (JNIEnv*, jclass, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpGEMM_workEstimationNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSpMatDescr;IILjcuda/jcusparse/cusparseSpGEMMDescr;[JLjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpGEMM_1workEstimationNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jint, jobject, jlongArray, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpGEMM_computeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSpMatDescr;IILjcuda/jcusparse/cusparseSpGEMMDescr;[JLjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpGEMM_1computeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jint, jobject, jlongArray, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseSpGEMM_copyNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/jcusparse/cusparseSpMatDescr;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSpMatDescr;IILjcuda/jcusparse/cusparseSpGEMMDescr;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseSpGEMM_1copyNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseConstrainedGeMMNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseDnMatDescr;Ljcuda/jcusparse/cusparseDnMatDescr;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSpMatDescr;ILjcuda/Pointer;)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseConstrainedGeMMNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jobject);

    /*
     * Class:     jcuda_jcusparse_JCusparse
     * Method:    cusparseConstrainedGeMM_bufferSizeNative
     * Signature: (Ljcuda/jcusparse/cusparseHandle;IILjcuda/Pointer;Ljcuda/jcusparse/cusparseDnMatDescr;Ljcuda/jcusparse/cusparseDnMatDescr;Ljcuda/Pointer;Ljcuda/jcusparse/cusparseSpMatDescr;I[J)I
     */
    JNIEXPORT jint JNICALL Java_jcuda_jcusparse_JCusparse_cusparseConstrainedGeMM_1bufferSizeNative
    (JNIEnv*, jclass, jobject, jint, jint, jobject, jobject, jobject, jobject, jobject, jint, jlongArray);

#ifdef __cplusplus
}
#endif
#endif
