/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcusparse;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.cuComplex;
import jcuda.cuDoubleComplex;
import jcuda.jcusparse.bsric02Info;
import jcuda.jcusparse.bsrilu02Info;
import jcuda.jcusparse.bsrsm2Info;
import jcuda.jcusparse.bsrsv2Info;
import jcuda.jcusparse.csrgemm2Info;
import jcuda.jcusparse.csric02Info;
import jcuda.jcusparse.csrilu02Info;
import jcuda.jcusparse.csrsm2Info;
import jcuda.jcusparse.csrsv2Info;
import jcuda.jcusparse.csru2csrInfo;
import jcuda.jcusparse.cusparseColorInfo;
import jcuda.jcusparse.cusparseDnMatDescr;
import jcuda.jcusparse.cusparseDnVecDescr;
import jcuda.jcusparse.cusparseHandle;
import jcuda.jcusparse.cusparseMatDescr;
import jcuda.jcusparse.cusparseSpGEMMDescr;
import jcuda.jcusparse.cusparseSpMatDescr;
import jcuda.jcusparse.cusparseSpVecDescr;
import jcuda.jcusparse.cusparseStatus;
import jcuda.jcusparse.pruneInfo;
import jcuda.runtime.JCuda;
import jcuda.runtime.cudaStream_t;

public class JCusparse {
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    private JCusparse() {
    }

    public static void initialize() {
        if (!initialized) {
            String libraryBaseName = "JCusparse-" + JCuda.getJCudaVersion();
            String libraryName = LibUtils.createPlatformLibraryName((String)libraryBaseName);
            LibUtils.loadLibrary((String)libraryName, (String[])new String[0]);
            initialized = true;
        }
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCusparse.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(cusparseStatus.stringFor(result));
        }
        return result;
    }

    private static int checkForError(int result) {
        if (exceptionsEnabled && result == -1) {
            throw new CudaException(cusparseStatus.stringFor(result));
        }
        return result;
    }

    public static int cusparseCreate(cusparseHandle handle) {
        return JCusparse.checkResult(JCusparse.cusparseCreateNative(handle));
    }

    private static native int cusparseCreateNative(cusparseHandle var0);

    public static int cusparseDestroy(cusparseHandle handle) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyNative(handle));
    }

    private static native int cusparseDestroyNative(cusparseHandle var0);

    public static int cusparseGetVersion(cusparseHandle handle, int[] version) {
        return JCusparse.checkResult(JCusparse.cusparseGetVersionNative(handle, version));
    }

    private static native int cusparseGetVersionNative(cusparseHandle var0, int[] var1);

    public static int cusparseGetProperty(int type, int[] value) {
        return JCusparse.checkResult(JCusparse.cusparseGetPropertyNative(type, value));
    }

    private static native int cusparseGetPropertyNative(int var0, int[] var1);

    public static String cusparseGetErrorName(int status) {
        return JCusparse.cusparseGetErrorNameNative(status);
    }

    private static native String cusparseGetErrorNameNative(int var0);

    public static String cusparseGetErrorString(int status) {
        return JCusparse.cusparseGetErrorStringNative(status);
    }

    private static native String cusparseGetErrorStringNative(int var0);

    public static int cusparseSetStream(cusparseHandle handle, cudaStream_t streamId) {
        return JCusparse.checkResult(JCusparse.cusparseSetStreamNative(handle, streamId));
    }

    private static native int cusparseSetStreamNative(cusparseHandle var0, cudaStream_t var1);

    public static int cusparseGetStream(cusparseHandle handle, cudaStream_t streamId) {
        return JCusparse.checkResult(JCusparse.cusparseGetStreamNative(handle, streamId));
    }

    private static native int cusparseGetStreamNative(cusparseHandle var0, cudaStream_t var1);

    public static int cusparseGetPointerMode(cusparseHandle handle, int[] mode) {
        return JCusparse.checkResult(JCusparse.cusparseGetPointerModeNative(handle, mode));
    }

    private static native int cusparseGetPointerModeNative(cusparseHandle var0, int[] var1);

    public static int cusparseSetPointerMode(cusparseHandle handle, int mode) {
        return JCusparse.checkResult(JCusparse.cusparseSetPointerModeNative(handle, mode));
    }

    private static native int cusparseSetPointerModeNative(cusparseHandle var0, int var1);

    public static int cusparseCreateMatDescr(cusparseMatDescr descrA) {
        return JCusparse.checkResult(JCusparse.cusparseCreateMatDescrNative(descrA));
    }

    private static native int cusparseCreateMatDescrNative(cusparseMatDescr var0);

    public static int cusparseDestroyMatDescr(cusparseMatDescr descrA) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyMatDescrNative(descrA));
    }

    private static native int cusparseDestroyMatDescrNative(cusparseMatDescr var0);

    public static int cusparseSetMatType(cusparseMatDescr descrA, int type) {
        return JCusparse.checkResult(JCusparse.cusparseSetMatTypeNative(descrA, type));
    }

    private static native int cusparseSetMatTypeNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatType(cusparseMatDescr descrA) {
        return JCusparse.checkResult(JCusparse.cusparseGetMatTypeNative(descrA));
    }

    private static native int cusparseGetMatTypeNative(cusparseMatDescr var0);

    public static int cusparseSetMatFillMode(cusparseMatDescr descrA, int fillMode) {
        return JCusparse.checkResult(JCusparse.cusparseSetMatFillModeNative(descrA, fillMode));
    }

    private static native int cusparseSetMatFillModeNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatFillMode(cusparseMatDescr descrA) {
        return JCusparse.checkResult(JCusparse.cusparseGetMatFillModeNative(descrA));
    }

    private static native int cusparseGetMatFillModeNative(cusparseMatDescr var0);

    public static int cusparseSetMatDiagType(cusparseMatDescr descrA, int diagType) {
        return JCusparse.checkResult(JCusparse.cusparseSetMatDiagTypeNative(descrA, diagType));
    }

    private static native int cusparseSetMatDiagTypeNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatDiagType(cusparseMatDescr descrA) {
        return JCusparse.checkResult(JCusparse.cusparseGetMatDiagTypeNative(descrA));
    }

    private static native int cusparseGetMatDiagTypeNative(cusparseMatDescr var0);

    public static int cusparseSetMatIndexBase(cusparseMatDescr descrA, int base) {
        return JCusparse.checkResult(JCusparse.cusparseSetMatIndexBaseNative(descrA, base));
    }

    private static native int cusparseSetMatIndexBaseNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatIndexBase(cusparseMatDescr descrA) {
        return JCusparse.checkResult(JCusparse.cusparseGetMatIndexBaseNative(descrA));
    }

    private static native int cusparseGetMatIndexBaseNative(cusparseMatDescr var0);

    public static int cusparseCreateCsrsv2Info(csrsv2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateCsrsv2InfoNative(info));
    }

    private static native int cusparseCreateCsrsv2InfoNative(csrsv2Info var0);

    public static int cusparseDestroyCsrsv2Info(csrsv2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyCsrsv2InfoNative(info));
    }

    private static native int cusparseDestroyCsrsv2InfoNative(csrsv2Info var0);

    public static int cusparseCreateCsric02Info(csric02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateCsric02InfoNative(info));
    }

    private static native int cusparseCreateCsric02InfoNative(csric02Info var0);

    public static int cusparseDestroyCsric02Info(csric02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyCsric02InfoNative(info));
    }

    private static native int cusparseDestroyCsric02InfoNative(csric02Info var0);

    public static int cusparseCreateBsric02Info(bsric02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateBsric02InfoNative(info));
    }

    private static native int cusparseCreateBsric02InfoNative(bsric02Info var0);

    public static int cusparseDestroyBsric02Info(bsric02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyBsric02InfoNative(info));
    }

    private static native int cusparseDestroyBsric02InfoNative(bsric02Info var0);

    public static int cusparseCreateCsrilu02Info(csrilu02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateCsrilu02InfoNative(info));
    }

    private static native int cusparseCreateCsrilu02InfoNative(csrilu02Info var0);

    public static int cusparseDestroyCsrilu02Info(csrilu02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyCsrilu02InfoNative(info));
    }

    private static native int cusparseDestroyCsrilu02InfoNative(csrilu02Info var0);

    public static int cusparseCreateBsrilu02Info(bsrilu02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateBsrilu02InfoNative(info));
    }

    private static native int cusparseCreateBsrilu02InfoNative(bsrilu02Info var0);

    public static int cusparseDestroyBsrilu02Info(bsrilu02Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyBsrilu02InfoNative(info));
    }

    private static native int cusparseDestroyBsrilu02InfoNative(bsrilu02Info var0);

    public static int cusparseCreateBsrsv2Info(bsrsv2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateBsrsv2InfoNative(info));
    }

    private static native int cusparseCreateBsrsv2InfoNative(bsrsv2Info var0);

    public static int cusparseDestroyBsrsv2Info(bsrsv2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyBsrsv2InfoNative(info));
    }

    private static native int cusparseDestroyBsrsv2InfoNative(bsrsv2Info var0);

    public static int cusparseCreateBsrsm2Info(bsrsm2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateBsrsm2InfoNative(info));
    }

    private static native int cusparseCreateBsrsm2InfoNative(bsrsm2Info var0);

    public static int cusparseDestroyBsrsm2Info(bsrsm2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyBsrsm2InfoNative(info));
    }

    private static native int cusparseDestroyBsrsm2InfoNative(bsrsm2Info var0);

    public static int cusparseCreateCsru2csrInfo(csru2csrInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateCsru2csrInfoNative(info));
    }

    private static native int cusparseCreateCsru2csrInfoNative(csru2csrInfo var0);

    public static int cusparseDestroyCsru2csrInfo(csru2csrInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyCsru2csrInfoNative(info));
    }

    private static native int cusparseDestroyCsru2csrInfoNative(csru2csrInfo var0);

    public static int cusparseCreateColorInfo(cusparseColorInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateColorInfoNative(info));
    }

    private static native int cusparseCreateColorInfoNative(cusparseColorInfo var0);

    public static int cusparseDestroyColorInfo(cusparseColorInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyColorInfoNative(info));
    }

    private static native int cusparseDestroyColorInfoNative(cusparseColorInfo var0);

    public static int cusparseCreatePruneInfo(pruneInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseCreatePruneInfoNative(info));
    }

    private static native int cusparseCreatePruneInfoNative(pruneInfo var0);

    public static int cusparseDestroyPruneInfo(pruneInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyPruneInfoNative(info));
    }

    private static native int cusparseDestroyPruneInfoNative(pruneInfo var0);

    @Deprecated
    public static int cusparseSaxpyi(cusparseHandle handle, int nnz, Pointer alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseSaxpyiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    @Deprecated
    public static int cusparseDaxpyi(cusparseHandle handle, int nnz, Pointer alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseDaxpyiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    @Deprecated
    public static int cusparseCaxpyi(cusparseHandle handle, int nnz, Pointer alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseCaxpyiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    @Deprecated
    public static int cusparseZaxpyi(cusparseHandle handle, int nnz, Pointer alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseZaxpyiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    @Deprecated
    public static int cusparseSgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseSgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    @Deprecated
    public static int cusparseDgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseDgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    @Deprecated
    public static int cusparseCgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseCgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    @Deprecated
    public static int cusparseZgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseZgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    @Deprecated
    public static int cusparseSgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseSgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    @Deprecated
    public static int cusparseDgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseDgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    @Deprecated
    public static int cusparseCgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseCgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    @Deprecated
    public static int cusparseZgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseZgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    @Deprecated
    public static int cusparseSsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseSsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    @Deprecated
    public static int cusparseDsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseDsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    @Deprecated
    public static int cusparseCsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseCsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    @Deprecated
    public static int cusparseZsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseZsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    @Deprecated
    public static int cusparseSroti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer c, Pointer s, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSrotiNative(handle, nnz, xVal, xInd, y, c, s, idxBase));
    }

    private static native int cusparseSrotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    @Deprecated
    public static int cusparseDroti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, Pointer c, Pointer s, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDrotiNative(handle, nnz, xVal, xInd, y, c, s, idxBase));
    }

    private static native int cusparseDrotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseSgemvi(cusparseHandle handle, int transA, int m, int n, Pointer alpha, Pointer A, int lda, int nnz, Pointer xVal, Pointer xInd, Pointer beta, Pointer y, int idxBase, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSgemviNative(handle, transA, m, n, alpha, A, lda, nnz, xVal, xInd, beta, y, idxBase, pBuffer));
    }

    private static native int cusparseSgemviNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseSgemvi_bufferSize(cusparseHandle handle, int transA, int m, int n, int nnz, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseSgemvi_bufferSizeNative(handle, transA, m, n, nnz, pBufferSize));
    }

    private static native int cusparseSgemvi_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int[] var5);

    public static int cusparseDgemvi(cusparseHandle handle, int transA, int m, int n, Pointer alpha, Pointer A, int lda, int nnz, Pointer xVal, Pointer xInd, Pointer beta, Pointer y, int idxBase, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDgemviNative(handle, transA, m, n, alpha, A, lda, nnz, xVal, xInd, beta, y, idxBase, pBuffer));
    }

    private static native int cusparseDgemviNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseDgemvi_bufferSize(cusparseHandle handle, int transA, int m, int n, int nnz, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseDgemvi_bufferSizeNative(handle, transA, m, n, nnz, pBufferSize));
    }

    private static native int cusparseDgemvi_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int[] var5);

    public static int cusparseCgemvi(cusparseHandle handle, int transA, int m, int n, Pointer alpha, Pointer A, int lda, int nnz, Pointer xVal, Pointer xInd, Pointer beta, Pointer y, int idxBase, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCgemviNative(handle, transA, m, n, alpha, A, lda, nnz, xVal, xInd, beta, y, idxBase, pBuffer));
    }

    private static native int cusparseCgemviNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseCgemvi_bufferSize(cusparseHandle handle, int transA, int m, int n, int nnz, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseCgemvi_bufferSizeNative(handle, transA, m, n, nnz, pBufferSize));
    }

    private static native int cusparseCgemvi_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int[] var5);

    public static int cusparseZgemvi(cusparseHandle handle, int transA, int m, int n, Pointer alpha, Pointer A, int lda, int nnz, Pointer xVal, Pointer xInd, Pointer beta, Pointer y, int idxBase, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZgemviNative(handle, transA, m, n, alpha, A, lda, nnz, xVal, xInd, beta, y, idxBase, pBuffer));
    }

    private static native int cusparseZgemviNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseZgemvi_bufferSize(cusparseHandle handle, int transA, int m, int n, int nnz, int[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseZgemvi_bufferSizeNative(handle, transA, m, n, nnz, pBufferSize));
    }

    private static native int cusparseZgemvi_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int[] var5);

    public static int cusparseCsrmvEx_bufferSize(cusparseHandle handle, int alg, int transA, int m, int n, int nnz, Pointer alpha, int alphatype, cusparseMatDescr descrA, Pointer csrValA, int csrValAtype, Pointer csrRowPtrA, Pointer csrColIndA, Pointer x, int xtype, Pointer beta, int betatype, Pointer y, int ytype, int executiontype, long[] bufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCsrmvEx_bufferSizeNative(handle, alg, transA, m, n, nnz, alpha, alphatype, descrA, csrValA, csrValAtype, csrRowPtrA, csrColIndA, x, xtype, beta, betatype, y, ytype, executiontype, bufferSizeInBytes));
    }

    private static native int cusparseCsrmvEx_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, cusparseMatDescr var8, Pointer var9, int var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, int var16, Pointer var17, int var18, int var19, long[] var20);

    public static int cusparseCsrmvEx(cusparseHandle handle, int alg, int transA, int m, int n, int nnz, Pointer alpha, int alphatype, cusparseMatDescr descrA, Pointer csrValA, int csrValAtype, Pointer csrRowPtrA, Pointer csrColIndA, Pointer x, int xtype, Pointer beta, int betatype, Pointer y, int ytype, int executiontype, Pointer buffer) {
        return JCusparse.checkResult(JCusparse.cusparseCsrmvExNative(handle, alg, transA, m, n, nnz, alpha, alphatype, descrA, csrValA, csrValAtype, csrRowPtrA, csrColIndA, x, xtype, beta, betatype, y, ytype, executiontype, buffer));
    }

    private static native int cusparseCsrmvExNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, cusparseMatDescr var8, Pointer var9, int var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, int var16, Pointer var17, int var18, int var19, Pointer var20);

    public static int cusparseSbsrmv(cusparseHandle handle, int dirA, int transA, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrmvNative(handle, dirA, transA, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseSbsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, Pointer var12, Pointer var13, Pointer var14);

    public static int cusparseDbsrmv(cusparseHandle handle, int dirA, int transA, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrmvNative(handle, dirA, transA, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseDbsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, Pointer var12, Pointer var13, Pointer var14);

    public static int cusparseCbsrmv(cusparseHandle handle, int dirA, int transA, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrmvNative(handle, dirA, transA, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseCbsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, Pointer var12, Pointer var13, Pointer var14);

    public static int cusparseZbsrmv(cusparseHandle handle, int dirA, int transA, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrmvNative(handle, dirA, transA, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseZbsrmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, Pointer var12, Pointer var13, Pointer var14);

    public static int cusparseSbsrxmv(cusparseHandle handle, int dirA, int transA, int sizeOfMask, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedMaskPtrA, Pointer bsrSortedRowPtrA, Pointer bsrSortedEndPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrxmvNative(handle, dirA, transA, sizeOfMask, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedMaskPtrA, bsrSortedRowPtrA, bsrSortedEndPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseSbsrxmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, Pointer var16, Pointer var17);

    public static int cusparseDbsrxmv(cusparseHandle handle, int dirA, int transA, int sizeOfMask, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedMaskPtrA, Pointer bsrSortedRowPtrA, Pointer bsrSortedEndPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrxmvNative(handle, dirA, transA, sizeOfMask, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedMaskPtrA, bsrSortedRowPtrA, bsrSortedEndPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseDbsrxmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, Pointer var16, Pointer var17);

    public static int cusparseCbsrxmv(cusparseHandle handle, int dirA, int transA, int sizeOfMask, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedMaskPtrA, Pointer bsrSortedRowPtrA, Pointer bsrSortedEndPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrxmvNative(handle, dirA, transA, sizeOfMask, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedMaskPtrA, bsrSortedRowPtrA, bsrSortedEndPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseCbsrxmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, Pointer var16, Pointer var17);

    public static int cusparseZbsrxmv(cusparseHandle handle, int dirA, int transA, int sizeOfMask, int mb, int nb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedMaskPtrA, Pointer bsrSortedRowPtrA, Pointer bsrSortedEndPtrA, Pointer bsrSortedColIndA, int blockDim, Pointer x, Pointer beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrxmvNative(handle, dirA, transA, sizeOfMask, mb, nb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedMaskPtrA, bsrSortedRowPtrA, bsrSortedEndPtrA, bsrSortedColIndA, blockDim, x, beta, y));
    }

    private static native int cusparseZbsrxmvNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13, int var14, Pointer var15, Pointer var16, Pointer var17);

    public static int cusparseXcsrsv2_zeroPivot(cusparseHandle handle, csrsv2Info info, Pointer position) {
        return JCusparse.checkResult(JCusparse.cusparseXcsrsv2_zeroPivotNative(handle, info, position));
    }

    private static native int cusparseXcsrsv2_zeroPivotNative(cusparseHandle var0, csrsv2Info var1, Pointer var2);

    public static int cusparseScsrsv2_bufferSize(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsv2_bufferSizeNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseScsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int[] var9);

    public static int cusparseDcsrsv2_bufferSize(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsv2_bufferSizeNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseDcsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int[] var9);

    public static int cusparseCcsrsv2_bufferSize(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsv2_bufferSizeNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseCcsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int[] var9);

    public static int cusparseZcsrsv2_bufferSize(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsv2_bufferSizeNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseZcsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int[] var9);

    public static int cusparseScsrsv2_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsv2_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseScsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int var9, Pointer var10);

    public static int cusparseDcsrsv2_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsv2_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseDcsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int var9, Pointer var10);

    public static int cusparseCcsrsv2_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsv2_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseCcsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int var9, Pointer var10);

    public static int cusparseZcsrsv2_analysis(cusparseHandle handle, int transA, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsv2_analysisNative(handle, transA, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseZcsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csrsv2Info var8, int var9, Pointer var10);

    public static int cusparseScsrsv2_solve(cusparseHandle handle, int transA, int m, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsv2_solveNative(handle, transA, m, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, f, x, policy, pBuffer));
    }

    private static native int cusparseScsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, csrsv2Info var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseDcsrsv2_solve(cusparseHandle handle, int transA, int m, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsv2_solveNative(handle, transA, m, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, f, x, policy, pBuffer));
    }

    private static native int cusparseDcsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, csrsv2Info var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseCcsrsv2_solve(cusparseHandle handle, int transA, int m, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsv2_solveNative(handle, transA, m, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, f, x, policy, pBuffer));
    }

    private static native int cusparseCcsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, csrsv2Info var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseZcsrsv2_solve(cusparseHandle handle, int transA, int m, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsv2_solveNative(handle, transA, m, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, f, x, policy, pBuffer));
    }

    private static native int cusparseZcsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, csrsv2Info var9, Pointer var10, Pointer var11, int var12, Pointer var13);

    public static int cusparseXbsrsv2_zeroPivot(cusparseHandle handle, bsrsv2Info info, Pointer position) {
        return JCusparse.checkResult(JCusparse.cusparseXbsrsv2_zeroPivotNative(handle, info, position));
    }

    private static native int cusparseXbsrsv2_zeroPivotNative(cusparseHandle var0, bsrsv2Info var1, Pointer var2);

    public static int cusparseSbsrsv2_bufferSize(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrsv2_bufferSizeNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseSbsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int[] var11);

    public static int cusparseDbsrsv2_bufferSize(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrsv2_bufferSizeNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseDbsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int[] var11);

    public static int cusparseCbsrsv2_bufferSize(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrsv2_bufferSizeNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseCbsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int[] var11);

    public static int cusparseZbsrsv2_bufferSize(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrsv2_bufferSizeNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseZbsrsv2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int[] var11);

    public static int cusparseSbsrsv2_analysis(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrsv2_analysisNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseSbsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int var11, Pointer var12);

    public static int cusparseDbsrsv2_analysis(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrsv2_analysisNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseDbsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int var11, Pointer var12);

    public static int cusparseCbsrsv2_analysis(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrsv2_analysisNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseCbsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int var11, Pointer var12);

    public static int cusparseZbsrsv2_analysis(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrsv2_analysisNative(handle, dirA, transA, mb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseZbsrsv2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, bsrsv2Info var10, int var11, Pointer var12);

    public static int cusparseSbsrsv2_solve(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrsv2_solveNative(handle, dirA, transA, mb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, f, x, policy, pBuffer));
    }

    private static native int cusparseSbsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, int var10, bsrsv2Info var11, Pointer var12, Pointer var13, int var14, Pointer var15);

    public static int cusparseDbsrsv2_solve(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrsv2_solveNative(handle, dirA, transA, mb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, f, x, policy, pBuffer));
    }

    private static native int cusparseDbsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, int var10, bsrsv2Info var11, Pointer var12, Pointer var13, int var14, Pointer var15);

    public static int cusparseCbsrsv2_solve(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrsv2_solveNative(handle, dirA, transA, mb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, f, x, policy, pBuffer));
    }

    private static native int cusparseCbsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, int var10, bsrsv2Info var11, Pointer var12, Pointer var13, int var14, Pointer var15);

    public static int cusparseZbsrsv2_solve(cusparseHandle handle, int dirA, int transA, int mb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, bsrsv2Info info, Pointer f, Pointer x, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrsv2_solveNative(handle, dirA, transA, mb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, info, f, x, policy, pBuffer));
    }

    private static native int cusparseZbsrsv2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, int var10, bsrsv2Info var11, Pointer var12, Pointer var13, int var14, Pointer var15);

    public static int cusparseSbsrmm(cusparseHandle handle, int dirA, int transA, int transB, int mb, int n, int kb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockSize, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrmmNative(handle, dirA, transA, transB, mb, n, kb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockSize, B, ldb, beta, C, ldc));
    }

    private static native int cusparseSbsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Pointer var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, int var15, Pointer var16, Pointer var17, int var18);

    public static int cusparseDbsrmm(cusparseHandle handle, int dirA, int transA, int transB, int mb, int n, int kb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockSize, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrmmNative(handle, dirA, transA, transB, mb, n, kb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockSize, B, ldb, beta, C, ldc));
    }

    private static native int cusparseDbsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Pointer var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, int var15, Pointer var16, Pointer var17, int var18);

    public static int cusparseCbsrmm(cusparseHandle handle, int dirA, int transA, int transB, int mb, int n, int kb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockSize, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrmmNative(handle, dirA, transA, transB, mb, n, kb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockSize, B, ldb, beta, C, ldc));
    }

    private static native int cusparseCbsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Pointer var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, int var15, Pointer var16, Pointer var17, int var18);

    public static int cusparseZbsrmm(cusparseHandle handle, int dirA, int transA, int transB, int mb, int n, int kb, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockSize, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrmmNative(handle, dirA, transA, transB, mb, n, kb, nnzb, alpha, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockSize, B, ldb, beta, C, ldc));
    }

    private static native int cusparseZbsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Pointer var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, int var13, Pointer var14, int var15, Pointer var16, Pointer var17, int var18);

    @Deprecated
    public static int cusparseSgemmi(cusparseHandle handle, int m, int n, int k, int nnz, Pointer alpha, Pointer A, int lda, Pointer cscValB, Pointer cscColPtrB, Pointer cscRowIndB, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseSgemmiNative(handle, m, n, k, nnz, alpha, A, lda, cscValB, cscColPtrB, cscRowIndB, beta, C, ldc));
    }

    private static native int cusparseSgemmiNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13);

    @Deprecated
    public static int cusparseDgemmi(cusparseHandle handle, int m, int n, int k, int nnz, Pointer alpha, Pointer A, int lda, Pointer cscValB, Pointer cscColPtrB, Pointer cscRowIndB, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseDgemmiNative(handle, m, n, k, nnz, alpha, A, lda, cscValB, cscColPtrB, cscRowIndB, beta, C, ldc));
    }

    private static native int cusparseDgemmiNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13);

    @Deprecated
    public static int cusparseCgemmi(cusparseHandle handle, int m, int n, int k, int nnz, Pointer alpha, Pointer A, int lda, Pointer cscValB, Pointer cscColPtrB, Pointer cscRowIndB, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseCgemmiNative(handle, m, n, k, nnz, alpha, A, lda, cscValB, cscColPtrB, cscRowIndB, beta, C, ldc));
    }

    private static native int cusparseCgemmiNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13);

    @Deprecated
    public static int cusparseZgemmi(cusparseHandle handle, int m, int n, int k, int nnz, Pointer alpha, Pointer A, int lda, Pointer cscValB, Pointer cscColPtrB, Pointer cscRowIndB, Pointer beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseZgemmiNative(handle, m, n, k, nnz, alpha, A, lda, cscValB, cscColPtrB, cscRowIndB, beta, C, ldc));
    }

    private static native int cusparseZgemmiNative(cusparseHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13);

    public static int cusparseCreateCsrsm2Info(csrsm2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateCsrsm2InfoNative(info));
    }

    private static native int cusparseCreateCsrsm2InfoNative(csrsm2Info var0);

    public static int cusparseDestroyCsrsm2Info(csrsm2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyCsrsm2InfoNative(info));
    }

    private static native int cusparseDestroyCsrsm2InfoNative(csrsm2Info var0);

    public static int cusparseXcsrsm2_zeroPivot(cusparseHandle handle, csrsm2Info info, Pointer position) {
        return JCusparse.checkResult(JCusparse.cusparseXcsrsm2_zeroPivotNative(handle, info, position));
    }

    private static native int cusparseXcsrsm2_zeroPivotNative(cusparseHandle var0, csrsm2Info var1, Pointer var2);

    public static int cusparseScsrsm2_bufferSizeExt(cusparseHandle handle, int algo, int transA, int transB, int m, int nrhs, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, csrsm2Info info, int policy, long[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsm2_bufferSizeExtNative(handle, algo, transA, transB, m, nrhs, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, info, policy, pBufferSize));
    }

    private static native int cusparseScsrsm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, csrsm2Info var14, int var15, long[] var16);

    public static int cusparseDcsrsm2_bufferSizeExt(cusparseHandle handle, int algo, int transA, int transB, int m, int nrhs, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, csrsm2Info info, int policy, long[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsm2_bufferSizeExtNative(handle, algo, transA, transB, m, nrhs, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, info, policy, pBufferSize));
    }

    private static native int cusparseDcsrsm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, csrsm2Info var14, int var15, long[] var16);

    public static int cusparseCcsrsm2_bufferSizeExt(cusparseHandle handle, int algo, int transA, int transB, int m, int nrhs, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, csrsm2Info info, int policy, long[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsm2_bufferSizeExtNative(handle, algo, transA, transB, m, nrhs, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, info, policy, pBufferSize));
    }

    private static native int cusparseCcsrsm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, csrsm2Info var14, int var15, long[] var16);

    public static int cusparseZcsrsm2_bufferSizeExt(cusparseHandle handle, int algo, int transA, int transB, int m, int nrhs, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, csrsm2Info info, int policy, long[] pBufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsm2_bufferSizeExtNative(handle, algo, transA, transB, m, nrhs, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, info, policy, pBufferSize));
    }

    private static native int cusparseZcsrsm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, csrsm2Info var14, int var15, long[] var16);

    public static int cusparseScsrsm2_analysis(cusparseHandle handle, int algo, int transA, int transB, int m, int nrhs, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, csrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsm2_analysisNative(handle, algo, transA, transB, m, nrhs, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, info, policy, pBuffer));
    }

    private static native int cusparseScsrsm2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, csrsm2Info var14, int var15, Pointer var16);

    public static int cusparseDcsrsm2_analysis(cusparseHandle handle, int algo, int transA, int transB, int m, int nrhs, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, csrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsm2_analysisNative(handle, algo, transA, transB, m, nrhs, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, info, policy, pBuffer));
    }

    private static native int cusparseDcsrsm2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, csrsm2Info var14, int var15, Pointer var16);

    public static int cusparseCcsrsm2_analysis(cusparseHandle handle, int algo, int transA, int transB, int m, int nrhs, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, csrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsm2_analysisNative(handle, algo, transA, transB, m, nrhs, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, info, policy, pBuffer));
    }

    private static native int cusparseCcsrsm2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, csrsm2Info var14, int var15, Pointer var16);

    public static int cusparseZcsrsm2_analysis(cusparseHandle handle, int algo, int transA, int transB, int m, int nrhs, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, csrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsm2_analysisNative(handle, algo, transA, transB, m, nrhs, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, info, policy, pBuffer));
    }

    private static native int cusparseZcsrsm2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, csrsm2Info var14, int var15, Pointer var16);

    public static int cusparseScsrsm2_solve(cusparseHandle handle, int algo, int transA, int transB, int m, int nrhs, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, csrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsm2_solveNative(handle, algo, transA, transB, m, nrhs, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, info, policy, pBuffer));
    }

    private static native int cusparseScsrsm2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, csrsm2Info var14, int var15, Pointer var16);

    public static int cusparseDcsrsm2_solve(cusparseHandle handle, int algo, int transA, int transB, int m, int nrhs, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, csrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsm2_solveNative(handle, algo, transA, transB, m, nrhs, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, info, policy, pBuffer));
    }

    private static native int cusparseDcsrsm2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, csrsm2Info var14, int var15, Pointer var16);

    public static int cusparseCcsrsm2_solve(cusparseHandle handle, int algo, int transA, int transB, int m, int nrhs, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, csrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsm2_solveNative(handle, algo, transA, transB, m, nrhs, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, info, policy, pBuffer));
    }

    private static native int cusparseCcsrsm2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, csrsm2Info var14, int var15, Pointer var16);

    public static int cusparseZcsrsm2_solve(cusparseHandle handle, int algo, int transA, int transB, int m, int nrhs, int nnz, Pointer alpha, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer B, int ldb, csrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsm2_solveNative(handle, algo, transA, transB, m, nrhs, nnz, alpha, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, B, ldb, info, policy, pBuffer));
    }

    private static native int cusparseZcsrsm2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, Pointer var12, int var13, csrsm2Info var14, int var15, Pointer var16);

    public static int cusparseXbsrsm2_zeroPivot(cusparseHandle handle, bsrsm2Info info, Pointer position) {
        return JCusparse.checkResult(JCusparse.cusparseXbsrsm2_zeroPivotNative(handle, info, position));
    }

    private static native int cusparseXbsrsm2_zeroPivotNative(cusparseHandle var0, bsrsm2Info var1, Pointer var2);

    public static int cusparseSbsrsm2_bufferSize(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrsm2_bufferSizeNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSizeInBytes));
    }

    private static native int cusparseSbsrsm2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int[] var13);

    public static int cusparseDbsrsm2_bufferSize(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrsm2_bufferSizeNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSizeInBytes));
    }

    private static native int cusparseDbsrsm2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int[] var13);

    public static int cusparseCbsrsm2_bufferSize(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrsm2_bufferSizeNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSizeInBytes));
    }

    private static native int cusparseCbsrsm2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int[] var13);

    public static int cusparseZbsrsm2_bufferSize(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrsm2_bufferSizeNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, pBufferSizeInBytes));
    }

    private static native int cusparseZbsrsm2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int[] var13);

    public static int cusparseSbsrsm2_analysis(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrsm2_analysisNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, policy, pBuffer));
    }

    private static native int cusparseSbsrsm2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int var13, Pointer var14);

    public static int cusparseDbsrsm2_analysis(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrsm2_analysisNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, policy, pBuffer));
    }

    private static native int cusparseDbsrsm2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int var13, Pointer var14);

    public static int cusparseCbsrsm2_analysis(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrsm2_analysisNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, policy, pBuffer));
    }

    private static native int cusparseCbsrsm2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int var13, Pointer var14);

    public static int cusparseZbsrsm2_analysis(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrsm2_analysisNative(handle, dirA, transA, transXY, mb, n, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, policy, pBuffer));
    }

    private static native int cusparseZbsrsm2_analysisNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, int var11, bsrsm2Info var12, int var13, Pointer var14);

    public static int cusparseSbsrsm2_solve(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, Pointer B, int ldb, Pointer X, int ldx, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrsm2_solveNative(handle, dirA, transA, transXY, mb, n, nnzb, alpha, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, B, ldb, X, ldx, policy, pBuffer));
    }

    private static native int cusparseSbsrsm2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, bsrsm2Info var13, Pointer var14, int var15, Pointer var16, int var17, int var18, Pointer var19);

    public static int cusparseDbsrsm2_solve(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, Pointer B, int ldb, Pointer X, int ldx, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrsm2_solveNative(handle, dirA, transA, transXY, mb, n, nnzb, alpha, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, B, ldb, X, ldx, policy, pBuffer));
    }

    private static native int cusparseDbsrsm2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, bsrsm2Info var13, Pointer var14, int var15, Pointer var16, int var17, int var18, Pointer var19);

    public static int cusparseCbsrsm2_solve(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, Pointer B, int ldb, Pointer X, int ldx, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrsm2_solveNative(handle, dirA, transA, transXY, mb, n, nnzb, alpha, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, B, ldb, X, ldx, policy, pBuffer));
    }

    private static native int cusparseCbsrsm2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, bsrsm2Info var13, Pointer var14, int var15, Pointer var16, int var17, int var18, Pointer var19);

    public static int cusparseZbsrsm2_solve(cusparseHandle handle, int dirA, int transA, int transXY, int mb, int n, int nnzb, Pointer alpha, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockSize, bsrsm2Info info, Pointer B, int ldb, Pointer X, int ldx, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrsm2_solveNative(handle, dirA, transA, transXY, mb, n, nnzb, alpha, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockSize, info, B, ldb, X, ldx, policy, pBuffer));
    }

    private static native int cusparseZbsrsm2_solveNative(cusparseHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, bsrsm2Info var13, Pointer var14, int var15, Pointer var16, int var17, int var18, Pointer var19);

    public static int cusparseScsrilu02_numericBoost(cusparseHandle handle, csrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseScsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseScsrilu02_numericBoostNative(cusparseHandle var0, csrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseDcsrilu02_numericBoost(cusparseHandle handle, csrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseDcsrilu02_numericBoostNative(cusparseHandle var0, csrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseCcsrilu02_numericBoost(cusparseHandle handle, csrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseCcsrilu02_numericBoostNative(cusparseHandle var0, csrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseZcsrilu02_numericBoost(cusparseHandle handle, csrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseZcsrilu02_numericBoostNative(cusparseHandle var0, csrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseXcsrilu02_zeroPivot(cusparseHandle handle, csrilu02Info info, Pointer position) {
        return JCusparse.checkResult(JCusparse.cusparseXcsrilu02_zeroPivotNative(handle, info, position));
    }

    private static native int cusparseXcsrilu02_zeroPivotNative(cusparseHandle var0, csrilu02Info var1, Pointer var2);

    public static int cusparseScsrilu02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseScsrilu02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseScsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int[] var8);

    public static int cusparseDcsrilu02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrilu02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseDcsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int[] var8);

    public static int cusparseCcsrilu02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrilu02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseCcsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int[] var8);

    public static int cusparseZcsrilu02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrilu02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseZcsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int[] var8);

    public static int cusparseScsrilu02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsrilu02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseScsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseDcsrilu02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrilu02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseDcsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseCcsrilu02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrilu02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseCcsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseZcsrilu02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrilu02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseZcsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseScsrilu02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsrilu02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseScsrilu02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseDcsrilu02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrilu02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseDcsrilu02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseCcsrilu02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrilu02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseCcsrilu02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseZcsrilu02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrilu02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseZcsrilu02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csrilu02Info var7, int var8, Pointer var9);

    public static int cusparseSbsrilu02_numericBoost(cusparseHandle handle, bsrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseSbsrilu02_numericBoostNative(cusparseHandle var0, bsrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseDbsrilu02_numericBoost(cusparseHandle handle, bsrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseDbsrilu02_numericBoostNative(cusparseHandle var0, bsrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseCbsrilu02_numericBoost(cusparseHandle handle, bsrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseCbsrilu02_numericBoostNative(cusparseHandle var0, bsrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseZbsrilu02_numericBoost(cusparseHandle handle, bsrilu02Info info, int enable_boost, Pointer tol, Pointer boost_val) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrilu02_numericBoostNative(handle, info, enable_boost, tol, boost_val));
    }

    private static native int cusparseZbsrilu02_numericBoostNative(cusparseHandle var0, bsrilu02Info var1, int var2, Pointer var3, Pointer var4);

    public static int cusparseXbsrilu02_zeroPivot(cusparseHandle handle, bsrilu02Info info, Pointer position) {
        return JCusparse.checkResult(JCusparse.cusparseXbsrilu02_zeroPivotNative(handle, info, position));
    }

    private static native int cusparseXbsrilu02_zeroPivotNative(cusparseHandle var0, bsrilu02Info var1, Pointer var2);

    public static int cusparseSbsrilu02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrilu02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseSbsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int[] var10);

    public static int cusparseDbsrilu02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrilu02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseDbsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int[] var10);

    public static int cusparseCbsrilu02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrilu02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseCbsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int[] var10);

    public static int cusparseZbsrilu02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrilu02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseZbsrilu02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int[] var10);

    public static int cusparseSbsrilu02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrilu02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseSbsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseDbsrilu02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrilu02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseDbsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseCbsrilu02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrilu02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseCbsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseZbsrilu02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrilu02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseZbsrilu02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseSbsrilu02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsrilu02Native(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseSbsrilu02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseDbsrilu02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsrilu02Native(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseDbsrilu02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseCbsrilu02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsrilu02Native(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseCbsrilu02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseZbsrilu02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsrilu02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsrilu02Native(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseZbsrilu02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsrilu02Info var9, int var10, Pointer var11);

    public static int cusparseXcsric02_zeroPivot(cusparseHandle handle, csric02Info info, Pointer position) {
        return JCusparse.checkResult(JCusparse.cusparseXcsric02_zeroPivotNative(handle, info, position));
    }

    private static native int cusparseXcsric02_zeroPivotNative(cusparseHandle var0, csric02Info var1, Pointer var2);

    public static int cusparseScsric02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseScsric02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseScsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int[] var8);

    public static int cusparseDcsric02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDcsric02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseDcsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int[] var8);

    public static int cusparseCcsric02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCcsric02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseCcsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int[] var8);

    public static int cusparseZcsric02_bufferSize(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZcsric02_bufferSizeNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, pBufferSizeInBytes));
    }

    private static native int cusparseZcsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int[] var8);

    public static int cusparseScsric02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsric02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseScsric02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseDcsric02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsric02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseDcsric02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseCcsric02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsric02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseCcsric02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseZcsric02_analysis(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsric02_analysisNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseZcsric02_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseScsric02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsric02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseScsric02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseDcsric02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsric02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseDcsric02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseCcsric02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsric02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseCcsric02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseZcsric02(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA_valM, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, csric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsric02Native(handle, m, nnz, descrA, csrSortedValA_valM, csrSortedRowPtrA, csrSortedColIndA, info, policy, pBuffer));
    }

    private static native int cusparseZcsric02Native(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, csric02Info var7, int var8, Pointer var9);

    public static int cusparseXbsric02_zeroPivot(cusparseHandle handle, bsric02Info info, Pointer position) {
        return JCusparse.checkResult(JCusparse.cusparseXbsric02_zeroPivotNative(handle, info, position));
    }

    private static native int cusparseXbsric02_zeroPivotNative(cusparseHandle var0, bsric02Info var1, Pointer var2);

    public static int cusparseSbsric02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSbsric02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseSbsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int[] var10);

    public static int cusparseDbsric02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDbsric02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseDbsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int[] var10);

    public static int cusparseCbsric02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCbsric02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseCbsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int[] var10);

    public static int cusparseZbsric02_bufferSize(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZbsric02_bufferSizeNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, pBufferSizeInBytes));
    }

    private static native int cusparseZbsric02_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int[] var10);

    public static int cusparseSbsric02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pInputBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsric02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pInputBuffer));
    }

    private static native int cusparseSbsric02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseDbsric02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pInputBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsric02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pInputBuffer));
    }

    private static native int cusparseDbsric02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseCbsric02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pInputBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsric02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pInputBuffer));
    }

    private static native int cusparseCbsric02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseZbsric02_analysis(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pInputBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsric02_analysisNative(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pInputBuffer));
    }

    private static native int cusparseZbsric02_analysisNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseSbsric02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSbsric02Native(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseSbsric02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseDbsric02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDbsric02Native(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseDbsric02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseCbsric02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCbsric02Native(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseCbsric02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseZbsric02(cusparseHandle handle, int dirA, int mb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int blockDim, bsric02Info info, int policy, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZbsric02Native(handle, dirA, mb, nnzb, descrA, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, blockDim, info, policy, pBuffer));
    }

    private static native int cusparseZbsric02Native(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, bsric02Info var9, int var10, Pointer var11);

    public static int cusparseSgtsv2_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, long[] bufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSgtsv2_bufferSizeExtNative(handle, m, n, dl, d, du, B, ldb, bufferSizeInBytes));
    }

    private static native int cusparseSgtsv2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, long[] var8);

    public static int cusparseDgtsv2_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, long[] bufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDgtsv2_bufferSizeExtNative(handle, m, n, dl, d, du, B, ldb, bufferSizeInBytes));
    }

    private static native int cusparseDgtsv2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, long[] var8);

    public static int cusparseCgtsv2_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, long[] bufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCgtsv2_bufferSizeExtNative(handle, m, n, dl, d, du, B, ldb, bufferSizeInBytes));
    }

    private static native int cusparseCgtsv2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, long[] var8);

    public static int cusparseZgtsv2_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, long[] bufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZgtsv2_bufferSizeExtNative(handle, m, n, dl, d, du, B, ldb, bufferSizeInBytes));
    }

    private static native int cusparseZgtsv2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, long[] var8);

    public static int cusparseSgtsv2(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSgtsv2Native(handle, m, n, dl, d, du, B, ldb, pBuffer));
    }

    private static native int cusparseSgtsv2Native(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8);

    public static int cusparseDgtsv2(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDgtsv2Native(handle, m, n, dl, d, du, B, ldb, pBuffer));
    }

    private static native int cusparseDgtsv2Native(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8);

    public static int cusparseCgtsv2(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCgtsv2Native(handle, m, n, dl, d, du, B, ldb, pBuffer));
    }

    private static native int cusparseCgtsv2Native(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8);

    public static int cusparseZgtsv2(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZgtsv2Native(handle, m, n, dl, d, du, B, ldb, pBuffer));
    }

    private static native int cusparseZgtsv2Native(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8);

    public static int cusparseSgtsv2_nopivot_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, long[] bufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSgtsv2_nopivot_bufferSizeExtNative(handle, m, n, dl, d, du, B, ldb, bufferSizeInBytes));
    }

    private static native int cusparseSgtsv2_nopivot_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, long[] var8);

    public static int cusparseDgtsv2_nopivot_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, long[] bufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDgtsv2_nopivot_bufferSizeExtNative(handle, m, n, dl, d, du, B, ldb, bufferSizeInBytes));
    }

    private static native int cusparseDgtsv2_nopivot_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, long[] var8);

    public static int cusparseCgtsv2_nopivot_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, long[] bufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCgtsv2_nopivot_bufferSizeExtNative(handle, m, n, dl, d, du, B, ldb, bufferSizeInBytes));
    }

    private static native int cusparseCgtsv2_nopivot_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, long[] var8);

    public static int cusparseZgtsv2_nopivot_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, long[] bufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZgtsv2_nopivot_bufferSizeExtNative(handle, m, n, dl, d, du, B, ldb, bufferSizeInBytes));
    }

    private static native int cusparseZgtsv2_nopivot_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, long[] var8);

    public static int cusparseSgtsv2_nopivot(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSgtsv2_nopivotNative(handle, m, n, dl, d, du, B, ldb, pBuffer));
    }

    private static native int cusparseSgtsv2_nopivotNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8);

    public static int cusparseDgtsv2_nopivot(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDgtsv2_nopivotNative(handle, m, n, dl, d, du, B, ldb, pBuffer));
    }

    private static native int cusparseDgtsv2_nopivotNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8);

    public static int cusparseCgtsv2_nopivot(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCgtsv2_nopivotNative(handle, m, n, dl, d, du, B, ldb, pBuffer));
    }

    private static native int cusparseCgtsv2_nopivotNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8);

    public static int cusparseZgtsv2_nopivot(cusparseHandle handle, int m, int n, Pointer dl, Pointer d, Pointer du, Pointer B, int ldb, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZgtsv2_nopivotNative(handle, m, n, dl, d, du, B, ldb, pBuffer));
    }

    private static native int cusparseZgtsv2_nopivotNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8);

    public static int cusparseSgtsv2StridedBatch_bufferSizeExt(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride, long[] bufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSgtsv2StridedBatch_bufferSizeExtNative(handle, m, dl, d, du, x, batchCount, batchStride, bufferSizeInBytes));
    }

    private static native int cusparseSgtsv2StridedBatch_bufferSizeExtNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7, long[] var8);

    public static int cusparseDgtsv2StridedBatch_bufferSizeExt(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride, long[] bufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDgtsv2StridedBatch_bufferSizeExtNative(handle, m, dl, d, du, x, batchCount, batchStride, bufferSizeInBytes));
    }

    private static native int cusparseDgtsv2StridedBatch_bufferSizeExtNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7, long[] var8);

    public static int cusparseCgtsv2StridedBatch_bufferSizeExt(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride, long[] bufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCgtsv2StridedBatch_bufferSizeExtNative(handle, m, dl, d, du, x, batchCount, batchStride, bufferSizeInBytes));
    }

    private static native int cusparseCgtsv2StridedBatch_bufferSizeExtNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7, long[] var8);

    public static int cusparseZgtsv2StridedBatch_bufferSizeExt(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride, long[] bufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZgtsv2StridedBatch_bufferSizeExtNative(handle, m, dl, d, du, x, batchCount, batchStride, bufferSizeInBytes));
    }

    private static native int cusparseZgtsv2StridedBatch_bufferSizeExtNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7, long[] var8);

    public static int cusparseSgtsv2StridedBatch(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSgtsv2StridedBatchNative(handle, m, dl, d, du, x, batchCount, batchStride, pBuffer));
    }

    private static native int cusparseSgtsv2StridedBatchNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7, Pointer var8);

    public static int cusparseDgtsv2StridedBatch(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDgtsv2StridedBatchNative(handle, m, dl, d, du, x, batchCount, batchStride, pBuffer));
    }

    private static native int cusparseDgtsv2StridedBatchNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7, Pointer var8);

    public static int cusparseCgtsv2StridedBatch(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCgtsv2StridedBatchNative(handle, m, dl, d, du, x, batchCount, batchStride, pBuffer));
    }

    private static native int cusparseCgtsv2StridedBatchNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7, Pointer var8);

    public static int cusparseZgtsv2StridedBatch(cusparseHandle handle, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, int batchStride, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZgtsv2StridedBatchNative(handle, m, dl, d, du, x, batchCount, batchStride, pBuffer));
    }

    private static native int cusparseZgtsv2StridedBatchNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6, int var7, Pointer var8);

    public static int cusparseSgtsvInterleavedBatch_bufferSizeExt(cusparseHandle handle, int algo, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSgtsvInterleavedBatch_bufferSizeExtNative(handle, algo, m, dl, d, du, x, batchCount, pBufferSizeInBytes));
    }

    private static native int cusparseSgtsvInterleavedBatch_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, long[] var8);

    public static int cusparseDgtsvInterleavedBatch_bufferSizeExt(cusparseHandle handle, int algo, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDgtsvInterleavedBatch_bufferSizeExtNative(handle, algo, m, dl, d, du, x, batchCount, pBufferSizeInBytes));
    }

    private static native int cusparseDgtsvInterleavedBatch_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, long[] var8);

    public static int cusparseCgtsvInterleavedBatch_bufferSizeExt(cusparseHandle handle, int algo, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCgtsvInterleavedBatch_bufferSizeExtNative(handle, algo, m, dl, d, du, x, batchCount, pBufferSizeInBytes));
    }

    private static native int cusparseCgtsvInterleavedBatch_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, long[] var8);

    public static int cusparseZgtsvInterleavedBatch_bufferSizeExt(cusparseHandle handle, int algo, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZgtsvInterleavedBatch_bufferSizeExtNative(handle, algo, m, dl, d, du, x, batchCount, pBufferSizeInBytes));
    }

    private static native int cusparseZgtsvInterleavedBatch_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, long[] var8);

    public static int cusparseSgtsvInterleavedBatch(cusparseHandle handle, int algo, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSgtsvInterleavedBatchNative(handle, algo, m, dl, d, du, x, batchCount, pBuffer));
    }

    private static native int cusparseSgtsvInterleavedBatchNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8);

    public static int cusparseDgtsvInterleavedBatch(cusparseHandle handle, int algo, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDgtsvInterleavedBatchNative(handle, algo, m, dl, d, du, x, batchCount, pBuffer));
    }

    private static native int cusparseDgtsvInterleavedBatchNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8);

    public static int cusparseCgtsvInterleavedBatch(cusparseHandle handle, int algo, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCgtsvInterleavedBatchNative(handle, algo, m, dl, d, du, x, batchCount, pBuffer));
    }

    private static native int cusparseCgtsvInterleavedBatchNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8);

    public static int cusparseZgtsvInterleavedBatch(cusparseHandle handle, int algo, int m, Pointer dl, Pointer d, Pointer du, Pointer x, int batchCount, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZgtsvInterleavedBatchNative(handle, algo, m, dl, d, du, x, batchCount, pBuffer));
    }

    private static native int cusparseZgtsvInterleavedBatchNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8);

    public static int cusparseSgpsvInterleavedBatch_bufferSizeExt(cusparseHandle handle, int algo, int m, Pointer ds, Pointer dl, Pointer d, Pointer du, Pointer dw, Pointer x, int batchCount, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSgpsvInterleavedBatch_bufferSizeExtNative(handle, algo, m, ds, dl, d, du, dw, x, batchCount, pBufferSizeInBytes));
    }

    private static native int cusparseSgpsvInterleavedBatch_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9, long[] var10);

    public static int cusparseDgpsvInterleavedBatch_bufferSizeExt(cusparseHandle handle, int algo, int m, Pointer ds, Pointer dl, Pointer d, Pointer du, Pointer dw, Pointer x, int batchCount, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDgpsvInterleavedBatch_bufferSizeExtNative(handle, algo, m, ds, dl, d, du, dw, x, batchCount, pBufferSizeInBytes));
    }

    private static native int cusparseDgpsvInterleavedBatch_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9, long[] var10);

    public static int cusparseCgpsvInterleavedBatch_bufferSizeExt(cusparseHandle handle, int algo, int m, Pointer ds, Pointer dl, Pointer d, Pointer du, Pointer dw, Pointer x, int batchCount, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCgpsvInterleavedBatch_bufferSizeExtNative(handle, algo, m, ds, dl, d, du, dw, x, batchCount, pBufferSizeInBytes));
    }

    private static native int cusparseCgpsvInterleavedBatch_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9, long[] var10);

    public static int cusparseZgpsvInterleavedBatch_bufferSizeExt(cusparseHandle handle, int algo, int m, Pointer ds, Pointer dl, Pointer d, Pointer du, Pointer dw, Pointer x, int batchCount, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZgpsvInterleavedBatch_bufferSizeExtNative(handle, algo, m, ds, dl, d, du, dw, x, batchCount, pBufferSizeInBytes));
    }

    private static native int cusparseZgpsvInterleavedBatch_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9, long[] var10);

    public static int cusparseSgpsvInterleavedBatch(cusparseHandle handle, int algo, int m, Pointer ds, Pointer dl, Pointer d, Pointer du, Pointer dw, Pointer x, int batchCount, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSgpsvInterleavedBatchNative(handle, algo, m, ds, dl, d, du, dw, x, batchCount, pBuffer));
    }

    private static native int cusparseSgpsvInterleavedBatchNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9, Pointer var10);

    public static int cusparseDgpsvInterleavedBatch(cusparseHandle handle, int algo, int m, Pointer ds, Pointer dl, Pointer d, Pointer du, Pointer dw, Pointer x, int batchCount, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDgpsvInterleavedBatchNative(handle, algo, m, ds, dl, d, du, dw, x, batchCount, pBuffer));
    }

    private static native int cusparseDgpsvInterleavedBatchNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9, Pointer var10);

    public static int cusparseCgpsvInterleavedBatch(cusparseHandle handle, int algo, int m, Pointer ds, Pointer dl, Pointer d, Pointer du, Pointer dw, Pointer x, int batchCount, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCgpsvInterleavedBatchNative(handle, algo, m, ds, dl, d, du, dw, x, batchCount, pBuffer));
    }

    private static native int cusparseCgpsvInterleavedBatchNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9, Pointer var10);

    public static int cusparseZgpsvInterleavedBatch(cusparseHandle handle, int algo, int m, Pointer ds, Pointer dl, Pointer d, Pointer du, Pointer dw, Pointer x, int batchCount, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZgpsvInterleavedBatchNative(handle, algo, m, ds, dl, d, du, dw, x, batchCount, pBuffer));
    }

    private static native int cusparseZgpsvInterleavedBatchNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9, Pointer var10);

    @Deprecated
    public static int cusparseCreateCsrgemm2Info(csrgemm2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateCsrgemm2InfoNative(info));
    }

    private static native int cusparseCreateCsrgemm2InfoNative(csrgemm2Info var0);

    @Deprecated
    public static int cusparseDestroyCsrgemm2Info(csrgemm2Info info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyCsrgemm2InfoNative(info));
    }

    private static native int cusparseDestroyCsrgemm2InfoNative(csrgemm2Info var0);

    @Deprecated
    public static int cusparseScsrgemm2_bufferSizeExt(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, csrgemm2Info info, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseScsrgemm2_bufferSizeExtNative(handle, m, n, k, alpha, descrA, nnzA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedRowPtrD, csrSortedColIndD, info, pBufferSizeInBytes));
    }

    private static native int cusparseScsrgemm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, cusparseMatDescr var9, int var10, Pointer var11, Pointer var12, Pointer var13, cusparseMatDescr var14, int var15, Pointer var16, Pointer var17, csrgemm2Info var18, long[] var19);

    @Deprecated
    public static int cusparseDcsrgemm2_bufferSizeExt(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, csrgemm2Info info, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrgemm2_bufferSizeExtNative(handle, m, n, k, alpha, descrA, nnzA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedRowPtrD, csrSortedColIndD, info, pBufferSizeInBytes));
    }

    private static native int cusparseDcsrgemm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, cusparseMatDescr var9, int var10, Pointer var11, Pointer var12, Pointer var13, cusparseMatDescr var14, int var15, Pointer var16, Pointer var17, csrgemm2Info var18, long[] var19);

    @Deprecated
    public static int cusparseCcsrgemm2_bufferSizeExt(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, csrgemm2Info info, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrgemm2_bufferSizeExtNative(handle, m, n, k, alpha, descrA, nnzA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedRowPtrD, csrSortedColIndD, info, pBufferSizeInBytes));
    }

    private static native int cusparseCcsrgemm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, cusparseMatDescr var9, int var10, Pointer var11, Pointer var12, Pointer var13, cusparseMatDescr var14, int var15, Pointer var16, Pointer var17, csrgemm2Info var18, long[] var19);

    @Deprecated
    public static int cusparseZcsrgemm2_bufferSizeExt(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, csrgemm2Info info, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrgemm2_bufferSizeExtNative(handle, m, n, k, alpha, descrA, nnzA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedRowPtrD, csrSortedColIndD, info, pBufferSizeInBytes));
    }

    private static native int cusparseZcsrgemm2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, cusparseMatDescr var9, int var10, Pointer var11, Pointer var12, Pointer var13, cusparseMatDescr var14, int var15, Pointer var16, Pointer var17, csrgemm2Info var18, long[] var19);

    @Deprecated
    public static int cusparseXcsrgemm2Nnz(cusparseHandle handle, int m, int n, int k, cusparseMatDescr descrA, int nnzA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrD, int nnzD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, cusparseMatDescr descrC, Pointer csrSortedRowPtrC, Pointer nnzTotalDevHostPtr, csrgemm2Info info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseXcsrgemm2NnzNative(handle, m, n, k, descrA, nnzA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedRowPtrB, csrSortedColIndB, descrD, nnzD, csrSortedRowPtrD, csrSortedColIndD, descrC, csrSortedRowPtrC, nnzTotalDevHostPtr, info, pBuffer));
    }

    private static native int cusparseXcsrgemm2NnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, cusparseMatDescr var8, int var9, Pointer var10, Pointer var11, cusparseMatDescr var12, int var13, Pointer var14, Pointer var15, cusparseMatDescr var16, Pointer var17, Pointer var18, csrgemm2Info var19, Pointer var20);

    @Deprecated
    public static int cusparseScsrgemm2(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedValD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, csrgemm2Info info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsrgemm2Native(handle, m, n, k, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedValD, csrSortedRowPtrD, csrSortedColIndD, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBuffer));
    }

    private static native int cusparseScsrgemm2Native(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, int var17, Pointer var18, Pointer var19, Pointer var20, cusparseMatDescr var21, Pointer var22, Pointer var23, Pointer var24, csrgemm2Info var25, Pointer var26);

    @Deprecated
    public static int cusparseDcsrgemm2(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedValD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, csrgemm2Info info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrgemm2Native(handle, m, n, k, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedValD, csrSortedRowPtrD, csrSortedColIndD, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBuffer));
    }

    private static native int cusparseDcsrgemm2Native(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, int var17, Pointer var18, Pointer var19, Pointer var20, cusparseMatDescr var21, Pointer var22, Pointer var23, Pointer var24, csrgemm2Info var25, Pointer var26);

    @Deprecated
    public static int cusparseCcsrgemm2(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedValD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, csrgemm2Info info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrgemm2Native(handle, m, n, k, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedValD, csrSortedRowPtrD, csrSortedColIndD, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBuffer));
    }

    private static native int cusparseCcsrgemm2Native(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, int var17, Pointer var18, Pointer var19, Pointer var20, cusparseMatDescr var21, Pointer var22, Pointer var23, Pointer var24, csrgemm2Info var25, Pointer var26);

    @Deprecated
    public static int cusparseZcsrgemm2(cusparseHandle handle, int m, int n, int k, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, Pointer beta, cusparseMatDescr descrD, int nnzD, Pointer csrSortedValD, Pointer csrSortedRowPtrD, Pointer csrSortedColIndD, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, csrgemm2Info info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrgemm2Native(handle, m, n, k, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, beta, descrD, nnzD, csrSortedValD, csrSortedRowPtrD, csrSortedColIndD, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBuffer));
    }

    private static native int cusparseZcsrgemm2Native(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, cusparseMatDescr var5, int var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, Pointer var15, cusparseMatDescr var16, int var17, Pointer var18, Pointer var19, Pointer var20, cusparseMatDescr var21, Pointer var22, Pointer var23, Pointer var24, csrgemm2Info var25, Pointer var26);

    public static int cusparseScsrgeam2_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseScsrgeam2_bufferSizeExtNative(handle, m, n, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, beta, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBufferSizeInBytes));
    }

    private static native int cusparseScsrgeam2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18, long[] var19);

    public static int cusparseDcsrgeam2_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrgeam2_bufferSizeExtNative(handle, m, n, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, beta, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBufferSizeInBytes));
    }

    private static native int cusparseDcsrgeam2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18, long[] var19);

    public static int cusparseCcsrgeam2_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrgeam2_bufferSizeExtNative(handle, m, n, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, beta, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBufferSizeInBytes));
    }

    private static native int cusparseCcsrgeam2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18, long[] var19);

    public static int cusparseZcsrgeam2_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrgeam2_bufferSizeExtNative(handle, m, n, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, beta, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBufferSizeInBytes));
    }

    private static native int cusparseZcsrgeam2_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18, long[] var19);

    public static int cusparseXcsrgeam2Nnz(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, int nnzA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrB, int nnzB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedRowPtrC, Pointer nnzTotalDevHostPtr, Pointer workspace) {
        return JCusparse.checkResult(JCusparse.cusparseXcsrgeam2NnzNative(handle, m, n, descrA, nnzA, csrSortedRowPtrA, csrSortedColIndA, descrB, nnzB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedRowPtrC, nnzTotalDevHostPtr, workspace));
    }

    private static native int cusparseXcsrgeam2NnzNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, int var4, Pointer var5, Pointer var6, cusparseMatDescr var7, int var8, Pointer var9, Pointer var10, cusparseMatDescr var11, Pointer var12, Pointer var13, Pointer var14);

    public static int cusparseScsrgeam2(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsrgeam2Native(handle, m, n, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, beta, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBuffer));
    }

    private static native int cusparseScsrgeam2Native(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18, Pointer var19);

    public static int cusparseDcsrgeam2(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrgeam2Native(handle, m, n, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, beta, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBuffer));
    }

    private static native int cusparseDcsrgeam2Native(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18, Pointer var19);

    public static int cusparseCcsrgeam2(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrgeam2Native(handle, m, n, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, beta, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBuffer));
    }

    private static native int cusparseCcsrgeam2Native(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18, Pointer var19);

    public static int cusparseZcsrgeam2(cusparseHandle handle, int m, int n, Pointer alpha, cusparseMatDescr descrA, int nnzA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer beta, cusparseMatDescr descrB, int nnzB, Pointer csrSortedValB, Pointer csrSortedRowPtrB, Pointer csrSortedColIndB, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrgeam2Native(handle, m, n, alpha, descrA, nnzA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, beta, descrB, nnzB, csrSortedValB, csrSortedRowPtrB, csrSortedColIndB, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBuffer));
    }

    private static native int cusparseZcsrgeam2Native(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseMatDescr var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cusparseMatDescr var10, int var11, Pointer var12, Pointer var13, Pointer var14, cusparseMatDescr var15, Pointer var16, Pointer var17, Pointer var18, Pointer var19);

    public static int cusparseScsrcolor(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer fractionToColor, Pointer ncolors, Pointer coloring, Pointer reordering, cusparseColorInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseScsrcolorNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, fractionToColor, ncolors, coloring, reordering, info));
    }

    private static native int cusparseScsrcolorNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, cusparseColorInfo var11);

    public static int cusparseDcsrcolor(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer fractionToColor, Pointer ncolors, Pointer coloring, Pointer reordering, cusparseColorInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrcolorNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, fractionToColor, ncolors, coloring, reordering, info));
    }

    private static native int cusparseDcsrcolorNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, cusparseColorInfo var11);

    public static int cusparseCcsrcolor(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer fractionToColor, Pointer ncolors, Pointer coloring, Pointer reordering, cusparseColorInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrcolorNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, fractionToColor, ncolors, coloring, reordering, info));
    }

    private static native int cusparseCcsrcolorNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, cusparseColorInfo var11);

    public static int cusparseZcsrcolor(cusparseHandle handle, int m, int nnz, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer fractionToColor, Pointer ncolors, Pointer coloring, Pointer reordering, cusparseColorInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrcolorNative(handle, m, nnz, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, fractionToColor, ncolors, coloring, reordering, info));
    }

    private static native int cusparseZcsrcolorNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, cusparseColorInfo var11);

    public static int cusparseSnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzTotalDevHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseSnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzTotalDevHostPtr));
    }

    private static native int cusparseSnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseDnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzTotalDevHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseDnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzTotalDevHostPtr));
    }

    private static native int cusparseDnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseCnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzTotalDevHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseCnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzTotalDevHostPtr));
    }

    private static native int cusparseCnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseZnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzTotalDevHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseZnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzTotalDevHostPtr));
    }

    private static native int cusparseZnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseSnnz_compress(cusparseHandle handle, int m, cusparseMatDescr descr, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer nnzPerRow, Pointer nnzC, float tol) {
        return JCusparse.checkResult(JCusparse.cusparseSnnz_compressNative(handle, m, descr, csrSortedValA, csrSortedRowPtrA, nnzPerRow, nnzC, tol));
    }

    private static native int cusparseSnnz_compressNative(cusparseHandle var0, int var1, cusparseMatDescr var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, float var7);

    public static int cusparseDnnz_compress(cusparseHandle handle, int m, cusparseMatDescr descr, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer nnzPerRow, Pointer nnzC, double tol) {
        return JCusparse.checkResult(JCusparse.cusparseDnnz_compressNative(handle, m, descr, csrSortedValA, csrSortedRowPtrA, nnzPerRow, nnzC, tol));
    }

    private static native int cusparseDnnz_compressNative(cusparseHandle var0, int var1, cusparseMatDescr var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, double var7);

    public static int cusparseCnnz_compress(cusparseHandle handle, int m, cusparseMatDescr descr, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer nnzPerRow, Pointer nnzC, cuComplex tol) {
        return JCusparse.checkResult(JCusparse.cusparseCnnz_compressNative(handle, m, descr, csrSortedValA, csrSortedRowPtrA, nnzPerRow, nnzC, tol));
    }

    private static native int cusparseCnnz_compressNative(cusparseHandle var0, int var1, cusparseMatDescr var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, cuComplex var7);

    public static int cusparseZnnz_compress(cusparseHandle handle, int m, cusparseMatDescr descr, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer nnzPerRow, Pointer nnzC, cuDoubleComplex tol) {
        return JCusparse.checkResult(JCusparse.cusparseZnnz_compressNative(handle, m, descr, csrSortedValA, csrSortedRowPtrA, nnzPerRow, nnzC, tol));
    }

    private static native int cusparseZnnz_compressNative(cusparseHandle var0, int var1, cusparseMatDescr var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, cuDoubleComplex var7);

    public static int cusparseScsr2csr_compress(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedColIndA, Pointer csrSortedRowPtrA, int nnzA, Pointer nnzPerRow, Pointer csrSortedValC, Pointer csrSortedColIndC, Pointer csrSortedRowPtrC, float tol) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2csr_compressNative(handle, m, n, descrA, csrSortedValA, csrSortedColIndA, csrSortedRowPtrA, nnzA, nnzPerRow, csrSortedValC, csrSortedColIndC, csrSortedRowPtrC, tol));
    }

    private static native int cusparseScsr2csr_compressNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, float var12);

    public static int cusparseDcsr2csr_compress(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedColIndA, Pointer csrSortedRowPtrA, int nnzA, Pointer nnzPerRow, Pointer csrSortedValC, Pointer csrSortedColIndC, Pointer csrSortedRowPtrC, double tol) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2csr_compressNative(handle, m, n, descrA, csrSortedValA, csrSortedColIndA, csrSortedRowPtrA, nnzA, nnzPerRow, csrSortedValC, csrSortedColIndC, csrSortedRowPtrC, tol));
    }

    private static native int cusparseDcsr2csr_compressNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, double var12);

    public static int cusparseCcsr2csr_compress(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedColIndA, Pointer csrSortedRowPtrA, int nnzA, Pointer nnzPerRow, Pointer csrSortedValC, Pointer csrSortedColIndC, Pointer csrSortedRowPtrC, cuComplex tol) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2csr_compressNative(handle, m, n, descrA, csrSortedValA, csrSortedColIndA, csrSortedRowPtrA, nnzA, nnzPerRow, csrSortedValC, csrSortedColIndC, csrSortedRowPtrC, tol));
    }

    private static native int cusparseCcsr2csr_compressNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, cuComplex var12);

    public static int cusparseZcsr2csr_compress(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedColIndA, Pointer csrSortedRowPtrA, int nnzA, Pointer nnzPerRow, Pointer csrSortedValC, Pointer csrSortedColIndC, Pointer csrSortedRowPtrC, cuDoubleComplex tol) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2csr_compressNative(handle, m, n, descrA, csrSortedValA, csrSortedColIndA, csrSortedRowPtrA, nnzA, nnzPerRow, csrSortedValC, csrSortedColIndC, csrSortedRowPtrC, tol));
    }

    private static native int cusparseZcsr2csr_compressNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, cuDoubleComplex var12);

    @Deprecated
    public static int cusparseSdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseSdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA));
    }

    private static native int cusparseSdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    @Deprecated
    public static int cusparseDdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseDdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA));
    }

    private static native int cusparseDdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    @Deprecated
    public static int cusparseCdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseCdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA));
    }

    private static native int cusparseCdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    @Deprecated
    public static int cusparseZdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseZdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA));
    }

    private static native int cusparseZdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    @Deprecated
    public static int cusparseScsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2denseNative(handle, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, A, lda));
    }

    private static native int cusparseScsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    @Deprecated
    public static int cusparseDcsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2denseNative(handle, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, A, lda));
    }

    private static native int cusparseDcsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    @Deprecated
    public static int cusparseCcsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2denseNative(handle, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, A, lda));
    }

    private static native int cusparseCcsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    @Deprecated
    public static int cusparseZcsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2denseNative(handle, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, A, lda));
    }

    private static native int cusparseZcsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    @Deprecated
    public static int cusparseSdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA) {
        return JCusparse.checkResult(JCusparse.cusparseSdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA));
    }

    private static native int cusparseSdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    @Deprecated
    public static int cusparseDdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA) {
        return JCusparse.checkResult(JCusparse.cusparseDdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA));
    }

    private static native int cusparseDdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    @Deprecated
    public static int cusparseCdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA) {
        return JCusparse.checkResult(JCusparse.cusparseCdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA));
    }

    private static native int cusparseCdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    @Deprecated
    public static int cusparseZdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA) {
        return JCusparse.checkResult(JCusparse.cusparseZdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA));
    }

    private static native int cusparseZdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    @Deprecated
    public static int cusparseScsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseScsc2denseNative(handle, m, n, descrA, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA, A, lda));
    }

    private static native int cusparseScsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    @Deprecated
    public static int cusparseDcsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseDcsc2denseNative(handle, m, n, descrA, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA, A, lda));
    }

    private static native int cusparseDcsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    @Deprecated
    public static int cusparseCcsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseCcsc2denseNative(handle, m, n, descrA, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA, A, lda));
    }

    private static native int cusparseCcsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    @Deprecated
    public static int cusparseZcsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscSortedValA, Pointer cscSortedRowIndA, Pointer cscSortedColPtrA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseZcsc2denseNative(handle, m, n, descrA, cscSortedValA, cscSortedRowIndA, cscSortedColPtrA, A, lda));
    }

    private static native int cusparseZcsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseXcoo2csr(cusparseHandle handle, Pointer cooRowInd, int nnz, int m, Pointer csrSortedRowPtr, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseXcoo2csrNative(handle, cooRowInd, nnz, m, csrSortedRowPtr, idxBase));
    }

    private static native int cusparseXcoo2csrNative(cusparseHandle var0, Pointer var1, int var2, int var3, Pointer var4, int var5);

    public static int cusparseXcsr2coo(cusparseHandle handle, Pointer csrSortedRowPtr, int nnz, int m, Pointer cooRowInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseXcsr2cooNative(handle, csrSortedRowPtr, nnz, m, cooRowInd, idxBase));
    }

    private static native int cusparseXcsr2cooNative(cusparseHandle var0, Pointer var1, int var2, int var3, Pointer var4, int var5);

    public static int cusparseXcsr2bsrNnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer bsrSortedRowPtrC, Pointer nnzTotalDevHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseXcsr2bsrNnzNative(handle, dirA, m, n, descrA, csrSortedRowPtrA, csrSortedColIndA, blockDim, descrC, bsrSortedRowPtrC, nnzTotalDevHostPtr));
    }

    private static native int cusparseXcsr2bsrNnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, int var7, cusparseMatDescr var8, Pointer var9, Pointer var10);

    public static int cusparseScsr2bsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2bsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, blockDim, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC));
    }

    private static native int cusparseScsr2bsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseDcsr2bsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2bsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, blockDim, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC));
    }

    private static native int cusparseDcsr2bsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseCcsr2bsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2bsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, blockDim, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC));
    }

    private static native int cusparseCcsr2bsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseZcsr2bsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2bsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, blockDim, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC));
    }

    private static native int cusparseZcsr2bsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseSbsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseSbsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseSbsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseDbsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseDbsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseDbsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseCbsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseCbsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseCbsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseZbsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int blockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseZbsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, blockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseZbsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseSgebsr2gebsc_bufferSize(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSgebsr2gebsc_bufferSizeNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseSgebsr2gebsc_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, int[] var9);

    public static int cusparseDgebsr2gebsc_bufferSize(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDgebsr2gebsc_bufferSizeNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseDgebsr2gebsc_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, int[] var9);

    public static int cusparseCgebsr2gebsc_bufferSize(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCgebsr2gebsc_bufferSizeNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseCgebsr2gebsc_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, int[] var9);

    public static int cusparseZgebsr2gebsc_bufferSize(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZgebsr2gebsc_bufferSizeNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseZgebsr2gebsc_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, int[] var9);

    public static int cusparseSgebsr2gebsc(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, Pointer bscVal, Pointer bscRowInd, Pointer bscColPtr, int copyValues, int idxBase, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSgebsr2gebscNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, bscVal, bscRowInd, bscColPtr, copyValues, idxBase, pBuffer));
    }

    private static native int cusparseSgebsr2gebscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseDgebsr2gebsc(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, Pointer bscVal, Pointer bscRowInd, Pointer bscColPtr, int copyValues, int idxBase, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDgebsr2gebscNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, bscVal, bscRowInd, bscColPtr, copyValues, idxBase, pBuffer));
    }

    private static native int cusparseDgebsr2gebscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseCgebsr2gebsc(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, Pointer bscVal, Pointer bscRowInd, Pointer bscColPtr, int copyValues, int idxBase, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCgebsr2gebscNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, bscVal, bscRowInd, bscColPtr, copyValues, idxBase, pBuffer));
    }

    private static native int cusparseCgebsr2gebscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseZgebsr2gebsc(cusparseHandle handle, int mb, int nb, int nnzb, Pointer bsrSortedVal, Pointer bsrSortedRowPtr, Pointer bsrSortedColInd, int rowBlockDim, int colBlockDim, Pointer bscVal, Pointer bscRowInd, Pointer bscColPtr, int copyValues, int idxBase, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZgebsr2gebscNative(handle, mb, nb, nnzb, bsrSortedVal, bsrSortedRowPtr, bsrSortedColInd, rowBlockDim, colBlockDim, bscVal, bscRowInd, bscColPtr, copyValues, idxBase, pBuffer));
    }

    private static native int cusparseZgebsr2gebscNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, int var7, int var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseSgebsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDim, int colBlockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseSgebsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDim, colBlockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseSgebsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, cusparseMatDescr var10, Pointer var11, Pointer var12, Pointer var13);

    public static int cusparseDgebsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDim, int colBlockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseDgebsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDim, colBlockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseDgebsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, cusparseMatDescr var10, Pointer var11, Pointer var12, Pointer var13);

    public static int cusparseCgebsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDim, int colBlockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseCgebsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDim, colBlockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseCgebsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, cusparseMatDescr var10, Pointer var11, Pointer var12, Pointer var13);

    public static int cusparseZgebsr2csr(cusparseHandle handle, int dirA, int mb, int nb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDim, int colBlockDim, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC) {
        return JCusparse.checkResult(JCusparse.cusparseZgebsr2csrNative(handle, dirA, mb, nb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDim, colBlockDim, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC));
    }

    private static native int cusparseZgebsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, cusparseMatDescr var10, Pointer var11, Pointer var12, Pointer var13);

    public static int cusparseScsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2gebsr_bufferSizeNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseScsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, int[] var10);

    public static int cusparseDcsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2gebsr_bufferSizeNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseDcsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, int[] var10);

    public static int cusparseCcsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2gebsr_bufferSizeNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseCcsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, int[] var10);

    public static int cusparseZcsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, int rowBlockDim, int colBlockDim, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2gebsr_bufferSizeNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, rowBlockDim, colBlockDim, pBufferSizeInBytes));
    }

    private static native int cusparseZcsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, int var8, int var9, int[] var10);

    public static int cusparseXcsr2gebsrNnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrC, Pointer bsrSortedRowPtrC, int rowBlockDim, int colBlockDim, Pointer nnzTotalDevHostPtr, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseXcsr2gebsrNnzNative(handle, dirA, m, n, descrA, csrSortedRowPtrA, csrSortedColIndA, descrC, bsrSortedRowPtrC, rowBlockDim, colBlockDim, nnzTotalDevHostPtr, pBuffer));
    }

    private static native int cusparseXcsr2gebsrNnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, cusparseMatDescr var7, Pointer var8, int var9, int var10, Pointer var11, Pointer var12);

    public static int cusparseScsr2gebsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDim, int colBlockDim, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2gebsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDim, colBlockDim, pBuffer));
    }

    private static native int cusparseScsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseDcsr2gebsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDim, int colBlockDim, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2gebsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDim, colBlockDim, pBuffer));
    }

    private static native int cusparseDcsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseCcsr2gebsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDim, int colBlockDim, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2gebsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDim, colBlockDim, pBuffer));
    }

    private static native int cusparseCcsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseZcsr2gebsr(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDim, int colBlockDim, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2gebsrNative(handle, dirA, m, n, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDim, colBlockDim, pBuffer));
    }

    private static native int cusparseZcsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseMatDescr var8, Pointer var9, Pointer var10, Pointer var11, int var12, int var13, Pointer var14);

    public static int cusparseSgebsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, int rowBlockDimC, int colBlockDimC, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSgebsr2gebsr_bufferSizeNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, rowBlockDimC, colBlockDimC, pBufferSizeInBytes));
    }

    private static native int cusparseSgebsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, int var11, int var12, int[] var13);

    public static int cusparseDgebsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, int rowBlockDimC, int colBlockDimC, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDgebsr2gebsr_bufferSizeNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, rowBlockDimC, colBlockDimC, pBufferSizeInBytes));
    }

    private static native int cusparseDgebsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, int var11, int var12, int[] var13);

    public static int cusparseCgebsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, int rowBlockDimC, int colBlockDimC, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCgebsr2gebsr_bufferSizeNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, rowBlockDimC, colBlockDimC, pBufferSizeInBytes));
    }

    private static native int cusparseCgebsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, int var11, int var12, int[] var13);

    public static int cusparseZgebsr2gebsr_bufferSize(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, int rowBlockDimC, int colBlockDimC, int[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZgebsr2gebsr_bufferSizeNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, rowBlockDimC, colBlockDimC, pBufferSizeInBytes));
    }

    private static native int cusparseZgebsr2gebsr_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, int var11, int var12, int[] var13);

    public static int cusparseXgebsr2gebsrNnz(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, cusparseMatDescr descrC, Pointer bsrSortedRowPtrC, int rowBlockDimC, int colBlockDimC, Pointer nnzTotalDevHostPtr, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseXgebsr2gebsrNnzNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, descrC, bsrSortedRowPtrC, rowBlockDimC, colBlockDimC, nnzTotalDevHostPtr, pBuffer));
    }

    private static native int cusparseXgebsr2gebsrNnzNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, int var8, int var9, cusparseMatDescr var10, Pointer var11, int var12, int var13, Pointer var14, Pointer var15);

    public static int cusparseSgebsr2gebsr(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDimC, int colBlockDimC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSgebsr2gebsrNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDimC, colBlockDimC, pBuffer));
    }

    private static native int cusparseSgebsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, cusparseMatDescr var11, Pointer var12, Pointer var13, Pointer var14, int var15, int var16, Pointer var17);

    public static int cusparseDgebsr2gebsr(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDimC, int colBlockDimC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDgebsr2gebsrNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDimC, colBlockDimC, pBuffer));
    }

    private static native int cusparseDgebsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, cusparseMatDescr var11, Pointer var12, Pointer var13, Pointer var14, int var15, int var16, Pointer var17);

    public static int cusparseCgebsr2gebsr(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDimC, int colBlockDimC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCgebsr2gebsrNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDimC, colBlockDimC, pBuffer));
    }

    private static native int cusparseCgebsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, cusparseMatDescr var11, Pointer var12, Pointer var13, Pointer var14, int var15, int var16, Pointer var17);

    public static int cusparseZgebsr2gebsr(cusparseHandle handle, int dirA, int mb, int nb, int nnzb, cusparseMatDescr descrA, Pointer bsrSortedValA, Pointer bsrSortedRowPtrA, Pointer bsrSortedColIndA, int rowBlockDimA, int colBlockDimA, cusparseMatDescr descrC, Pointer bsrSortedValC, Pointer bsrSortedRowPtrC, Pointer bsrSortedColIndC, int rowBlockDimC, int colBlockDimC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZgebsr2gebsrNative(handle, dirA, mb, nb, nnzb, descrA, bsrSortedValA, bsrSortedRowPtrA, bsrSortedColIndA, rowBlockDimA, colBlockDimA, descrC, bsrSortedValC, bsrSortedRowPtrC, bsrSortedColIndC, rowBlockDimC, colBlockDimC, pBuffer));
    }

    private static native int cusparseZgebsr2gebsrNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10, cusparseMatDescr var11, Pointer var12, Pointer var13, Pointer var14, int var15, int var16, Pointer var17);

    public static int cusparseCreateIdentityPermutation(cusparseHandle handle, int n, Pointer p) {
        return JCusparse.checkResult(JCusparse.cusparseCreateIdentityPermutationNative(handle, n, p));
    }

    private static native int cusparseCreateIdentityPermutationNative(cusparseHandle var0, int var1, Pointer var2);

    public static int cusparseXcoosort_bufferSizeExt(cusparseHandle handle, int m, int n, int nnz, Pointer cooRowsA, Pointer cooColsA, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseXcoosort_bufferSizeExtNative(handle, m, n, nnz, cooRowsA, cooColsA, pBufferSizeInBytes));
    }

    private static native int cusparseXcoosort_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, long[] var6);

    public static int cusparseXcoosortByRow(cusparseHandle handle, int m, int n, int nnz, Pointer cooRowsA, Pointer cooColsA, Pointer P, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseXcoosortByRowNative(handle, m, n, nnz, cooRowsA, cooColsA, P, pBuffer));
    }

    private static native int cusparseXcoosortByRowNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7);

    public static int cusparseXcoosortByColumn(cusparseHandle handle, int m, int n, int nnz, Pointer cooRowsA, Pointer cooColsA, Pointer P, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseXcoosortByColumnNative(handle, m, n, nnz, cooRowsA, cooColsA, P, pBuffer));
    }

    private static native int cusparseXcoosortByColumnNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7);

    public static int cusparseXcsrsort_bufferSizeExt(cusparseHandle handle, int m, int n, int nnz, Pointer csrRowPtrA, Pointer csrColIndA, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseXcsrsort_bufferSizeExtNative(handle, m, n, nnz, csrRowPtrA, csrColIndA, pBufferSizeInBytes));
    }

    private static native int cusparseXcsrsort_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, long[] var6);

    public static int cusparseXcsrsort(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer P, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseXcsrsortNative(handle, m, n, nnz, descrA, csrRowPtrA, csrColIndA, P, pBuffer));
    }

    private static native int cusparseXcsrsortNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8);

    public static int cusparseXcscsort_bufferSizeExt(cusparseHandle handle, int m, int n, int nnz, Pointer cscColPtrA, Pointer cscRowIndA, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseXcscsort_bufferSizeExtNative(handle, m, n, nnz, cscColPtrA, cscRowIndA, pBufferSizeInBytes));
    }

    private static native int cusparseXcscsort_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, long[] var6);

    public static int cusparseXcscsort(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer cscColPtrA, Pointer cscRowIndA, Pointer P, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseXcscsortNative(handle, m, n, nnz, descrA, cscColPtrA, cscRowIndA, P, pBuffer));
    }

    private static native int cusparseXcscsortNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8);

    public static int cusparseScsru2csr_bufferSizeExt(cusparseHandle handle, int m, int n, int nnz, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseScsru2csr_bufferSizeExtNative(handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, info, pBufferSizeInBytes));
    }

    private static native int cusparseScsru2csr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, csru2csrInfo var7, long[] var8);

    public static int cusparseDcsru2csr_bufferSizeExt(cusparseHandle handle, int m, int n, int nnz, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDcsru2csr_bufferSizeExtNative(handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, info, pBufferSizeInBytes));
    }

    private static native int cusparseDcsru2csr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, csru2csrInfo var7, long[] var8);

    public static int cusparseCcsru2csr_bufferSizeExt(cusparseHandle handle, int m, int n, int nnz, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseCcsru2csr_bufferSizeExtNative(handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, info, pBufferSizeInBytes));
    }

    private static native int cusparseCcsru2csr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, csru2csrInfo var7, long[] var8);

    public static int cusparseZcsru2csr_bufferSizeExt(cusparseHandle handle, int m, int n, int nnz, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseZcsru2csr_bufferSizeExtNative(handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, info, pBufferSizeInBytes));
    }

    private static native int cusparseZcsru2csr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, csru2csrInfo var7, long[] var8);

    public static int cusparseScsru2csr(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsru2csrNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseScsru2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    public static int cusparseDcsru2csr(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsru2csrNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseDcsru2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    public static int cusparseCcsru2csr(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsru2csrNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseCcsru2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    public static int cusparseZcsru2csr(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsru2csrNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseZcsru2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    public static int cusparseScsr2csru(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2csruNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseScsr2csruNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    public static int cusparseDcsr2csru(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2csruNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseDcsr2csruNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    public static int cusparseCcsr2csru(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2csruNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseCcsr2csruNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    public static int cusparseZcsr2csru(cusparseHandle handle, int m, int n, int nnz, cusparseMatDescr descrA, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, csru2csrInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2csruNative(handle, m, n, nnz, descrA, csrVal, csrRowPtr, csrColInd, info, pBuffer));
    }

    private static native int cusparseZcsr2csruNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, csru2csrInfo var8, Pointer var9);

    public static int cusparseSpruneDense2csr_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer A, int lda, Pointer threshold, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSpruneDense2csr_bufferSizeExtNative(handle, m, n, A, lda, threshold, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBufferSizeInBytes));
    }

    private static native int cusparseSpruneDense2csr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, long[] var10);

    public static int cusparseDpruneDense2csr_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer A, int lda, Pointer threshold, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDpruneDense2csr_bufferSizeExtNative(handle, m, n, A, lda, threshold, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBufferSizeInBytes));
    }

    private static native int cusparseDpruneDense2csr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, long[] var10);

    public static int cusparseSpruneDense2csrNnz(cusparseHandle handle, int m, int n, Pointer A, int lda, Pointer threshold, cusparseMatDescr descrC, Pointer csrRowPtrC, Pointer nnzTotalDevHostPtr, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSpruneDense2csrNnzNative(handle, m, n, A, lda, threshold, descrC, csrRowPtrC, nnzTotalDevHostPtr, pBuffer));
    }

    private static native int cusparseSpruneDense2csrNnzNative(cusparseHandle var0, int var1, int var2, Pointer var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseDpruneDense2csrNnz(cusparseHandle handle, int m, int n, Pointer A, int lda, Pointer threshold, cusparseMatDescr descrC, Pointer csrSortedRowPtrC, Pointer nnzTotalDevHostPtr, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDpruneDense2csrNnzNative(handle, m, n, A, lda, threshold, descrC, csrSortedRowPtrC, nnzTotalDevHostPtr, pBuffer));
    }

    private static native int cusparseDpruneDense2csrNnzNative(cusparseHandle var0, int var1, int var2, Pointer var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseSpruneDense2csr(cusparseHandle handle, int m, int n, Pointer A, int lda, Pointer threshold, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSpruneDense2csrNative(handle, m, n, A, lda, threshold, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBuffer));
    }

    private static native int cusparseSpruneDense2csrNative(cusparseHandle var0, int var1, int var2, Pointer var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10);

    public static int cusparseDpruneDense2csr(cusparseHandle handle, int m, int n, Pointer A, int lda, Pointer threshold, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDpruneDense2csrNative(handle, m, n, A, lda, threshold, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBuffer));
    }

    private static native int cusparseDpruneDense2csrNative(cusparseHandle var0, int var1, int var2, Pointer var3, int var4, Pointer var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10);

    public static int cusparseSpruneCsr2csr_bufferSizeExt(cusparseHandle handle, int m, int n, int nnzA, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer threshold, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSpruneCsr2csr_bufferSizeExtNative(handle, m, n, nnzA, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, threshold, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBufferSizeInBytes));
    }

    private static native int cusparseSpruneCsr2csr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, long[] var13);

    public static int cusparseDpruneCsr2csr_bufferSizeExt(cusparseHandle handle, int m, int n, int nnzA, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer threshold, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDpruneCsr2csr_bufferSizeExtNative(handle, m, n, nnzA, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, threshold, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBufferSizeInBytes));
    }

    private static native int cusparseDpruneCsr2csr_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, long[] var13);

    public static int cusparseSpruneCsr2csrNnz(cusparseHandle handle, int m, int n, int nnzA, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer threshold, cusparseMatDescr descrC, Pointer csrSortedRowPtrC, Pointer nnzTotalDevHostPtr, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSpruneCsr2csrNnzNative(handle, m, n, nnzA, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, threshold, descrC, csrSortedRowPtrC, nnzTotalDevHostPtr, pBuffer));
    }

    private static native int cusparseSpruneCsr2csrNnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseDpruneCsr2csrNnz(cusparseHandle handle, int m, int n, int nnzA, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer threshold, cusparseMatDescr descrC, Pointer csrSortedRowPtrC, Pointer nnzTotalDevHostPtr, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDpruneCsr2csrNnzNative(handle, m, n, nnzA, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, threshold, descrC, csrSortedRowPtrC, nnzTotalDevHostPtr, pBuffer));
    }

    private static native int cusparseDpruneCsr2csrNnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12);

    public static int cusparseSpruneCsr2csr(cusparseHandle handle, int m, int n, int nnzA, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer threshold, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSpruneCsr2csrNative(handle, m, n, nnzA, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, threshold, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBuffer));
    }

    private static native int cusparseSpruneCsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13);

    public static int cusparseDpruneCsr2csr(cusparseHandle handle, int m, int n, int nnzA, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, Pointer threshold, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDpruneCsr2csrNative(handle, m, n, nnzA, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, threshold, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, pBuffer));
    }

    private static native int cusparseDpruneCsr2csrNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, Pointer var13);

    public static int cusparseSpruneDense2csrByPercentage_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer A, int lda, float percentage, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, pruneInfo info, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSpruneDense2csrByPercentage_bufferSizeExtNative(handle, m, n, A, lda, percentage, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBufferSizeInBytes));
    }

    private static native int cusparseSpruneDense2csrByPercentage_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, int var4, float var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, pruneInfo var10, long[] var11);

    public static int cusparseDpruneDense2csrByPercentage_bufferSizeExt(cusparseHandle handle, int m, int n, Pointer A, int lda, float percentage, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, pruneInfo info, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDpruneDense2csrByPercentage_bufferSizeExtNative(handle, m, n, A, lda, percentage, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBufferSizeInBytes));
    }

    private static native int cusparseDpruneDense2csrByPercentage_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, Pointer var3, int var4, float var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, pruneInfo var10, long[] var11);

    public static int cusparseSpruneDense2csrNnzByPercentage(cusparseHandle handle, int m, int n, Pointer A, int lda, float percentage, cusparseMatDescr descrC, Pointer csrRowPtrC, Pointer nnzTotalDevHostPtr, pruneInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSpruneDense2csrNnzByPercentageNative(handle, m, n, A, lda, percentage, descrC, csrRowPtrC, nnzTotalDevHostPtr, info, pBuffer));
    }

    private static native int cusparseSpruneDense2csrNnzByPercentageNative(cusparseHandle var0, int var1, int var2, Pointer var3, int var4, float var5, cusparseMatDescr var6, Pointer var7, Pointer var8, pruneInfo var9, Pointer var10);

    public static int cusparseDpruneDense2csrNnzByPercentage(cusparseHandle handle, int m, int n, Pointer A, int lda, float percentage, cusparseMatDescr descrC, Pointer csrRowPtrC, Pointer nnzTotalDevHostPtr, pruneInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDpruneDense2csrNnzByPercentageNative(handle, m, n, A, lda, percentage, descrC, csrRowPtrC, nnzTotalDevHostPtr, info, pBuffer));
    }

    private static native int cusparseDpruneDense2csrNnzByPercentageNative(cusparseHandle var0, int var1, int var2, Pointer var3, int var4, float var5, cusparseMatDescr var6, Pointer var7, Pointer var8, pruneInfo var9, Pointer var10);

    public static int cusparseSpruneDense2csrByPercentage(cusparseHandle handle, int m, int n, Pointer A, int lda, float percentage, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, pruneInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSpruneDense2csrByPercentageNative(handle, m, n, A, lda, percentage, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBuffer));
    }

    private static native int cusparseSpruneDense2csrByPercentageNative(cusparseHandle var0, int var1, int var2, Pointer var3, int var4, float var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, pruneInfo var10, Pointer var11);

    public static int cusparseDpruneDense2csrByPercentage(cusparseHandle handle, int m, int n, Pointer A, int lda, float percentage, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, pruneInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDpruneDense2csrByPercentageNative(handle, m, n, A, lda, percentage, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBuffer));
    }

    private static native int cusparseDpruneDense2csrByPercentageNative(cusparseHandle var0, int var1, int var2, Pointer var3, int var4, float var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, pruneInfo var10, Pointer var11);

    public static int cusparseSpruneCsr2csrByPercentage_bufferSizeExt(cusparseHandle handle, int m, int n, int nnzA, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, float percentage, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, pruneInfo info, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseSpruneCsr2csrByPercentage_bufferSizeExtNative(handle, m, n, nnzA, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, percentage, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBufferSizeInBytes));
    }

    private static native int cusparseSpruneCsr2csrByPercentage_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, float var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, pruneInfo var13, long[] var14);

    public static int cusparseDpruneCsr2csrByPercentage_bufferSizeExt(cusparseHandle handle, int m, int n, int nnzA, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, float percentage, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, pruneInfo info, long[] pBufferSizeInBytes) {
        return JCusparse.checkResult(JCusparse.cusparseDpruneCsr2csrByPercentage_bufferSizeExtNative(handle, m, n, nnzA, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, percentage, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBufferSizeInBytes));
    }

    private static native int cusparseDpruneCsr2csrByPercentage_bufferSizeExtNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, float var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, pruneInfo var13, long[] var14);

    public static int cusparseSpruneCsr2csrNnzByPercentage(cusparseHandle handle, int m, int n, int nnzA, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, float percentage, cusparseMatDescr descrC, Pointer csrSortedRowPtrC, Pointer nnzTotalDevHostPtr, pruneInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSpruneCsr2csrNnzByPercentageNative(handle, m, n, nnzA, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, percentage, descrC, csrSortedRowPtrC, nnzTotalDevHostPtr, info, pBuffer));
    }

    private static native int cusparseSpruneCsr2csrNnzByPercentageNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, float var8, cusparseMatDescr var9, Pointer var10, Pointer var11, pruneInfo var12, Pointer var13);

    public static int cusparseDpruneCsr2csrNnzByPercentage(cusparseHandle handle, int m, int n, int nnzA, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, float percentage, cusparseMatDescr descrC, Pointer csrSortedRowPtrC, Pointer nnzTotalDevHostPtr, pruneInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDpruneCsr2csrNnzByPercentageNative(handle, m, n, nnzA, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, percentage, descrC, csrSortedRowPtrC, nnzTotalDevHostPtr, info, pBuffer));
    }

    private static native int cusparseDpruneCsr2csrNnzByPercentageNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, float var8, cusparseMatDescr var9, Pointer var10, Pointer var11, pruneInfo var12, Pointer var13);

    public static int cusparseSpruneCsr2csrByPercentage(cusparseHandle handle, int m, int n, int nnzA, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, float percentage, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, pruneInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSpruneCsr2csrByPercentageNative(handle, m, n, nnzA, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, percentage, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBuffer));
    }

    private static native int cusparseSpruneCsr2csrByPercentageNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, float var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, pruneInfo var13, Pointer var14);

    public static int cusparseDpruneCsr2csrByPercentage(cusparseHandle handle, int m, int n, int nnzA, cusparseMatDescr descrA, Pointer csrSortedValA, Pointer csrSortedRowPtrA, Pointer csrSortedColIndA, float percentage, cusparseMatDescr descrC, Pointer csrSortedValC, Pointer csrSortedRowPtrC, Pointer csrSortedColIndC, pruneInfo info, Pointer pBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseDpruneCsr2csrByPercentageNative(handle, m, n, nnzA, descrA, csrSortedValA, csrSortedRowPtrA, csrSortedColIndA, percentage, descrC, csrSortedValC, csrSortedRowPtrC, csrSortedColIndC, info, pBuffer));
    }

    private static native int cusparseDpruneCsr2csrByPercentageNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, float var8, cusparseMatDescr var9, Pointer var10, Pointer var11, Pointer var12, pruneInfo var13, Pointer var14);

    public static int cusparseCsr2cscEx2(cusparseHandle handle, int m, int n, int nnz, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer cscVal, Pointer cscColPtr, Pointer cscRowInd, int valType, int copyValues, int idxBase, int alg, Pointer buffer) {
        return JCusparse.checkResult(JCusparse.cusparseCsr2cscEx2Native(handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, cscVal, cscColPtr, cscRowInd, valType, copyValues, idxBase, alg, buffer));
    }

    private static native int cusparseCsr2cscEx2Native(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10, int var11, int var12, int var13, Pointer var14);

    public static int cusparseCsr2cscEx2_bufferSize(cusparseHandle handle, int m, int n, int nnz, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer cscVal, Pointer cscColPtr, Pointer cscRowInd, int valType, int copyValues, int idxBase, int alg, long[] bufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseCsr2cscEx2_bufferSizeNative(handle, m, n, nnz, csrVal, csrRowPtr, csrColInd, cscVal, cscColPtr, cscRowInd, valType, copyValues, idxBase, alg, bufferSize));
    }

    private static native int cusparseCsr2cscEx2_bufferSizeNative(cusparseHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, int var10, int var11, int var12, int var13, long[] var14);

    public static int cusparseCreateSpVec(cusparseSpVecDescr spVecDescr, long size, long nnz, Pointer indices, Pointer values, int idxType, int idxBase, int valueType) {
        return JCusparse.checkResult(JCusparse.cusparseCreateSpVecNative(spVecDescr, size, nnz, indices, values, idxType, idxBase, valueType));
    }

    private static native int cusparseCreateSpVecNative(cusparseSpVecDescr var0, long var1, long var3, Pointer var5, Pointer var6, int var7, int var8, int var9);

    public static int cusparseDestroySpVec(cusparseSpVecDescr spVecDescr) {
        return JCusparse.checkResult(JCusparse.cusparseDestroySpVecNative(spVecDescr));
    }

    private static native int cusparseDestroySpVecNative(cusparseSpVecDescr var0);

    public static int cusparseSpVecGet(cusparseSpVecDescr spVecDescr, long[] size, long[] nnz, Pointer indices, Pointer values, int[] idxType, int[] idxBase, int[] valueType) {
        return JCusparse.checkResult(JCusparse.cusparseSpVecGetNative(spVecDescr, size, nnz, indices, values, idxType, idxBase, valueType));
    }

    private static native int cusparseSpVecGetNative(cusparseSpVecDescr var0, long[] var1, long[] var2, Pointer var3, Pointer var4, int[] var5, int[] var6, int[] var7);

    public static int cusparseSpVecGetIndexBase(cusparseSpVecDescr spVecDescr, int[] idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSpVecGetIndexBaseNative(spVecDescr, idxBase));
    }

    private static native int cusparseSpVecGetIndexBaseNative(cusparseSpVecDescr var0, int[] var1);

    public static int cusparseSpVecGetValues(cusparseSpVecDescr spVecDescr, Pointer values) {
        return JCusparse.checkResult(JCusparse.cusparseSpVecGetValuesNative(spVecDescr, values));
    }

    private static native int cusparseSpVecGetValuesNative(cusparseSpVecDescr var0, Pointer var1);

    public static int cusparseSpVecSetValues(cusparseSpVecDescr spVecDescr, Pointer values) {
        return JCusparse.checkResult(JCusparse.cusparseSpVecSetValuesNative(spVecDescr, values));
    }

    private static native int cusparseSpVecSetValuesNative(cusparseSpVecDescr var0, Pointer var1);

    public static int cusparseCreateDnVec(cusparseDnVecDescr dnVecDescr, long size, Pointer values, int valueType) {
        return JCusparse.checkResult(JCusparse.cusparseCreateDnVecNative(dnVecDescr, size, values, valueType));
    }

    private static native int cusparseCreateDnVecNative(cusparseDnVecDescr var0, long var1, Pointer var3, int var4);

    public static int cusparseDestroyDnVec(cusparseDnVecDescr dnVecDescr) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyDnVecNative(dnVecDescr));
    }

    private static native int cusparseDestroyDnVecNative(cusparseDnVecDescr var0);

    public static int cusparseDnVecGet(cusparseDnVecDescr dnVecDescr, long[] size, Pointer values, int[] valueType) {
        return JCusparse.checkResult(JCusparse.cusparseDnVecGetNative(dnVecDescr, size, values, valueType));
    }

    private static native int cusparseDnVecGetNative(cusparseDnVecDescr var0, long[] var1, Pointer var2, int[] var3);

    public static int cusparseDnVecGetValues(cusparseDnVecDescr dnVecDescr, Pointer values) {
        return JCusparse.checkResult(JCusparse.cusparseDnVecGetValuesNative(dnVecDescr, values));
    }

    private static native int cusparseDnVecGetValuesNative(cusparseDnVecDescr var0, Pointer var1);

    public static int cusparseDnVecSetValues(cusparseDnVecDescr dnVecDescr, Pointer values) {
        return JCusparse.checkResult(JCusparse.cusparseDnVecSetValuesNative(dnVecDescr, values));
    }

    private static native int cusparseDnVecSetValuesNative(cusparseDnVecDescr var0, Pointer var1);

    public static int cusparseDestroySpMat(cusparseSpMatDescr spMatDescr) {
        return JCusparse.checkResult(JCusparse.cusparseDestroySpMatNative(spMatDescr));
    }

    private static native int cusparseDestroySpMatNative(cusparseSpMatDescr var0);

    public static int cusparseSpMatGetFormat(cusparseSpMatDescr spMatDescr, int[] format) {
        return JCusparse.checkResult(JCusparse.cusparseSpMatGetFormatNative(spMatDescr, format));
    }

    private static native int cusparseSpMatGetFormatNative(cusparseSpMatDescr var0, int[] var1);

    public static int cusparseSpMatGetIndexBase(cusparseSpMatDescr spMatDescr, int[] idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSpMatGetIndexBaseNative(spMatDescr, idxBase));
    }

    private static native int cusparseSpMatGetIndexBaseNative(cusparseSpMatDescr var0, int[] var1);

    public static int cusparseSpMatGetValues(cusparseSpMatDescr spMatDescr, Pointer values) {
        return JCusparse.checkResult(JCusparse.cusparseSpMatGetValuesNative(spMatDescr, values));
    }

    private static native int cusparseSpMatGetValuesNative(cusparseSpMatDescr var0, Pointer var1);

    public static int cusparseSpMatSetValues(cusparseSpMatDescr spMatDescr, Pointer values) {
        return JCusparse.checkResult(JCusparse.cusparseSpMatSetValuesNative(spMatDescr, values));
    }

    private static native int cusparseSpMatSetValuesNative(cusparseSpMatDescr var0, Pointer var1);

    public static int cusparseSpMatGetSize(cusparseSpMatDescr spMatDescr, long[] rows, long[] cols, long[] nnz) {
        return JCusparse.checkResult(JCusparse.cusparseSpMatGetSizeNative(spMatDescr, rows, cols, nnz));
    }

    private static native int cusparseSpMatGetSizeNative(cusparseSpMatDescr var0, long[] var1, long[] var2, long[] var3);

    public static int cusparseSpMatSetStridedBatch(cusparseSpMatDescr spMatDescr, int batchCount) {
        return JCusparse.checkResult(JCusparse.cusparseSpMatSetStridedBatchNative(spMatDescr, batchCount));
    }

    private static native int cusparseSpMatSetStridedBatchNative(cusparseSpMatDescr var0, int var1);

    public static int cusparseSpMatGetStridedBatch(cusparseSpMatDescr spMatDescr, int[] batchCount) {
        return JCusparse.checkResult(JCusparse.cusparseSpMatGetStridedBatchNative(spMatDescr, batchCount));
    }

    private static native int cusparseSpMatGetStridedBatchNative(cusparseSpMatDescr var0, int[] var1);

    public static int cusparseCooSetStridedBatch(cusparseSpMatDescr spMatDescr, int batchCount, long batchStride) {
        return JCusparse.checkResult(JCusparse.cusparseCooSetStridedBatchNative(spMatDescr, batchCount, batchStride));
    }

    private static native int cusparseCooSetStridedBatchNative(cusparseSpMatDescr var0, int var1, long var2);

    public static int cusparseCsrSetStridedBatch(cusparseSpMatDescr spMatDescr, int batchCount, long offsetsBatchStride, long columnsValuesBatchStride) {
        return JCusparse.checkResult(JCusparse.cusparseCsrSetStridedBatchNative(spMatDescr, batchCount, offsetsBatchStride, columnsValuesBatchStride));
    }

    private static native int cusparseCsrSetStridedBatchNative(cusparseSpMatDescr var0, int var1, long var2, long var4);

    public static int cusparseCreateCsr(cusparseSpMatDescr spMatDescr, long rows, long cols, long nnz, Pointer csrRowOffsets, Pointer csrColInd, Pointer csrValues, int csrRowOffsetsType, int csrColIndType, int idxBase, int valueType) {
        return JCusparse.checkResult(JCusparse.cusparseCreateCsrNative(spMatDescr, rows, cols, nnz, csrRowOffsets, csrColInd, csrValues, csrRowOffsetsType, csrColIndType, idxBase, valueType));
    }

    private static native int cusparseCreateCsrNative(cusparseSpMatDescr var0, long var1, long var3, long var5, Pointer var7, Pointer var8, Pointer var9, int var10, int var11, int var12, int var13);

    public static int cusparseCreateCsc(cusparseSpMatDescr spMatDescr, long rows, long cols, long nnz, Pointer csrColOffsets, Pointer csrRowInd, Pointer csrValues, int csrColOffsetsType, int csrRowIndType, int idxBase, int valueType) {
        return JCusparse.checkResult(JCusparse.cusparseCreateCscNative(spMatDescr, rows, cols, nnz, csrColOffsets, csrRowInd, csrValues, csrColOffsetsType, csrRowIndType, idxBase, valueType));
    }

    private static native int cusparseCreateCscNative(cusparseSpMatDescr var0, long var1, long var3, long var5, Pointer var7, Pointer var8, Pointer var9, int var10, int var11, int var12, int var13);

    public static int cusparseCsrGet(cusparseSpMatDescr spMatDescr, long[] rows, long[] cols, long[] nnz, Pointer csrRowOffsets, Pointer csrColInd, Pointer csrValues, int[] csrRowOffsetsType, int[] csrColIndType, int[] idxBase, int[] valueType) {
        return JCusparse.checkResult(JCusparse.cusparseCsrGetNative(spMatDescr, rows, cols, nnz, csrRowOffsets, csrColInd, csrValues, csrRowOffsetsType, csrColIndType, idxBase, valueType));
    }

    private static native int cusparseCsrGetNative(cusparseSpMatDescr var0, long[] var1, long[] var2, long[] var3, Pointer var4, Pointer var5, Pointer var6, int[] var7, int[] var8, int[] var9, int[] var10);

    public static int cusparseCsrSetPointers(cusparseSpMatDescr spMatDescr, Pointer csrRowOffsets, Pointer csrColInd, Pointer csrValues) {
        return JCusparse.checkResult(JCusparse.cusparseCsrSetPointersNative(spMatDescr, csrRowOffsets, csrColInd, csrValues));
    }

    private static native int cusparseCsrSetPointersNative(cusparseSpMatDescr var0, Pointer var1, Pointer var2, Pointer var3);

    public static int cusparseCscSetPointers(cusparseSpMatDescr spMatDescr, Pointer cscColOffsets, Pointer cscRowInd, Pointer cscValues) {
        return JCusparse.checkResult(JCusparse.cusparseCscSetPointersNative(spMatDescr, cscColOffsets, cscRowInd, cscValues));
    }

    private static native int cusparseCscSetPointersNative(cusparseSpMatDescr var0, Pointer var1, Pointer var2, Pointer var3);

    public static int cusparseCreateCoo(cusparseSpMatDescr spMatDescr, long rows, long cols, long nnz, Pointer cooRowInd, Pointer cooColInd, Pointer cooValues, int cooIdxType, int idxBase, int valueType) {
        return JCusparse.checkResult(JCusparse.cusparseCreateCooNative(spMatDescr, rows, cols, nnz, cooRowInd, cooColInd, cooValues, cooIdxType, idxBase, valueType));
    }

    private static native int cusparseCreateCooNative(cusparseSpMatDescr var0, long var1, long var3, long var5, Pointer var7, Pointer var8, Pointer var9, int var10, int var11, int var12);

    public static int cusparseCreateCooAoS(cusparseSpMatDescr spMatDescr, long rows, long cols, long nnz, Pointer cooInd, Pointer cooValues, int cooIdxType, int idxBase, int valueType) {
        return JCusparse.checkResult(JCusparse.cusparseCreateCooAoSNative(spMatDescr, rows, cols, nnz, cooInd, cooValues, cooIdxType, idxBase, valueType));
    }

    private static native int cusparseCreateCooAoSNative(cusparseSpMatDescr var0, long var1, long var3, long var5, Pointer var7, Pointer var8, int var9, int var10, int var11);

    public static int cusparseCooGet(cusparseSpMatDescr spMatDescr, long[] rows, long[] cols, long[] nnz, Pointer cooRowInd, Pointer cooColInd, Pointer cooValues, int[] idxType, int[] idxBase, int[] valueType) {
        return JCusparse.checkResult(JCusparse.cusparseCooGetNative(spMatDescr, rows, cols, nnz, cooRowInd, cooColInd, cooValues, idxType, idxBase, valueType));
    }

    private static native int cusparseCooGetNative(cusparseSpMatDescr var0, long[] var1, long[] var2, long[] var3, Pointer var4, Pointer var5, Pointer var6, int[] var7, int[] var8, int[] var9);

    public static int cusparseCooAoSGet(cusparseSpMatDescr spMatDescr, long[] rows, long[] cols, long[] nnz, Pointer cooInd, Pointer cooValues, int[] idxType, int[] idxBase, int[] valueType) {
        return JCusparse.checkResult(JCusparse.cusparseCooAoSGetNative(spMatDescr, rows, cols, nnz, cooInd, cooValues, idxType, idxBase, valueType));
    }

    private static native int cusparseCooAoSGetNative(cusparseSpMatDescr var0, long[] var1, long[] var2, long[] var3, Pointer var4, Pointer var5, int[] var6, int[] var7, int[] var8);

    public static int cusparseCooSetPointers(cusparseSpMatDescr spMatDescr, Pointer cooRows, Pointer cooColumns, Pointer cooValues) {
        return JCusparse.checkResult(JCusparse.cusparseCooSetPointersNative(spMatDescr, cooRows, cooColumns, cooValues));
    }

    private static native int cusparseCooSetPointersNative(cusparseSpMatDescr var0, Pointer var1, Pointer var2, Pointer var3);

    public static int cusparseCreateDnMat(cusparseDnMatDescr dnMatDescr, long rows, long cols, long ld, Pointer values, int valueType, int order) {
        return JCusparse.checkResult(JCusparse.cusparseCreateDnMatNative(dnMatDescr, rows, cols, ld, values, valueType, order));
    }

    private static native int cusparseCreateDnMatNative(cusparseDnMatDescr var0, long var1, long var3, long var5, Pointer var7, int var8, int var9);

    public static int cusparseDestroyDnMat(cusparseDnMatDescr dnMatDescr) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyDnMatNative(dnMatDescr));
    }

    private static native int cusparseDestroyDnMatNative(cusparseDnMatDescr var0);

    public static int cusparseDnMatGet(cusparseDnMatDescr dnMatDescr, long[] rows, long[] cols, long[] ld, Pointer values, int[] type, int[] order) {
        return JCusparse.checkResult(JCusparse.cusparseDnMatGetNative(dnMatDescr, rows, cols, ld, values, type, order));
    }

    private static native int cusparseDnMatGetNative(cusparseDnMatDescr var0, long[] var1, long[] var2, long[] var3, Pointer var4, int[] var5, int[] var6);

    public static int cusparseDnMatGetValues(cusparseDnMatDescr dnMatDescr, Pointer values) {
        return JCusparse.checkResult(JCusparse.cusparseDnMatGetValuesNative(dnMatDescr, values));
    }

    private static native int cusparseDnMatGetValuesNative(cusparseDnMatDescr var0, Pointer var1);

    public static int cusparseDnMatSetValues(cusparseDnMatDescr dnMatDescr, Pointer values) {
        return JCusparse.checkResult(JCusparse.cusparseDnMatSetValuesNative(dnMatDescr, values));
    }

    private static native int cusparseDnMatSetValuesNative(cusparseDnMatDescr var0, Pointer var1);

    public static int cusparseDnMatSetStridedBatch(cusparseDnMatDescr dnMatDescr, int batchCount, long batchStride) {
        return JCusparse.checkResult(JCusparse.cusparseDnMatSetStridedBatchNative(dnMatDescr, batchCount, batchStride));
    }

    private static native int cusparseDnMatSetStridedBatchNative(cusparseDnMatDescr var0, int var1, long var2);

    public static int cusparseDnMatGetStridedBatch(cusparseDnMatDescr dnMatDescr, int[] batchCount, long[] batchStride) {
        return JCusparse.checkResult(JCusparse.cusparseDnMatGetStridedBatchNative(dnMatDescr, batchCount, batchStride));
    }

    private static native int cusparseDnMatGetStridedBatchNative(cusparseDnMatDescr var0, int[] var1, long[] var2);

    public static int cusparseAxpby(cusparseHandle handle, Pointer alpha, cusparseSpVecDescr vecX, Pointer beta, cusparseDnVecDescr vecY) {
        return JCusparse.checkResult(JCusparse.cusparseAxpbyNative(handle, alpha, vecX, beta, vecY));
    }

    private static native int cusparseAxpbyNative(cusparseHandle var0, Pointer var1, cusparseSpVecDescr var2, Pointer var3, cusparseDnVecDescr var4);

    public static int cusparseGather(cusparseHandle handle, cusparseDnVecDescr vecY, cusparseSpVecDescr vecX) {
        return JCusparse.checkResult(JCusparse.cusparseGatherNative(handle, vecY, vecX));
    }

    private static native int cusparseGatherNative(cusparseHandle var0, cusparseDnVecDescr var1, cusparseSpVecDescr var2);

    public static int cusparseScatter(cusparseHandle handle, cusparseSpVecDescr vecX, cusparseDnVecDescr vecY) {
        return JCusparse.checkResult(JCusparse.cusparseScatterNative(handle, vecX, vecY));
    }

    private static native int cusparseScatterNative(cusparseHandle var0, cusparseSpVecDescr var1, cusparseDnVecDescr var2);

    public static int cusparseRot(cusparseHandle handle, Pointer c_coeff, Pointer s_coeff, cusparseSpVecDescr vecX, cusparseDnVecDescr vecY) {
        return JCusparse.checkResult(JCusparse.cusparseRotNative(handle, c_coeff, s_coeff, vecX, vecY));
    }

    private static native int cusparseRotNative(cusparseHandle var0, Pointer var1, Pointer var2, cusparseSpVecDescr var3, cusparseDnVecDescr var4);

    public static int cusparseSpVV_bufferSize(cusparseHandle handle, int opX, cusparseSpVecDescr vecX, cusparseDnVecDescr vecY, Pointer result, int computeType, long[] bufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseSpVV_bufferSizeNative(handle, opX, vecX, vecY, result, computeType, bufferSize));
    }

    private static native int cusparseSpVV_bufferSizeNative(cusparseHandle var0, int var1, cusparseSpVecDescr var2, cusparseDnVecDescr var3, Pointer var4, int var5, long[] var6);

    public static int cusparseSpVV(cusparseHandle handle, int opX, cusparseSpVecDescr vecX, cusparseDnVecDescr vecY, Pointer result, int computeType, Pointer externalBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSpVVNative(handle, opX, vecX, vecY, result, computeType, externalBuffer));
    }

    private static native int cusparseSpVVNative(cusparseHandle var0, int var1, cusparseSpVecDescr var2, cusparseDnVecDescr var3, Pointer var4, int var5, Pointer var6);

    public static int cusparseSparseToDense_bufferSize(cusparseHandle handle, cusparseSpMatDescr matA, cusparseDnMatDescr matB, int alg, long[] bufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseSparseToDense_bufferSizeNative(handle, matA, matB, alg, bufferSize));
    }

    private static native int cusparseSparseToDense_bufferSizeNative(cusparseHandle var0, cusparseSpMatDescr var1, cusparseDnMatDescr var2, int var3, long[] var4);

    public static int cusparseSparseToDense(cusparseHandle handle, cusparseSpMatDescr matA, cusparseDnMatDescr matB, int alg, Pointer buffer) {
        return JCusparse.checkResult(JCusparse.cusparseSparseToDenseNative(handle, matA, matB, alg, buffer));
    }

    private static native int cusparseSparseToDenseNative(cusparseHandle var0, cusparseSpMatDescr var1, cusparseDnMatDescr var2, int var3, Pointer var4);

    public static int cusparseDenseToSparse_bufferSize(cusparseHandle handle, cusparseDnMatDescr matA, cusparseSpMatDescr matB, int alg, long[] bufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseDenseToSparse_bufferSizeNative(handle, matA, matB, alg, bufferSize));
    }

    private static native int cusparseDenseToSparse_bufferSizeNative(cusparseHandle var0, cusparseDnMatDescr var1, cusparseSpMatDescr var2, int var3, long[] var4);

    public static int cusparseDenseToSparse_analysis(cusparseHandle handle, cusparseDnMatDescr matA, cusparseSpMatDescr matB, int alg, Pointer buffer) {
        return JCusparse.checkResult(JCusparse.cusparseDenseToSparse_analysisNative(handle, matA, matB, alg, buffer));
    }

    private static native int cusparseDenseToSparse_analysisNative(cusparseHandle var0, cusparseDnMatDescr var1, cusparseSpMatDescr var2, int var3, Pointer var4);

    public static int cusparseDenseToSparse_convert(cusparseHandle handle, cusparseDnMatDescr matA, cusparseSpMatDescr matB, int alg, Pointer buffer) {
        return JCusparse.checkResult(JCusparse.cusparseDenseToSparse_convertNative(handle, matA, matB, alg, buffer));
    }

    private static native int cusparseDenseToSparse_convertNative(cusparseHandle var0, cusparseDnMatDescr var1, cusparseSpMatDescr var2, int var3, Pointer var4);

    public static int cusparseSpMV(cusparseHandle handle, int opA, Pointer alpha, cusparseSpMatDescr matA, cusparseDnVecDescr vecX, Pointer beta, cusparseDnVecDescr vecY, int computeType, int alg, Pointer externalBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSpMVNative(handle, opA, alpha, matA, vecX, beta, vecY, computeType, alg, externalBuffer));
    }

    private static native int cusparseSpMVNative(cusparseHandle var0, int var1, Pointer var2, cusparseSpMatDescr var3, cusparseDnVecDescr var4, Pointer var5, cusparseDnVecDescr var6, int var7, int var8, Pointer var9);

    public static int cusparseSpMV_bufferSize(cusparseHandle handle, int opA, Pointer alpha, cusparseSpMatDescr matA, cusparseDnVecDescr vecX, Pointer beta, cusparseDnVecDescr vecY, int computeType, int alg, long[] bufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseSpMV_bufferSizeNative(handle, opA, alpha, matA, vecX, beta, vecY, computeType, alg, bufferSize));
    }

    private static native int cusparseSpMV_bufferSizeNative(cusparseHandle var0, int var1, Pointer var2, cusparseSpMatDescr var3, cusparseDnVecDescr var4, Pointer var5, cusparseDnVecDescr var6, int var7, int var8, long[] var9);

    public static int cusparseSpMM(cusparseHandle handle, int opA, int opB, Pointer alpha, cusparseSpMatDescr matA, cusparseDnMatDescr matB, Pointer beta, cusparseDnMatDescr matC, int computeType, int alg, Pointer externalBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseSpMMNative(handle, opA, opB, alpha, matA, matB, beta, matC, computeType, alg, externalBuffer));
    }

    private static native int cusparseSpMMNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseSpMatDescr var4, cusparseDnMatDescr var5, Pointer var6, cusparseDnMatDescr var7, int var8, int var9, Pointer var10);

    public static int cusparseSpMM_bufferSize(cusparseHandle handle, int opA, int opB, Pointer alpha, cusparseSpMatDescr matA, cusparseDnMatDescr matB, Pointer beta, cusparseDnMatDescr matC, int computeType, int alg, long[] bufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseSpMM_bufferSizeNative(handle, opA, opB, alpha, matA, matB, beta, matC, computeType, alg, bufferSize));
    }

    private static native int cusparseSpMM_bufferSizeNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseSpMatDescr var4, cusparseDnMatDescr var5, Pointer var6, cusparseDnMatDescr var7, int var8, int var9, long[] var10);

    public static int cusparseSpGEMM_createDescr(cusparseSpGEMMDescr descr) {
        return JCusparse.checkResult(JCusparse.cusparseSpGEMM_createDescrNative(descr));
    }

    private static native int cusparseSpGEMM_createDescrNative(cusparseSpGEMMDescr var0);

    public static int cusparseSpGEMM_destroyDescr(cusparseSpGEMMDescr descr) {
        return JCusparse.checkResult(JCusparse.cusparseSpGEMM_destroyDescrNative(descr));
    }

    private static native int cusparseSpGEMM_destroyDescrNative(cusparseSpGEMMDescr var0);

    public static int cusparseSpGEMM_workEstimation(cusparseHandle handle, int opA, int opB, Pointer alpha, cusparseSpMatDescr matA, cusparseSpMatDescr matB, Pointer beta, cusparseSpMatDescr matC, int computeType, int alg, cusparseSpGEMMDescr spgemmDescr, long[] bufferSize1, Pointer externalBuffer1) {
        return JCusparse.checkResult(JCusparse.cusparseSpGEMM_workEstimationNative(handle, opA, opB, alpha, matA, matB, beta, matC, computeType, alg, spgemmDescr, bufferSize1, externalBuffer1));
    }

    private static native int cusparseSpGEMM_workEstimationNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseSpMatDescr var4, cusparseSpMatDescr var5, Pointer var6, cusparseSpMatDescr var7, int var8, int var9, cusparseSpGEMMDescr var10, long[] var11, Pointer var12);

    public static int cusparseSpGEMM_compute(cusparseHandle handle, int opA, int opB, Pointer alpha, cusparseSpMatDescr matA, cusparseSpMatDescr matB, Pointer beta, cusparseSpMatDescr matC, int computeType, int alg, cusparseSpGEMMDescr spgemmDescr, long[] bufferSize2, Pointer externalBuffer2) {
        return JCusparse.checkResult(JCusparse.cusparseSpGEMM_computeNative(handle, opA, opB, alpha, matA, matB, beta, matC, computeType, alg, spgemmDescr, bufferSize2, externalBuffer2));
    }

    private static native int cusparseSpGEMM_computeNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseSpMatDescr var4, cusparseSpMatDescr var5, Pointer var6, cusparseSpMatDescr var7, int var8, int var9, cusparseSpGEMMDescr var10, long[] var11, Pointer var12);

    public static int cusparseSpGEMM_copy(cusparseHandle handle, int opA, int opB, Pointer alpha, cusparseSpMatDescr matA, cusparseSpMatDescr matB, Pointer beta, cusparseSpMatDescr matC, int computeType, int alg, cusparseSpGEMMDescr spgemmDescr) {
        return JCusparse.checkResult(JCusparse.cusparseSpGEMM_copyNative(handle, opA, opB, alpha, matA, matB, beta, matC, computeType, alg, spgemmDescr));
    }

    private static native int cusparseSpGEMM_copyNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseSpMatDescr var4, cusparseSpMatDescr var5, Pointer var6, cusparseSpMatDescr var7, int var8, int var9, cusparseSpGEMMDescr var10);

    public static int cusparseConstrainedGeMM(cusparseHandle handle, int opA, int opB, Pointer alpha, cusparseDnMatDescr matA, cusparseDnMatDescr matB, Pointer beta, cusparseSpMatDescr matC, int computeType, Pointer externalBuffer) {
        return JCusparse.checkResult(JCusparse.cusparseConstrainedGeMMNative(handle, opA, opB, alpha, matA, matB, beta, matC, computeType, externalBuffer));
    }

    private static native int cusparseConstrainedGeMMNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseDnMatDescr var4, cusparseDnMatDescr var5, Pointer var6, cusparseSpMatDescr var7, int var8, Pointer var9);

    public static int cusparseConstrainedGeMM_bufferSize(cusparseHandle handle, int opA, int opB, Pointer alpha, cusparseDnMatDescr matA, cusparseDnMatDescr matB, Pointer beta, cusparseSpMatDescr matC, int computeType, long[] bufferSize) {
        return JCusparse.checkResult(JCusparse.cusparseConstrainedGeMM_bufferSizeNative(handle, opA, opB, alpha, matA, matB, beta, matC, computeType, bufferSize));
    }

    private static native int cusparseConstrainedGeMM_bufferSizeNative(cusparseHandle var0, int var1, int var2, Pointer var3, cusparseDnMatDescr var4, cusparseDnMatDescr var5, Pointer var6, cusparseSpMatDescr var7, int var8, long[] var9);

    static {
        JCusparse.initialize();
    }
}

