/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jnvgraph;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.jnvgraph.SpectralClusteringParameter;
import jcuda.jnvgraph.nvgraphGraphDescr;
import jcuda.jnvgraph.nvgraphHandle;
import jcuda.jnvgraph.nvgraphStatus;
import jcuda.jnvgraph.nvgraphTraversalParameter;
import jcuda.runtime.JCuda;

public class JNvgraph {
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    private JNvgraph() {
    }

    public static void initialize() {
        if (!initialized) {
            String libraryBaseName = "JNvgraph-" + JCuda.getJCudaVersion();
            String libraryName = LibUtils.createPlatformLibraryName((String)libraryBaseName);
            LibUtils.loadLibrary((String)libraryName, (String[])new String[0]);
            initialized = true;
        }
    }

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(nvgraphStatus.stringFor(result));
        }
        return result;
    }

    public static void setLogLevel(LogLevel logLevel) {
        JNvgraph.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    public static String nvgraphStatusGetString(int status) {
        return JNvgraph.nvgraphStatusGetStringNative(status);
    }

    private static native String nvgraphStatusGetStringNative(int var0);

    public static int nvgraphGetProperty(int type, int[] value) {
        return JNvgraph.checkResult(JNvgraph.nvgraphGetPropertyNative(type, value));
    }

    private static native int nvgraphGetPropertyNative(int var0, int[] var1);

    public static int nvgraphCreate(nvgraphHandle handle) {
        return JNvgraph.checkResult(JNvgraph.nvgraphCreateNative(handle));
    }

    private static native int nvgraphCreateNative(nvgraphHandle var0);

    public static int nvgraphDestroy(nvgraphHandle handle) {
        return JNvgraph.checkResult(JNvgraph.nvgraphDestroyNative(handle));
    }

    private static native int nvgraphDestroyNative(nvgraphHandle var0);

    public static int nvgraphCreateGraphDescr(nvgraphHandle handle, nvgraphGraphDescr descrG) {
        return JNvgraph.checkResult(JNvgraph.nvgraphCreateGraphDescrNative(handle, descrG));
    }

    private static native int nvgraphCreateGraphDescrNative(nvgraphHandle var0, nvgraphGraphDescr var1);

    public static int nvgraphDestroyGraphDescr(nvgraphHandle handle, nvgraphGraphDescr descrG) {
        return JNvgraph.checkResult(JNvgraph.nvgraphDestroyGraphDescrNative(handle, descrG));
    }

    private static native int nvgraphDestroyGraphDescrNative(nvgraphHandle var0, nvgraphGraphDescr var1);

    public static int nvgraphSetGraphStructure(nvgraphHandle handle, nvgraphGraphDescr descrG, Object topologyData, int TType) {
        return JNvgraph.checkResult(JNvgraph.nvgraphSetGraphStructureNative(handle, descrG, topologyData, TType));
    }

    private static native int nvgraphSetGraphStructureNative(nvgraphHandle var0, nvgraphGraphDescr var1, Object var2, int var3);

    public static int nvgraphGetGraphStructure(nvgraphHandle handle, nvgraphGraphDescr descrG, Object topologyData, int[] TType) {
        return JNvgraph.checkResult(JNvgraph.nvgraphGetGraphStructureNative(handle, descrG, topologyData, TType));
    }

    private static native int nvgraphGetGraphStructureNative(nvgraphHandle var0, nvgraphGraphDescr var1, Object var2, int[] var3);

    public static int nvgraphAllocateVertexData(nvgraphHandle handle, nvgraphGraphDescr descrG, long numsets, Pointer settypes) {
        return JNvgraph.checkResult(JNvgraph.nvgraphAllocateVertexDataNative(handle, descrG, numsets, settypes));
    }

    private static native int nvgraphAllocateVertexDataNative(nvgraphHandle var0, nvgraphGraphDescr var1, long var2, Pointer var4);

    public static int nvgraphAllocateEdgeData(nvgraphHandle handle, nvgraphGraphDescr descrG, long numsets, Pointer settypes) {
        return JNvgraph.checkResult(JNvgraph.nvgraphAllocateEdgeDataNative(handle, descrG, numsets, settypes));
    }

    private static native int nvgraphAllocateEdgeDataNative(nvgraphHandle var0, nvgraphGraphDescr var1, long var2, Pointer var4);

    public static int nvgraphSetVertexData(nvgraphHandle handle, nvgraphGraphDescr descrG, Pointer vertexData, long setnum) {
        return JNvgraph.checkResult(JNvgraph.nvgraphSetVertexDataNative(handle, descrG, vertexData, setnum));
    }

    private static native int nvgraphSetVertexDataNative(nvgraphHandle var0, nvgraphGraphDescr var1, Pointer var2, long var3);

    public static int nvgraphGetVertexData(nvgraphHandle handle, nvgraphGraphDescr descrG, Pointer vertexData, long setnum) {
        return JNvgraph.checkResult(JNvgraph.nvgraphGetVertexDataNative(handle, descrG, vertexData, setnum));
    }

    private static native int nvgraphGetVertexDataNative(nvgraphHandle var0, nvgraphGraphDescr var1, Pointer var2, long var3);

    public static int nvgraphConvertTopology(nvgraphHandle handle, int srcTType, Object srcTopology, Pointer srcEdgeData, Pointer dataType, int dstTType, Object dstTopology, Pointer dstEdgeData) {
        return JNvgraph.checkResult(JNvgraph.nvgraphConvertTopologyNative(handle, srcTType, srcTopology, srcEdgeData, dataType, dstTType, dstTopology, dstEdgeData));
    }

    private static native int nvgraphConvertTopologyNative(nvgraphHandle var0, int var1, Object var2, Pointer var3, Pointer var4, int var5, Object var6, Pointer var7);

    public static int nvgraphConvertGraph(nvgraphHandle handle, nvgraphGraphDescr srcDescrG, nvgraphGraphDescr dstDescrG, int dstTType) {
        return JNvgraph.checkResult(JNvgraph.nvgraphConvertGraphNative(handle, srcDescrG, dstDescrG, dstTType));
    }

    private static native int nvgraphConvertGraphNative(nvgraphHandle var0, nvgraphGraphDescr var1, nvgraphGraphDescr var2, int var3);

    public static int nvgraphSetEdgeData(nvgraphHandle handle, nvgraphGraphDescr descrG, Pointer edgeData, long setnum) {
        return JNvgraph.checkResult(JNvgraph.nvgraphSetEdgeDataNative(handle, descrG, edgeData, setnum));
    }

    private static native int nvgraphSetEdgeDataNative(nvgraphHandle var0, nvgraphGraphDescr var1, Pointer var2, long var3);

    public static int nvgraphGetEdgeData(nvgraphHandle handle, nvgraphGraphDescr descrG, Pointer edgeData, long setnum) {
        return JNvgraph.checkResult(JNvgraph.nvgraphGetEdgeDataNative(handle, descrG, edgeData, setnum));
    }

    private static native int nvgraphGetEdgeDataNative(nvgraphHandle var0, nvgraphGraphDescr var1, Pointer var2, long var3);

    public static int nvgraphExtractSubgraphByVertex(nvgraphHandle handle, nvgraphGraphDescr descrG, nvgraphGraphDescr subdescrG, Pointer subvertices, long numvertices) {
        return JNvgraph.checkResult(JNvgraph.nvgraphExtractSubgraphByVertexNative(handle, descrG, subdescrG, subvertices, numvertices));
    }

    private static native int nvgraphExtractSubgraphByVertexNative(nvgraphHandle var0, nvgraphGraphDescr var1, nvgraphGraphDescr var2, Pointer var3, long var4);

    public static int nvgraphExtractSubgraphByEdge(nvgraphHandle handle, nvgraphGraphDescr descrG, nvgraphGraphDescr subdescrG, Pointer subedges, long numedges) {
        return JNvgraph.checkResult(JNvgraph.nvgraphExtractSubgraphByEdgeNative(handle, descrG, subdescrG, subedges, numedges));
    }

    private static native int nvgraphExtractSubgraphByEdgeNative(nvgraphHandle var0, nvgraphGraphDescr var1, nvgraphGraphDescr var2, Pointer var3, long var4);

    public static int nvgraphSrSpmv(nvgraphHandle handle, nvgraphGraphDescr descrG, long weight_index, Pointer alpha, long x_index, Pointer beta, long y_index, int SR) {
        return JNvgraph.checkResult(JNvgraph.nvgraphSrSpmvNative(handle, descrG, weight_index, alpha, x_index, beta, y_index, SR));
    }

    private static native int nvgraphSrSpmvNative(nvgraphHandle var0, nvgraphGraphDescr var1, long var2, Pointer var4, long var5, Pointer var7, long var8, int var10);

    public static int nvgraphTraversalParameterInit(nvgraphTraversalParameter param) {
        return JNvgraph.checkResult(JNvgraph.nvgraphTraversalParameterInitNative(param));
    }

    private static native int nvgraphTraversalParameterInitNative(nvgraphTraversalParameter var0);

    public static int nvgraphTraversalSetDistancesIndex(nvgraphTraversalParameter param, long value) {
        return JNvgraph.checkResult(JNvgraph.nvgraphTraversalSetDistancesIndexNative(param, value));
    }

    private static native int nvgraphTraversalSetDistancesIndexNative(nvgraphTraversalParameter var0, long var1);

    public static int nvgraphTraversalGetDistancesIndex(nvgraphTraversalParameter param, long[] value) {
        return JNvgraph.checkResult(JNvgraph.nvgraphTraversalGetDistancesIndexNative(param, value));
    }

    private static native int nvgraphTraversalGetDistancesIndexNative(nvgraphTraversalParameter var0, long[] var1);

    public static int nvgraphTraversalSetPredecessorsIndex(nvgraphTraversalParameter param, long value) {
        return JNvgraph.checkResult(JNvgraph.nvgraphTraversalSetPredecessorsIndexNative(param, value));
    }

    private static native int nvgraphTraversalSetPredecessorsIndexNative(nvgraphTraversalParameter var0, long var1);

    public static int nvgraphTraversalGetPredecessorsIndex(nvgraphTraversalParameter param, long[] value) {
        return JNvgraph.checkResult(JNvgraph.nvgraphTraversalGetPredecessorsIndexNative(param, value));
    }

    private static native int nvgraphTraversalGetPredecessorsIndexNative(nvgraphTraversalParameter var0, long[] var1);

    public static int nvgraphTraversalSetEdgeMaskIndex(nvgraphTraversalParameter param, long value) {
        return JNvgraph.checkResult(JNvgraph.nvgraphTraversalSetEdgeMaskIndexNative(param, value));
    }

    private static native int nvgraphTraversalSetEdgeMaskIndexNative(nvgraphTraversalParameter var0, long var1);

    public static int nvgraphTraversalGetEdgeMaskIndex(nvgraphTraversalParameter param, long[] value) {
        return JNvgraph.checkResult(JNvgraph.nvgraphTraversalGetEdgeMaskIndexNative(param, value));
    }

    private static native int nvgraphTraversalGetEdgeMaskIndexNative(nvgraphTraversalParameter var0, long[] var1);

    public static int nvgraphTraversalSetUndirectedFlag(nvgraphTraversalParameter param, long value) {
        return JNvgraph.checkResult(JNvgraph.nvgraphTraversalSetUndirectedFlagNative(param, value));
    }

    private static native int nvgraphTraversalSetUndirectedFlagNative(nvgraphTraversalParameter var0, long var1);

    public static int nvgraphTraversalGetUndirectedFlag(nvgraphTraversalParameter param, long[] value) {
        return JNvgraph.checkResult(JNvgraph.nvgraphTraversalGetUndirectedFlagNative(param, value));
    }

    private static native int nvgraphTraversalGetUndirectedFlagNative(nvgraphTraversalParameter var0, long[] var1);

    public static int nvgraphTraversalSetAlpha(nvgraphTraversalParameter param, long value) {
        return JNvgraph.checkResult(JNvgraph.nvgraphTraversalSetAlphaNative(param, value));
    }

    private static native int nvgraphTraversalSetAlphaNative(nvgraphTraversalParameter var0, long var1);

    public static int nvgraphTraversalGetAlpha(nvgraphTraversalParameter param, long[] value) {
        return JNvgraph.checkResult(JNvgraph.nvgraphTraversalGetAlphaNative(param, value));
    }

    private static native int nvgraphTraversalGetAlphaNative(nvgraphTraversalParameter var0, long[] var1);

    public static int nvgraphTraversalSetBeta(nvgraphTraversalParameter param, long value) {
        return JNvgraph.checkResult(JNvgraph.nvgraphTraversalSetBetaNative(param, value));
    }

    private static native int nvgraphTraversalSetBetaNative(nvgraphTraversalParameter var0, long var1);

    public static int nvgraphTraversalGetBeta(nvgraphTraversalParameter param, long[] value) {
        return JNvgraph.checkResult(JNvgraph.nvgraphTraversalGetBetaNative(param, value));
    }

    private static native int nvgraphTraversalGetBetaNative(nvgraphTraversalParameter var0, long[] var1);

    public static int nvgraphTraversal(nvgraphHandle handle, nvgraphGraphDescr descrG, int traversalT, Pointer source_vert, nvgraphTraversalParameter params) {
        return JNvgraph.checkResult(JNvgraph.nvgraphTraversalNative(handle, descrG, traversalT, source_vert, params));
    }

    private static native int nvgraphTraversalNative(nvgraphHandle var0, nvgraphGraphDescr var1, int var2, Pointer var3, nvgraphTraversalParameter var4);

    public static int nvgraphSssp(nvgraphHandle handle, nvgraphGraphDescr descrG, long weight_index, Pointer source_vert, long sssp_index) {
        return JNvgraph.checkResult(JNvgraph.nvgraphSsspNative(handle, descrG, weight_index, source_vert, sssp_index));
    }

    private static native int nvgraphSsspNative(nvgraphHandle var0, nvgraphGraphDescr var1, long var2, Pointer var4, long var5);

    public static int nvgraphWidestPath(nvgraphHandle handle, nvgraphGraphDescr descrG, long weight_index, Pointer source_vert, long widest_path_index) {
        return JNvgraph.checkResult(JNvgraph.nvgraphWidestPathNative(handle, descrG, weight_index, source_vert, widest_path_index));
    }

    private static native int nvgraphWidestPathNative(nvgraphHandle var0, nvgraphGraphDescr var1, long var2, Pointer var4, long var5);

    public static int nvgraphPagerank(nvgraphHandle handle, nvgraphGraphDescr descrG, long weight_index, Pointer alpha, long bookmark_index, int has_guess, long pagerank_index, float tolerance, int max_iter) {
        return JNvgraph.checkResult(JNvgraph.nvgraphPagerankNative(handle, descrG, weight_index, alpha, bookmark_index, has_guess, pagerank_index, tolerance, max_iter));
    }

    private static native int nvgraphPagerankNative(nvgraphHandle var0, nvgraphGraphDescr var1, long var2, Pointer var4, long var5, int var7, long var8, float var10, int var11);

    public static int nvgraphContractGraph(nvgraphHandle handle, nvgraphGraphDescr descrG, nvgraphGraphDescr contrdescrG, Pointer aggregates, long numaggregates, int VertexCombineOp, int VertexReduceOp, int EdgeCombineOp, int EdgeReduceOp, int flag) {
        return JNvgraph.checkResult(JNvgraph.nvgraphContractGraphNative(handle, descrG, contrdescrG, aggregates, numaggregates, VertexCombineOp, VertexReduceOp, EdgeCombineOp, EdgeReduceOp, flag));
    }

    private static native int nvgraphContractGraphNative(nvgraphHandle var0, nvgraphGraphDescr var1, nvgraphGraphDescr var2, Pointer var3, long var4, int var6, int var7, int var8, int var9, int var10);

    public static int nvgraphSpectralClustering(nvgraphHandle handle, nvgraphGraphDescr graph_descr, long weight_index, SpectralClusteringParameter params, Pointer clustering, Pointer eig_vals, Pointer eig_vects) {
        return JNvgraph.checkResult(JNvgraph.nvgraphSpectralClusteringNative(handle, graph_descr, weight_index, params, clustering, eig_vals, eig_vects));
    }

    private static native int nvgraphSpectralClusteringNative(nvgraphHandle var0, nvgraphGraphDescr var1, long var2, SpectralClusteringParameter var4, Pointer var5, Pointer var6, Pointer var7);

    public static int nvgraphAnalyzeClustering(nvgraphHandle handle, nvgraphGraphDescr graph_descr, long weight_index, int n_clusters, Pointer clustering, int metric, Pointer score) {
        return JNvgraph.checkResult(JNvgraph.nvgraphAnalyzeClusteringNative(handle, graph_descr, weight_index, n_clusters, clustering, metric, score));
    }

    private static native int nvgraphAnalyzeClusteringNative(nvgraphHandle var0, nvgraphGraphDescr var1, long var2, int var4, Pointer var5, int var6, Pointer var7);

    public static int nvgraphTriangleCount(nvgraphHandle handle, nvgraphGraphDescr graph_descr, long[] result) {
        return JNvgraph.checkResult(JNvgraph.nvgraphTriangleCountNative(handle, graph_descr, result));
    }

    private static native int nvgraphTriangleCountNative(nvgraphHandle var0, nvgraphGraphDescr var1, long[] var2);

    static {
        JNvgraph.initialize();
    }
}

