/*
 * Decompiled with CFR 0.152.
 */
package org.jddd.archunit;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.thirdparty.com.google.common.base.Supplier;
import com.tngtech.archunit.thirdparty.com.google.common.base.Suppliers;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class FormatableJavaClass {
    private static final Map<JavaClass, FormatableJavaClass> CACHE = new ConcurrentHashMap<JavaClass, FormatableJavaClass>();
    private final JavaClass type;
    private final Supplier<String> abbreviatedName;

    public static FormatableJavaClass of(JavaClass type) {
        Assert.notNull((Object)type, (String)"JavaClass must not be null!");
        return CACHE.computeIfAbsent(type, FormatableJavaClass::new);
    }

    private FormatableJavaClass(JavaClass type) {
        Assert.notNull((Object)type, (String)"JavaClass must not be null!");
        this.type = type;
        this.abbreviatedName = Suppliers.memoize(() -> {
            String abbreviatedPackage = Stream.of(type.getPackageName().split("\\.")).map(it -> it.substring(0, 1)).collect(Collectors.joining("."));
            return abbreviatedPackage.concat(".").concat(ClassUtils.getShortName((String)type.getName()));
        });
    }

    public String getAbbreviatedFullName() {
        return (String)this.abbreviatedName.get();
    }

    public String getFullName() {
        return this.type.getFullName();
    }
}

