/*
 * Decompiled with CFR 0.152.
 */
package org.jddd.archunit;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.CompositeArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.jddd.archunit.FormatableJavaClass;
import org.jddd.core.types.AggregateRoot;
import org.jddd.core.types.Entity;
import org.springframework.core.ResolvableType;

public class JDddRules {
    public static ArchRule all() {
        return CompositeArchRule.of((ArchRule)JDddRules.entitiesShouldBeDeclaredForUseInSameAggregate()).and(JDddRules.aggregateReferencesShouldBeViaIdOrAssociation());
    }

    public static ArchRule entitiesShouldBeDeclaredForUseInSameAggregate() {
        return ArchRuleDefinition.fields().that(JDddRules.areAssignableTo(Entity.class).and(DescribedPredicate.not((DescribedPredicate)JDddRules.areAssignableTo(AggregateRoot.class)))).should((ArchCondition)JDddRules.beDeclaredToBeUsedWithDeclaringAggregate());
    }

    public static ArchRule aggregateReferencesShouldBeViaIdOrAssociation() {
        return ArchRuleDefinition.fields().that((DescribedPredicate)JDddRules.areAssignableTo(AggregateRoot.class)).or((DescribedPredicate)JDddRules.hasFieldTypeAnnotatedWith(org.jddd.core.annotation.AggregateRoot.class)).should((ArchCondition)new ShouldUseIdReferenceOrAssociation());
    }

    private static IsDeclaredToUseTheSameAggregate beDeclaredToBeUsedWithDeclaringAggregate() {
        return new IsDeclaredToUseTheSameAggregate();
    }

    private static IsAssignableTypeField areAssignableTo(Class<?> type) {
        return new IsAssignableTypeField(type);
    }

    private static FieldTypeIsAnnotatedWith hasFieldTypeAnnotatedWith(Class<? extends Annotation> type) {
        return new FieldTypeIsAnnotatedWith(type);
    }

    private static class IsAssignableTypeField
    extends DescribedPredicate<JavaField> {
        private static final ResolvableType COLLECTION_TYPE = ResolvableType.forClass(Collection.class);
        private static final ResolvableType MAP_TYPE = ResolvableType.forClass(Map.class);
        private final Class<?> type;

        private IsAssignableTypeField(Class<?> type) {
            super("are assignable to %s", new Object[]{type.getName()});
            this.type = type;
        }

        public boolean apply(JavaField input) {
            ResolvableType fieldType = ResolvableType.forField((Field)input.reflect());
            ResolvableType domainType = IsAssignableTypeField.unwrapDomainType(fieldType);
            return ResolvableType.forClass(this.type).isAssignableFrom(domainType);
        }

        private static ResolvableType unwrapDomainType(ResolvableType fieldType) {
            if (COLLECTION_TYPE.isAssignableFrom(fieldType)) {
                return fieldType.as(Collection.class).getGeneric(new int[]{0});
            }
            if (MAP_TYPE.isAssignableFrom(fieldType)) {
                return fieldType.as(Map.class).getGeneric(new int[]{1});
            }
            return fieldType;
        }
    }

    private static class FieldTypeIsAnnotatedWith
    extends DescribedPredicate<JavaField> {
        private final DescribedPredicate<CanBeAnnotated> isAnnotatedWith;

        public FieldTypeIsAnnotatedWith(Class<? extends Annotation> type) {
            super("is of type annotated with %s", new Object[]{type.getSimpleName()});
            this.isAnnotatedWith = CanBeAnnotated.Predicates.annotatedWith(type);
        }

        public boolean apply(JavaField input) {
            return this.isAnnotatedWith.apply((Object)input.getRawType());
        }
    }

    private static class ShouldUseIdReferenceOrAssociation
    extends ArchCondition<JavaField> {
        public ShouldUseIdReferenceOrAssociation() {
            super("use id reference or Association", new Object[0]);
        }

        public void check(JavaField field, ConditionEvents events) {
            events.add(SimpleConditionEvent.violated((Object)field, (String)String.format("Field %s.%s refers to an aggregate root (%s). Rather use an identifier reference or Association!", FormatableJavaClass.of(field.getOwner()).getAbbreviatedFullName(), field.getName(), FormatableJavaClass.of(field.getRawType()).getAbbreviatedFullName())));
        }
    }

    private static class IsDeclaredToUseTheSameAggregate
    extends ArchCondition<JavaField> {
        private IsDeclaredToUseTheSameAggregate() {
            super("belong to aggregate the field is declared in", new Object[0]);
        }

        public void check(JavaField item, ConditionEvents events) {
            Field field = item.reflect();
            ResolvableType type = ResolvableType.forField((Field)field);
            ResolvableType expectedAggregateType = type.as(Entity.class).getGeneric(new int[]{0});
            ResolvableType owningType = ResolvableType.forClass(field.getDeclaringClass());
            String ownerName = FormatableJavaClass.of(item.getOwner()).getAbbreviatedFullName();
            events.add(owningType.isAssignableFrom(expectedAggregateType) ? SimpleConditionEvent.satisfied((Object)field, (String)"Matches") : SimpleConditionEvent.violated((Object)item, (String)String.format("Field %s.%s is of type %s and declared to be used from aggregate %s!", ownerName, item.getName(), item.getRawType().getSimpleName(), expectedAggregateType.resolve(Object.class).getSimpleName())));
        }
    }
}

