/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.aop.interceptor;

import com.jdon.aop.interceptor.Advisor;
import com.jdon.container.pico.Startable;
import com.jdon.util.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InterceptorsChain
implements Startable {
    private static final String module = InterceptorsChain.class.getName();
    public static final String NAME = "InterceptorsChain";
    private final Map<String, List<Advisor>> chain = new ConcurrentHashMap<String, List<Advisor>>();

    @Override
    public void start() {
        Debug.logVerbose("[JdonFramework]InterceptorsChain start..", module);
    }

    @Override
    public void stop() {
        this.chain.clear();
    }

    public void addInterceptor(String pointcut, String InterceptorName) {
        if (pointcut == null) {
            System.err.print("pointcut is null in InterceptorsChain");
            return;
        }
        List<Advisor> interceptors = this.chain.get(pointcut);
        if (interceptors == null) {
            interceptors = new ArrayList<Advisor>();
            this.chain.put(pointcut, interceptors);
        }
        Advisor advisor = new Advisor(InterceptorName, pointcut);
        interceptors.add(advisor);
    }

    public boolean findInterceptorFromChainByName(String pointcut, String InterceptorName) {
        boolean ok = false;
        List<Advisor> interceptors = this.chain.get(pointcut);
        for (Advisor advisor : interceptors) {
            if (!advisor.getAdviceName().equals(InterceptorName)) continue;
            ok = true;
            break;
        }
        return ok;
    }

    public List<Advisor> getAdvisors(String pointcut) {
        return this.chain.get(pointcut);
    }

    public int size() {
        return this.chain.size();
    }
}

