/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.aop.interceptor;

import com.jdon.annotation.intercept.SessionContextAcceptable;
import com.jdon.aop.reflection.ProxyMethodInvocation;
import com.jdon.bussinessproxy.TargetMetaDef;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.access.TargetMetaRequest;
import com.jdon.container.access.TargetMetaRequestsHolder;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.container.pico.Startable;
import com.jdon.container.visitor.data.SessionContext;
import com.jdon.util.Debug;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class SessionContextInterceptor
implements MethodInterceptor,
Startable {
    private static final String module = SessionContextInterceptor.class.getName();
    private final List isSessionContextAcceptables = new ArrayList();
    private final Map<String, Method> isSessionContextAcceptablesAnnotations = new HashMap<String, Method>();
    private final List unSessionContextAcceptables = new ArrayList();
    private final ContainerCallback containerCallback;
    private final TargetMetaRequestsHolder targetMetaRequestsHolder;

    public SessionContextInterceptor(ContainerCallback containerCallback, TargetMetaRequestsHolder targetMetaRequestsHolder) {
        this.containerCallback = containerCallback;
        this.targetMetaRequestsHolder = targetMetaRequestsHolder;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        ProxyMethodInvocation pmi = (ProxyMethodInvocation)invocation;
        TargetMetaRequest targetMetaRequest = this.targetMetaRequestsHolder.getTargetMetaRequest();
        TargetMetaDef targetMetaDef = targetMetaRequest.getTargetMetaDef();
        if (targetMetaDef.isEJB()) {
            return invocation.proceed();
        }
        if (!this.isSessionContextAcceptable(targetMetaDef)) {
            return invocation.proceed();
        }
        Debug.logVerbose("[JdonFramework] enter SessionContextInterceptor", module);
        Object result = null;
        try {
            Object targetObject = pmi.getThis();
            if (targetObject == null) {
                throw new Exception("targetObject is null, add @Poolable and try again");
            }
            Debug.logVerbose("[JdonFramework] targetObject should be SessionContextAcceptable: " + targetObject.getClass().getName(), module);
            this.setSessionContext(targetObject, targetMetaRequest);
            result = invocation.proceed();
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework]SessionContextInterceptor error: " + ex, module);
        }
        return result;
    }

    public boolean isSessionContextAcceptable(TargetMetaDef targetMetaDef) {
        boolean found = false;
        if (this.isSessionContextAcceptables.contains(targetMetaDef.getName()) || this.isSessionContextAcceptablesAnnotations.containsKey(targetMetaDef.getName())) {
            found = true;
        } else if (!this.unSessionContextAcceptables.contains(targetMetaDef.getName())) {
            Debug.logVerbose("[JdonFramework] check if it is a isSessionContextAcceptable", module);
            ContainerWrapper containerWrapper = this.containerCallback.getContainerWrapper();
            Class thisCLass = containerWrapper.getComponentClass(targetMetaDef.getName());
            if (com.jdon.container.visitor.data.SessionContextAcceptable.class.isAssignableFrom(thisCLass)) {
                found = true;
                this.isSessionContextAcceptables.add(targetMetaDef.getName());
            } else {
                for (Method method : thisCLass.getMethods()) {
                    if (!method.isAnnotationPresent(SessionContextAcceptable.class)) continue;
                    this.isSessionContextAcceptablesAnnotations.put(targetMetaDef.getName(), method);
                    found = true;
                }
            }
            if (!found) {
                this.unSessionContextAcceptables.add(targetMetaDef.getName());
            }
        }
        return found;
    }

    private void setSessionContext(Object targetObject, TargetMetaRequest targetMetaRequest) {
        if (this.isSessionContextAcceptables.contains(targetMetaRequest.getTargetMetaDef().getName())) {
            com.jdon.container.visitor.data.SessionContextAcceptable myResult = (com.jdon.container.visitor.data.SessionContextAcceptable)targetObject;
            SessionContext sessionContext = targetMetaRequest.getSessionContext();
            myResult.setSessionContext(sessionContext);
        } else if (this.isSessionContextAcceptablesAnnotations.containsKey(targetMetaRequest.getTargetMetaDef().getName())) {
            Method method = this.isSessionContextAcceptablesAnnotations.get(targetMetaRequest.getTargetMetaDef().getName());
            try {
                Object[] sessionContexts = new SessionContext[]{targetMetaRequest.getSessionContext()};
                method.invoke(targetObject, sessionContexts);
            }
            catch (Exception e) {
                Debug.logError("[JdonFramework]the target must has method setSessionContext(SessionContext sessionContext) : " + e, module);
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.isSessionContextAcceptables.clear();
        this.isSessionContextAcceptablesAnnotations.clear();
        this.unSessionContextAcceptables.clear();
    }
}

