/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.aop.joinpoint;

import com.jdon.aop.interceptor.Advisor;
import com.jdon.aop.interceptor.InterceptorsChain;
import com.jdon.bussinessproxy.TargetMetaDef;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.container.pico.Startable;
import com.jdon.util.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInterceptor;

public class AdvisorChainFactory
implements Startable {
    private static final String module = AdvisorChainFactory.class.getName();
    private final InterceptorsChain interceptorsChain;
    private final ContainerCallback containerCallback;
    private List<MethodInterceptor> interceptors;
    private List<MethodInterceptor> interceptorsForEJB;
    private Map<String, List<MethodInterceptor>> targetInterceptors;

    public AdvisorChainFactory(InterceptorsChain interceptorsChain, ContainerCallback containerCallback) {
        this.interceptorsChain = interceptorsChain;
        this.containerCallback = containerCallback;
        this.targetInterceptors = new ConcurrentHashMap<String, List<MethodInterceptor>>();
        this.interceptorsForEJB = new ArrayList<MethodInterceptor>();
        this.interceptors = new ArrayList<MethodInterceptor>();
    }

    public List<MethodInterceptor> create(TargetMetaDef targetMetaDef) throws Exception {
        List<MethodInterceptor> targets;
        Debug.logVerbose("[JdonFramework] enter  create PointcutAdvisor  ", module);
        if (targetMetaDef.isEJB()) {
            if (this.interceptorsForEJB.isEmpty()) {
                this.createEJBAdvice(targetMetaDef);
            }
            return this.interceptorsForEJB;
        }
        if (this.interceptors.isEmpty()) {
            this.createPOJOAdvice(targetMetaDef);
        }
        if ((targets = this.targetInterceptors.get(targetMetaDef.getName())) == null) {
            targets = this.createTargetPOJOAdvice(targetMetaDef.getName());
            this.targetInterceptors.put(targetMetaDef.getName(), targets);
        }
        return this.interceptors;
    }

    public List<MethodInterceptor> createTargetAdvice(String name) throws Exception {
        Debug.logVerbose("[JdonFramework] enter   createTargetAdvice  ", module);
        List<MethodInterceptor> targets = this.targetInterceptors.get(name);
        if (targets == null) {
            targets = this.createTargetPOJOAdvice(name);
            this.targetInterceptors.put(name, targets);
        }
        return targets;
    }

    protected synchronized void createEJBAdvice(TargetMetaDef targetMetaDef) throws Exception {
        if (!targetMetaDef.isEJB()) {
            return;
        }
        if (!this.interceptorsForEJB.isEmpty()) {
            return;
        }
        List<Advisor> ejbInterceptorNames = this.interceptorsChain.getAdvisors("ejbServices");
        if (ejbInterceptorNames == null) {
            return;
        }
        List<Advisor> alladvices = this.interceptorsChain.getAdvisors("services");
        if (alladvices != null) {
            ejbInterceptorNames.addAll(alladvices);
        }
        for (Advisor advisor : ejbInterceptorNames) {
            MethodInterceptor ejbInterceptor = (MethodInterceptor)this.containerCallback.getContainerWrapper().lookup(advisor.getAdviceName());
            this.interceptorsForEJB.add(ejbInterceptor);
            Debug.logVerbose("[JdonFramework] find ejbService's interceptos size=" + this.interceptorsForEJB.size(), module);
        }
    }

    protected synchronized void createPOJOAdvice(TargetMetaDef targetMetaDef) throws Exception {
        if (targetMetaDef.isEJB()) {
            return;
        }
        if (!this.interceptors.isEmpty()) {
            return;
        }
        Debug.logVerbose("[JdonFramework] enter  create PointcutAdvisor  ", module);
        try {
            List<Advisor> pojoInterceptorNames = this.interceptorsChain.getAdvisors("pojoServices");
            if (pojoInterceptorNames == null) {
                return;
            }
            List<Advisor> alladvices = this.interceptorsChain.getAdvisors("services");
            if (alladvices != null) {
                pojoInterceptorNames.addAll(alladvices);
            }
            for (Advisor advisor : pojoInterceptorNames) {
                MethodInterceptor interceptor = (MethodInterceptor)this.containerCallback.getContainerWrapper().lookup(advisor.getAdviceName());
                if (interceptor == null) continue;
                this.interceptors.add(interceptor);
            }
            Debug.logVerbose("[JdonFramework] find pojoService's interceptos size=" + this.interceptors.size(), module);
        }
        catch (Exception e) {
            Debug.logError("error:" + e, module);
        }
    }

    protected List<MethodInterceptor> createTargetPOJOAdvice(String name) throws Exception {
        List<MethodInterceptor> myinterceptors = Collections.synchronizedList(new ArrayList());
        Debug.logVerbose("[JdonFramework] enter  create PointcutAdvisor2  ", module);
        List<Advisor> pojoInterceptorNames = this.interceptorsChain.getAdvisors(name);
        if (pojoInterceptorNames == null) {
            return myinterceptors;
        }
        for (Advisor advisor : pojoInterceptorNames) {
            MethodInterceptor interceptor = (MethodInterceptor)this.containerCallback.getContainerWrapper().lookup(advisor.getAdviceName());
            myinterceptors.add(interceptor);
            Debug.logVerbose("[JdonFramework] find pojoService's interceptos size=" + myinterceptors.size(), module);
        }
        return myinterceptors;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.interceptors.clear();
        this.interceptorsChain.stop();
        this.interceptorsForEJB.clear();
        this.targetInterceptors.clear();
    }
}

