/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.aop.reflection;

import com.jdon.aop.reflection.MethodInvokerUtil;
import com.jdon.bussinessproxy.target.TargetServiceFactory;
import com.jdon.container.access.TargetMetaRequestsHolder;
import com.jdon.util.Debug;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ProxyMethodInvocation
implements MethodInvocation,
Serializable {
    private static final long serialVersionUID = 8210744876679222009L;
    private static final String module = ProxyMethodInvocation.class.getName();
    protected final TargetServiceFactory targetServiceFactory;
    private final Method method;
    private final Object[] args;
    private Object target;
    protected final List<MethodInterceptor> interceptors;
    protected final MethodInvokerUtil mUtil;
    protected int currentInterceptorInt = -1;

    public ProxyMethodInvocation(List<MethodInterceptor> interceptors, TargetMetaRequestsHolder targetMetaRequestsHolder, TargetServiceFactory targetServiceFactory, Method method, Object[] args) {
        Debug.logVerbose("[JdonFramework] method.getName() :" + method.getName(), module);
        this.interceptors = interceptors;
        this.targetServiceFactory = targetServiceFactory;
        this.mUtil = new MethodInvokerUtil(targetMetaRequestsHolder);
        this.method = method;
        this.args = args;
    }

    public Object proceed() throws Throwable {
        MethodInterceptor interceptor;
        if (this.currentInterceptorInt == this.interceptors.size() - 1) {
            Debug.logVerbose("[JdonFramework] finish call all inteceptors", module);
            return this.methodInvoke();
        }
        if ((interceptor = this.interceptors.get(++this.currentInterceptorInt)) != null) {
            MethodInterceptor methodInterceptor = interceptor;
            return methodInterceptor.invoke((MethodInvocation)this);
        }
        Debug.logVerbose("[JdonFramework] null finish call all inteceptors", module);
        return this.methodInvoke();
    }

    private Object methodInvoke() throws Throwable {
        Debug.logVerbose("[JdonFramework]enter method reflection ", module);
        Object result = null;
        try {
            if (this.target == null) {
                Debug.logVerbose("[JdonFramework] all interceptors not set this target object, now create it", module);
                this.target = this.mUtil.createTargetObject(this.targetServiceFactory);
            }
            Debug.logVerbose("[JdonFramework] target:" + this.target.getClass().getName() + " service's method:" + this.method.getName() + " running.. ", module);
            Debug.logVerbose("[JdonFramework] it is pojo target service", module);
            result = this.mUtil.execute(this.method, this.target, this.args);
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework]run error: " + ex, module);
            throw new Throwable(ex);
        }
        catch (Throwable tex) {
            throw new Throwable(tex);
        }
        return result;
    }

    public Object[] getArguments() {
        return this.args;
    }

    public Object getThis() {
        return this.target;
    }

    public void setThis(Object target) {
        this.target = target;
    }

    public AccessibleObject getStaticPart() {
        return null;
    }

    public Method getMethod() {
        return this.method;
    }
}

