/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.async.disruptor;

import com.jdon.async.disruptor.DisruptorParams;
import com.jdon.async.disruptor.DomainEventHandlerAdapter;
import com.jdon.async.disruptor.EventDisruptor;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.container.pico.Startable;
import com.jdon.domain.message.DomainEventDispatchHandler;
import com.jdon.domain.message.DomainEventHandler;
import com.jdon.domain.message.consumer.ConsumerMethodHolder;
import com.jdon.util.Debug;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.MultiThreadedClaimStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.EventHandlerGroup;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class DisruptorFactory
implements EventFactory,
Startable {
    public static final String module = DisruptorFactory.class.getName();
    protected final Map<String, TreeSet<DomainEventHandler>> handlesMap;
    private String RingBufferSize;
    private ContainerWrapper containerWrapper;

    public DisruptorFactory(DisruptorParams disruptorParams, ContainerCallback containerCallback) {
        this.RingBufferSize = disruptorParams.getRingBufferSize();
        this.containerWrapper = containerCallback.getContainerWrapper();
        this.handlesMap = new ConcurrentHashMap<String, TreeSet<DomainEventHandler>>();
    }

    public DisruptorFactory() {
        this.RingBufferSize = "8";
        this.containerWrapper = null;
        this.handlesMap = new ConcurrentHashMap<String, TreeSet<DomainEventHandler>>();
    }

    private Disruptor createDw(String topic) {
        BlockingWaitStrategy waitStrategy = new BlockingWaitStrategy();
        MultiThreadedClaimStrategy claimStrategy = new MultiThreadedClaimStrategy(Integer.parseInt(this.RingBufferSize));
        return new Disruptor((EventFactory)this, (Executor)Executors.newCachedThreadPool(), (ClaimStrategy)claimStrategy, (WaitStrategy)waitStrategy);
    }

    public Disruptor addEventMessageHandler(String topic, TreeSet<DomainEventHandler> handlers) {
        if (handlers.size() == 0) {
            return null;
        }
        Disruptor dw = this.createDw(topic);
        EventHandlerGroup eh = null;
        for (DomainEventHandler handler : handlers) {
            DomainEventHandlerAdapter dea = new DomainEventHandlerAdapter(handler);
            if (eh == null) {
                eh = dw.handleEventsWith(new EventHandler[]{dea});
                continue;
            }
            eh = eh.handleEventsWith(new EventHandler[]{dea});
        }
        return dw;
    }

    public Disruptor createDisruptor(String topic) {
        Disruptor disruptor;
        TreeSet<DomainEventHandler> handlers = this.handlesMap.get(topic);
        if (handlers == null) {
            handlers = this.loadEvenHandler(topic);
            if ((handlers = this.loadOnEventConsumers(topic, handlers)).size() == 0) {
                Object o = this.containerWrapper.lookup(topic);
                if (o == null) {
                    Debug.logError("[Jdonframework]no found the class annotated with @Consumer(" + topic + ") ", module);
                }
                return null;
            }
            this.handlesMap.put(topic, handlers);
        }
        if ((disruptor = this.addEventMessageHandler(topic, handlers)) == null) {
            return null;
        }
        disruptor.start();
        return disruptor;
    }

    protected TreeSet<DomainEventHandler> loadEvenHandler(String topic) {
        TreeSet<DomainEventHandler> ehs = this.getTreeSet();
        Collection consumers = (Collection)this.containerWrapper.lookup("CONSUMER_TOPIC" + topic);
        if (consumers == null || consumers.size() == 0) {
            Debug.logWarning("[Jdonframework]there is no any consumer class annotated with @Consumer(" + topic + ") ", module);
            return ehs;
        }
        for (String consumerName : consumers) {
            DomainEventHandler eh = (DomainEventHandler)this.containerWrapper.lookup(consumerName);
            ehs.add(eh);
        }
        return ehs;
    }

    protected TreeSet<DomainEventHandler> loadOnEventConsumers(String topic, TreeSet<DomainEventHandler> ehs) {
        Collection consumerMethods = (Collection)this.containerWrapper.lookup("MEHTOD_TOPIC" + topic);
        if (consumerMethods == null) {
            return ehs;
        }
        for (Object o : consumerMethods) {
            ConsumerMethodHolder consumerMethodHolder = (ConsumerMethodHolder)o;
            DomainEventDispatchHandler domainEventDispatchHandler = new DomainEventDispatchHandler(consumerMethodHolder, this.containerWrapper);
            ehs.add(domainEventDispatchHandler);
        }
        return ehs;
    }

    public TreeSet<DomainEventHandler> getTreeSet() {
        return new TreeSet<DomainEventHandler>(new Comparator(){

            public int compare(Object num1, Object num2) {
                String inum2;
                String inum1 = num1.getClass().getName();
                if (inum1.compareTo(inum2 = num2.getClass().getName()) < 1) {
                    return -1;
                }
                return 1;
            }
        });
    }

    public EventDisruptor newInstance() {
        return new EventDisruptor();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.containerWrapper = null;
        this.handlesMap.clear();
        this.RingBufferSize = null;
    }
}

