/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.async.disruptor;

import com.jdon.async.EventResultHandler;
import com.jdon.async.disruptor.EventResultDisruptor;
import com.jdon.async.disruptor.EventResultFactory;
import com.jdon.async.disruptor.ValueEventProcessor;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.SingleThreadedClaimStrategy;
import com.lmax.disruptor.WaitStrategy;

public class EventResultHandlerImp
implements EventResultHandler {
    protected int timeoutforeturnResult = 10000;
    protected ValueEventProcessor valueEventProcessor;

    public EventResultHandlerImp() {
        RingBuffer ringBuffer = new RingBuffer((EventFactory)new EventResultFactory(), (ClaimStrategy)new SingleThreadedClaimStrategy(8), (WaitStrategy)new BlockingWaitStrategy());
        this.valueEventProcessor = new ValueEventProcessor((RingBuffer<EventResultDisruptor>)ringBuffer);
    }

    @Override
    public void send(Object result) {
        this.valueEventProcessor.send(result);
    }

    @Override
    public Object get() {
        Object result = null;
        EventResultDisruptor ve = this.valueEventProcessor.waitFor(this.timeoutforeturnResult);
        if (ve != null) {
            result = ve.getValue();
            ve.clear();
        }
        return result;
    }

    @Override
    public Object getBlockedValue() {
        Object result = null;
        EventResultDisruptor ve = this.valueEventProcessor.waitForBlocking(this.timeoutforeturnResult * 100);
        if (ve != null) {
            result = ve.getValue();
            ve.clear();
        }
        return result;
    }

    @Override
    public void clear() {
        this.valueEventProcessor.clear();
    }

    public int getTimeoutforeturnResult() {
        return this.timeoutforeturnResult;
    }

    @Override
    public void setWaitforTimeout(int timeoutforeturnResult) {
        this.timeoutforeturnResult = timeoutforeturnResult;
    }
}

