/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.async.disruptor;

import com.jdon.async.disruptor.EventResultDisruptor;
import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import java.util.concurrent.TimeUnit;

public class ValueEventProcessor {
    protected RingBuffer<EventResultDisruptor> ringBuffer;
    private long waitAtSequence = 0L;

    public ValueEventProcessor(RingBuffer<EventResultDisruptor> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    public void send(Object result) {
        this.ringBuffer.setGatingSequences(new Sequence[]{new Sequence(-1L)});
        this.waitAtSequence = this.ringBuffer.next();
        EventResultDisruptor ve = (EventResultDisruptor)this.ringBuffer.get(this.waitAtSequence);
        ve.setValue(result);
        this.ringBuffer.publish(this.waitAtSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventResultDisruptor waitFor(long timeoutforeturnResult) {
        SequenceBarrier barrier = this.ringBuffer.newBarrier(new Sequence[0]);
        try {
            long a = barrier.waitFor(this.waitAtSequence, timeoutforeturnResult, TimeUnit.MILLISECONDS);
            if (this.ringBuffer != null) {
                EventResultDisruptor eventResultDisruptor = (EventResultDisruptor)this.ringBuffer.get(a);
                return eventResultDisruptor;
            }
        }
        catch (AlertException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            barrier.alert();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventResultDisruptor waitForBlocking(long timeoutforeturnResult) {
        SequenceBarrier barrier = this.ringBuffer.newBarrier(new Sequence[0]);
        try {
            long a = barrier.waitFor(this.waitAtSequence, timeoutforeturnResult, TimeUnit.MILLISECONDS);
            if (this.ringBuffer != null) {
                EventResultDisruptor eventResultDisruptor = (EventResultDisruptor)this.ringBuffer.get(a);
                return eventResultDisruptor;
            }
        }
        catch (AlertException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            barrier.alert();
        }
        return null;
    }

    public long getWaitAtSequence() {
        return this.waitAtSequence;
    }

    public void setWaitAtSequence(long waitAtSequence) {
        this.waitAtSequence = waitAtSequence;
    }

    public void clear() {
        this.ringBuffer = null;
    }
}

