/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.cache;

import com.jdon.cache.CacheLine;
import com.jdon.util.ConcurrentLinkedList;
import com.jdon.util.Debug;
import com.jdon.util.PropsUtil;
import com.jdon.util.UtilValidate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class UtilCache {
    public static String module = UtilCache.class.getName();
    private ScheduledExecutorService scheduExecStatic = Executors.newScheduledThreadPool(1);
    public final ConcurrentLinkedList keyLRUList = new ConcurrentLinkedList();
    public final Map cacheLineTable = new ConcurrentHashMap();
    protected volatile long hitCount = 0L;
    protected volatile long missCount = 0L;
    protected volatile long maxSize = 0L;
    protected volatile long expireTime = 0L;
    protected volatile boolean useSoftReference = false;

    public UtilCache(PropsUtil propsUtil) {
        this.setPropertiesParams(propsUtil, "default");
        this.startMon(this.expireTime);
    }

    public UtilCache(int maxSize, long expireTime, boolean useSoftReference) {
        this.maxSize = maxSize;
        this.expireTime = expireTime;
        this.useSoftReference = useSoftReference;
        this.startMon(expireTime);
    }

    public void startMon(long expireTime) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                UtilCache.this.clearExpired();
            }
        };
        this.scheduExecStatic.scheduleAtFixedRate(task, expireTime / 1000L + 30L, expireTime / 1000L + 30L, TimeUnit.SECONDS);
    }

    protected void setPropertiesParams(PropsUtil propsUtil, String cacheName) {
        Long longValue;
        String value;
        if (propsUtil == null) {
            System.err.println(" UtilCache propsUtil not yet set!! ");
            return;
        }
        try {
            value = propsUtil.getProperty("cache." + cacheName + ".maxSize");
            if (UtilValidate.isNotEmpty(value)) {
                Debug.logVerbose("[JdonFramework]found cache configure: cache." + cacheName + ".maxSize = " + value, module);
                longValue = new Long(value);
                if (longValue != null) {
                    this.maxSize = longValue;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            value = propsUtil.getProperty("cache." + cacheName + ".expireTime");
            if (UtilValidate.isNotEmpty(value) && (longValue = new Long(value)) != null) {
                this.expireTime = longValue;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            value = propsUtil.getProperty("cache." + cacheName + ".useSoftReference");
            if (UtilValidate.isNotEmpty(value)) {
                this.useSoftReference = "true".equals(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object value) {
        if (key == null || value == null) {
            return;
        }
        try {
            if (this.maxSize > 0L) {
                if (this.cacheLineTable.containsKey(key)) {
                    this.keyLRUList.moveFirst(key);
                } else {
                    this.keyLRUList.addFirst(key);
                }
            }
            if (this.expireTime > 0L) {
                this.cacheLineTable.put(key, new CacheLine(value, this.useSoftReference, System.currentTimeMillis()));
            } else {
                this.cacheLineTable.put(key, new CacheLine(value, this.useSoftReference));
            }
            if (this.maxSize > 0L && (long)this.cacheLineTable.size() > this.maxSize) {
                Object lastKey = this.keyLRUList.getLast();
                this.removeObject(lastKey);
            }
        }
        catch (Exception e) {
            Debug.logError(e);
        }
        Debug.logVerbose("[JdonFramework]cache now size = " + this.keyLRUList.size() + " maxSize =" + this.maxSize + " this Cache id:" + this.hashCode(), module);
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        if (!this.cacheLineTable.containsKey(key)) {
            return null;
        }
        CacheLine line = (CacheLine)this.cacheLineTable.get(key);
        if (this.hasExpired(line)) {
            this.removeObject(key);
            line = null;
        }
        if (line == null) {
            ++this.missCount;
            return null;
        }
        ++this.hitCount;
        if (this.maxSize > 0L) {
            this.keyLRUList.moveFirst(key);
        }
        return line.getValue();
    }

    public void remove(Object key) {
        this.removeObject(key);
    }

    private void removeObject(Object key) {
        CacheLine line;
        if (key == null) {
            ++this.missCount;
        }
        if ((line = (CacheLine)this.cacheLineTable.remove(key)) != null) {
            if (this.maxSize > 0L) {
                this.keyLRUList.remove(key);
            }
        } else {
            ++this.missCount;
        }
    }

    public Set keySet() {
        return this.cacheLineTable.keySet();
    }

    public Collection values() {
        return this.cacheLineTable.values();
    }

    public void clear() {
        this.cacheLineTable.clear();
        this.keyLRUList.clear();
        this.clearCounters();
    }

    public void clearAllCaches() {
        this.clear();
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public void clearCounters() {
        this.hitCount = 0L;
        this.missCount = 0L;
    }

    public void setMaxSize(long maxSize) {
        if (maxSize <= 0L) {
            this.keyLRUList.clear();
        } else if (maxSize > 0L && this.maxSize <= 0L) {
            Iterator keys = this.cacheLineTable.keySet().iterator();
            while (keys.hasNext()) {
                this.keyLRUList.add(keys.next());
            }
        }
        if (maxSize > 0L && (long)this.cacheLineTable.size() > maxSize) {
            while ((long)this.cacheLineTable.size() > maxSize) {
                Object lastKey = this.keyLRUList.getLast();
                this.removeObject(lastKey);
            }
        }
        this.maxSize = maxSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setExpireTime(long expireTime) {
        if (this.expireTime <= 0L && expireTime > 0L) {
            long currentTime = System.currentTimeMillis();
            for (CacheLine line : this.cacheLineTable.values()) {
                line.setLoadTime(currentTime);
            }
        } else if (this.expireTime > 0L || expireTime > 0L) {
            // empty if block
        }
        this.expireTime = expireTime;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public boolean getUseSoftReference() {
        return this.useSoftReference;
    }

    public long size() {
        return this.cacheLineTable.size();
    }

    public boolean containsKey(Object key) {
        CacheLine line = (CacheLine)this.cacheLineTable.get(key);
        if (this.hasExpired(line)) {
            this.removeObject(key);
            line = null;
        }
        return line != null;
    }

    public boolean hasExpired(Object key) {
        if (key == null) {
            return false;
        }
        CacheLine line = (CacheLine)this.cacheLineTable.get(key);
        return this.hasExpired(line);
    }

    protected boolean hasExpired(CacheLine line) {
        if (line == null) {
            return false;
        }
        if (this.useSoftReference && line.getValue() == null) {
            Debug.logWarning("SoftReference getValue()  == null GC has done it. ", module);
            return true;
        }
        if (this.expireTime <= 0L) {
            return false;
        }
        if (line.getLoadTime() <= 0L) {
            return true;
        }
        return line.getLoadTime() + this.expireTime < System.currentTimeMillis();
    }

    public void clearExpired() {
        for (Object key : this.cacheLineTable.keySet()) {
            if (!this.hasExpired(key)) continue;
            this.removeObject(key);
        }
    }

    public void stop() {
        this.clear();
        try {
            this.scheduExecStatic.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

