/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.components.encache;

import com.jdon.components.encache.EhcacheConf;
import com.jdon.container.pico.Startable;
import com.jdon.controller.cache.Cache;
import com.jdon.util.FileLocator;
import java.io.InputStream;
import java.util.Collection;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class EncacheProvider
implements Cache,
Startable {
    private CacheManager manager;
    private final EhcacheConf ehcacheConf;

    public EncacheProvider(EhcacheConf ehcacheConf) {
        this.ehcacheConf = ehcacheConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (this.manager == null) {
                FileLocator fileLocator = new FileLocator();
                InputStream pathCongfgName = fileLocator.getConfStream(this.ehcacheConf.getEhcacheConfFileName());
                this.manager = new CacheManager(pathCongfgName);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void stop() {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        cache.removeAll();
        this.manager.removeCache(this.ehcacheConf.getPredefinedCacheName());
        this.manager.removalAll();
        this.manager.clearAll();
        this.manager.shutdown();
        this.manager = null;
    }

    @Override
    public Object get(Object key) {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        Element e = cache.get(key);
        if (e == null) {
            return null;
        }
        return e.getObjectValue();
    }

    @Override
    public void put(Object key, Object value) {
        Element element = new Element(key, value);
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        cache.put(element);
    }

    @Override
    public void remove(Object key) {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        cache.remove(key);
    }

    @Override
    public long size() {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        return cache.getMemoryStoreSize();
    }

    @Override
    public void clear() {
        if (this.manager != null) {
            net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
            cache.removeAll();
        }
    }

    @Override
    public boolean contain(Object key) {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        return cache.isKeyInCache(key);
    }

    @Override
    public Collection keySet() {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        return cache.getKeys();
    }

    @Override
    public long getCacheHits() {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        return cache.getStatistics().getCacheHits();
    }

    @Override
    public long getCacheMisses() {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        return cache.getStatistics().getCacheMisses();
    }

    public static void main(String[] args) throws Exception {
        EhcacheConf ehcacheConf = new EhcacheConf("jdon_ehcache.xml", "jdonCache");
        EncacheProvider encacheProvider = new EncacheProvider(ehcacheConf);
        encacheProvider.start();
        encacheProvider.put("key1", "value122");
        String value = (String)encacheProvider.get("key1");
        System.out.println("value=" + value);
        encacheProvider.remove("key1");
        value = (String)encacheProvider.get("key2");
        System.out.println("value2=" + value);
    }
}

