/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.access.xml;

import com.jdon.container.access.TargetMetaDefHolder;
import com.jdon.container.access.xml.AppConfigureCollection;
import com.jdon.container.pico.Startable;
import com.jdon.controller.config.XmlParser;
import com.jdon.controller.config.XmlPojoServiceParser;
import com.jdon.util.Debug;
import java.util.Map;

public class TargetMetaDefXmlLoader
implements Startable {
    private static final String module = TargetMetaDefXmlLoader.class.getName();
    private final XmlParser xmlPojoServiceParser;
    private TargetMetaDefHolder targetMetaDefHolder;
    private AppConfigureCollection appConfigureFiles;

    public TargetMetaDefXmlLoader(AppConfigureCollection appConfigureFiles, TargetMetaDefHolder targetMetaDefHolder) {
        this.appConfigureFiles = appConfigureFiles;
        this.targetMetaDefHolder = targetMetaDefHolder;
        this.xmlPojoServiceParser = new XmlPojoServiceParser();
    }

    public void loadXML() {
        Debug.logVerbose("[JdonFramework]TargetMetaDefXmlLoader start ... found configures:" + this.appConfigureFiles.getConfigList().size(), module);
        for (String configFileName : this.appConfigureFiles.getConfigList()) {
            Debug.logVerbose("[JdonFramework] start to load configure: " + configFileName, module);
            Map pojoMps = this.xmlPojoServiceParser.load(configFileName);
            this.targetMetaDefHolder.add(pojoMps);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.targetMetaDefHolder = null;
        this.appConfigureFiles = null;
    }
}

