/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.annotation;

import com.jdon.annotation.Interceptor;
import com.jdon.aop.interceptor.InterceptorsChain;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.annotation.AnnotationContainerRegistry;
import com.jdon.container.annotation.AnnotationHolder;
import com.jdon.container.annotation.ContainerLoaderAnnotation;
import com.jdon.container.builder.DefaultContainerBuilder;
import com.jdon.container.config.ContainerComponents;
import com.jdon.container.interceptor.IntroduceInfoHolder;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.util.Debug;
import com.jdon.util.UtilValidate;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;

public class AnnotationContainerBuilder
extends DefaultContainerBuilder {
    public static final String module = AnnotationContainerBuilder.class.getName();
    private AnnotationContainerRegistry annotationContainerRegistry;
    private AppContextWrapper context;

    public AnnotationContainerBuilder(AppContextWrapper context, ContainerWrapper containerWrapper, ContainerComponents basicComponents, ContainerComponents aspectConfigComponents, ContainerLoaderAnnotation containerLoaderAnnotation) {
        super(containerWrapper, basicComponents, aspectConfigComponents);
        this.context = context;
        this.annotationContainerRegistry = new AnnotationContainerRegistry(context, containerWrapper, containerLoaderAnnotation);
    }

    @Override
    public void registerAspectComponents() throws Exception {
        super.registerAspectComponents();
        this.registerAnnotationAspectComponents();
        InterceptorsChain existedInterceptorsChain = (InterceptorsChain)this.containerWrapper.lookup("interceptorsChain");
        IntroduceInfoHolder ih = this.annotationContainerRegistry.getContainerLoaderAnnotation().getConfigInfo().getIntroduceInfoHolder();
        for (String adviceName : ih.getIntroduceNames()) {
            List<String> targetNames = ih.getIntroducerNameByIntroducedName(adviceName);
            for (String targetName : targetNames) {
                if (!existedInterceptorsChain.findInterceptorFromChainByName("domain", adviceName)) continue;
                existedInterceptorsChain.addInterceptor(targetName, adviceName);
            }
        }
    }

    public void registerAnnotationAspectComponents() throws Exception {
        try {
            InterceptorsChain existedInterceptorsChain = (InterceptorsChain)this.containerWrapper.lookup("interceptorsChain");
            AnnotationHolder annotationHolder = this.annotationContainerRegistry.getContainerLoaderAnnotation().loadAnnotationHolder(this.context, this.containerWrapper);
            Map<String, Class> inters = annotationHolder.getInterceptors();
            for (String name : inters.keySet()) {
                Class classz = inters.get(name);
                if (!MethodInterceptor.class.isAssignableFrom(classz)) {
                    Debug.logError(" your @Interceptor class not implements MethodInteceptor! class=" + classz.getName(), module);
                    continue;
                }
                Interceptor inter = classz.getAnnotation(Interceptor.class);
                if (!UtilValidate.isEmpty(inter.pointcut())) {
                    String[] targets = inter.pointcut().split(",");
                    for (int i = 0; i < targets.length; ++i) {
                        existedInterceptorsChain.addInterceptor(targets[i], name);
                    }
                    continue;
                }
                IntroduceInfoHolder ih = this.annotationContainerRegistry.getContainerLoaderAnnotation().getConfigInfo().getIntroduceInfoHolder();
                List<String> targetNames = ih.getIntroducerNameByIntroducedName(name);
                for (String targetName : targetNames) {
                    existedInterceptorsChain.addInterceptor(targetName, name);
                }
                if (targetNames.size() != 0) continue;
                existedInterceptorsChain.addInterceptor("pojoServices", name);
            }
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework] registerAspectComponents" + e, module);
        }
    }

    @Override
    public void registerUserService() throws Exception {
        super.registerUserService();
        this.annotationContainerRegistry.registerAnnotationComponents();
    }

    @Override
    public void doAfterStarted() throws Exception {
        this.annotationContainerRegistry.copyTargetMetaDefHolder();
    }
}

