/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.annotation;

import com.jdon.container.ContainerWrapper;
import com.jdon.container.annotation.AnnotationHolder;
import com.jdon.container.annotation.type.AnnotationScaner;
import com.jdon.container.annotation.type.ComponentLoader;
import com.jdon.container.annotation.type.ConsumerLoader;
import com.jdon.container.annotation.type.InroduceLoader;
import com.jdon.container.annotation.type.InterceptorLoader;
import com.jdon.container.annotation.type.ServiceLoader;
import com.jdon.container.interceptor.IntroduceInfoHolder;
import com.jdon.container.pico.ConfigInfo;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.util.Debug;

public class ContainerLoaderAnnotation {
    public static final String module = ContainerLoaderAnnotation.class.getName();
    private AnnotationScaner annotationScaner;
    private ConfigInfo configInfo = new ConfigInfo();
    private AnnotationHolder annotationHolder;

    public ContainerLoaderAnnotation() {
        this.annotationScaner = new AnnotationScaner();
    }

    public void startScan(AppContextWrapper context) {
        this.annotationScaner.startScan(context);
    }

    public AnnotationHolder loadAnnotationHolder(AppContextWrapper context, ContainerWrapper containerWrapper) {
        if (this.annotationHolder != null) {
            return this.annotationHolder;
        }
        Debug.logVerbose("[JdonFramework] load all Annotation components ", module);
        this.annotationHolder = new AnnotationHolder();
        ConsumerLoader consumerLoader = new ConsumerLoader(this.annotationScaner);
        consumerLoader.loadAnnotationConsumers(this.annotationHolder, context, containerWrapper);
        ServiceLoader serviceLoader = new ServiceLoader(this.annotationScaner, consumerLoader);
        serviceLoader.loadAnnotationServices(this.annotationHolder, context, containerWrapper);
        ComponentLoader componentLoader = new ComponentLoader(this.annotationScaner, consumerLoader);
        componentLoader.loadAnnotationComponents(this.annotationHolder, context, containerWrapper);
        InroduceLoader inroduceLoader = new InroduceLoader(this.annotationScaner, this.configInfo.getIntroduceInfoHolder());
        inroduceLoader.loadAnnotationIntroduceInfos(this.annotationHolder, context, containerWrapper);
        InterceptorLoader interceptorLoader = new InterceptorLoader(this.annotationScaner, this.configInfo.getIntroduceInfoHolder());
        interceptorLoader.loadAnnotationInterceptors(this.annotationHolder, context);
        containerWrapper.register(AnnotationHolder.NAME, this.annotationHolder);
        containerWrapper.register(IntroduceInfoHolder.NAME, this.configInfo.getIntroduceInfoHolder());
        return this.annotationHolder;
    }

    public ConfigInfo getConfigInfo() {
        return this.configInfo;
    }

    public void setConfigInfo(ConfigInfo configInfo) {
        this.configInfo = configInfo;
    }
}

