/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.pico;

import com.jdon.container.ContainerWrapper;
import com.jdon.container.pico.ConfigInfo;
import com.jdon.container.pico.JdonInstantiatingComponentAdapter;
import com.jdon.container.pico.JdonThreadLocalCyclicDependencyGuard;
import com.jdon.domain.advsior.ComponentAdvsior;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.TooManySatisfiableConstructorsException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class JdonConstructorInjectionComponentAdapter
extends JdonInstantiatingComponentAdapter {
    private static final long serialVersionUID = 1L;
    protected transient List sortedMatchingConstructors;
    protected transient Guard instantiationGuard;
    private ConfigInfo configInfo;

    public JdonConstructorInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses, ConfigInfo configInfo) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, allowNonPublicClasses);
        this.configInfo = configInfo;
    }

    public JdonConstructorInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters, ConfigInfo configInfo) {
        this(componentKey, componentImplementation, parameters, false, configInfo);
    }

    public JdonConstructorInjectionComponentAdapter(Object componentKey, Class componentImplementation, ConfigInfo configInf) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        this(componentKey, componentImplementation, null, configInf);
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new Guard(){

                public Object run() {
                    Constructor constructor;
                    try {
                        constructor = JdonConstructorInjectionComponentAdapter.this.getGreediestSatisfiableConstructor(this.guardedContainer);
                    }
                    catch (AmbiguousComponentResolutionException e) {
                        e.setComponent(JdonConstructorInjectionComponentAdapter.this.getComponentImplementation());
                        throw e;
                    }
                    ComponentMonitor componentMonitor = JdonConstructorInjectionComponentAdapter.this.currentMonitor();
                    try {
                        Object[] parameters = JdonConstructorInjectionComponentAdapter.this.getConstructorArguments(this.guardedContainer, constructor);
                        componentMonitor.instantiating(constructor);
                        long startTime = System.currentTimeMillis();
                        Object inst = JdonConstructorInjectionComponentAdapter.this.newInstance(constructor, parameters);
                        componentMonitor.instantiated(constructor, System.currentTimeMillis() - startTime);
                        return inst;
                    }
                    catch (InvocationTargetException e) {
                        componentMonitor.instantiationFailed(constructor, (Exception)e);
                        if (e.getTargetException() instanceof RuntimeException) {
                            throw (RuntimeException)e.getTargetException();
                        }
                        if (e.getTargetException() instanceof Error) {
                            throw (Error)e.getTargetException();
                        }
                        throw new PicoInvocationTargetInitializationException(e.getTargetException());
                    }
                    catch (InstantiationException e) {
                        componentMonitor.instantiationFailed(constructor, (Exception)e);
                        throw new PicoInitializationException("Should never get here");
                    }
                    catch (IllegalAccessException e) {
                        componentMonitor.instantiationFailed(constructor, (Exception)e);
                        throw new PicoInitializationException((Throwable)e);
                    }
                }
            };
        }
        this.instantiationGuard.setArguments(container);
        Object result = this.instantiationGuard.observe(this.getComponentImplementation());
        this.instantiationGuard.clear();
        return result;
    }

    @Override
    protected Object newInstance(Constructor constructor, Object[] parameters) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.allowNonPublicClasses) {
            constructor.setAccessible(true);
        }
        Object o = constructor.newInstance(parameters);
        ComponentAdvsior componentAdvsior = (ComponentAdvsior)this.configInfo.getContainerWrapper().lookup("componentAdvsior");
        Object proxy = null;
        if (componentAdvsior != null) {
            proxy = componentAdvsior.createProxy(o);
        }
        if (!proxy.getClass().isInstance(o)) {
            Map orignals = this.getContainerOrignals(this.configInfo.getContainerWrapper());
            orignals.put((String)this.getComponentKey(), o);
        }
        return proxy;
    }

    public Map getContainerOrignals(ContainerWrapper containerWrapper) {
        HashMap orignals = (HashMap)containerWrapper.lookup("OrignalKey");
        if (orignals == null) {
            orignals = new HashMap();
            containerWrapper.register("OrignalKey", orignals);
        }
        return orignals;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.instantiationGuard != null) {
            this.instantiationGuard.clear();
        }
    }

    @Override
    protected Constructor getGreediestSatisfiableConstructor(PicoContainer container) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        HashSet<Constructor> conflicts = new HashSet<Constructor>();
        HashSet<List<Class>> unsatisfiableDependencyTypes = new HashSet<List<Class>>();
        if (this.sortedMatchingConstructors == null) {
            this.sortedMatchingConstructors = this.getSortedMatchingConstructors();
        }
        Constructor greediestConstructor = null;
        int lastSatisfiableConstructorSize = -1;
        Class unsatisfiedDependencyType = null;
        for (int i = 0; i < this.sortedMatchingConstructors.size(); ++i) {
            boolean failedDependency = false;
            Constructor constructor = (Constructor)this.sortedMatchingConstructors.get(i);
            Class[] parameterTypes = constructor.getParameterTypes();
            Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
            for (int j = 0; j < currentParameters.length; ++j) {
                if (currentParameters[j].isResolvable(container, (ComponentAdapter)this, parameterTypes[j])) continue;
                unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                unsatisfiedDependencyType = parameterTypes[j];
                failedDependency = true;
                break;
            }
            if (greediestConstructor != null && parameterTypes.length != lastSatisfiableConstructorSize) {
                if (conflicts.isEmpty()) {
                    return greediestConstructor;
                }
                conflicts.add(constructor);
                continue;
            }
            if (!failedDependency && lastSatisfiableConstructorSize == parameterTypes.length) {
                conflicts.add(constructor);
                conflicts.add(greediestConstructor);
                continue;
            }
            if (failedDependency) continue;
            greediestConstructor = constructor;
            lastSatisfiableConstructorSize = parameterTypes.length;
        }
        if (!conflicts.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(this.getComponentImplementation(), conflicts);
        }
        if (greediestConstructor == null && !unsatisfiableDependencyTypes.isEmpty()) {
            throw new UnsatisfiableDependenciesException((ComponentAdapter)this, unsatisfiedDependencyType, unsatisfiableDependencyTypes, container);
        }
        if (greediestConstructor == null) {
            HashSet<Constructor> nonMatching = new HashSet<Constructor>();
            Constructor[] constructors = this.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                nonMatching.add(constructors[i]);
            }
            throw new PicoInitializationException("Either do the specified parameters not match any of the following constructors: " + ((Object)nonMatching).toString() + " or the constructors were not accessible for '" + this.getComponentImplementation() + "'");
        }
        return greediestConstructor;
    }

    protected Object[] getConstructorArguments(PicoContainer container, Constructor ctor) {
        Class[] parameterTypes = ctor.getParameterTypes();
        Object[] result = new Object[parameterTypes.length];
        Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
        for (int i = 0; i < currentParameters.length; ++i) {
            result[i] = currentParameters[i].resolveInstance(container, (ComponentAdapter)this, parameterTypes[i]);
        }
        return result;
    }

    private List getSortedMatchingConstructors() {
        ArrayList<Constructor> matchingConstructors = new ArrayList<Constructor>();
        Constructor[] allConstructors = this.getConstructors();
        for (int i = 0; i < allConstructors.length; ++i) {
            Constructor constructor = allConstructors[i];
            if (this.parameters != null && constructor.getParameterTypes().length != this.parameters.length || !this.allowNonPublicClasses && (constructor.getModifiers() & 1) == 0) continue;
            matchingConstructors.add(constructor);
        }
        if (this.parameters == null) {
            Collections.sort(matchingConstructors, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return ((Constructor)arg1).getParameterTypes().length - ((Constructor)arg0).getParameterTypes().length;
                }
            });
        }
        return matchingConstructors;
    }

    private Constructor[] getConstructors() {
        return (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return JdonConstructorInjectionComponentAdapter.this.getComponentImplementation().getDeclaredConstructors();
            }
        });
    }

    private static abstract class Guard
    extends JdonThreadLocalCyclicDependencyGuard {
        protected PicoContainer guardedContainer;

        private Guard() {
        }

        private void setArguments(PicoContainer container) {
            this.guardedContainer = container;
        }
    }
}

