/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.controller.config;

import com.jdon.bussinessproxy.TargetMetaDef;
import com.jdon.controller.config.DTDEntityResolver;
import com.jdon.util.Debug;
import com.jdon.util.FileLocator;
import com.jdon.util.UtilValidate;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;

public abstract class XmlParser {
    private static final String module = XmlParser.class.getName();
    protected final FileLocator fileLocator = new FileLocator();

    public Map load(String configFileName) {
        LinkedHashMap<String, TargetMetaDef> mps = new LinkedHashMap<String, TargetMetaDef>();
        try {
            if (UtilValidate.isEmpty(configFileName)) {
                return mps;
            }
            Document doc = this.buildDocument(configFileName);
            if (doc == null) {
                return mps;
            }
            Element root = doc.getRootElement();
            this.parse(root, mps);
            Debug.logVerbose("[JdonFramework]<!--   config load finished -->", module);
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework]configure FileName: " + configFileName + " parsed error: " + ex, module);
        }
        return mps;
    }

    protected Document buildDocument(String configFileName) {
        Debug.logVerbose("[JdonFramework] locate configure file  :" + configFileName, module);
        Document doc = null;
        try {
            InputStream xmlStream = this.getInputStream(configFileName);
            if (xmlStream == null) {
                Debug.logVerbose("[JdonFramework]can't locate file:" + configFileName, module);
                return null;
            }
            Debug.logVerbose("[JdonFramework] configure file found :" + xmlStream, module);
            SAXBuilder builder = new SAXBuilder();
            builder.setEntityResolver((EntityResolver)new DTDEntityResolver());
            doc = builder.build(xmlStream);
            Debug.logVerbose("[JdonFramework] got mapping file ", module);
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework] JDOMException error: " + e, module);
        }
        return doc;
    }

    protected InputStream getInputStream(String configFileName) throws Exception {
        return this.fileLocator.getConfPathXmlStream(configFileName);
    }

    public abstract void parse(Element var1, Map<String, TargetMetaDef> var2) throws Exception;
}

