/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.controller.context.web;

import com.jdon.controller.context.ContextHolder;
import com.jdon.controller.context.RequestWrapper;
import com.jdon.controller.context.web.HttpSessionWrapper;
import com.jdon.controller.context.web.ServletContextWrapper;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;

public class HttpServletRequestWrapper
implements RequestWrapper {
    private HttpServletRequest request;
    private ContextHolder contextHolder;

    public HttpServletRequestWrapper(HttpServletRequest request) {
        this.request = request;
        ServletContextWrapper acw = new ServletContextWrapper(request.getSession().getServletContext());
        HttpSessionWrapper sw = new HttpSessionWrapper(request.getSession());
        this.contextHolder = new ContextHolder(acw, sw);
    }

    public HttpServletRequestWrapper(HttpServletRequest request, ContextHolder contextHolder) {
        this.request = request;
        this.contextHolder = contextHolder;
    }

    @Override
    public ContextHolder getContextHolder() {
        return this.contextHolder;
    }

    @Override
    public Principal getRegisteredPrincipal() {
        return this.request.getUserPrincipal();
    }

    @Override
    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }
}

