/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.controller.service;

import com.jdon.bussinessproxy.TargetMetaDef;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.access.UserTargetMetaDefFactory;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.controller.context.ContextHolder;
import com.jdon.controller.context.RequestWrapper;
import com.jdon.controller.service.ServiceFactory;
import com.jdon.controller.service.WebServiceAccessor;
import com.jdon.util.Debug;

public class WebServiceFactory
implements ServiceFactory {
    private static final String module = WebServiceFactory.class.getName();
    private final ContainerCallback containerCallback;
    private final WebServiceAccessor webServiceAccessor;
    private final UserTargetMetaDefFactory userTargetMetaDefFactory;

    public WebServiceFactory(WebServiceAccessor webServiceAccessor, ContainerCallback containerCallback, UserTargetMetaDefFactory userTargetMetaDefFactory) {
        this.webServiceAccessor = webServiceAccessor;
        this.containerCallback = containerCallback;
        this.userTargetMetaDefFactory = userTargetMetaDefFactory;
    }

    @Override
    public Object getService(String name, RequestWrapper request) {
        Debug.logVerbose("<==============================>start: JdonFramework core entrance", module);
        Debug.logVerbose("<===============>Looking up new service='" + name + "'", module);
        ContainerWrapper cw = this.containerCallback.getContainerWrapper();
        if (!cw.isStart()) {
            Debug.logError("JdonFramework not yet started, please try later ", module);
            return null;
        }
        TargetMetaDef targetMetaDef = this.userTargetMetaDefFactory.getTargetMetaDef(name, cw);
        if (targetMetaDef == null) {
            return null;
        }
        Debug.logVerbose("[JdonFramework] service=" + name + "  found, and now return the service instance", module);
        Object result = this.getService(targetMetaDef, request);
        Debug.logVerbose("<===============>found service='" + name + "'  instance and return  it successfully!", module);
        Debug.logVerbose("<==============================>over", module);
        return result;
    }

    @Override
    public Object getService(TargetMetaDef targetMetaDef, RequestWrapper request) {
        this.userTargetMetaDefFactory.createTargetMetaRequest(targetMetaDef, request.getContextHolder());
        return this.webServiceAccessor.getService(request);
    }

    public Object getService(TargetMetaDef targetMetaDef, AppContextWrapper acw) {
        this.userTargetMetaDefFactory.createTargetMetaRequest(targetMetaDef, new ContextHolder(acw, null));
        return this.webServiceAccessor.getService();
    }

    @Override
    public Object getService(String name, AppContextWrapper acw) {
        ContainerWrapper cw = this.containerCallback.getContainerWrapper();
        if (!cw.isStart()) {
            Debug.logError("JdonFramework not yet started, please try later ", module);
            return null;
        }
        TargetMetaDef targetMetaDef = this.userTargetMetaDefFactory.getTargetMetaDef(name, cw);
        if (targetMetaDef == null) {
            return null;
        }
        Debug.logVerbose("[JdonFramework] service=" + name + "  found, and now return the service instance", module);
        Object result = this.getService(targetMetaDef, acw);
        return result;
    }
}

