/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.domain.advsior;

import com.jdon.annotation.Introduce;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.container.pico.Startable;
import com.jdon.domain.proxy.ModelCGLIBMethodInterceptorImp;
import com.jdon.domain.proxy.ModelProxyFactory;
import com.jdon.util.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.proxy.MethodInterceptor;

public class ModelAdvisor
implements Startable {
    private static final String module = ModelAdvisor.class.getName();
    private final ContainerCallback containerCallback;
    private final ModelProxyFactory modelProxyFactory;
    private Map<Class, MethodInterceptor> modeInterceptors;

    public ModelAdvisor(ContainerCallback containerCallback, ModelProxyFactory modelProxyFactory) {
        this.containerCallback = containerCallback;
        this.modelProxyFactory = modelProxyFactory;
        this.modeInterceptors = new ConcurrentHashMap<Class, MethodInterceptor>();
    }

    public Object createProxy(Object model) {
        if (!this.isAcceptable(model.getClass())) {
            return model;
        }
        MethodInterceptor methodInterceptor = this.modeInterceptors.get(model.getClass());
        if (methodInterceptor == null) {
            List methodInterceptors = this.getAdviceName(model);
            if (methodInterceptors == null || methodInterceptors.size() == 0) {
                return model;
            }
            methodInterceptor = new ModelCGLIBMethodInterceptorImp(methodInterceptors);
            this.modeInterceptors.put(model.getClass(), methodInterceptor);
        }
        return this.modelProxyFactory.create(model.getClass(), methodInterceptor);
    }

    public List getAdviceName(Object model) {
        ArrayList<Object> methodInterceptors = new ArrayList<Object>();
        try {
            Introduce introduce = model.getClass().getAnnotation(Introduce.class);
            if (introduce == null) {
                return methodInterceptors;
            }
            String[] adviceNames = introduce.value();
            if (adviceNames != null) {
                for (int i = 0; i < adviceNames.length; ++i) {
                    Object interceptorCustomzied = this.containerCallback.getContainerWrapper().getComponentNewInstance(adviceNames[i]);
                    methodInterceptors.add(interceptorCustomzied);
                }
            }
        }
        catch (Exception e) {
            Debug.logError(" getAdviceNameAnnotation:" + e, module);
        }
        return methodInterceptors;
    }

    public boolean isAcceptable(Class classz) {
        return classz.isAnnotationPresent(Introduce.class);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.modeInterceptors.clear();
    }
}

