/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.domain.model.cache;

import com.jdon.annotation.pointcut.Around;
import com.jdon.container.pico.Startable;
import com.jdon.controller.model.ModelUtil;
import com.jdon.domain.model.cache.ModelKey;
import com.jdon.domain.model.cache.ModelManager;
import com.jdon.util.Debug;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class DomainCacheInterceptor
implements MethodInterceptor,
Startable {
    public static final String module = DomainCacheInterceptor.class.getName();
    private Map<String, String> adviceArounds = new HashMap<String, String>();
    private ModelManager modelManager;

    public DomainCacheInterceptor(ModelManager modelManager) {
        this.modelManager = modelManager;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (invocation.getThis() == null) {
            return invocation.proceed();
        }
        if (!this.isAdviceAround(invocation.getThis().getClass(), invocation.getMethod())) {
            return invocation.proceed();
        }
        ModelKey modelKey = null;
        Object o = null;
        try {
            Object[] args = invocation.getArguments();
            if (args == null || args.length == 0) {
                return invocation.proceed();
            }
            if (args[0] instanceof ModelKey) {
                modelKey = (ModelKey)args[0];
            } else {
                Class<?> modelClass = invocation.getMethod().getReturnType();
                modelKey = new ModelKey(args[0], modelClass);
            }
            Debug.logVerbose("try to get model from cache, cacheKey=" + modelKey.toString(), module);
            o = this.modelManager.getCache(modelKey);
            if (o != null) {
                return o;
            }
            o = invocation.proceed();
            if (o == null) {
                return o;
            }
            Debug.logVerbose(" get model from database, cacheKey=" + modelKey.toString(), module);
            o = this.modelManager.addCache(modelKey, o);
            Debug.logVerbose("[JdonFramework] save to cache2", module);
        }
        catch (Exception e) {
            Debug.logError("invoke:" + e, module);
        }
        return o;
    }

    public boolean isAdviceAround(Class targetClass, Method methodx) {
        String methodName = this.adviceArounds.get(targetClass.getName());
        if (methodName != null && methodName.equals(methodx.getName())) {
            return true;
        }
        try {
            Method aroundMethod = targetClass.getMethod(methodx.getName(), methodx.getParameterTypes());
            if (aroundMethod == null) {
                return false;
            }
            if (!aroundMethod.isAnnotationPresent(Around.class)) {
                return false;
            }
            if (aroundMethod.getReturnType() == null) {
                return false;
            }
            Class<?> returnClass = aroundMethod.getReturnType();
            if (returnClass.getSuperclass() == null) {
                return false;
            }
            Debug.logVerbose("[JdonFramework]methodMatchsModelGET: returnClassName = " + returnClass.getName(), module);
            if (ModelUtil.isModel(returnClass)) {
                this.adviceArounds.put(targetClass.getName(), methodx.getName());
                return true;
            }
        }
        catch (Exception e) {
            Debug.logError("isAdviceAround:" + e, module);
        }
        return false;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (this.modelManager != null) {
            this.modelManager.clearCache();
        }
        this.modelManager = null;
        this.adviceArounds.clear();
    }
}

