/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class DbUtil {
    public static final String ORACLE = "oracle";
    public static final String MYSQL = "mysql";
    public static final String SQLSERVER = "sql server";
    public static final String INTERBASE = "interbase";
    public static final String POSTGRES = "postgres";
    private static boolean init = false;
    public static boolean streamLargeText;
    public static boolean supportsMaxRows;
    public static boolean supportsFetchSize;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void testConnection(Connection con) {
        if (init) {
            return;
        }
        init = true;
        streamLargeText = false;
        supportsMaxRows = true;
        supportsFetchSize = true;
        try {
            DatabaseMetaData metaData = con.getMetaData();
            String dbName = metaData.getDatabaseProductName().toLowerCase();
            String driverName = metaData.getDriverName().toLowerCase();
            if (dbName.indexOf(ORACLE) != -1) {
                streamLargeText = true;
                if (driverName.indexOf("auguro") == -1) return;
                streamLargeText = false;
                supportsFetchSize = true;
                supportsMaxRows = false;
                return;
            }
            if (dbName.indexOf(POSTGRES) != -1) {
                supportsFetchSize = false;
                return;
            }
            if (dbName.indexOf(INTERBASE) != -1) {
                supportsFetchSize = false;
                supportsMaxRows = false;
                return;
            }
            if (dbName.indexOf(SQLSERVER) != -1 && driverName.indexOf("una") != -1) {
                supportsFetchSize = true;
                supportsMaxRows = false;
                return;
            }
            if (dbName.indexOf(MYSQL) == -1) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getProductAllCount(DataSource ds, String key, String sql_allcount) throws Exception {
        Connection c = null;
        Statement ps = null;
        ResultSet rs = null;
        int ret = 0;
        try {
            c = ds.getConnection();
            ps = c.prepareStatement(sql_allcount, 1004, 1007);
            ps.setString(1, key);
            rs = ps.executeQuery();
            if (rs.first()) {
                ret = rs.getInt(1);
            }
        }
        catch (SQLException se) {
            throw new Exception("SQLException: " + se.getMessage());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
            if (c != null) {
                c.close();
            }
        }
        return ret;
    }

    public List getDataList(DataSource ds, String key, String sql, int start, int count) throws Exception {
        Connection c = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<String> items = new ArrayList<String>(count);
        try {
            c = ds.getConnection();
            stmt = c.createStatement();
            DbUtil.testConnection(c);
            if (supportsMaxRows) {
                stmt.setMaxRows(count + start + 1);
            }
            rs = stmt.executeQuery(sql);
            if (supportsFetchSize) {
                rs.setFetchSize(count);
            }
            if (start >= 0 && rs.absolute(start + 1)) {
                do {
                    items.add(rs.getString(1));
                } while (rs.next() && --count > 0);
            }
        }
        catch (SQLException se) {
            throw new Exception("SQLException: " + se.getMessage());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (c != null) {
                c.close();
            }
        }
        return items;
    }
}

