/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.util.jdom;

import com.jdon.util.jdom.XMLFilterBase;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DataFormatFilter
extends XMLFilterBase {
    private static final Object SEEN_NOTHING = new Object();
    private static final Object SEEN_ELEMENT = new Object();
    private static final Object SEEN_DATA = new Object();
    private static final char[] NEWLINE = new char[]{'\n'};
    private static final char INDENT_CHAR = ' ';
    private Object state = SEEN_NOTHING;
    private Stack stateStack = new Stack();
    private int indentStep = 0;

    public DataFormatFilter() {
    }

    public DataFormatFilter(XMLReader xmlreader) {
        super(xmlreader);
    }

    public int getIndentStep() {
        return this.indentStep;
    }

    public void setIndentStep(int indentStep) {
        this.indentStep = indentStep;
    }

    public void reset() {
        this.state = SEEN_NOTHING;
        this.stateStack = new Stack();
    }

    @Override
    public void startDocument() throws SAXException {
        this.reset();
        super.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.stateStack.empty()) {
            this.doNewline();
            this.doIndent();
        }
        this.stateStack.push(SEEN_ELEMENT);
        this.state = SEEN_NOTHING;
        super.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean seenElement = this.state == SEEN_ELEMENT;
        this.state = this.stateStack.pop();
        if (seenElement) {
            this.doNewline();
            this.doIndent();
        }
        super.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.state = SEEN_DATA;
        super.characters(ch, start, length);
    }

    private void doNewline() throws SAXException {
        super.characters(NEWLINE, 0, NEWLINE.length);
    }

    private void doIndent() throws SAXException {
        int n = this.indentStep * this.stateStack.size();
        if (n > 0) {
            char[] ch = new char[n];
            for (int i = 0; i < n; ++i) {
                ch[i] = 32;
            }
            super.characters(ch, 0, n);
        }
    }
}

