/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.util.jdom;

import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLFilterBase
extends XMLFilterImpl
implements LexicalHandler {
    private LexicalHandler lexicalHandler = null;
    protected static final Attributes EMPTY_ATTS = new AttributesImpl();
    protected static final String[] LEXICAL_HANDLER_NAMES = new String[]{"http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/handlers/LexicalHandler"};

    public XMLFilterBase() {
    }

    public XMLFilterBase(XMLReader parent) {
        super(parent);
    }

    public void startElement(String uri, String localName) throws SAXException {
        this.startElement(uri, localName, "", EMPTY_ATTS);
    }

    public void startElement(String localName, Attributes atts) throws SAXException {
        this.startElement("", localName, "", atts);
    }

    public void startElement(String localName) throws SAXException {
        this.startElement("", localName, "", EMPTY_ATTS);
    }

    public void endElement(String uri, String localName) throws SAXException {
        this.endElement(uri, localName, "");
    }

    public void endElement(String localName) throws SAXException {
        this.endElement("", localName, "");
    }

    public void emptyElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.startElement(uri, localName, qName, atts);
        this.endElement(uri, localName, qName);
    }

    public void emptyElement(String uri, String localName) throws SAXException {
        this.emptyElement(uri, localName, "", EMPTY_ATTS);
    }

    public void emptyElement(String localName, Attributes atts) throws SAXException {
        this.emptyElement("", localName, "", atts);
    }

    public void emptyElement(String localName) throws SAXException {
        this.emptyElement("", localName, "", EMPTY_ATTS);
    }

    public void dataElement(String uri, String localName, String qName, Attributes atts, String content) throws SAXException {
        this.startElement(uri, localName, qName, atts);
        this.characters(content);
        this.endElement(uri, localName, qName);
    }

    public void dataElement(String uri, String localName, String content) throws SAXException {
        this.dataElement(uri, localName, "", EMPTY_ATTS, content);
    }

    public void dataElement(String localName, Attributes atts, String content) throws SAXException {
        this.dataElement("", localName, "", atts, content);
    }

    public void dataElement(String localName, String content) throws SAXException {
        this.dataElement("", localName, "", EMPTY_ATTS, content);
    }

    public void characters(String data) throws SAXException {
        char[] ch = data.toCharArray();
        this.characters(ch, 0, ch.length);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        for (int i = 0; i < LEXICAL_HANDLER_NAMES.length; ++i) {
            if (!LEXICAL_HANDLER_NAMES[i].equals(name)) continue;
            this.setLexicalHandler((LexicalHandler)value);
            return;
        }
        super.setProperty(name, value);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        for (int i = 0; i < LEXICAL_HANDLER_NAMES.length; ++i) {
            if (!LEXICAL_HANDLER_NAMES[i].equals(name)) continue;
            return this.getLexicalHandler();
        }
        return super.getProperty(name);
    }

    @Override
    public void parse(InputSource input) throws SAXException, IOException {
        this.installLexicalHandler();
        super.parse(input);
    }

    public void setLexicalHandler(LexicalHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Null lexical handler");
        }
        this.lexicalHandler = handler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    private void installLexicalHandler() {
        XMLReader parent = this.getParent();
        if (parent == null) {
            throw new NullPointerException("No parent for filter");
        }
        for (int i = 0; i < LEXICAL_HANDLER_NAMES.length; ++i) {
            try {
                parent.setProperty(LEXICAL_HANDLER_NAMES[i], this);
                break;
            }
            catch (SAXNotRecognizedException ex) {
                continue;
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
        }
    }
}

