/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.aop;

import com.jdon.aop.joinpoint.AdvisorChainFactory;
import com.jdon.aop.reflection.MethodConstructor;
import com.jdon.aop.reflection.ProxyMethodInvocation;
import com.jdon.bussinessproxy.target.TargetServiceFactory;
import com.jdon.container.access.TargetMetaRequest;
import com.jdon.container.access.TargetMetaRequestsHolder;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.util.Debug;
import java.lang.reflect.Method;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;

public class AopClient {
    private static final String module = AopClient.class.getName();
    private final AdvisorChainFactory advisorChainFactory;
    private final TargetServiceFactory targetServiceFactory;
    private final MethodConstructor methodConstructor;
    private final TargetMetaRequestsHolder targetMetaRequestsHolder;

    public AopClient(ContainerCallback containerCallback, AdvisorChainFactory advisorChainFactory, TargetServiceFactory targetServiceFactory, TargetMetaRequestsHolder targetMetaRequestsHolder) {
        this.advisorChainFactory = advisorChainFactory;
        this.targetServiceFactory = targetServiceFactory;
        this.methodConstructor = new MethodConstructor(containerCallback, targetMetaRequestsHolder);
        this.targetMetaRequestsHolder = targetMetaRequestsHolder;
    }

    public Object invoke() throws Throwable {
        TargetMetaRequest targetMetaRequest = this.targetMetaRequestsHolder.getTargetMetaRequest();
        Debug.logVerbose("[JdonFramework] enter AOP invoker for:" + targetMetaRequest.getTargetMetaDef().getClassName() + " method:" + targetMetaRequest.getMethodMetaArgs().getMethodName(), module);
        Object result = null;
        ProxyMethodInvocation methodInvocation = null;
        try {
            List<MethodInterceptor> chain = this.advisorChainFactory.create(targetMetaRequest.getTargetMetaDef());
            Object[] args = targetMetaRequest.getMethodMetaArgs().getArgs();
            Method method = this.methodConstructor.createMethod(this.targetServiceFactory);
            methodInvocation = new ProxyMethodInvocation(chain, this.targetMetaRequestsHolder, this.targetServiceFactory, method, args);
            Debug.logVerbose("[JdonFramework] MethodInvocation will proceed ... ", module);
            result = methodInvocation.proceed();
        }
        catch (Exception ex) {
            Debug.logError(ex, module);
            throw new Exception(ex);
        }
        catch (Throwable ex) {
            throw new Throwable(ex);
        }
        finally {
            this.targetMetaRequestsHolder.clear();
        }
        return result;
    }

    public Object invoke(TargetMetaRequest targetMetaRequest, Method method, Object[] args) throws Throwable {
        this.targetMetaRequestsHolder.setTargetMetaRequest(targetMetaRequest);
        Debug.logVerbose("[JdonFramework] enter AOP invoker2 for:" + targetMetaRequest.getTargetMetaDef().getClassName() + " method:" + method.getName(), module);
        Object result = null;
        ProxyMethodInvocation methodInvocation = null;
        try {
            List<MethodInterceptor> chain = this.advisorChainFactory.create(targetMetaRequest.getTargetMetaDef());
            methodInvocation = new ProxyMethodInvocation(chain, this.targetMetaRequestsHolder, this.targetServiceFactory, method, args);
            Debug.logVerbose("[JdonFramework] MethodInvocation will proceed ... ", module);
            result = methodInvocation.proceed();
        }
        catch (Exception ex) {
            Debug.logError(ex, module);
            throw new Exception(ex);
        }
        catch (Throwable ex) {
            throw new Throwable(ex);
        }
        finally {
            this.targetMetaRequestsHolder.clear();
        }
        return result;
    }
}

