/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.async;

import com.jdon.annotation.model.Receiver;
import com.jdon.annotation.model.Send;
import com.jdon.async.disruptor.DisruptorFactory;
import com.jdon.async.disruptor.DisruptorForCommandFactory;
import com.jdon.async.disruptor.EventDisruptor;
import com.jdon.async.future.EventResultFuture;
import com.jdon.async.future.FutureDirector;
import com.jdon.async.future.FutureListener;
import com.jdon.container.pico.Startable;
import com.jdon.controller.model.ModelUtil;
import com.jdon.domain.message.DomainMessage;
import com.jdon.domain.message.consumer.ModelConsumerMethodHolder;
import com.jdon.domain.model.injection.ModelProxyInjection;
import com.jdon.util.Debug;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public class EventMessageFirer
implements Startable {
    public static final String module = EventMessageFirer.class.getName();
    private DisruptorFactory disruptorFactory;
    private DisruptorForCommandFactory disruptorForCommandFactory;
    private FutureDirector futureDirector;
    private ModelProxyInjection modelProxyInjection;

    public EventMessageFirer(DisruptorFactory disruptorFactory, DisruptorForCommandFactory disruptorForCommandFactory, FutureDirector futureDirector, ModelProxyInjection modelProxyInjection) {
        this.disruptorFactory = disruptorFactory;
        this.disruptorForCommandFactory = disruptorForCommandFactory;
        this.futureDirector = futureDirector;
        this.modelProxyInjection = modelProxyInjection;
    }

    public void start() {
    }

    public void stop() {
        if (this.futureDirector != null) {
            this.futureDirector.stop();
            this.futureDirector = null;
        }
    }

    public void fire(DomainMessage domainMessage, Send send, FutureListener futureListener) {
        EventResultFuture eventMessageFuture = new EventResultFuture(send.value(), futureListener, domainMessage);
        eventMessageFuture.setAsyn(send.asyn());
        domainMessage.setEventResultHandler(eventMessageFuture);
        this.futureDirector.fire(domainMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(DomainMessage domainMessage, Send send) {
        String topic = send.value();
        if (this.disruptorForCommandFactory.isContain(topic)) {
            return;
        }
        if (!this.disruptorFactory.isContain(topic)) {
            Debug.logError(" no found any consumer annonated with @Consumer or its methods with @OnEvent for topic=" + topic, module);
            return;
        }
        try {
            long sequence;
            Disruptor disruptor = this.disruptorFactory.getDisruptor(topic);
            if (disruptor == null) {
                Debug.logWarning("not create disruptor for " + topic, module);
                return;
            }
            RingBuffer ringBuffer = disruptor.getRingBuffer();
            EventDisruptor eventDisruptor = (EventDisruptor)ringBuffer.get(sequence = ringBuffer.next());
            if (eventDisruptor == null) {
                return;
            }
            eventDisruptor.setTopic(topic);
            eventDisruptor.setDomainMessage(domainMessage);
            ringBuffer.publish(sequence);
        }
        catch (Exception e) {
            Debug.logError("fire error: " + e.getMessage() + " for" + send.value() + " from:" + domainMessage.getEventSource() + " ", module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireToModel(DomainMessage domainMessage, Send send, MethodInvocation invocation) {
        String topic = send.value();
        if (this.disruptorFactory.isContain(topic)) {
            return;
        }
        ModelConsumerMethodHolder modelConsumerMethodHolder = this.disruptorForCommandFactory.getModelConsumerMethodHolder(topic);
        if (modelConsumerMethodHolder == null) {
            Debug.logError(" no found any consumer annonated with @OnCommand for topic=" + topic, module);
            return;
        }
        Object[] arguments = invocation.getArguments();
        if (arguments.length == 0) {
            Debug.logError("there is no a destination parameter(@Receiver) in this method:" + invocation.getMethod().getName() + topic, module);
            return;
        }
        Object model = this.fetchCommandReceiver(invocation.getMethod(), arguments);
        if (model == null || !ModelUtil.isModel(model)) {
            Debug.logError(" there is no a destination parameter(@Receiver)  in this method:" + invocation.getMethod().getName() + " or the destination class not annotated with @Model", module);
            return;
        }
        this.modelProxyInjection.injectProperties(model);
        domainMessage.setDestination(model);
        Disruptor disruptor = this.disruptorForCommandFactory.getDisruptor(topic);
        if (disruptor == null) {
            Debug.logWarning("not create command disruptor for " + topic, module);
            return;
        }
        try {
            RingBuffer ringBuffer = disruptor.getRingBuffer();
            long sequence = ringBuffer.next();
            EventDisruptor eventDisruptor = (EventDisruptor)ringBuffer.get(sequence);
            if (eventDisruptor == null) {
                return;
            }
            eventDisruptor.setTopic(topic);
            eventDisruptor.setDomainMessage(domainMessage);
            ringBuffer.publish(sequence);
        }
        catch (Exception e) {
            Debug.logError("fireToModel error: " + send.value() + " domainMessage:" + domainMessage.getEventSource() + " mode:" + arguments[0].getClass().getName(), module);
        }
    }

    private Object fetchCommandReceiver(Method method, Object[] arguments) {
        Annotation[][] paramAnnotations;
        int i = 0;
        for (Annotation[] anns : paramAnnotations = method.getParameterAnnotations()) {
            Object parameter = arguments[i++];
            for (Annotation annotation : anns) {
                if (!(annotation instanceof Receiver)) continue;
                return parameter;
            }
        }
        return null;
    }
}

